/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xml;

import java.util.Stack;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.xml.sax.AttributeList;

class ObjectCreate
extends XmlAction {
    String className;
    String attrib;

    public ObjectCreate(String classN) {
        this.className = classN;
    }

    public ObjectCreate(String classN, String attrib) {
        this.className = classN;
        this.attrib = attrib;
    }

    public void cleanup(SaxContext ctx) {
        Stack st = ctx.getObjectStack();
        String tag = ctx.getTag(ctx.getTagCount() - 1);
        Object o = st.pop();
        if (ctx.getDebug() > 0) {
            ctx.log("pop " + tag + " " + o.getClass().getName() + ": " + o);
        }
    }

    public void start(SaxContext ctx) throws Exception {
        Stack st = ctx.getObjectStack();
        int top = ctx.getTagCount() - 1;
        String tag = ctx.getTag(top);
        String classN = this.className;
        if (this.attrib != null) {
            AttributeList attributes = ctx.getAttributeList(top);
            classN = attributes.getValue(this.attrib);
        }
        Class<?> c = Class.forName(classN);
        Object o = c.newInstance();
        st.push(o);
        if (ctx.getDebug() > 0) {
            ctx.log("new " + this.attrib + " " + classN + " " + tag + " " + o);
        }
    }
}

