/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.MimeHeadersEnumerator;
import org.apache.tomcat.util.StringManager;

public class MimeHeaders {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private byte[] buf;

    public MimeHeaders() {
        this(512);
    }

    public MimeHeaders(int len) {
        this.buf = new byte[len];
    }

    public void addDateHeader(String name) {
        this.addHeader(name).setDateValue();
    }

    public void addDateHeader(String name, long t) {
        this.addHeader(name).setDateValue(t);
    }

    protected MimeHeaderField addHeader(String name) {
        MimeHeaderField mh = this.putHeader();
        mh.setName(name);
        return mh;
    }

    public void addHeader(String name, String s) {
        this.addHeader(name).setValue(s);
    }

    public void addIntHeader(String name, int i) {
        this.addHeader(name).setIntValue(i);
    }

    public void appendHeader(String name, String s) {
        MimeHeaderField mh = this.putHeader();
        mh.setName(name);
        mh.setValue(s);
    }

    public void clear() {
        int i = 0;
        while (i < this.count) {
            this.headers[i].reset();
            ++i;
        }
        this.count = 0;
    }

    public boolean containsHeader(String name) {
        return this.find(name) != null;
    }

    public void dump(PrintStream out) {
        int i = 0;
        while (i < this.count) {
            out.println(this.headers[i]);
            ++i;
        }
    }

    protected MimeHeaderField find(String name) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(name)) {
                return this.headers[i];
            }
            ++i;
        }
        return null;
    }

    public int getAll(byte[] buf, int buf_offset) {
        int start_pt = buf_offset;
        int i = 0;
        while (i < this.count) {
            buf_offset += this.headers[i].getBytes(buf, buf_offset);
            ++i;
        }
        return buf_offset - start_pt;
    }

    public long getDateHeader(String name) throws IllegalArgumentException {
        MimeHeaderField mh = this.find(name);
        return mh != null ? mh.getDateValue() : -1L;
    }

    public MimeHeaderField getField(int n) {
        return n >= 0 && n < this.count ? this.headers[n] : null;
    }

    public int getFieldCount(String name) {
        int retval = 0;
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(name)) {
                ++retval;
            }
            ++i;
        }
        return retval;
    }

    public String getHeader(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public String getHeader(String name) {
        MimeHeaderField mh = this.find(name);
        return mh != null ? mh.getValue() : null;
    }

    public String getHeaderName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public String[] getHeaders(String name) {
        Vector values = this.getHeadersVector(name);
        if (values.size() > 0) {
            String[] retval = new String[values.size()];
            int i = 0;
            while (i < retval.length) {
                retval[i] = (String)values.elementAt(i);
                ++i;
            }
            return retval;
        }
        return null;
    }

    public Vector getHeadersVector(String name) {
        Vector<String> values = new Vector<String>();
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(name)) {
                values.addElement(this.headers[i].getValue());
            }
            ++i;
        }
        return values;
    }

    public int getIntHeader(String name) throws NumberFormatException {
        MimeHeaderField mh = this.find(name);
        return mh != null ? mh.getIntValue() : -1;
    }

    public Enumeration names() {
        return new MimeHeadersEnumerator(this);
    }

    public void putDateHeader(String name) {
        this.putHeader(name).setDateValue();
    }

    public void putDateHeader(String name, long t) {
        this.putHeader(name).setDateValue(t);
    }

    protected MimeHeaderField putHeader() {
        MimeHeaderField mh;
        int len = this.headers.length;
        if (this.count >= len) {
            MimeHeaderField[] tmp = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    protected MimeHeaderField putHeader(String name) {
        if (this.containsHeader(name)) {
            this.removeHeader(name);
        }
        return this.addHeader(name);
    }

    public void putHeader(String name, String s) {
        this.putHeader(name).setValue(s);
    }

    public void putIntHeader(String name, int i) {
        this.putHeader(name).setIntValue(i);
    }

    public void read(ServletInputStream in) throws IOException {
        block4: {
            int start;
            MimeHeaderField mhf;
            byte[] b = this.count == 0 ? this.buf : new byte[this.buf.length];
            int off = 0;
            do {
                start = off;
                while (true) {
                    int len;
                    if ((len = b.length - off) > 0 && (len = in.readLine(b, off, len)) == -1) {
                        String msg = this.sm.getString("mimeHeader.connection.ioe");
                        throw new IOException(msg);
                    }
                    if (len == 0 || b[(off += len) - 1] == 10) break;
                    byte[] tmp = new byte[b.length * 2];
                    System.arraycopy(b, 0, tmp, 0, b.length);
                    b = tmp;
                }
                if (--off > start && b[off - 1] == 13) {
                    --off;
                }
                if (off == start) break block4;
            } while ((mhf = this.putHeader()).parse(b, start, off - start));
            return;
        }
    }

    public void removeHeader(String name) {
        int i = 0;
        while (i < this.count) {
            if (this.headers[i].nameEquals(name)) {
                MimeHeaderField mh = this.headers[i];
                mh.reset();
                this.headers[i] = this.headers[this.count - 1];
                this.headers[this.count - 1] = mh;
                --this.count;
                --i;
            }
            ++i;
        }
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int i = 0;
        while (i < this.count) {
            sb.append("{");
            sb.append(this.headers[i].toString());
            sb.append("}");
            if (i < this.count - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public void write(ServletOutputStream out) throws IOException {
        int i = 0;
        while (i < this.count) {
            this.headers[i].write(out);
            ++i;
        }
        out.println();
    }
}

