/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tomcat.util.Ascii;
import org.apache.tomcat.util.StringManager;

public class HttpDate
extends Ascii {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    private static final String DATESTR = "Sun, 06 Nov 1994 08:49:37 GMT";
    public static final int DATELEN = "Sun, 06 Nov 1994 08:49:37 GMT".length();
    private static final Locale loc = Locale.US;
    private static final TimeZone zone = TimeZone.getTimeZone("GMT");
    private static final String rfc1123Pattern = "EEE, dd MMM yyyyy HH:mm:ss z";
    private static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String asctimePattern = "EEE MMM d HH:mm:ss yyyyy";
    private static final SimpleDateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", loc);
    private static final SimpleDateFormat rfc1036Format = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", loc);
    private static final SimpleDateFormat asctimeFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyyy", loc);
    protected Calendar calendar = new GregorianCalendar(zone, loc);

    static {
        rfc1123Format.setTimeZone(zone);
        rfc1036Format.setTimeZone(zone);
        asctimeFormat.setTimeZone(zone);
    }

    public HttpDate() {
        this.calendar.setTime(new Date(System.currentTimeMillis()));
    }

    public HttpDate(long ms) {
        this.calendar.setTime(new Date(ms));
    }

    public int getBytes(byte[] buf, int off, int len) {
        if (len < DATELEN) {
            String msg = this.sm.getString("httpDate.iae", new Integer(len));
            throw new IllegalArgumentException(msg);
        }
        String dateString = rfc1123Format.format(this.calendar.getTime());
        byte[] b = dateString.getBytes();
        System.arraycopy(b, 0, buf, off, DATELEN);
        return DATELEN;
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public long getTime() {
        return this.calendar.getTime().getTime();
    }

    public void parse(String dateString) {
        try {
            Date date = rfc1123Format.parse(dateString);
            this.calendar.setTime(date);
            return;
        }
        catch (ParseException parseException) {
            try {
                Date date = rfc1036Format.parse(dateString);
                this.calendar.setTime(date);
                return;
            }
            catch (ParseException parseException2) {
                try {
                    Date date = asctimeFormat.parse(dateString);
                    this.calendar.setTime(date);
                    return;
                }
                catch (ParseException parseException3) {
                    String msg = this.sm.getString("httpDate.pe", dateString);
                    throw new IllegalArgumentException(msg);
                }
            }
        }
    }

    public void parse(byte[] b, int off, int len) {
        try {
            String dateString = new String(b, off, len, "8859_1");
            this.parse(dateString);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public void setTime() {
        this.calendar.setTime(new Date(System.currentTimeMillis()));
    }

    public void setTime(long ms) {
        this.calendar.setTime(new Date(ms));
    }

    public String toString() {
        return rfc1123Format.format(this.calendar.getTime());
    }

    public void write(OutputStream out) throws IOException {
        String dateString = rfc1123Format.format(this.calendar.getTime());
        byte[] b = dateString.getBytes();
        out.write(b);
    }
}

