/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.task;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.FileUtil;

public class ApacheConfig {
    public static final String APACHE_CONFIG = "/conf/tomcat-apache.conf";

    public void execute(ContextManager cm) throws TomcatException {
        try {
            String tomcatHome = cm.getHome();
            String apacheHome = this.findApache();
            FileWriter configW = new FileWriter(String.valueOf(tomcatHome) + APACHE_CONFIG);
            PrintWriter pw = new PrintWriter(configW);
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                pw.println("LoadModule jserv_module modules/ApacheModuleJServ.dll");
            } else {
                pw.println("LoadModule jserv_module libexec/mod_jserv.so");
            }
            pw.println("ApJServManual on");
            pw.println("ApJServDefaultProtocol ajpv12");
            pw.println("ApJServSecretKey DISABLED");
            pw.println("ApJServMountCopy on");
            pw.println("ApJServLogLevel notice");
            pw.println();
            pw.println("ApJServDefaultPort 8007");
            pw.println();
            pw.println("AddType test/jsp .jsp");
            pw.println("AddHandler jserv-servlet .jsp");
            Enumeration enumeration = cm.getContextNames();
            while (enumeration.hasMoreElements()) {
                String path = (String)enumeration.nextElement();
                Context context = cm.getContext(path);
                if (path.length() > 1) {
                    pw.println("Alias " + path + " " + FileUtil.patch(String.valueOf(tomcatHome) + "/webapps" + path));
                    pw.println("<Directory \"" + FileUtil.patch(String.valueOf(tomcatHome) + "/webapps" + path) + "\">");
                    pw.println("    Options Indexes FollowSymLinks");
                    pw.println("</Directory>");
                    pw.println("ApJServMount " + path + "/servlet" + " " + path);
                    pw.println("<Location " + path + "/WEB-INF/ >");
                    pw.println("    AllowOverride None");
                    pw.println("    deny from all");
                    pw.println("</Location>");
                    pw.println();
                    continue;
                }
                pw.println("ApJServMount /servlet /ROOT");
            }
            pw.close();
        }
        catch (Exception ex) {
            System.out.println("Failed to generate automatic apache configuration " + ex.toString());
        }
    }

    String findApache() {
        return null;
    }
}

