/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.server;

import java.net.InetAddress;
import java.util.Properties;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.server.HttpServerException;
import org.apache.tomcat.service.SimpleTcpConnector;
import org.apache.tomcat.service.http.HttpConnectionHandler;
import org.apache.tomcat.util.StringManager;

public class HttpServer {
    public static final String VHOST_PORT = "vhost_port";
    public static final String VHOST_NAME = "vhost_name";
    public static final String SERVER = "server";
    public static final String VHOST_ADDRESS = "vhost_address";
    public static final String SOCKET_FACTORY = "socketFactory";
    public static final String CONNECTOR_PROP = "/connector.properties";
    ContextManager contextM;
    int connector_count = 0;
    InetAddress address;
    ServerSocketFactory factory;
    Properties props;
    private StringManager sm = StringManager.getManager("org.apache.tomcat.server");
    private String hostname = "";
    private String serverHeader = null;
    String workDir;

    public HttpServer() {
    }

    public HttpServer(int port, InetAddress address, String hostname) {
        this.contextM = new ContextManager();
        this.init(port, address, hostname, this.contextM);
    }

    public HttpServer(int port, InetAddress address, String hostname, ContextManager contextM) {
        this.init(port, address, hostname, contextM);
    }

    public synchronized void addConnector(String classN) {
        try {
            Class<?> c = Class.forName(classN);
            ServerConnector conn = (ServerConnector)c.newInstance();
            this.addConnector(conn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void addConnector(ServerConnector connector) {
        connector.setAttribute(SERVER, this);
        connector.setContextManager(this.contextM);
        connector.setAttribute(VHOST_PORT, new Integer(this.getPort()));
        connector.setAttribute(VHOST_ADDRESS, this.address);
        connector.setAttribute(SOCKET_FACTORY, this.factory);
        connector.setAttribute(VHOST_NAME, this.getHostName());
        this.contextM.addServerConnector(connector);
        ++this.connector_count;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public ContextManager getContextManager() {
        return this.contextM;
    }

    public String getHostName() {
        return this.contextM.getHostName();
    }

    public int getPort() {
        return this.contextM.getPort();
    }

    public String getServerHeader() {
        if (this.serverHeader == null) {
            this.serverHeader = "Tomcat Web Server 3.1";
        }
        return this.serverHeader;
    }

    public void init(int port, InetAddress address, String hostname, ContextManager contextM) {
        this.contextM = contextM;
        if (hostname == null || "".equals(hostname)) {
            hostname = "localhost";
        }
        this.setPort(port);
        this.setAddress(address);
        this.setHostName(hostname);
    }

    private void initConnector() {
        if (this.connector_count == 0) {
            SimpleTcpConnector sc = new SimpleTcpConnector();
            sc.setTcpConnectionHandler(new HttpConnectionHandler());
            this.addConnector(sc);
        }
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
        cm.setWorkDir(this.workDir);
    }

    public void setDefaultSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setHostName(String hostname) {
        this.contextM.setHostName(hostname);
    }

    public void setPort(int port) {
        this.contextM.setPort(port);
    }

    public void setWorkDir(String wd) {
        this.workDir = wd;
    }

    public void start() throws HttpServerException {
        try {
            this.contextM.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new HttpServerException(ex);
        }
    }

    public void stop() throws HttpServerException {
        try {
            this.contextM.stop();
        }
        catch (Exception ex) {
            throw new HttpServerException(ex);
        }
    }
}

