.Sall; suppress all Macro expansions.
Page 58,132; 58 lines/page, 132 columns/line.
Name Kaleidoscope; name of program module in .obj file.
Title "Kaleidm -- Multiple Kaleidoscopes"
main Group code, data; declare Group main as 2 segments.
Assume cs:main,ss:main,ds:main,es:main; all Segment regs point to main Group.
O Equ <Offset main:>; define O as Offset operator.
W Equ <Word Ptr>; define W as Word Ptr operator.
B Equ <Byte Ptr>; define B as Byte Ptr operator.
TIM0 = 40h; timer zero's port.
TIMC = 43h; timer command port.
X = 640; number of X pixels.
Y = 350; number of Y pixels.
C = 16; number of colors.
psp Struc; define PSP structure.
	db	128 Dup(?); first half of psp.
cmdlen	db	?
cmdtail	db	127 Dup(?); command tail length and data.
psp EndS; end of PSP structure.
code Segment; define code Segment.
Org 0100h; all .com programs start at 0100h.
data Segment; define data Segment.
q	dw	1024; theoretical size.
mx	dw	X
my	dw	Y; save max. x and max. y here.
ix	dw	0
iy	dw	0; initial x and y offsets.
ox	dw	0
oy	dw	0; save x and y offsets here.
sx	dw	?
sy	dw	?
ex	dw	?
ey	dw	?; save start and end coords here.
umsg Label Byte
	db	"   Usage:"
	db	13,10
	db	13,10
	db	"    Kaleidm [ SquareRoot(NumberOfKaleidoscopes) ]"
	db	13,10
	db	13,10
	db	"    Default is random 1-10, Maximum is 30."
	db	13,10,'$'
data EndS; close data segment, goes after code.
Kaleidm:
; program starts here.
	Cli
	Sub	al,al
	Out	TIMC,AL; latch timer zero.
	In	AL,TIM0
	Mov	ah,al; fetch LSB.
	In	AL,TIM0
	Xchg	al,ah
	Sti; fetch MSB, ax = count.
	Mov	seed[0],ax
	Xchg	ah,al; save timer in LSW of seed.
	Mov	seed[2],ax; save swapped timer in MSW of seed.
	Mov	si,cmdtail; si = command tail pointer.
	Sub	cx,cx
	Mov	cl,ds:cmdlen; cx = length of command tail.
	Call	Number
	Test	ax,ax; get number to do.
	Jnz	?Els0001
?Top0001:; if user doesn't care, then...
	Mov	ax,10
	Call	Rand; get a random number to do.
	Mov	bx,ax
	Inc	bx; bx = square root of number to do.
; else...
	Jmp	Short ?End0001
?Els0001:
?Top0002:; he cares...
	Cmp	ax,30
	Jbe	?Els0003
?Top0003:
	Mov	ax,30
?Els0003:
?End0003:; if too big, use the max.
	Mov	bx,ax; bx = square root of number to do.
?Els0002:
?End0001:; end get number to do.
	Mov	ax,X
	Sub	dx,dx
	Div	bx; compute max. x.
	Mov	mx,ax; save max. x.
	Mov	ax,Y
	Sub	dx,dx
	Div	bx; compute max. y.
	Mov	my,ax; save max. y.
	Mov	ax,X
	Sub	dx,dx
	Div	mx
	Mul	mx; compute max. x pixels across.
	Mov	dx,X
	Sub	dx,ax
	Shr	dx,1
	Mov	ix,dx
	Mov	ox,dx; save initial x offset.
	Mov	ax,Y
	Sub	dx,dx
	Div	my
	Mul	my; compute max. y pixels down.
	Mov	dx,Y
	Sub	dx,ax
	Shr	dx,1
	Mov	iy,dx
	Mov	oy,dx; save initial y offset.
	Mov	ax,10h
	Int	10h; select 640-by-350 graphics
?Top0004:; do...
	Call	Kaleid; put up a Kaleidoscope.
	Mov	ax,ox
	Add	ax,mx
	Mov	ox,ax; compute next x offset.
	Add	ax,mx
	Cmp	ax,X; if beyond the physical limit...
	Jbe	?Els0005
?Top0005:; then...
	Mov	ax,ix
	Mov	ox,ax; re-set it to start, and...
	Mov	ax,oy
	Add	ax,my
	Mov	oy,ax; compute next y offset.
	Add	ax,my
	Cmp	ax,Y; if beyond the physical limit...
	Jbe	?Els0006
?Top0006:
	Mov	ax,iy
	Mov	oy,ax
?Els0006:
?End0006:; then, re-set it to start.
?Els0005:
?End0005:; end, x beyond limit.
	Mov	ah,11h
	Int	16h; if a key is waiting then exit...
	Jz	?Top0004
?Els0004:
?End0004:; loop 'til done...
quit:
	Mov	ax,03h
	Int	10h; select 25-by-80 text
	Mov	al,cl
	Mov	ah,4Ch
	Int	21h; return to DOS.
;
;\\\\\\\\\
; Kaleid \
;\\\\\\\\\
;
;
;   Kaleid puts a Kaleidoscope on the screen.  This routine builds a
;   Kaleidoscope on the screen at position
;
;   Entry Conditions:
;       ax = scratch.
;       cx = scratch.
;       dx = scratch.
;       si = scratch.
;       di = scratch.
;
;   Exit Conditions:
;       ax = scratch.
;       cx = scratch.
;       dx = scratch.
;       si = scratch.
;       di = scratch.
;
Kaleid Proc Near; procedure to put a Kaleidoscope up.
	Mov	ax,q
	Call	Rand
	Mov	sx,ax; get and save start x coord.
	Mov	dx,mx
	Mul	dx
	Div	q; ax = scaled x value.
	Mov	si,ax; save x coord.
	Mov	ax,si
	Add	ax,ox
	Push	ax; get x coord.
	Mov	ax,q
	Call	Rand
	Mov	sy,ax; get and save start y coord.
	Mov	dx,my
	Mul	dx
	Div	q; ax = scaled y value.
	Mov	di,ax; save y coord.
	Mov	ax,di
	Add	ax,oy
	Push	ax; get y coord.
	Mov	ax,C-1
	Call	Rand
	Inc	ax
	Push	ax; compute color.
	Mov	cx,ax; save color.
	Call	PSet; plot the point.
	Mov	ax,q
	Call	Rand
	Mov	ex,ax; get and save end x coord.
	Mov	dx,mx
	Mul	dx
	Div	q; ax = scaled x value.
	Mov	bx,ax; save x coord.
	Mov	ax,bx
	Add	ax,ox
	Push	ax; get x coord.
	Mov	ax,q
	Call	Rand
	Mov	ey,ax; get and save end y coord.
	Mov	dx,my
	Mul	dx
	Div	q; ax = scaled y value.
	Mov	bp,ax; save y coord.
	Mov	ax,bp
	Add	ax,oy
	Push	ax; get y coord.
	Push	cx; same color.
	Call	Line; plot the line.
	Call	Quad; duplicate it in the other quadrants.
	Mov	ax,sx
	Xchg	ax,sy; exchange sx and sy.
	Mov	dx,mx
	Mul	dx
	Div	q; ax = scaled x value.
	Mov	si,ax; save x coord.
	Mov	ax,si
	Add	ax,ox
	Push	ax; get x coord.
	Mov	ax,sy; get new sy.
	Mov	dx,my
	Mul	dx
	Div	q; ax = scaled y value.
	Mov	di,ax; save y coord.
	Mov	ax,di
	Add	ax,oy
	Push	ax; get y coord.
	Push	cx; same color.
	Call	PSet; plot the point.
	Mov	ax,ex
	Xchg	ax,ey; exchange ex and ey.
	Mov	dx,mx
	Mul	dx
	Div	q; ax = scaled x value.
	Mov	bx,ax; save x coord.
	Mov	ax,bx
	Add	ax,ox
	Push	ax; swap and get x coord.
	Mov	ax,ey; get new ey.
	Mov	dx,my
	Mul	dx
	Div	q; ax = scaled y value.
	Mov	bp,ax; save y coord.
	Mov	ax,bp
	Add	ax,oy
	Push	ax; get y coord.
	Push	cx; same color.
	Call	Line; plot the line.
	Call	Quad; duplicate it in the other quadrants.
	Ret; return...............................
Kaleid EndP; end proc to put a Kaleidoscope up.
;
;\\\\\\\
; Quad \
;\\\\\\\
;
;
;   Quad is called to duplicate a line in quadrant II in the other
;   three quadrants (I, III, and IV).
;
;   Entry Conditions:
;       ax = scratch.
;       bx = ending x coord.
;       cx = color.
;       dx = scratch.
;       bp = ending y coord.
;       si = starting x coord.
;       di = starting y coord.
;
;   Exit Conditions:
;       ax = scratch.
;       bx = ending x coord.
;       cx = color.
;       dx = scratch.
;       bp = ending y coord.
;       si = starting x coord.
;       di = starting y coord.
;
;
Quad Proc Near; procedure to duplicate in quads.
	Mov	ax,mx
	Sub	ax,1
	Sub	ax,si
	Add	ax,ox
	Push	ax; compute quad I x coord.
	Mov	ax,di
	Add	ax,oy
	Push	ax; use quad II y for quad I y coord.
	Push	cx; same color.
	Call	PSet; plot the point.
	Mov	ax,mx
	Sub	ax,1
	Sub	ax,bx
	Add	ax,ox
	Push	ax; compute quad I x coord.
	Mov	ax,bp
	Add	ax,oy
	Push	ax; use quad II y for quad I y coord.
	Push	cx; same color.
	Call	Line; plot the line.
	Mov	ax,si
	Add	ax,ox
	Push	ax; use quad II x for quad III x coord.
	Mov	ax,my
	Sub	ax,1
	Sub	ax,di
	Add	ax,oy
	Push	ax; compute quad III y coord.
	Push	cx; same color.
	Call	PSet; plot the point.
	Mov	ax,bx
	Add	ax,ox
	Push	ax; use quad II x for quad III x coord.
	Mov	ax,my
	Sub	ax,1
	Sub	ax,bp
	Add	ax,oy
	Push	ax; compute quad III y coord.
	Push	cx; same color.
	Call	Line; plot the line.
	Mov	ax,mx
	Sub	ax,1
	Sub	ax,si
	Add	ax,ox
	Push	ax; compute quad IV x coord.
	Mov	ax,my
	Sub	ax,1
	Sub	ax,di
	Add	ax,oy
	Push	ax; compute quad IV y coord.
	Push	cx; same color.
	Call	PSet; plot the point.
	Mov	ax,mx
	Sub	ax,1
	Sub	ax,bx
	Add	ax,ox
	Push	ax; compute quad IV x coord.
	Mov	ax,my
	Sub	ax,1
	Sub	ax,bp
	Add	ax,oy
	Push	ax; compute quad IV y coord.
	Push	cx; same color.
	Call	Line; plot the line.
	Ret; return...............................
Quad EndP; end proc to duplicate in quads.
;
;\\\\\\\\\
; Number \
;\\\\\\\\\
;
;
;   Number converts an ASCII decimal number from the buffer at [si] and
;   returns it in ax.  If no number exists, zero is returned.  If the
;   number is not delimited by white space, the Usage message is displayed
;   and control is returned to DOS with ErrorLevel 255.  No check is made
;   for overflow so the actual number returned is modulo 65536.
;
;   Entry Conditions:
;       ax = scratch.
;       dx = scratch.
;       si = address of input string.
;       di = scratch.
;
;   Exit Conditions:
;       ax = number.
;       dx = scratch.
;       si = pointer to delimiter (non-numeric).
;       di = number.
;
;
Number Proc Near; procedure to get a number.
	Sub	di,di; di = initial value (zero).
?Top0007:; scan off leading white space.
	Lodsb
	Cmp	al,13
	Jz	?End0007; get char, break if cr.
	Cmp	al,' ' ; if space, tab or ctrl char...
	Jbe	?Top0007
?Els0007:
?End0007:; loop 'til white space gone...
?Top0008:; now get the number...
	Sub	al,'0'
	Jae	?Els0009
?Top0009:
	Dec	si
	Jmp	Short ?End0008
?Els0009:
?End0009:; if below zero back up & break.
	Cmp	al,9
	Jbe	?Els000A
?Top000A:
	Dec	si
	Jmp	Short ?End0008
?Els000A:
?End000A:; if above nine back up & break.
	Sub	ah,ah
	Xchg	di,ax; ax = old, di = new.
	Mov	dx,10
	Mul	dx
	Add	di,ax; di = new value.
	Lodsb; al = next char.
	Jmp	?Top0008
?Els0008:
?End0008:; loop 'til done...
	Cmp	B[si],' ' ; if delimiter is space or ctrl char...
	Ja	?Els000B
?Top000B:
	Mov	ax,di
	Ret
?Els000B:
?End000B:; return with number...................
	Mov	dx,O(umsg)
	Mov	ah,9
	Int	21h; non-numeric, print usage message.
	Mov	ax,4CFFh
	Int	21h; return with ErrorLevel 255.
Number EndP; end of procedure to get a number.
;
;\\\\\\\
; Rand \
;\\\\\\\
;
;
;   Rand is a random number generator.
;
;   Entry Conditions:
;       ax = largest random number desired + 1.  Zero => 65536.
;       dx = scratch.
;
;   Exit Conditions:
;       ax = the random number.
;       dx = the random number.
;
;
data Segment; define data Segment.
seed	dw	5678h
	dw	1234h; define the default seed.
data EndS; close data segment, goes after code.
Rand Proc Near; procedure to generate random numbers.
	Push	bx
	Push	ax; save bx and max. random number.
	Mov	ax,3
	Mul	seed[0]; ax = 3.  dxax = LSW seed * 3.
	Mov	bx,ax; bx = LSW seed * 3.
	Mov	ax,43FDh
	Mul	seed[2]; ax = 43FD.  dxax = MSW seed * 43FD.
	Add	bx,ax; bx = LSW seed * 3 + MSW seed * 43FD.
	Mov	ax,43FDh
	Mul	seed[0]; ax = 43FD.  dxax = LSW seed * 43FD.
	Add	dx,bx; dxax = seed * 343FDh.
	Add	ax,9EC3h
	Adc	dx,26h; dxax = seed * 343FDh + 269EC3h.
	Mov	seed[0],ax
	Mov	seed[2],dx; save new seed for next time.
	Pop	bx
	Test	bx,bx; if max. random < 65536, then...
	Jz	?Els000C
?Top000C:
	Mov	ax,dx
	Sub	dx,dx
	Div	bx
?Els000C:
?End000C:; random is MSW of seed MOD max.
	Mov	ax,dx; ax = dx = random number.
	Pop	bx
	Ret; restore bx and return................
Rand EndP; end proc to generate random numbers.
;
;\\\\\\\
; PSet \
;\\\\\\\
;
;
;   PSet sets the specified EGA pixel to the specified color (0-15).
;   This routine is Pascal callable.  8088 or better compatible.
;
;   Calling Sequence:
;       =xpos =ypos =color; =.PSet;             \ plot a point.
;
;   Entry Conditions:
;       Stack Frame contains:
;          return address.
;          pc (pixel color).
;          yi (y input).
;          xi (x input).
;
;   Exit Conditions:
;       Stack Frame removed.
;       All Registers preserved.
;
;
xi Equ [bp][8]; x input.
yi Equ [bp][6]; y input.
pc Equ [bp][4]; pixel color.
NARGS = 3; number of arguments.
data Segment
xo	dw	0
yo	dw	0; save locations for last coords.
data EndS
EGA_CCR Equ 03D4h; CRT Control Register port address.
EGA_GCR Equ 03CEh; Graphics Controller Reg port addr.
EGA_SQR Equ 03C4h; Sequencer port address.
EGA_MMR Equ 02h; wo Map Mask Register sub index.
EGA_RAM Equ 0A000h; start segment for EGA text RAM.
GL Equ 80; number of bytes in line of graphics.
PSet Proc Near; proc to plot a point.
	Push	bp
	Mov	bp,sp; save bp & set-up stack frame.
	Push	ax
	Push	cx
	Push	dx
	Push	di; save regs.
	Mov	dx,EGA_SQR; dx = Sequencer Port Address.
	Mov	ah,0Fh
	Mov	al,EGA_MMR
	Out	DX,AX; enable all four planes.
	Mov	dx,EGA_GCR; dx = Graphic Ctrl Reg Port.
	Mov	ax,0005h
	Out	DX,AX; al = sub reg 5, ah = mode 0.
	Mov	ax,0F01h
	Out	DX,AX; ax = enable all S/R.
	Mov	ah,pc
	Sub	al,al
	Out	DX,AX; set S/R register to color.
	Mov	ax,yi
	Mov	yo,ax; yo = ax = yi.
	Mov	dx,GL
	Mul	dx
	Xchg	di,ax; di = row address.
	Mov	ax,xi
	Mov	xo,ax; xo = ax = xi.
	Mov	cl,al
	And	cl,7; cl = bit number.
	Shr	ax,1
	Shr	ax,1
	Shr	ax,1
	Add	di,ax; di = byte address in GRAM.
	Mov	dx,EGA_GCR; dx = Graphic Ctrl Reg Port.
	Mov	ax,8008h
	Shr	ah,cl
	Out	DX,AX; write bit pattern to mask register.
	Mov	bp,ds
	Mov	ax,EGA_RAM
	Mov	ds,ax; save ds, ds = screen segment address.
	Xchg	[di],al; draw the pixel.
	Mov	ds,bp; restore ds.
	Mov	ax,0FF08h
	Out	DX,AX; restore unimpeded writes.
	Mov	ax,00001h
	Out	DX,AX; disable all set/reset regs.
	Pop	di
	Pop	dx
	Pop	cx
	Pop	ax
	Pop	bp; restore registers.
	Ret	NARGS*2; return with clean stack......
PSet EndP; end proc to plot a point.
;
;\\\\\\\
; Line \
;\\\\\\\
;
;
;   Line draws a line from last EGA point to the specified point in
;   the specified color (0-15).  This routine is Pascal callable.
;   8088 or better compatible.
;
;   Calling Sequence:
;       =xpos =ypos =color; =.Line;             \ plot a line.
;
;   Entry Conditions:
;       Stack Frame contains:
;          return address.
;          pc (pixel color).
;          yi (y input).
;          xi (x input).
;
;   Exit Conditions:
;       Stack Frame removed.
;       All Registers are preserved.
;
;
data Segment
t	dw	0
l	dw	0; total segs, line length.
data EndS
Line Proc Near; proc to draw a line.
	Push	bp
	Mov	bp,sp; set-up stack frame.
	Push	ax
	Push	cx
	Push	dx
	Push	di
	Push	bx
	Push	si; save registers.
	Mov	dx,EGA_SQR; dx = Sequencer Port Address.
	Mov	ah,0Fh
	Mov	al,EGA_MMR
	Out	DX,AX; enable all four planes.
	Mov	dx,EGA_GCR; dx = Graphic Ctrl Reg Port.
	Mov	ax,0005h
	Out	DX,AX; al = sub reg 5, ah = mode 0.
	Mov	ax,0F01h
	Out	DX,AX; ax = enable all S/R.
	Mov	ah,pc
	Sub	al,al
	Out	DX,AX; set S/R register to color.
	Mov	ax,xi
	Sub	ax,xo; ax = x-diff.
	Mov	bx,yi
	Sub	bx,yo; bx = y-diff.
?Top000D:; case of x ? y.
; case of y same.
	Jnz	?Els000E
?Top000E:; yes then...
	Test	ax,ax; test direction of draw.
	Mov	di,xo
	Mov	si,xi
	Mov	xo,si; to right, di = xo, si = xi.
	Jns	?Els000F
?Top000F:
	Xchg	di,si
?Els000F:
?End000F:; to left, di = xi, si = xo.
	Mov	cx,di
	And	cx,7
	Shr	di,1
	Shr	di,1
	Shr	di,1; cl = bit numb, di = byte numb
	Mov	bx,si
	And	bx,7; bl = end bit number in byte.
	Shr	si,1
	Shr	si,1
	Shr	si,1
	Sub	si,di; si = numb of bytes involved.
	Mov	ax,GL
	Mul	yo
	Add	di,ax; di = start byte offset.
	Mov	bh,0FFh
	Shr	bh,cl; bh = start byte mask.
	Mov	cx,si; cx = numb of bytes involved.
	Mov	si,ds
	Mov	ax,EGA_RAM
	Mov	ds,ax; si = ds, ds = GRAM segment.
	Mov	al,08h
	Mov	dx,EGA_GCR; al = reg #, dx = GCR port.
; cx = number of bytes involved
	Jcxz	?Els0010
?Top0010:; if start and end bytes diff
	Mov	ah,bh
	Out	DX,AX; write 1st pattern to mask reg
	Xchg	[di],ah
	Inc	di
	Dec	cx; plot 1st byte pattern.
	Mov	bh,0FFh
	Mov	ah,bh
	Out	DX,AX; write bit pattern to mask reg
	Jcxz	?Els0011
?Top0011:
	Xchg	[di],ah
	Inc	di
	Loop	?Top0011
?Els0011:
?End0011:; plot cx whole byte patterns.
?Els0010:
?End0010:; endif diff start and end byte
	Mov	cl,bl
	Mov	ah,80h
	Sar	ah,cl
	And	ah,bh; ah = end pattern mask.
	Out	DX,AX
	Xchg	[di],ah; plot last byte's worth.
	Mov	ds,si; restore ds and exit.
	Jmp	?End000D
?Els000E:
?End000E:; end y same.
	Xchg	bx,ax
	Test	bx,bx; case of x same.
	Jnz	?Els0012
?Top0012:; yes then...
	Xchg	bx,ax
	Test	bx,bx; bx = n, test draw direction.
	Mov	ax,yo
	Mov	dx,yi
	Mov	yo,dx; down, ax = yo, dx = yi, bx=n
	Jns	?Els0013
?Top0013:
	Xchg	ax,dx
	Neg	bx
?Els0013:
?End0013:; up, ax = yi, dx = yo. abs(bx)
	Mov	si,GL
	Mul	si
	Xchg	di,ax; si = increment, di = strt row
	Mov	ax,xo; ax = x-old.
	Mov	cl,al
	And	cl,7; cl = bit number.
	Shr	ax,1
	Shr	ax,1
	Shr	ax,1
	Add	di,ax; di = start GRAM address.
	Mov	ax,8008h
	Shr	ah,cl; ah = bit pattern, al = reg #
	Mov	dx,EGA_GCR
	Out	DX,AX; write bit pattern to mask reg
	Mov	cx,bx
	Inc	cx; cx = number to do.
	Mov	bx,ds
	Mov	ax,EGA_RAM
	Mov	ds,ax; bx = ds, ds = GRAM segment.
?Top0014:
	Xchg	[di],al
	Add	di,si
	Loop	?Top0014
?Els0014:
?End0014:; draw vertical line.
	Mov	ds,bx; restore ds and exit.
	Jmp	?End000D
?Els0012:
?End0012:; end x same.
	Cwd	
	Xor	ax,dx
	Sub	ax,dx
	Inc	ax; ax = y pixels to do.
	Xchg	bx,ax
	Mov	si,GL
	Xor	si,dx
	Sub	si,dx; bx = numb y pixels, si = dir.
	Cwd	
	Xor	ax,dx
	Sub	ax,dx
	Inc	ax; ax = numb x pixels, dx = dir.
	Mov	di,yi
	Xchg	di,yo; di = old y, save new y.
	Test	dx,dx
	Mov	cx,xi
	Xchg	xo,cx; cx = old x, save new x.
	Jns	?Els0015
?Top0015:
	Mov	cx,xo
	Mov	di,yo
	Neg	si
?Els0015:
?End0015:; don't let x move to the left.
	Xchg	ax,di
	Mov	dx,GL
	Mul	dx
	Xchg	di,ax; di = start row GRAM address.
	Cmp	ax,bx; case of x and y pixels same.
	Jnz	?Els0016
?Top0016:; yes then...
	Mov	ax,cx; ax = start x coord.
	And	cl,7; cl = bit number.
	Shr	ax,1
	Shr	ax,1
	Shr	ax,1
	Add	di,ax; di = start GRAM address.
	Mov	ax,8008h
	Shr	ah,cl; ah = bit pattern, al = reg #
	Mov	cx,bx; cx = number to do.
	Mov	bp,ds
	Mov	dx,EGA_RAM
	Mov	ds,dx; bp = ds, ds = GRAM segment.
	Mov	dx,EGA_GCR; dx = bit pattern to mask reg
?Top0017:; draw diagonal line.
	Out	DX,AX
	Xchg	[di],bl; set mask reg and draw pixel.
	Ror	ah,1
	Adc	di,si; adjust mask and GRAM address.
	Loop	?Top0017
?Els0017:
?End0017:; loop 'til done...
	Mov	ds,bp; restore ds.
; end x and y pixels same.
; case of less x than y pixels.
	Jmp	?End0016
?Els0016:
	Jae	?Els0018
?Top0018:; yes, then...
	Mov	t,ax; save total segs (x pixels).
	Mov	l,bx; save total pixels (Y pixels).
	Mov	dx,ax
	Sub	ax,ax
	Div	bx; ax = increment.
	Shl	dx,1
	Cmp	bx,dx
	Mov	bx,ax
	Adc	bx,0
	Sub	ax,ax; bx = rounded inc, ax = acc.
	Mov	bp,cx; bp = initial x.
	And	cl,7; cl = bit number.
	Shr	bp,1
	Shr	bp,1
	Shr	bp,1
	Add	di,bp; di = start GRAM address.
	Mov	dx,8008h
	Shr	dh,cl; dh = bit pattern, dl = reg #.
?Top0019:; while segments to do...
	Cmp	t,1; if not least segment...
	Jz	?Els001A
?Top001A:; then, compute segment len...
	Mov	cx,-1; -line minimum segment length.
?Top001B:
	Add	ax,bx
	Jb	?End001B
	Loop	?Top001B
?Els001B:
?End001B:; add inc, break if cy, loop.
	Neg	cx
	Sub	l,cx; cx = Seg len, l = remaining.
	Jmp	Short ?End001A
?Els001A:
?Top001C:
	Mov	cx,l
	Jcxz	?End0019
?Els001C:
?End001A:; else, use rem, break if none.
	Push	ax
	Push	bx
	Push	ds; save acc, inc and ds.
	Mov	ax,EGA_RAM
	Mov	ds,ax; ds = GRAM segment.
	Mov	ax,dx; ah = bit pattern, al = reg #.
	Mov	dx,EGA_GCR; dx = GCR port.
?Top001D:; draw next vertical segment...
	Out	DX,AX
	Xchg	[di],bl; set mask reg and draw pixel.
	Add	di,si; adjust GRAM address.
	Loop	?Top001D
?Els001D:
?End001D:; loop 'til segment done...
	Ror	ah,1
	Adc	di,0; adjust mask and GRAM address.
	Mov	dx,ax; dh = bit pattern, dl = reg #.
	Pop	ds
	Pop	bx
	Pop	ax; restore acc, inc, ds.
	Dec	t; decrement total numb segments
	Jnz	?Top0019
?Els0019:
?End0019:; loop until done...
; end more y than x pixels.
	Jmp	?End0016
?Els0018:
?Top001E:; case of more x than y pixels.
	Mov	t,bx; save total segs (y pixels).
	Mov	l,ax; save total pixels (x pixels).
	Mov	dx,bx
	Mov	bx,ax
	Sub	ax,ax
	Div	bx; ax = increment.
	Shl	dx,1
	Cmp	bx,dx
	Mov	bx,ax
	Adc	bx,0
	Sub	ax,ax; bx = rounded inc, ax = acc.
	Mov	bp,cx; bp = initial x coord.
	Shr	bp,1
	Shr	bp,1
	Shr	bp,1
	Add	di,bp; di = initial GRAM address.
	Mov	bp,cx
	And	bp,7; bp = initial x bit position.
	Mov	dx,EGA_GCR; dx = GCR port.
?Top001F:; for each line segment...
	Cmp	t,1; if not least segment...
	Jz	?Els0020
?Top0020:; then, compute segment len...
	Mov	cx,-1; -line minimum segment length.
?Top0021:
	Add	ax,bx
	Jb	?End0021
	Loop	?Top0021
?Els0021:
?End0021:; add inc, break if cy, loop.
	Neg	cx
	Sub	l,cx; cx = Seg len, l = remaining.
	Jmp	Short ?End0020
?Els0020:
?Top0022:
	Mov	cx,l
	Jcxz	?End001F
?Els0022:
?End0020:; else, use rem, break if none.
	Push	ax
	Push	bx
	Push	ds; save acc, inc and ds.
	Mov	ax,EGA_RAM
	Mov	ds,ax; ds = GRAM segment.
	Add	cx,bp
	Mov	ax,cx
	Dec	ax
	Xchg	bp,cx
	And	bp,7; cx = x bit pos, bp = next pos
	Mov	bl,al
	And	bl,7; bl = end bit number in byte.
	Mov	bh,0FFh
	Shr	bh,cl; bh = start byte mask.
	Xchg	cx,ax
	Shr	cx,1
	Shr	cx,1
	Shr	cx,1; cx = numb of bytes involved.
	Mov	al,08h; al = reg #.
; cx = number of bytes involved
	Jcxz	?Els0023
?Top0023:; if start and end bytes diff
	Mov	ah,bh
	Out	DX,AX; write 1st pattern to mask reg
	Xchg	[di],ah
	Inc	di
	Dec	cx; plot 1st byte pattern.
	Mov	ah,0FFh
	Mov	bh,ah
	Out	DX,AX; write bit pattern to mask reg
	Jcxz	?Els0024
?Top0024:
	Xchg	[di],ah
	Inc	di
	Loop	?Top0024
?Els0024:
?End0024:; plot cx whole byte patterns.
?Els0023:
?End0023:; endif diff start and end byte
	Mov	cl,bl
	Mov	ah,80h
	Sar	ah,cl
	And	ah,bh; ah = end pattern mask.
	Out	DX,AX
	Xchg	[di],al; plot last byte's worth.
	Shr	ah,1
	Adc	di,si; di = next GRAM address.
	Pop	ds
	Pop	bx
	Pop	ax; restore acc, inc, ds.
	Dec	t; decrement total numb segments
	Jnz	?Top001F
?Els001F:
?End001F:; loop until done...
?Els001E:
?End0016:; end more x than y pixels.
?Els000D:
?End000D:; end case of x ? y.
	Mov	ax,0FF08h
	Out	DX,AX; restore unimpeded writes.
	Mov	ax,00001h
	Out	DX,AX; disable all set/reset regs.
	Pop	si
	Pop	bx
	Pop	di
	Pop	dx
	Pop	cx
	Pop	ax
	Pop	bp; restore registers.
	Ret	NARGS*2; return with clean stack......
Line EndP; end proc to draw a line.
code EndS; close code Segment, goes before data.
End Kaleidm; end of source, start at Kaleidm.
