/*
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991
 *
 * This modification of Douglas Thomson's code is released into the
 * public domain, Frank Davis.  You may distribute it freely.
 *
 * This file contains all prototypes for every function in tde.  It should
 * be included in every source code module.
 *
 * I'm so stupid, I can't keep up with which functions are used in which
 * files.  Let's gather all prototypes into one file, so I don't have
 * to remember too much.
 */


/***********************  function prototypes in bj_ctype.c *************/
int  bj_tolower( int );
int  bj_toupper( int );
int  bj_isspc( int );
/************************************************************************/


/*************************  function prototypes in block.c *************/
int  mark_block( TDE_WIN * );
int  unmark_block( TDE_WIN * );
void restore_marked_block( TDE_WIN *, int );
int  prepare_block( TDE_WIN *, line_list_ptr, int );
int  pad_dest_line( TDE_WIN *, file_infos *, line_list_ptr );
int  block_operation( TDE_WIN * );
void do_line_block( TDE_WIN *,  TDE_WIN *,  int,  file_infos *,  file_infos *,
                    int,  line_list_ptr,  line_list_ptr,  line_list_ptr,
                    line_list_ptr,  long,  long,  long,  int * );
void do_stream_block( TDE_WIN *,  TDE_WIN *,  int,  file_infos *,
                      file_infos *,  line_list_ptr,  line_list_ptr,
                      line_list_ptr,  line_list_ptr,
                      long,  long,  long,  int,  int,  int,  int * );
void do_box_block( TDE_WIN *,  TDE_WIN *,  int,  file_infos *,  file_infos *,
                   line_list_ptr, line_list_ptr,  long,  long,
                   long,  long,  long,  int,  int,  char *,
                   int,  int,  int,  int,  int,  int * );
void load_box_buff( char *, line_list_ptr, int, int, char );
int  copy_buff_2file( TDE_WIN *, char *, line_list_ptr, int, int, int );
void block_fill( char *, int, int );
void number_block_buff( char *, int, long, int );
void restore_cursors( file_infos * );
int  delete_box_block( TDE_WIN *, line_list_ptr, int, int );
void check_block( void );
void find_begblock( file_infos * );
void find_endblock( file_infos * );
int  block_write( TDE_WIN * );
int  block_print( TDE_WIN * );
int  get_block_fill_char( TDE_WIN *, int * );
int  get_block_numbers( TDE_WIN *, long *, long *, int * );
int  block_trim_trailing( TDE_WIN * );
int  block_email_reply( TDE_WIN * );
int  block_convert_case( TDE_WIN * );
void upper_case( text_ptr, size_t );
void lower_case( text_ptr, size_t );
void rot13( text_ptr, size_t );
void fix_uue( text_ptr, size_t );
void strip_hi( text_ptr, size_t );
int  get_block_border_style( TDE_WIN *, char * );
void justify_line_block( TDE_WIN *, line_list_ptr, long, long, int * );
int  block_indent( TDE_WIN * );
/************************************************************************/


/**********************  function prototypes in config.c   ***************/
int  tdecfgfile( TDE_WIN * );
int  readfile( char *, int );
void remove_cr( char * );
void parse_line( char *, int );
char *parse_token( char *, char * );
char *parse_literal( char *, char * );
int  search( char *, CONFIG_DEFS *, int );
void clear_previous_macro( int );
int  parse_macro( char *, int );
MACRO *initialize_macro( long );
void check_macro( MACRO * );
int  cfg_record_keys( MACRO *, long, int, int );
long cfg_search_tree( int, TREE * );
void new_sort_order( unsigned char *, unsigned char * );
int  add_twokey( long, int );
void new_upper_lower( unsigned char * );
void new_bj_ctype( unsigned char * );
/************************************************************************/


/**********************  function prototypes in *\console.c  ************/
void video_config( struct vcfg *cfg );
long getkey( void );
int  waitkey( int );
int  capslock_active( void );           /* moved by jmh 980723 */
void flush_keyboard( void );
void page(unsigned char);               /* new function added by jmh */
void xygoto( int, int );
void update_line( TDE_WIN * );
void c_output( int, int, int, int );
void s_output( char FAR *, int, int, int );
void eol_clear( int, int, int );
void window_eol_clear( TDE_WIN *, int );
void hlight_line( int, int, int, int );
void cls( void );
void set_cursor_size( int );
void set_overscan_color( int );
void save_screen_line( int, int, Char * );
void restore_screen_line( int, int, Char * );
void save_area( Char *, int, int, int, int );
void restore_area( Char *, int, int, int, int );
/************************************************************************/


/*************************  function prototypes in diff.c  **************/
int  define_diff( TDE_WIN * );
int  repeat_diff( TDE_WIN * );
int  differ( int, int, int );
int  skip_leading_space( text_ptr, int );
line_list_ptr skip_eol( line_list_ptr, int *, int *, long *, long * );
void show_diff_window( TDE_WIN * );
int  verify_number( char *, int * );
int  verify_letter( char *, int *, TDE_WIN ** );
/************************************************************************/


/*************************  function prototypes in dirlist.c *************/
int  dir_help( TDE_WIN * );
int  dir_help_name( TDE_WIN *, char * );
void FAR *my_calloc( unsigned, unsigned );
int  list_and_pick( char *, TDE_WIN * );
void setup_directory_window( DIRECTORY *, FTYPE *, int );
void recalculate_dir( DIRECTORY *, FTYPE *, int );
void write_directory_list( FTYPE *, DIRECTORY );
int  select_file( FTYPE *, char *, DIRECTORY * );
void shell_sort( FTYPE *, int );
int  dir_cmp( char *, char * );
/************************************************************************/


/*************************  function prototypes in ed.c *****************/
int  insert_newline( TDE_WIN * );
int  insert_overwrite( TDE_WIN * );
int  join_line( TDE_WIN * );
int  dup_line( TDE_WIN * );
int  word_delete( TDE_WIN * );
int  back_space( TDE_WIN * );
int  transpose( TDE_WIN * );            /* new function by jmh */
int  line_kill( TDE_WIN * );
int  char_del_under( TDE_WIN * );
int  eol_kill( TDE_WIN * );
int  undo_line( TDE_WIN * );
int  undo( TDE_WIN * );
int  beg_next_line( TDE_WIN * );
int  next_line( TDE_WIN * );
int  home( TDE_WIN * );
int  goto_eol( TDE_WIN * );
int  goto_top( TDE_WIN * );
int  goto_bottom( TDE_WIN * );
int  set_tabstop( TDE_WIN * );
void show_line_col( TDE_WIN * );
void show_asterisk( TDE_WIN * );
int  toggle_overwrite( TDE_WIN * );
int  toggle_smart_tabs( TDE_WIN * );
int  toggle_indent( TDE_WIN * );
int  set_left_margin( TDE_WIN * );
int  set_right_margin( TDE_WIN * );
int  set_paragraph_margin( TDE_WIN * );
int  toggle_ww( TDE_WIN * );
int  toggle_crlf( TDE_WIN * );
int  toggle_trailing( TDE_WIN * );
int  toggle_z( TDE_WIN * );
int  toggle_eol( TDE_WIN * );
int  toggle_search_case( TDE_WIN * );
int  toggle_sync( TDE_WIN * );
int  toggle_ruler( TDE_WIN * );
int  toggle_tabinflate( TDE_WIN * );
int  toggle_cursor_cross( TDE_WIN * );  /* new function added by jmh 980724 */
int  toggle_graphic_chars( TDE_WIN * ); /* new function added by jmh 980724 */
int  change_cur_dir( TDE_WIN * );       /* new function added by jmh 981129 */
void cursor_sync( TDE_WIN * );
void editor( void );
int  repeat( TDE_WIN * );               /* new function added by jmh */
void display_dirty_windows( TDE_WIN * );
void show_dirty_window( TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in file.c  **************/
int  write_file( char *, int, file_infos *, long, long, int );
int  hw_save( char *, file_infos *, long, long, int );
int  hw_append( char *, file_infos *, long, long, int );
int  load_file( char *, file_infos *, int *, int, line_list_ptr );
void insert_node( file_infos *, line_list_ptr, line_list_ptr );
int  show_file_2big( char *, int, line_list_ptr, text_ptr );
int  backup_file( TDE_WIN * );
int  edit_file( char *, int, int );
int  edit_another_file( TDE_WIN * );
int  attempt_edit_display( char *, int );
int  file_file( TDE_WIN * );
int  file_all( TDE_WIN * );     /* new function by jmh */
int  save_file( TDE_WIN * );
int  save_backup( TDE_WIN * );
int  save_as_file( TDE_WIN * );
void make_backup_fname( file_infos * );
int  write_to_disk( TDE_WIN *, char * );
int  search_and_seize( TDE_WIN * );
int  edit_next_file( TDE_WIN * );
int  binary_file( char * );
/************************************************************************/


/*************************  function prototypes in findrep.c ************/
int  get_replacement_flags( int );
int  ask_replace( TDE_WIN *, int * );
int  ask_wrap_replace( TDE_WIN *, int * );
void do_replace( TDE_WIN *, int );
int  find_string( TDE_WIN * );
void build_boyer_array( void );
void build_forward_skip( boyer_moore_type * );
void build_backward_skip( boyer_moore_type * );
int  calculate_forward_md2( char *, int );
int  calculate_backward_md2( char *, int );
line_list_ptr forward_boyer_moore_search( TDE_WIN *, long *, int * );
line_list_ptr search_forward( line_list_ptr, long *, size_t *, long );
line_list_ptr backward_boyer_moore_search( TDE_WIN *, long *, int * );
line_list_ptr search_backward( line_list_ptr, long *, size_t *, long );
void show_search_message( int );
void bin_offset_adjust( TDE_WIN *, long );
void find_adjust( TDE_WIN *, line_list_ptr, long, int );
int  replace_string( TDE_WIN * );
int  replace_and_display( TDE_WIN*, line_list_ptr, long, int, int*, int*, int );
line_list_ptr scan_forward( long *, int *, line_list_ptr, char, char, int * );
line_list_ptr scan_backward( long *, int *, line_list_ptr, char, char, int * );
int  match_pair( TDE_WIN * );
int  set_break_point( TDE_WIN * );      /* new function added by jmh 980815 */
/************************************************************************/


/*************************  function prototypes in hwind.c **************/
void format_time( char *, char * );     /* added by jmh 980521 */
void show_end_mem( void );
void show_end_text( TDE_WIN * );
void show_modes( void );
void show_file_count( int );
void show_window_count( int );
void show_avail_mem( void );
void show_tab_modes( void );
void show_indent_mode( void );
void show_search_case( void );
void show_sync_mode( void );
void show_wordwrap_mode( void );
void show_trailing( void );
void show_control_z( void );
void show_insert_mode( void );
void show_graphic_chars( void );        /* added by jmh 980724 */
void show_cur_dir( void );              /* added by jmh 981129 */
void show_recording( void );            /* added by jmh 981129 */
void my_scroll_down( TDE_WIN * );
void combine_strings( char *, char *, char *, char * );
void make_ruler( TDE_WIN * );
void show_ruler( TDE_WIN * );
void show_ruler_char( TDE_WIN * );
void show_ruler_pointer( TDE_WIN * );
void show_all_rulers( void );
int  show_help( void );
void show_strings( char **, int, int, int );
/************************************************************************/


/************************  function prototypes in macro.c  **************/
int  record_on_off( TDE_WIN * );
int  find_combination( TDE_WIN * );
TREE *search_tree( long, TREE * );
MACRO *find_pseudomacro( int, TDE_WIN * );
void add_branch( TREE *, TREE * );
void record_key( long, int );
void show_avail_strokes( int );
int  save_strokes( TDE_WIN * );
void write_macro( FILE *, MACRO *, char **, char ** );
void write_pseudomacro( FILE *, TREE *, char **, char ** );
void write_twokeymacro( FILE *, TREE *, char **, char ** );
char *key_name( long, char *, char ** );
int  clear_macros( TDE_WIN * );
void delete_pseudomacro( TREE * );
void delete_twokeymacro( TREE * );
int  play_back( TDE_WIN * );
int  push_macro_stack( void );
int  pop_macro_stack( void );
int  macro_pause( TDE_WIN * );
long getkey_macro( void );              /* new function added by jmh 980726 */
/************************************************************************/


/*************************  function prototypes in main.c  **************/
int  main( int, char *[] );
void error( int, int, char * );
#if defined( __DOS16__ )
 #if defined( __MSC__ )
  void interrupt FAR harmless( void );
 #else
  int harmless( void );
 #endif
  void interrupt FAR ctrl_break( void );
#endif
void terminate( void );
int  initialize( void );
void hw_initialize( void );
int  get_help( TDE_WIN * );
void show_credits( void );
/************************************************************************/


/*************************  function prototypes in port.c *************/
void FAR *my_malloc( size_t, int * );
void my_free( void FAR * );
long my_heapavail( void );
void my_memcpy( void FAR *dest, void FAR *src, size_t size );
void my_memmove( void FAR *dest, void FAR *src, size_t size );
#if !defined( __DOS16__ )
# define my_ltoa itoa
# define my_strlen strlen
# define my_realloc realloc
#else
# define my_ltoa ltoa
# define my_strlen _fstrlen             /* added by jmh 980716 */
# if defined( __MSC__ )
#  define my_realloc _frealloc          /* added by jmh 980806 */
# else
#  define my_realloc farrealloc
# endif
#endif
FTYPE *my_findfirst( char *, FFIND *, int );
FTYPE *my_findnext( FFIND * );
int  hw_fattrib( char * );
int  change_mode( char *, int );
int  change_fattr( TDE_WIN * );
int  get_fattr( char FAR *, fattr_t * );
int  set_fattr( char FAR *, fattr_t );
int  get_current_directory( char FAR *, int );
int  set_current_directory( char FAR * );
void get_full_path( char FAR *, char FAR * );   /* new function added by jmh */
/************************************************************************/


/*************************  function prototypes in pull.c *************/
int  main_pull_down( TDE_WIN * );
void draw_lite_alt( int, int [] );
int  lite_bar_menu( int *, int * );
int  pull_me( int, int, int, int, int * );
void get_bar_spacing( int, int *, int * );
void draw_lite_head( int, int [] );
void get_minor_counts( void );
void init_menu( void );                 /* new function added by jmh */
/************************************************************************/


/*************************  function prototypes in query.c **************/
int  getfunc( long );
long translate_key( int key );          /* added by jmh 980725 */
int  get_name( char *, int, char * );
int  copy_word( TDE_WIN *, char *, int, int );  /* added by jmh 980731 */
int  get_response( char *, int, int, int, int, int, ... );
#define get_yn( prompt, line, flag ) \
   get_response( prompt, line, flag, 2, L_YES, A_YES, L_NO, A_NO )
#define get_ny( prompt, line, flag ) \
   get_response( prompt, line, flag, 2, L_NO, A_NO, L_YES, A_YES )
int  get_sort_order( TDE_WIN * );
int  get_direction( TDE_WIN *, char * );
/************************************************************************/


/*************************  function prototypes in regx.c *************/
int  find_regx( TDE_WIN * );
line_list_ptr forward_regx_search( TDE_WIN *, long *, int * );
line_list_ptr regx_search_forward( line_list_ptr, long *, int *, long );
line_list_ptr backward_regx_search( TDE_WIN *, long *, int * );
line_list_ptr regx_search_backward( line_list_ptr, long *, int *, long );
int  nfa_match( void );
int  build_nfa( void );
int  expression( void );
int  term( void );
int  factor( void );
int  escape_char( int );
void emit_cnode( int, int, int, int );
void emit_nnode( int, int, int, int, int );
int  put_dq( int );
int  push_dq( int );
int  pop_dq( void );
int  dequeempty( void );
void init_nfa( void );
void regx_error( char * );
int  separator( int );
int  Kleene_star( int );
int  letter( int );
/**********************************************************************/


/*************************  function prototypes in sort.c *************/
int  sort_box_block( TDE_WIN * );
void quick_sort_block( long, long, line_list_ptr, line_list_ptr );
void insertion_sort_block( long, long, line_list_ptr );
void load_pivot( line_list_ptr );
int  compare_pivot( line_list_ptr );
int  my_memcmp( text_ptr, text_ptr, int );
/************************************************************************/


/**********************  function prototypes in syntax.c  ***************/
int  init_syntax( TDE_WIN * );
int  scan_syntax( char *, char *, int );
int  syntax_read_line( FILE *, char ** );
LANGUAGE *add_language( char *, LANGUAGE * );
void syntax_parse_file( FILE *, LANGUAGE * );
void add_keyword_list( LANGUAGE *, int, char *, char * );
void add_keyword( LANGUAGE *, char *, int );
text_ptr is_keyword( LANGUAGE *, char *, int );
void syntax_init_colors( FILE * );
void syntax_init_lines( file_infos * );
void syntax_check( line_list_ptr, syntax_info * );
long syntax_check_lines( line_list_ptr, LANGUAGE * );
void syntax_check_block( long, long, line_list_ptr, LANGUAGE * );
int  syntax_attr( text_ptr, int, int, unsigned char *, LANGUAGE * );
int  syntax_toggle( TDE_WIN * );
int  syntax_select( TDE_WIN * );
int  my_strcmp( text_ptr, text_ptr );   /* added by jmh 980716 */
/************************************************************************/


/**********************  function prototypes in tab.c  ******************/
int  tab_key( TDE_WIN * );
int  backtab( TDE_WIN * );
int  next_smart_tab( TDE_WIN * );
int  prev_smart_tab( TDE_WIN * );
text_ptr entab( text_ptr, int );
void detab_linebuff( void );
void entab_linebuff( void );
text_ptr detab_a_line( text_ptr, int * );
int  detab_adjust_rcol( text_ptr, int );
int  entab_adjust_rcol( text_ptr, int, int );
int  block_expand_tabs( TDE_WIN * );
int  block_compress_tabs( TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in utils.c **************/
int  myiswhitespc( int );
void check_virtual_col( TDE_WIN *, int, int );
void copy_line( line_list_ptr );
int  un_copy_line( line_list_ptr,  TDE_WIN * , int );
/* jmh 980729: This function is currently unused.       */
/* int  un_copy_tab_buffer( line_list_ptr, TDE_WIN * ); */
void load_undo_buffer( file_infos *, text_ptr, int );
void set_prompt( char *, int );
void show_eof( TDE_WIN * );
void display_current_window( TDE_WIN * );
int  redraw_screen( TDE_WIN * );
void redraw_current_window( TDE_WIN * );
void show_changed_line( TDE_WIN * );
void show_curl_line( TDE_WIN * );
void dup_window_info( TDE_WIN *, TDE_WIN * );
void adjust_windows_cursor( TDE_WIN *, long );
int  first_non_blank( text_ptr, int );
int  find_end( text_ptr, int );
int  is_line_blank( text_ptr, int );
int  page_up( TDE_WIN * );
int  page_down( TDE_WIN * );
int  scroll_down( TDE_WIN * );
int  scroll_up( TDE_WIN * );
int  pan_up( TDE_WIN * );
int  pan_down( TDE_WIN * );
void show_window_header( TDE_WIN * );
void show_window_number_letter( TDE_WIN * );
void show_window_fname( TDE_WIN * );
void show_crlf_mode( TDE_WIN * );
void show_size( TDE_WIN * );
int  quit( TDE_WIN * );
int  quit_all( TDE_WIN * );             /* new function added by jmh */
int  move_up( TDE_WIN * );
int  move_down( TDE_WIN * );
int  prepare_move_down( TDE_WIN * );
int  move_left( TDE_WIN * );
int  move_right( TDE_WIN * );
int  pan_left( TDE_WIN * );
int  pan_right( TDE_WIN * );
int  word_left( TDE_WIN * );
int  word_right( TDE_WIN * );
int  next_dirty_line( TDE_WIN * );
int  prev_dirty_line( TDE_WIN * );
int  center_window( TDE_WIN * );
int  horizontal_screen_right( TDE_WIN * );
int  horizontal_screen_left( TDE_WIN * );
int  goto_top_file( TDE_WIN * );
int  goto_end_file( TDE_WIN * );
int  goto_line( TDE_WIN * );
int  set_marker( TDE_WIN * );
int  goto_marker( TDE_WIN * );
int  date_time_stamp( TDE_WIN * );
int  stamp_format( TDE_WIN * );         /* new function added by jmh */
int  add_chars( char *, TDE_WIN * );
int  dos_shell( TDE_WIN * );            /* new function added by jmh */
int  dos_screen( TDE_WIN * );           /* new function added by jmh */
/************************************************************************/


/*************************  function prototypes in window.c *************/
int  initialize_window( void );
int  get_next_letter( int );
void choose_window( char *, TDE_WIN * );
int  next_window( TDE_WIN * );
int  prev_window( TDE_WIN * );
int  split_horizontal( TDE_WIN * );
int  split_vertical( TDE_WIN * );
void show_vertical_separator( TDE_WIN * );
int  size_window( TDE_WIN * );
int  zoom_window( TDE_WIN * );
int  next_hidden_window( TDE_WIN * );
int  prev_hidden_window( TDE_WIN * );   /* new function added by jmh */
void setup_window( TDE_WIN * );
void finish( TDE_WIN * );
int  create_window( TDE_WIN **, int, int, int, int, file_infos * );
/************************************************************************/


/**********************  function prototypes in wordwrap.c **************/
int  find_left_margin( line_list_ptr, int );
void word_wrap( TDE_WIN * );
int  format_paragraph( TDE_WIN * );
void combine_wrap_spill( TDE_WIN *, int, int, int, int, int );
void justify_right_margin( TDE_WIN *, line_list_ptr, int, int, int );
void remove_spaces( int );
int  find_word( text_ptr, int, int );
int  flush_left( TDE_WIN * );
int  flush_right( TDE_WIN * );
int  flush_center( TDE_WIN * );
/************************************************************************/


/*************************  function prototypes in tdeasm.c *************/
#if !defined( __DOS16__ )
#define ptoul( ptr ) (void*)ptr
#else
unsigned long  ptoul( void FAR * );
#endif
text_ptr tabout( text_ptr, int * );
/*****************************************************/


#if defined( __DOS16__ )
/***********  function prototype for dos/simul101.asm *********/
void FAR simulate_enh_kbd( int );
/*****************************************************/

/***********  function prototype for dos/criterr.asm **********/
void FAR install_ceh( void FAR * );
/*****************************************************/
#endif


/***********  function prototype for *\criterr.c *************/
#if !defined( __DOS16__ )
void crit_err_handler( int );
# if defined( __DJGPP__ )
void crit_err_handler_end( void );
# endif
#else
int  FAR crit_err_handler( void );
void show_error_screen( void );
#endif
/*****************************************************/
