/*
 * I wrote this function because I'm so stupid, I constantly forget
 *  file names and directory stuff.  The main function prompts for a
 *  subdirectory name or a search path.  The default search path is the
 *  cwd (current working directory).  In addition to being stupid, I'm also
 *  lazy.  If the user types a subdirectory name, I think we can assume he
 *  wants to list all files w/o having to type *.*   Let's save the cwd on
 *  whatever drive the user wishes to search, so we can restore it we get
 *  thru dir'ing.  Use the standard DOS functions to get and set directories.
 *
 * The search pattern can contain wild card chars, valid file names, or a
 *  valid subdirectory name.
 *
 * Being that TDE 2.2 now handles binary files, lets make .EXE and .COM files
 *  autoload in binary mode.
 *
 * Before matching files are displayed on the screen, file names are sorted
 *  using the easy-to-implement and fairly fast Shellsort algorithm.
 *
 * See:
 *
 *   Donald Lewis Shell, "A High-Speed Sorting Procedure."  _Communications of
 *     the ACM_ 2 (No. 2): 30-32, 1959.
 *
 * See also:
 *
 *   Donald Ervin Knuth, _The Art of Computer Programming; Volume 3:  Sorting
 *     and Searching_, Addison-Wesley, Reading, Mass., 1973, Chapter 5,
 *     "Sorting", pp 84-95.  ISBN 0-201-03803-X.
 *
 *   Robert Sedgewick, _Algorithms in C_, Addison-Wesley, Reading, Mass.,
 *     1990, Chapter 8, "Elementary Sorting Methods", pp 107-111.
 *     ISBN 0-201-51425-7.
 *
 *
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991, version 1.0
 * Date:             July 29, 1991, version 1.1
 * Date:             October 5, 1991, version 1.2
 * Date:             January 20, 1992, version 1.3
 * Date:             February 17, 1992, version 1.4
 * Date:             April 1, 1992, version 1.5
 * Date:             June 5, 1992, version 2.0
 * Date:             October 31, 1992, version 2.1
 * Date:             April 1, 1993, version 2.2
 * Date:             June 5, 1993, version 3.0
 * Date:             August 29, 1993, version 3.1
 * Date:             November 13, 1993, version 3.2
 * Date:             June 5, 1994, version 4.0
 * Date:             December 5, 1998, version 5.0 (jmh)
 *
 * This code is released into the public domain, Frank Davis.
 *    You may distribute it freely.
 */

#include "tdestr.h"
#include "common.h"
#include "define.h"
#include "tdefunc.h"


static int fofs;                        /* offset in the file list for the */
                                        /* first file (jmh 980523)         */

/*
 * Name:    dir_help
 * Purpose: To prompt the user and list the directory contents
 * Date:    February 13, 1992
 * Passed:  window:  pointer to current window
 *
 * jmh 980528: disable command line language;
 *             use return code of attempt_edit_display.
 */
int  dir_help( TDE_WIN *window )
{
char dname[PATH_MAX+2]; /* directory search pattern */
int  rc;
int  prompt_line;
char *old_language;

   if (window != NULL) {
      entab_linebuff( );
      if (un_copy_line( window->ll, window, TRUE ) == ERROR)
         return( ERROR );
      prompt_line = window->bottom_line;
   } else
      prompt_line = g_display.nlines;

   /*
    * search path or pattern
    */
   dname[0] = '\0';
   rc = get_name( dir1, prompt_line, dname );

   if (rc == OK) {
      rc = list_and_pick( dname, window );

      /*
       * if everything is everything, load in the file selected by user.
       */
      if (rc == OK) {
         /*
          * Don't use the command line language.
          */
         old_language = g_status.language;
         g_status.language = NULL;
         rc = attempt_edit_display( dname, (window != NULL) ? LOCAL : GLOBAL );
         g_status.language = old_language;
      }
   }
   return( rc );
}


/*
 * Name:    dir_help_name
 * Purpose: To display name of directory
 * Date:    February 13, 1992
 * Passed:  window:  pointer to current window
 */
int  dir_help_name( TDE_WIN *window, char *name )
{
char dname[PATH_MAX+2]; /* directory search pattern */
int  rc;

   rc = OK;
   if (window != NULL) {
      entab_linebuff( );
      if (un_copy_line( window->ll, window, TRUE ) == ERROR)
         return( ERROR );
   }

   strcpy( dname, name );
   rc = list_and_pick( dname, window );

   /*
    * if everything is everything, load in the file selected by user.
    */
   if (rc == OK)
      rc = attempt_edit_display( dname, (window != NULL) ? LOCAL : GLOBAL );

   return( rc );
}


/*
 * Name:    list_and_pick
 * Purpose: To show matching file names and let user pick a file
 * Date:    February 13, 1992
 * Passed:  dname:  directory search pattern
 *          window:  pointer to current window
 * Returns: return code from pick.  rc = OK, then edit a new file.
 * Notes:   real work routine of this function.  save the cwd and let the
 *           user search upwards or downwards thru the directory structure.
 *          since we are doing DOS directory functions, we need to check the
 *           return code after each DOS call for critical errors.
 */
int  list_and_pick( char *dname, TDE_WIN *window )
{
int  rc;
FFIND dta;              /* file finding info */
DIRECTORY dir;          /* contains all info for dir display */
unsigned int cnt;       /* number of matching files */
FTYPE *flist, *p, *ffind; /* pointer to list of matching files */
char cwd[PATH_MAX];     /* save the current working directory in this buff */
char dbuff[PATH_MAX];   /* temporary directory buff */
int  change_directory = FALSE;
int  stop;
int  len;
int  drive;
int  prompt_line;

   prompt_line = (window != NULL) ? window->bottom_line : g_display.nlines;

   /*
    * Some algorithms alloc the maximum possible number of files in
    *  a directory, eg. 256 or 512.  Let's count the number of matching
    *  files so we know exactly how much memory to request from calloc.
    */
   ffind = my_findfirst( dname, &dta, TRUE );
   if (ffind == NULL) {
      error( WARNING, prompt_line, dir2 );
      return ERROR;
   }
   for (cnt=1; (ffind = my_findnext( &dta )) != NULL;)
      ++cnt;
   flist = (FTYPE *)calloc( cnt, sizeof(FTYPE) );
   if (flist != NULL) {

      stop = FALSE;
#if defined( __UNIX__ )
      drive = 0;
#else
      /*
       * If user entered drive name in search pattern, find out the drive and
       *  directory stem.
       */
      if (dta.stem[1] == ':') {

         /*
          * If the second character of the search pattern is a ':', the
          *  the first character of the pattern should be the drive.
          *  Convert drive to lower case and get a numerical representation.
          * CAVEAT:  In DOS v 2.x, there may be up to 63 logical drives.
          *   my algorithm may blow up if the number of logical drives
          *   is greater than 'Z'.
          * For DOS >= 3, the number of drives is limited to 26, I think.
          */
         drive = dta.stem[0];
         if (drive < 'a')
            drive += 32;
         drive = drive - 'a' + 1;

      /*
       * else get current directory from default drive
       */
      } else {

         /*
          * 0 = default drive.
          */
         drive = 0;
      }
#endif
      rc = get_current_directory( cwd, drive );
      if (rc == ERROR)
         stop = TRUE;

      while (stop == FALSE) {
         /*
          * If we had enough memory, find all matching file names.
          *
          * when we get here, we have already done: 1) my_findfirst and
          *  my_findnext, 2) counted the number of matching files, and
          *  3) allocated space.
          */
         p = flist;

         ffind = my_findfirst( dname, &dta, TRUE );
         do {

            /*
             * p is pointer that walks down the file info structure.
             *  save the file name and file size for each matching
             *  file we find. jmh 980527: save attribute as well.
             */

            strcpy( p->fname, ffind->fname );
            p->fsize = ffind->fsize;
            p->fattr = ffind->fattr;
            ++p;
            ffind = my_findnext( &dta );
         } while (ffind != NULL);

         if (rc != ERROR) {
            shell_sort( flist, cnt );

            /*
             * figure out number of rows, cols, etc... then display dir list
             */
            setup_directory_window( &dir, flist, cnt );
            write_directory_list( flist, dir );

            /*
             * Let user select file name or another search directory.
             *  Save the choice in dbuff. rc == OK if user selected file or dir.
             */
            strcpy( dbuff, dta.stem );
            strcat( dbuff, dta.pattern );
            rc = select_file( flist, dbuff, &dir );

            strcpy( dbuff, flist[dir.select].fname );
         }

         /*
          *  give memory back.
          */
         free( flist );
         flist = NULL;

         if (rc == ERROR)
            stop = TRUE;
         else {
            len = strlen( dbuff );

            /*
             * If the last character in a file name is '/' then let's
             *  do a dir on selected directory.  See the matching
             *  else when the user selects a file.
             */
            if (dbuff[len-1] == '/') {

               /*
                * Stem has subdirectory path.  dbuff has selected path.
                * Create a new dname with stem and dbuff.
                */

               assert( strlen( dta.stem ) + strlen( dbuff ) < PATH_MAX );

               strcpy( dname, dta.stem );
               strcat( dname, dbuff );
               len = strlen( dname );
               strcpy( dbuff, dname );

               /*
                * The last character in dbuff is '/', because we append the
                *  '/' to every directory entry in the file list.  Replace
                *  it with a NULL char then we will have a valid path name.
                */
               dbuff[len-1] = '\0';

               /*
                * now let's change to the selected subdirectory.
                */
               rc = set_current_directory( dbuff );
               if (rc == OK) {

                  /*
                   * Every time we change directories, we need to get the
                   *  current directory so we will be sure to have the
                   *  correct path.
                   */
                  rc = get_current_directory( dname, drive );
                  if (rc == OK) {
                     change_directory = TRUE;
                  }
               }

               /*
                * Validate the new path and allocate memory for the
                *  matching files.
                */
               if (rc == OK) {
                  strcat( dname, dta.pattern );
                  ffind = my_findfirst( dname, &dta, TRUE );
                  rc = (ffind == NULL);
                  if (rc != ERROR) {
                     for (cnt=1; (ffind = my_findnext( &dta )) != NULL;)
                        ++cnt;
                     flist = (FTYPE *)calloc( cnt, sizeof(FTYPE) );
                  }
               }
               if (flist == NULL || rc == ERROR) {
                  stop = TRUE;
                  rc = ERROR;
                  if (flist != NULL) {
                     free( flist );
                     flist = NULL;
                  }
               }
            } else {

               /*
                * user selected a file.  store fname in dname and return.
                */
               rc = OK;
               stop = TRUE;

               assert( strlen( dta.stem ) + strlen( dbuff ) < PATH_MAX );

               strcpy( dname, dta.stem );
               strcat( dname, dbuff );
            }
         }
      }

      /*
       * Go back to the current directory if needed.
       */
      if (change_directory) {
         cwd[strlen( cwd ) - 1] = '\0';         /* this should probably go */
         set_current_directory( cwd );          /*  in this function */
      }
      if (window != NULL)
         redraw_screen( window );

   } else {
      /*
       * out of memory
       */
      error( WARNING, prompt_line, main4 );
      rc = ERROR;
   }
   return( rc );
}


/*
 * Name:    setup_directory_window
 * Purpose: set number of rows and cols in directory window
 * Date:    February 13, 1992
 * Passed:  dir:   pointer to directory structure
 *          flist: list of filenames to be displayed
 *          cnt:   number of files
 * Notes:   set up stuff we need to know about how to display files.
 *
 * jmh 980524: displayed a few more lines.
 */
void setup_directory_window( DIRECTORY *dir, FTYPE *flist, int cnt )
{
int  i, j;
#if !defined( __DOS16__ )
int  cols[5] = { 0, 0, 0, 0, 0 };       /* number of columns to use */
#endif
int  wid;
char ch;
char temp[MAX_COLS];                    /* line to output */

   /*
    * setup the fixed vars used in dir display.
    *    dir->col =      physical upper left column of dir screen
    *    dir->row =      physical upper left row or line of dir screen
    *    dir->wid =      width of physical screen
    *    dir->hgt =      height of physical screen
    *    dir->max_cols   number of columns of files in dir screen
    *    dir->max_lines  number of lines of files in each column in dir screen
    *    dir->cnt        number of files in list
    */
   dir->col = 2;
   dir->row = 3;
   dir->wid = 76;
   dir->hgt = 18;
   dir->max_lines = 10;
   dir->cnt = cnt;

#if defined( __DOS16__ )
   dir->len      = 12;
   dir->max_cols = 5;

#else
   /*
    * Figure out the width of each column (ie. the highlight bar/filename
    * length). We'll make 12 the smallest ("standard" 8.3) for five columns.
    * If the overall width is limited to 76, then the longest name can be
    * 72 (two characters for the frame, space each side). However, let's try
    * and be clever - if the majority of files are "short", use more columns
    * and truncate the longer names. Anyone have a better algorithm?
    */
   for (i = 0; i < cnt; ++i) {
      j = strlen( flist[i].fname );
           if (j <= 12) ++cols[4];      /* depending on the length */
      else if (j <= 16) ++cols[3];      /* of the name, increase   */
      else if (j <= 22) ++cols[2];      /* the appropriate number  */
      else if (j <= 35) ++cols[1];      /* of columns              */
      else              ++cols[0];
   }
   /*
    * The number of columns used most is the one selected, unless there's
    * enough space to display all files without truncation.
    */
   for (i = 0; cols[i] == 0; ++i) ;     /* assumes cnt > 0 */
   dir->max_cols = i+1;
   if (cnt > (i+1) * dir->max_lines) {
      j = cols[i];
      for (++i; i < 5; ++i) {
         if (cols[i] > j) j = cols[i], dir->max_cols = i+1;
      }
   }
   /*
    * Set the actual width of the column to the largest possible.
    */
        if (dir->max_cols == 5) dir->len = 12;
   else if (dir->max_cols == 4) dir->len = 16;
   else if (dir->max_cols == 3) dir->len = 22;
   else if (dir->max_cols == 2) dir->len = 35;
   else                         dir->len = 72;
#endif

   /*
    * Find out how many lines in each column are needed to display
    *  matching files.
    */
   dir->lines = dir->cnt / dir->max_cols + (dir->cnt % dir->max_cols ? 1 : 0);
   if (dir->lines > dir->max_lines)
      dir->lines = dir->max_lines;

   /*
    * Find out how many columns of file names we need.
    */
   dir->cols = dir->cnt / dir->lines + (dir->cnt % dir->lines ? 1 : 0);
   if (dir->cols > dir->max_cols)
      dir->cols = dir->max_cols;

   /*
    * Find the maximum number of file names we can display in help screen.
    */
   dir->avail = dir->lines * dir->cols;

   /*
    * Now find the number of file names we do have on the screen.  Every
    *  time we slide the "window", we have to calculate a new nfiles.
    */
   dir->nfiles = dir->cnt > dir->avail ? dir->avail : dir->cnt;

   /*
    * A lot of times, the number of matching files will not fit evenly
    *  in our help screen.  The last column on the right will be partially
    *  filled, hence the variable name prow (partial row).  When there are
    *  more file names than can fit on the screen, we have to calculate
    *  prow every time we slide the "window" of files.
    */
   dir->prow = dir->lines - (dir->avail - dir->nfiles);

   /*
    * Find out how many "virtual" columns of file names we have.  If
    *  all the files can fit in the dir screen, there will be no
    *  virtual columns.
    */
   if (dir->cnt <= dir->avail)
      dir->vcols = 0;
   else
      dir->vcols =  (dir->cnt - dir->avail) / dir->max_lines +
                   ((dir->cnt - dir->avail) % dir->max_lines ? 1 : 0);

   /*
    * Find the physical display column in dir screen.
    */
   dir->flist_col[0] = dir->col + 2;
   for (i=1; i<dir->max_cols; i++)
      dir->flist_col[i] = dir->flist_col[i-1] + dir->len + 3;

   /*
    * Find the offset for the first file (ie. skip the directories).
    * If there are no files, point to the directories.
    */
   for (fofs = 0; fofs < cnt; ++fofs) {
      if (flist[fofs].fname[strlen( flist[fofs].fname ) - 1] != '/') break;
   }
   if (fofs == cnt)
      fofs = 0;

   /*
    * Now, draw the borders of the dir screen.
    */
   wid = dir->wid - 1;
   temp[wid+1] = '\0';
   for (i=0; i < dir->hgt; i++) {
      ch = VERTICAL_LINE;
      if (i == 0 || i == DIR6_ROW+1 || i == DIR8_ROW-1 || i == dir->hgt-1) {
         memset( temp, HORIZONTAL_LINE, wid );
         if (i == 0) {
            temp[0]   = CORNER_LEFT_UP;
            temp[wid] = CORNER_RIGHT_UP;
         } else if (i == dir->hgt-1) {
            temp[0]   = CORNER_LEFT_DOWN;
            temp[wid] = CORNER_RIGHT_DOWN;
         } else {
            temp[0]   = LEFT_T;
            temp[wid] = RIGHT_T;
            ch = (i == DIR6_ROW+1) ? TOP_T : BOTTOM_T;
         }
      } else {
         memset( temp, ' ', wid );
         temp[0] = temp[wid] = VERTICAL_LINE;
      }
      if (i >= DIR6_ROW+1 && i <= DIR8_ROW-1) {
         for (j = dir->len + 3; j < wid; j += dir->len + 3)
            temp[j] = ch;
      }
      s_output( temp, dir->row+i, dir->col, g_display.help_color );
   }

   /*
    * Write headings in help screen.
    */
   s_output( dir4, dir->row+DIR4_ROW, dir->col+DIR4_COL, g_display.help_color );
   s_output( dir5, dir->row+DIR5_ROW, dir->col+DIR5_COL, g_display.help_color );
   s_output( dir6, dir->row+DIR6_ROW, dir->col+DIR6_COL, g_display.help_color );
   s_output( dir8, dir->row+DIR8_ROW, dir->col+DIR8_COL, g_display.help_color );

   /*
    * Display the file count right justified.
    */
   strcpy( temp, dir7 );
   my_ltoa( dir->cnt, temp + strlen( temp ), 10 );
   s_output( temp, dir->row+DIR7_ROW, dir->col+wid-1-strlen( temp ),
             g_display.help_color );
}


/*
 * Name:    write_directory_list
 * Purpose: given directory list, display matching files
 * Date:    February 13, 1992
 * Passed:  flist: pointer to list of files
 *          dir:   directory display structure
 * Notes:   blank out the previous file name and display the new one.
 *
 * jmh 980523: Display the lines for each column, rather than the columns for
 *             each line. This corrects a one-column bug.
 */
void write_directory_list( FTYPE *flist, DIRECTORY dir )
{
FTYPE *p;
int  i;
int  j;
int  k;
int  end;
int  line;
int  col;
int  color;
char temp[NAME_MAX+2];
char blank[73];         /* blank out file names */

   memset( blank, ' ', dir.len );
   blank[dir.len] = '\0';
   color = g_display.help_color;
   p     = flist;
   end   = FALSE;
   for (k=1, j=0; j < dir.cols; ++j) {
      col = dir.flist_col[j];
      for (line=dir.row+5, i=0; i < dir.lines; ++k, ++p, ++line, ++i) {
         /*
          * We need to blank out all lines and columns used to display
          *  files, because there may be some residue from a previous dir
          */
         s_output( blank, line, col, color );
         if (!end) {
            if (strlen( p->fname ) <= dir.len)
               s_output( p->fname, line, col, color );
            else {
               strcpy( temp, p->fname );
               temp[dir.len] = '\0';
               s_output( temp, line, col, color );
            }
            if (k >= dir.nfiles)
               end = TRUE;
         }
      }
   }
}


/*
 * Name:    select_file
 * Purpose: To let user select a file from dir list
 * Date:    February 13, 1992
 * Passed:  flist: pointer to list of files
 *          stem:  base directory and wildcard pattern
 *          dir:   directory display stuff
 * Notes:   let user move thru the file names with the cursor keys
 *
 * jmh 980527: display attribute as well, restructured.
 * jmh 980805: use SortBoxBlock to toggle between name and extension sorting.
 */
int  select_file( FTYPE *flist, char *stem, DIRECTORY *dir )
{
long ch;                /* input character from user */
int  func;              /* function of character input by user */
int  fno;               /* index into flist of the file under cursor */
int  r;                 /* current row of cursor */
int  c;                 /* current column of cursor */
int  offset;            /* offset into file list */
int  lastoffset;        /* largest possible offset */
int  stop;              /* stop indicator */
int  max_len;           /* maximum allowed length of name */
int  color;             /* color of help screen */
int  file_color;        /* color of current file */
int  change;            /* boolean, hilite another file? */
int  oldr;              /* old row */
int  oldc;              /* old column */
int  col;               /* column to display directory, selected file, size */
int  len;               /* length of file name to display */
char temp[PATH_MAX];
unsigned char let;

/*
 * Convert the file list column and row into a screen column and row.
 */
#define colrow(c, r) (c-1)*(dir->len+3)+dir->col+2, r+dir->row+4

   /*
    * initial everything.
    */
   color      = g_display.help_color;
   file_color = g_display.hilited_file;
   fno        =                         /* These two are just to remove */
   func       =                         /*  gcc warnings */
   offset     = 0;
   lastoffset = dir->vcols * dir->lines;
   c          =
   r          =
   oldc       =
   oldr       = 1;
   stop       = FALSE;
   change     = TRUE;

   /*
    * Some names could be quite long - let's truncate the ones that don't fit.
    * Assume the directory, selected file and file size messages (dir4, 5 & 6)
    * are all equal length and in the same column.
    */
   col = DIR4_COL + strlen( dir4 );
   max_len = dir->wid - col - 2;

   if (strlen( stem ) <= max_len)
      s_output( stem, dir->row+DIR4_ROW, dir->col+col, color );
   else {
      strcpy( temp, "..." );
      strcat( temp, stem + strlen( stem ) - (max_len-3) );
      s_output( temp, dir->row+DIR4_ROW, dir->col+col, color );
   }

   while (stop == FALSE) {
      if (change) {
         memset( temp, ' ', max_len );
         temp[max_len] = '\0';
         s_output( temp, dir->row+DIR5_ROW, dir->col+col, color );
         temp[19] = '\0';
         s_output( temp, dir->row+DIR6_ROW, dir->col+col, color );

         fno = offset + (c-1)*dir->lines + (r-1);
         len = strlen( flist[fno].fname );
         if (len <= max_len)
            s_output(flist[fno].fname, dir->row+DIR5_ROW, dir->col+col, color);
         else {
            if (len <= dir->len) {
               /*
                * It was fully displayed in the list
                * so just truncate in the selected.
                */
               memcpy( temp, flist[fno].fname, max_len );
               temp[max_len] = '\0';

            } else {
               strcpy( temp, "..." );
               if (len <= dir->len + max_len - 3)
                  /*
                   * The beginning of the name is in the list, the end of it
                   * (and perhaps the end of the beginning) is in the selected.
                   */
                  memcpy( temp+3, flist[fno].fname + len - max_len + 3,
                          max_len - 2 );

               else {
                  /*
                   * list+selected is still not all the name.
                   */
                  memcpy( temp+3, flist[fno].fname+dir->len, max_len - 6 );
                  strcpy( temp+max_len-3, "..." );
               }
            }
            s_output( temp, dir->row+DIR5_ROW, dir->col+col, color );
         }

         my_ltoa( flist[fno].fsize, temp, 10 );
         s_output( temp, dir->row+DIR6_ROW, dir->col+col, color );

         len = flist[fno].fattr;
#if defined( __UNIX__ )
         temp[0] = (len & S_IRUSR)   ? L_UNIX_READ     : '-';
         temp[1] = (len & S_IWUSR)   ? L_UNIX_WRITE    : '-';
         temp[2] = (len & S_IXUSR)   ? L_UNIX_EXECUTE  : '-';
         temp[3] = '\0';
#else
         temp[0] = (len & ARCHIVE)   ? L_DOS_ARCHIVE   : '-';
         temp[1] = (len & SYSTEM)    ? L_DOS_SYSTEM    : '-';
         temp[2] = (len & HIDDEN)    ? L_DOS_HIDDEN    : '-';
         temp[3] = (len & READ_ONLY) ? L_DOS_READ_ONLY : '-';
         temp[4] = '\0';
#endif
         s_output( temp, dir->row+DIRA_ROW, dir->col+DIRA_COL, color );

         xygoto( colrow(c, r) );
         hlight_line( colrow(oldc, oldr), dir->len, color );
         hlight_line( colrow(c, r),       dir->len, file_color );
         change = FALSE;
#if defined( __UNIX__ )
         refresh( );
#endif
      }
      oldr = r;
      oldc = c;
      ch   = getkey( );
      /*
       * User may have redefined the Enter and ESC keys.  Make the Enter key
       *  perform a Rturn in this function. Make the ESC key do an AbortCommand.
       */
      func = (ch == RTURN) ? Rturn        :
             (ch == ESC)   ? AbortCommand :
             getfunc( ch );

      /*
       * jmh 980523: if a normal character has been entered, search the file
       *              list for a name starting with that character.
       * jmh 980805: made more awkward when sorting by extension, since the
       *              names are no longer in order.
       */
      if (ch < 256) {
       int i = fno;
       #define fc sort.order_array[flist[i].fname[0]]
         let = sort.order_array[(int)ch];
         /*
          * if we're already on one, go to the next.
          * if it doesn't match, loop around.
          */
         if (fc == let && i >= fofs) {
            do
               ++i;
            while (i < dir->cnt && fc != let);
            if (i == dir->cnt)
               for (i = fofs; fc != let; ++i) ;
         } else {
            if (mode.dir_sort == SORT_NAME) {
               for (i = fofs; i < dir->cnt && fc < let; ++i) ;
               if (i == dir->cnt)
                  func = EndOfFile;
            } else {
               for (i = fofs; i < dir->cnt && fc != let; ++i) ;
               if (i == dir->cnt)
                  func = ERROR;         /* do nothing */
            }
         }
         if (func == 0) {
            if (i >= offset && i < offset+dir->avail) {
               /* do nothing */
            } else {
               offset = i - ( i % dir->lines);
               if (dir->max_cols == 3 || dir->max_cols == 4)
                  offset -= dir->lines;
               else if (dir->max_cols == 5)
                  offset -= dir->lines * 2;
               if (offset < 0)
                  offset = 0;
               else if (offset > lastoffset)
                  offset = lastoffset;
               recalculate_dir( dir, flist, offset );
            }
            i     -= offset;
            c      = i / dir->lines + 1;
            r      = i % dir->lines + 1;
            change = TRUE;
         }
       #undef fc
      }
      switch (func) {
         case Rturn        :
         case NextLine     :
         case BegNextLine  :
         case AbortCommand :
            stop = TRUE;
            break;

         case LineUp :
            if (r > 1) {
               --r;
            } else {
               r = dir->lines;
               if (c > 1) {
                  --c;
               } else if (offset > 0) {
                  /*
                   * recalculate the dir display stuff.
                   */
                  offset -= dir->lines;
                  recalculate_dir( dir, flist, offset );
               }
            }
            change = TRUE;
            break;

         case LineDown :
            if (r < dir->prow) {
               ++r;
            } else if (r < dir->lines && c != dir->cols) {
               ++r;
            } else {
               r = 1;
               if (c < dir->cols) {
                  ++c;
               } else if (offset < lastoffset) {
                  offset += dir->lines;
                  recalculate_dir( dir, flist, offset );
               }
            }
            change = TRUE;
            break;

         case CharLeft :
            if (c > 1) {
               --c;
               change = TRUE;
            } else if (offset > 0) {
               offset -= dir->lines;
               recalculate_dir( dir, flist, offset );
               change = TRUE;
            }
            break;

         case CharRight :
            if (c < dir->cols) {
               ++c;
               if (c == dir->cols) {
                  if (r > dir->prow)
                     r = dir->prow;
               }
               change = TRUE;
            } else if (offset < lastoffset) {
               offset += dir->lines;
               recalculate_dir( dir, flist, offset );
               if (r > dir->prow)
                  r = dir->prow;
               change = TRUE;
            }
            break;

         case BegOfLine :
            if (c != 1 || r != 1) {
               c = r = 1;
               change = TRUE;
            }
            break;

         case EndOfLine :
            if (c != dir->cols || r != dir->prow) {
               c = dir->cols;
               r = dir->prow;
               change = TRUE;
            }
            break;

         case ScreenDown :
            if (offset < lastoffset) {
               offset += dir->avail;
               if (offset > lastoffset)
                  offset = lastoffset;
               recalculate_dir( dir, flist, offset );
               if (c == dir->cols && r > dir->prow)
                  r = dir->prow;
               change = TRUE;
            }
            break;

         case ScreenUp :
            if (offset > 0) {
               offset -= dir->avail;
               if (offset < 0)
                  offset = 0;
               recalculate_dir( dir, flist, offset );
               change = TRUE;
            }
            break;

         case TopOfFile:                /* added by jmh 980523 */
            if (c != 1 || r != 1) {     /* added conditions jmh 980527 */
               c = r = 1;
               change = TRUE;
            }
            if (offset != 0) {
               offset = 0;
               recalculate_dir( dir, flist, offset );
               change = TRUE;
            }
            break;

         case EndOfFile:                /* added by jmh 980523 */
            if (offset != lastoffset) { /* added conditions jmh 980527 */
               offset = lastoffset;
               recalculate_dir( dir, flist, offset );
               change = TRUE;
            }
            if (c != dir->cols || r != dir->prow) {
               c = dir->cols;
               r = dir->prow;
               change = TRUE;
            }
            break;

         case BackSpace:
            /*
             * jmh 980523: use BackSpace to select the "../" entry, which
             *             will be first, except in root directory.
             */
            if (strcmp( flist[0].fname, "../" ) == 0) {
               fno  = 0;
               stop = TRUE;
            }
            break;

         case SortBoxBlock:
            mode.dir_sort = (SORT_NAME + SORT_EXT) - mode.dir_sort;
            shell_sort( flist, dir->cnt );
            write_directory_list( flist+offset, *dir );
            change = TRUE;
            break;

         default :
            break;
      }
   }
   dir->select = fno;
   return( func == AbortCommand ? ERROR : OK );
}


/*
 * Name:    recalculate_dir
 * Purpose: To recalcute dir structure when cursor goes ahead or behind screen
 * Date:    November 13, 1993
 * Passed:  dir:    pointer to file structure
 *          flist:  pointer to file structure
 *          offset: number of files from beginning of flist
 * Notes:   Find new number of files on the screen.  Then, find out
 *           how many files names are in the last column.
 */
void recalculate_dir( DIRECTORY *dir , FTYPE *flist, int offset )
{
register int off;

   off = offset;
   dir->nfiles = (dir->cnt - off) > dir->avail ? dir->avail :
                                                 (dir->cnt - off);
   dir->prow   = dir->lines - (dir->avail - dir->nfiles);
   write_directory_list( flist+off, *dir );
}


/*
 * Name:     shell_sort
 * Purpose:  To sort file names
 * Date:     February 13, 1992
 * Modified: November 13, 1993, Frank Davis per Byrial Jensen
 * Passed:   flist: pointer to file structure
 *           cnt:   number of files to sort
 * Notes:    this implementation of Shellsort is based on the one by Robert
 *            Sedgewick on page 109, _Algorithms in C_.
 *
 * Change:   Use of my_memcmp instead of memcmp
 *           (In somes cases not-english people wants to use their own letters
 *           even in filenames; I am such one, Byrial).
 *
 * jmh 980805: place the ../ entry first and exclude it from the sort.
 */
void shell_sort( FTYPE *flist, int cnt )
{
int  i;
register int j;
register int inc;
FTYPE temp;
FTYPE *fl;

   sort.order_array = (mode.search_case == IGNORE) ?
                      sort_order.ignore : sort_order.match;

   if (cnt > 1) {

      for (j = 0; j < cnt; ++j)
         if (strcmp( flist[j].fname, "../" ) == 0)
            break;
      if (j < cnt) {
         if (j != 0) {
            strcpy( flist[j].fname, flist[0].fname );
            strcpy( flist[0].fname, "../" );
         }
         --cnt;
         ++flist;
      }

      fl = flist;

      /*
       * figure the increments, per Donald Knuth, _Sorting and Searching_, and
       *  Robert Sedgewick, _Algorithms in C_.
       */
      j = cnt / 9;
      for (inc=1; inc <= j; inc = 3 * inc + 1);

      /*
       * now, Shellsort the directory file names.
       */
      for (; inc > 0; inc /= 3) {
         for (i=inc; i < cnt; i++) {
            j = i;
            memcpy( &temp, fl+j, sizeof(FTYPE) );
            while (j >= inc  &&  dir_cmp( fl[j-inc].fname, temp.fname ) > 0) {
               memcpy( fl+j, fl+j-inc, sizeof(FTYPE) );
               j -= inc;
            }
            memcpy( fl+j, &temp, sizeof(FTYPE) );
         }
      }
   }
}


/*
 * Name:    dir_cmp
 * Purpose: compare two filenames for the directory sort
 * Author:  Jason Hood
 * Date:    August 5, 1998
 * Passed:  name1: pointer to first filename
 *          name2: pointer to second filename
 * Returns: < 0 if name1 comes before name2
 *            0 if name1 and name2 are equal (should never occur)
 *          > 0 if name1 comes after name2
 * Notes:   directories are placed before files.
 *          the strings are assumed to be NUL-terminated.
 *          names that begin with a dot are not treated as extensions.
 */
int  dir_cmp( char *name1, char *name2 )
{
int len;
int d;
int e1;
int e2;

   len = strlen( name1 ) + 1;           /* include the NUL */
   e2  = strlen( name2 ) - 1;           /* last character */
   d   = (name2[e2] == '/') - (name1[len-2] == '/');
   if (d == 0) {
      /*
       * Both files are either directories or names
       */
      if (mode.dir_sort == SORT_NAME)
         d = my_memcmp( (text_ptr)name1, (text_ptr)name2, len );
      else {
         /*
          * Search for the extension
          */
         for (e1 = len-2; e1 > 0 && name1[e1] != '.'; --e1) ;
         for (;           e2 > 0 && name2[e2] != '.'; --e2) ;

         if (!e1 &&  e2) return -1;     /* no extension before extension */
         if ( e1 && !e2) return +1;     /* extension after no extension */
         if (!e1 && !e2)                /* neither have an extension */
            d = my_memcmp( (text_ptr)name1, (text_ptr)name2, len );
         else {
            /*
             * Sort the extension first. If the extension is the same,
             * sort by name.
             */
            d = my_memcmp( (text_ptr)(name1+e1), (text_ptr)(name2+e2), len-e1 );
            if (d == 0) {
               name1[e1] = name2[e2] = '\0';
               d = my_memcmp( (text_ptr)name1, (text_ptr)name2, len );
               name1[e1] = name2[e2] = '.';
            }
         }
      }
   }
   return( d );
}
