/*
    Filename: C:\DAVE\CPP\BIBLE\randdos.cpp
    Author  : Dave Nelson
    Created : Sun 18-Oct-1998 19:45:01
    Modified: Sat 24-Jul-1999 11:15:11 - Dave Nelson

    Gruesomely inefficient routines for obtaining pseudo-random numbers
    within a specific range.   These are actually less inefficient than
    those found in RANDOM.CPP, because these use DOS-specific functions
    for system time and therefore can get 100th-second granularity.
    The tradeoff is lack of portability.
*/

#include <dos.h>
#include <stdlib.h>

static int seeded = 0;

/*Function: seedgen
      Descr: Seeds the standard library's random number generator using a
             couple of machinations around the system time.
       Args: none
     Return: void
*/
void seedgen(){
dos_time_t dt;
    dos_gettime(&dt);
    srand(dt.hsecond);
    for(int b=rand(); b; b--){ ; }
    dos_gettime(&dt);
    srand( rand()* dt.hsecond );
    seeded = -1;
    }

/*Function: random
      Descr: Returns a random number within the specified range, eventually.
             The distribution is actually pretty good, but it's SLOW!
       Args: int min    - Minimum acceptable value
             int max    - Maximum acceptable value
     Return: int
*/
int random(int min, int max){
int x;
double d,m;
    if(!seeded) seedgen();
    do {
        d = ((double)rand())*.0001;
        x=(int)(d*max);
        }
    while (x<min||x>max);
    return x;
    }

#if 0
#include <stdio.h>
#include <stdlib.h>
void main(int argc, char **argv){
int cnt;
    if(argc==1) cnt = 1;
    else cnt = atoi(argv[1]);
    for(; cnt; cnt--) printf("%3d\n", random(1,100) );
    }
#endif
