<!DOCTYPE xsl:stylesheet [
<!ENTITY degrees "&#176;">
]>
<!-- Stylesheet -->

<!-- Embed this style sheet in the source document using the 
     <?xml-stylesheet type="text/xsl" href="myxsl.xsl"?> processing instruction. 
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" encoding="UTF-8"/>

	<!--====================================================================-->

	<xsl:template match="/">
		<html>
			<link href="style/gutenberg.css" rel="stylesheet" type="text/css"/>
			<link href="style/amazonia.css" rel="stylesheet" type="text/css"/>
			<head>
				<title><xsl:value-of select="//docTitle"/></title>
			</head>
		<body>
			<div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>
			<xsl:apply-templates/>
		</body>
		</html>
	</xsl:template>

	<!--====================================================================-->
	<!-- TEI Header -->

	<!-- Suppress the header in the output -->

	<xsl:template match="teiHeader"/>	

	<!--====================================================================-->
	<!-- Title Page -->

	<xsl:template match="titlePage">	
		<xsl:apply-templates mode="titlePage"/>
	</xsl:template>

	<xsl:template match="docTitle" mode="titlePage">
		<h1 class="docTitle">
			<xsl:apply-templates mode="titlePage"/>
		</h1>
	</xsl:template>

	<xsl:template match="byline" mode="titlePage">
		<h2 class="byline">
			<xsl:apply-templates mode="titlePage"/>
		</h2>
	</xsl:template>

	<!--====================================================================-->
	<!-- Corrections -->

	<xsl:template match="corr">
		<xsl:apply-templates/>		
	</xsl:template>

	<!--====================================================================-->
	<!-- Cross References -->
	
	<!-- Only use generated ID's to avoid clashes of original with generated ID's. Note
	     that the target id generated here should also be generated on the element being 
	     referenced. We cannot use the id() function here, since we do not use a DTD. -->

	<xsl:template match="ref[@target]">
		<xsl:variable name="target" select="./@target"/>
		<a href="#{generate-id(//*[@id=$target])}">
			<xsl:apply-templates/>
		</a>
	</xsl:template>

	<!--====================================================================-->
	<!-- Page Breaks -->

	<xsl:template match="pb">
		<span id="{generate-id()}" class="pageno">
			<xsl:if test="@n">
				<xsl:value-of select="$strPage"/><xsl:text> </xsl:text><xsl:value-of select="@n"/>
			</xsl:if>
		</span>
	</xsl:template>

	<!--====================================================================-->
	<!-- Table of Contents -->
	<!-- Take care only to generate ToC entries for divisions of the main text, not for those in quoted texts -->

	<xsl:template match="divGen[@type='toc']">
		<h1><xsl:value-of select="$strTableOfContents"/></h1>
		<ul>
			<xsl:apply-templates mode="gentoc" select="/TEI.2/text/front/div1"/>
			<xsl:choose>
				<xsl:when test="/TEI.2/text/body/div0">
					<xsl:apply-templates mode="gentoc" select="/TEI.2/text/body/div0"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates mode="gentoc" select="/TEI.2/text/body/div1"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates mode="gentoc" select="/TEI.2/text/back/div1"/>
		</ul>
	</xsl:template>

	<xsl:template match="div0" mode="gentoc">
		<xsl:if test="head">
			<li>
				<a href="#{generate-id()}">
				<xsl:choose>
					<xsl:when test="@type='part'">
						<xsl:value-of select="$strPart"/><xsl:text> </xsl:text><xsl:value-of select="./@n"/>:<xsl:text> </xsl:text>
					</xsl:when>
				</xsl:choose>
				<xsl:apply-templates select="head" mode="tochead"/></a>
				<ul>
					<xsl:apply-templates select="div1" mode="gentoc"/>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="div1" mode="gentoc">
		<xsl:if test="head">
			<li>
				<a href="#{generate-id()}">
				<xsl:choose>
					<xsl:when test="@type='chapter'">
						<xsl:value-of select="$strChapter"/><xsl:text> </xsl:text><xsl:value-of select="./@n"/>:<xsl:text> </xsl:text>
					</xsl:when>
					<xsl:when test="@type='appendix'">
						Appendix <xsl:value-of select="./@n"/>:<xsl:text> </xsl:text>
					</xsl:when>
				</xsl:choose>
				<xsl:apply-templates select="head" mode="tochead"/></a>
				<ul>
					<xsl:apply-templates select="div2" mode="gentoc"/>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="div2" mode="gentoc">
		<xsl:if test="head">
			<li>
				<a href="#{generate-id()}">
				<xsl:apply-templates select="head" mode="tochead"/></a>
				<ul>
					<xsl:apply-templates select="div3" mode="gentoc"/>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="div3" mode="gentoc">
		<xsl:if test="head">
			<li>
				<a href="#{generate-id()}">
				<xsl:apply-templates select="head" mode="tochead"/></a>
			</li>
		</xsl:if>
	</xsl:template>

	<!-- Suppress notes in table of contents (avoid getting them twice) -->

	<xsl:template match="note" mode="tochead"/>

	<!-- Text styles in chapter headings -->

	<xsl:template match="hi" mode="tochead">
		<i>
			<xsl:apply-templates  mode="tochead"/>
		</i>
	</xsl:template>

	<xsl:template match="hi[@rend='italic']" mode="tochead">
		<i>
			<xsl:apply-templates  mode="tochead"/>
		</i>
	</xsl:template>

	<!--====================================================================-->
	<!-- Divisions and Headings -->

	<xsl:template match="div0[@type='Part' or @type='part']/head">
		<h2 id="{generate-id(parent::div0)}" class="abovehead"><xsl:value-of select="$strPart"/><xsl:text> </xsl:text><xsl:value-of select="../@n"/></h2>
		<h1><xsl:apply-templates/></h1>
	</xsl:template>

	<xsl:template match="div1">
		<xsl:if test="count(head) = 0">
			<a id="{generate-id()}"></a>
			<xsl:if test="@type='Chapter' or @type='chapter'">
				<h1><xsl:value-of select="$strChapter"/><xsl:text> </xsl:text><xsl:value-of select="@n"/></h1>
			</xsl:if>
		</xsl:if>
		<xsl:apply-templates/>
		<xsl:if test=".//note and not(ancestor::q)">
			<!-- <h2><xsl:value-of select="$strNotes"/></h2> -->
			<p/><hr class="noteseparator"/>
			<xsl:apply-templates mode="footnotes" select=".//note"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="div1[@type='Chapter' or @type='chapter']/head">
		<h2 id="{generate-id(parent::div1)}" class="abovehead"><xsl:value-of select="$strChapter"/><xsl:text> </xsl:text><xsl:value-of select="../@n"/></h2>
		<h1><xsl:apply-templates/></h1>
	</xsl:template>

	<xsl:template match="div1[@type='Appendix' or @type='appendix']/head">
		<h2 id="{generate-id(parent::div1)}" class="abovehead"><xsl:value-of select="$strAppendix"/><xsl:text> </xsl:text><xsl:value-of select="../@n"/></h2>
		<h1><xsl:apply-templates/></h1>
	</xsl:template>

	<xsl:template match="div1[@type != 'chapter' and @type != 'appendix']/head">
		<h1 id="{generate-id(parent::div1)}"><xsl:apply-templates/></h1>
	</xsl:template>

	<xsl:template match="div2/head">
		<h2 id="{generate-id(parent::div2)}"><xsl:apply-templates/></h2>
	</xsl:template>

	<xsl:template match="div3/head">
		<h3 id="{generate-id(parent::div3)}"><xsl:apply-templates/></h3>
	</xsl:template>

	<xsl:template match="div4/head">
		<h4 id="{generate-id(parent::div4)}"><xsl:apply-templates/></h4>
	</xsl:template>

	<xsl:template match="div5/head">
		<h5 id="{generate-id(parent::div5)}"><xsl:apply-templates/></h5>
	</xsl:template>

	<xsl:template match="head">
		<h5 id="{generate-id()}"><xsl:apply-templates/></h5>
	</xsl:template>

	<xsl:template match="byline">
		<p align="left" class="byline">
			<i><xsl:apply-templates/></i>
		</p>
	</xsl:template>

	<!--====================================================================-->
	<!-- Tables: TODO: check this for more complicated tables. -->

	<xsl:template match="table">
		<p>
			<xsl:apply-templates select="head"/>
			<table width="100%">
				<xsl:apply-templates select="row"/>
			</table>
		</p>
	</xsl:template>

	<xsl:template match="table/head">
		<h5 id="{generate-id()}"><xsl:apply-templates/></h5>
	</xsl:template>

	<xsl:template match="row">
		<tr valign="top">
			<xsl:apply-templates/>
		</tr>
	</xsl:template>

	<xsl:template match="cell">
		<td valign="top">
			<xsl:apply-templates/>
		</td>
	</xsl:template>

	<!--====================================================================-->
	<!-- Lists -->

	<xsl:template match="list">
		<ul>
			<xsl:apply-templates/>
		</ul>
	</xsl:template>

	<xsl:template match="item">
		<li id="{generate-id()}">
			<xsl:apply-templates/>
		</li>
	</xsl:template>

	<!--====================================================================-->
	<!-- Figures -->

	<!-- Derive the file name from the unique id, and assume that the format is .jpg. This is a temporary solution. -->

	<xsl:template match="figure[@rend='inline']">
		<xsl:variable name="file" select="@id"/>
		<img src="img/{$file}.png"/>
	</xsl:template>

	<xsl:template match="figure[@rend='left']">
		<table align="left" style="margin:10px; margin-left:0px"><tr><td>
			<div id="{generate-id()}" class="divFigure">
				<xsl:if test="@n">
					<h3><xsl:value-of select="$strFigure"/><xsl:text> </xsl:text><xsl:value-of select="@n"/>.</h3>
				</xsl:if>
				<xsl:variable name="file" select="@id"/>
				<xsl:variable name="alt" select="head"/>
				<p class="legend"><img src="img/{$file}.jpg" alt="{$alt}"/></p>
				<xsl:apply-templates/>
			</div>
		</td></tr></table>
	</xsl:template>

	<xsl:template match="figure[@rend='right']">
		<table align="right" style="margin:10px; margin-right:0px"><tr><td>
			<div id="{generate-id()}" class="divFigure">
				<xsl:if test="@n">
					<h3><xsl:value-of select="$strFigure"/><xsl:text> </xsl:text><xsl:value-of select="@n"/>.</h3>
				</xsl:if>
				<xsl:variable name="file" select="@id"/>
				<xsl:variable name="alt" select="head"/>
				<p class="legend"><img src="img/{$file}.jpg" alt="{$alt}"/></p>
				<xsl:apply-templates/>
			</div>
		</td></tr></table>
	</xsl:template>

	<xsl:template match="figure">
		<div id="{generate-id()}" class="divFigure">
			<xsl:if test="@n">
				<h3><xsl:value-of select="$strFigure"/><xsl:text> </xsl:text><xsl:value-of select="@n"/>.</h3>
			</xsl:if>
			<xsl:variable name="file" select="@id"/>
			<xsl:variable name="alt" select="head"/>
			<p class="legend"><img src="img/{$file}.jpg" alt="{$alt}"/></p>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<xsl:template match="figure/head">
		<p class="figureHead"><xsl:apply-templates/></p>
	</xsl:template>

	<!--====================================================================-->
	<!-- Arguments -->

	<xsl:template match="argument">
		<div class="blockquote">
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--====================================================================-->
	<!-- Blockquotes -->

	<xsl:template match="q[@rend='block']">
		<div class="blockquote">
			<xsl:apply-templates/>
		</div>
	</xsl:template>
	
	<!--====================================================================-->
	<!-- Notes -->

	<!-- Move footnotes to the end of the div1 element they appear in (but not in quoted texts) -->

	<xsl:template match="note">
		<a id="{generate-id()}src" href="#{generate-id()}" class="noteref">
			<xsl:number level="any" from="div1[not(ancestor::q)]"/>
		</a>
	</xsl:template>

	<!-- Handle notes with paragraphs different from simple notes -->

	<xsl:template match="note[p]" mode="footnotes">
		<div class="notetext">
			<p mode="notetext">
				<a id="{generate-id()}" href="#{generate-id()}src" class="noteref">
					<xsl:number level="any" from="div1[not(ancestor::q)]"/>
				</a>
				<xsl:text> </xsl:text>
				<xsl:apply-templates select="*[1]" mode="footfirst"/>
			</p>
			<xsl:apply-templates select="*[position() > 1]" mode="footnotes"/>
		</div>
	</xsl:template>

	<xsl:template match="note" mode="footnotes">
		<div class="notetext">
			<p class="notetext">
				<a id="{generate-id()}" href="#{generate-id()}src" class="noteref">
					<xsl:number level="any" from="div1[not(ancestor::q)]"/>
				</a>
				<xsl:text> </xsl:text>
				<xsl:apply-templates/>
			</p>
		</div>
	</xsl:template>

	<xsl:template match="*" mode="footfirst">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="p" mode="footnotes">
		<p id="{generate-id()}" mode="notetext"><xsl:apply-templates/></p>
	</xsl:template>

	<xsl:template match="*" mode="footnotes">
		<xsl:apply-templates/>
	</xsl:template>

	<!--====================================================================-->
	<!-- Paragraphs -->

	<xsl:template match="p">
		<p id="{generate-id()}"><xsl:apply-templates/></p>
	</xsl:template>

	<!--====================================================================-->
	<!-- Line groups -->

	<xsl:template match="lg">
		<p><xsl:apply-templates/></p>
	</xsl:template>

	<xsl:template match="l">
		<br/><xsl:apply-templates/>
	</xsl:template>

	<!--====================================================================-->
	<!-- Text styles -->

	<xsl:template match="hi">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>

	<xsl:template match="hi[@rend='italic']">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>

	<xsl:template match="hi[@rend='bold']">
		<b>
			<xsl:apply-templates/>
		</b>
	</xsl:template>

	<xsl:template match="hi[@rend='smallcaps']">
		<span class="smallcaps">
			<xsl:apply-templates/>
		</span>
	</xsl:template>

	<!--====================================================================-->
	<!-- Measurements with metric equivalent (own extention of TEI) -->

	<xsl:template match="measure">
		<xsl:variable name="reg" select="./@reg"/>
		<a href="javascript:void(0);" onmouseover="return overlib('{$reg}');" onmouseout="return nd();">
			<xsl:apply-templates/>
		</a> 
	</xsl:template>

</xsl:stylesheet>
