/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Polygon;

public class TabControl
extends Panel {
    int m_iNumCards;
    TabCard[] m_tabCards;
    int m_iSelectedCard = 0;
    int m_iMouseCard = -1;
    int m_iNextTabOffset;
    int m_iTabHeight = 22;
    Color m_background = Color.white;
    private String msg;
    public static final int MAX_CARDS = 10;
    static final int FIRST_TAB = 10;
    static final int TAB_SPACE = 10;
    static final int LABEL_SPACE = 3;
    static final int TAB_SLOPE = 6;

    TabControl() {
        this.m_tabCards = new TabCard[10];
        this.setLayout(null);
    }

    public Insets insets() {
        return new Insets(8 + this.m_iTabHeight, 8, 8, 8);
    }

    public void setLabelColor(String string, Color color) {
        int n = this.getCardIndex(string);
        if (n == -1) {
            return;
        }
        if (this.m_tabCards[n].m_labelColor != color) {
            this.m_tabCards[n].m_labelColor = color;
            Polygon polygon = this.MakeCard(n);
            Graphics graphics = this.getGraphics();
            graphics.setColor(color);
            graphics.clipRect(polygon.xpoints[3], polygon.ypoints[2], polygon.xpoints[0] - polygon.xpoints[3], polygon.ypoints[0] - polygon.ypoints[1]);
            this.paint(graphics);
        }
    }

    public Color getLabelColor(String string) {
        int n = this.getCardIndex(string);
        if (n == -1) {
            n = 0;
        }
        return this.m_tabCards[n].m_labelColor;
    }

    public void setTabBackground(Color color) {
        this.m_background = color;
        this.repaint();
    }

    public Color getTabBackground() {
        return this.m_background;
    }

    public boolean isCard(String string) {
        return this.getCardIndex(string) != -1;
    }

    public boolean addCard(String string, Container container) {
        if (this.m_iNumCards + 1 >= 10) {
            return false;
        }
        if (this.isCard(string)) {
            return false;
        }
        this.m_tabCards[this.m_iNumCards++] = new TabCard(string, container);
        this.add(container);
        Insets insets = this.insets();
        container.move(insets.left, insets.top);
        this.repaint();
        container.bounds();
        return true;
    }

    public void hideCard(String string) {
        int n = this.getCardIndex(string);
        if (n == -1) {
            return;
        }
        if (!this.m_tabCards[n].hidden) {
            this.m_tabCards[n].hidden = true;
            if (n == this.m_iSelectedCard) {
                int n2 = 0;
                while (n2 < this.m_iNumCards) {
                    if (!this.m_tabCards[n2].hidden) {
                        this.showCard(n2);
                        return;
                    }
                    ++n2;
                }
            }
            this.repaint();
        }
    }

    public void showCard(String string) {
        int n = this.getCardIndex(string);
        if (n == -1) {
            return;
        }
        this.showCard(n);
    }

    public void showNextCard() {
        int n = this.m_iSelectedCard;
        while (n < this.m_iNumCards - 1) {
            if (this.m_tabCards[++n].hidden) continue;
            this.showCard(n);
            return;
        }
    }

    public void showPrevCard() {
        int n = this.m_iSelectedCard;
        while (n > 0) {
            if (this.m_tabCards[--n].hidden) continue;
            this.showCard(n);
            return;
        }
    }

    public void paint(Graphics graphics) {
        this.SetTabs();
        this.insets();
        this.size();
        int n = 0;
        while (n < this.m_iNumCards) {
            TabCard tabCard = this.m_tabCards[n];
            Polygon polygon = this.MakeCard(n);
            Container container = this.m_tabCards[n].container;
            if (tabCard.hidden) {
                container.hide();
            } else {
                if (this.selected(n)) {
                    graphics.setColor(this.m_background);
                } else {
                    graphics.setColor(this.m_background.darker());
                }
                graphics.fillPolygon(polygon);
                graphics.setColor(this.getForeground());
                graphics.drawPolygon(polygon);
                graphics.setColor(tabCard.m_labelColor);
                graphics.drawString(tabCard.m_labelString, polygon.xpoints[3] + 3 + 3, polygon.ypoints[0] - 3);
                if (this.selected(n)) {
                    container.show();
                } else {
                    container.hide();
                }
            }
            ++n;
        }
        if (this.msg != null) {
            graphics.setColor(this.getForeground());
            graphics.drawString(this.msg, 5, 30);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3 = this.onCard(n, n2);
        if (n3 > -1 & n3 != this.m_iSelectedCard) {
            this.showCard(n3);
        }
        return true;
    }

    public boolean gotFocus(Event event, Object object) {
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return this.mouseMove(event, n, n2);
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return this.mouseMove(event, n, n2);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        int n3 = this.onCard(n, n2);
        if (n3 != this.m_iMouseCard) {
            Container container;
            Event event2;
            if (this.m_iMouseCard > -1) {
                event2 = new Event(this, 1005, this.m_tabCards[this.m_iMouseCard].m_labelString);
                container = this.getParent();
                if (container != null) {
                    container.gotFocus(event2, event2.arg);
                }
            }
            if (n3 > -1) {
                event2 = new Event(this, 1004, this.m_tabCards[n3].m_labelString);
                container = this.getParent();
                if (container != null) {
                    container.gotFocus(event2, event2.arg);
                }
            }
            this.m_iMouseCard = n3;
        }
        return false;
    }

    int onCard(int n, int n2) {
        int n3 = 0;
        while (n3 < this.m_iNumCards) {
            Polygon polygon;
            if (!this.m_tabCards[n3].hidden && (polygon = this.MakeCard(n3)).inside(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int getCardIndex(String string) {
        int n = 0;
        while (n < this.m_iNumCards) {
            if (this.m_tabCards[n].m_labelString.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Container getCurrentContainer() {
        return this.m_tabCards[this.m_iSelectedCard].container;
    }

    public String getCurrentCard() {
        return this.m_tabCards[this.m_iSelectedCard].m_labelString;
    }

    private void showCard(int n) {
        boolean bl = false;
        if (this.m_tabCards[n].hidden) {
            this.m_tabCards[n].hidden = false;
            bl = true;
        }
        if (this.m_iSelectedCard != n) {
            bl = true;
            Event event = new Event(this, 1001, this.m_tabCards[n].m_labelString);
            Container container = this.getParent();
            if (container != null) {
                container.action(event, event.arg);
            }
            this.m_iSelectedCard = n;
            if (this.m_tabCards[n].container.countComponents() > 0) {
                Component component = this.m_tabCards[n].container.getComponent(0);
                component.requestFocus();
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    private boolean selected(int n) {
        return this.m_iSelectedCard == n;
    }

    void SetTabs() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.m_iNextTabOffset = 10;
        this.m_iTabHeight = fontMetrics.getHeight() + 6;
        int n = 0;
        while (n < this.m_iNumCards) {
            TabCard tabCard = this.m_tabCards[n];
            if (!tabCard.hidden) {
                tabCard.m_iWidth = fontMetrics.stringWidth(tabCard.m_labelString) + 6 + 6;
                tabCard.m_iOffset = this.m_iNextTabOffset;
                this.m_iNextTabOffset += tabCard.m_iWidth + 10;
            }
            ++n;
        }
    }

    Polygon MakeCard(int n) {
        Polygon polygon = new Polygon();
        Dimension dimension = this.size();
        this.SetTabs();
        TabCard tabCard = this.m_tabCards[n];
        dimension.height -= this.m_iTabHeight + 1;
        --dimension.width;
        polygon.addPoint(tabCard.m_iOffset + tabCard.m_iWidth, this.m_iTabHeight);
        polygon.addPoint(tabCard.m_iOffset + tabCard.m_iWidth - 6, 0);
        polygon.addPoint(tabCard.m_iOffset + 6, 0);
        polygon.addPoint(tabCard.m_iOffset, this.m_iTabHeight);
        if (this.selected(n)) {
            polygon.addPoint(0, this.m_iTabHeight);
            polygon.addPoint(0, this.m_iTabHeight + dimension.height);
            polygon.addPoint(dimension.width, this.m_iTabHeight + dimension.height);
            polygon.addPoint(dimension.width, this.m_iTabHeight);
        }
        polygon.addPoint(tabCard.m_iOffset + tabCard.m_iWidth, this.m_iTabHeight);
        return polygon;
    }
}

