/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.List;
import java.util.Vector;

class ParsedStringBuffer {
    private Vector fieldWidths;
    private StringBuffer sb;

    ParsedStringBuffer() {
        this.sb = new StringBuffer();
        this.fieldWidths = new Vector();
    }

    ParsedStringBuffer(int n) {
        this.sb = new StringBuffer(n);
        this.fieldWidths = new Vector(n);
    }

    ParsedStringBuffer(String string) {
        this.sb = new StringBuffer(string);
        this.fieldWidths = new Vector(string.length());
    }

    ParsedStringBuffer(ParsedStringBuffer parsedStringBuffer) {
        this.sb = new StringBuffer(parsedStringBuffer.sb.toString());
        int n = parsedStringBuffer.fieldWidths.size();
        this.fieldWidths = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            this.fieldWidths.addElement(new Integer(parsedStringBuffer.getFieldWidth(n2)));
            ++n2;
        }
    }

    public ParsedStringBuffer Clone() {
        return new ParsedStringBuffer(this);
    }

    public boolean addField(int n) {
        int n2 = 0;
        if (n < 0) {
            return false;
        }
        this.fieldWidths.addElement(new Integer(n));
        n2 = this.getFieldIndent(this.fieldWidths.size());
        while (this.sb.length() < n2) {
            this.sb.append(" ");
        }
        return true;
    }

    public boolean addField(int n, String string) {
        int n2 = this.fieldWidths.size();
        int n3 = this.getFieldIndent(n2);
        if (!this.addField(n)) {
            return false;
        }
        string = this.trim(string, n2);
        this.sb.insert(n3, string);
        return true;
    }

    public String trim(String string, int n) {
        return this.trim(string, n, false);
    }

    public String trim(String string, int n, boolean bl) {
        String string2 = string;
        String string3 = new String();
        int n2 = this.getFieldWidth(n);
        if (n2 < 0) {
            return string2;
        }
        if (string2 == null) {
            string2 = new String();
        }
        if (string2.length() > n2) {
            string2 = string2.substring(0, n2);
        } else if (string2.length() < n2) {
            int n3 = n2 - string2.length();
            int n4 = 0;
            while (n4 < n3) {
                string3 = String.valueOf(string3) + " ";
                ++n4;
            }
            string2 = bl ? String.valueOf(string3) + string2 : String.valueOf(string2) + string3;
        }
        return string2;
    }

    public int getNumFields() {
        return this.fieldWidths.size();
    }

    public int getFieldWidth(int n) {
        Integer n2 = new Integer(-1);
        if (n > this.fieldWidths.size()) {
            return -1;
        }
        n2 = (Integer)this.fieldWidths.elementAt(n);
        return n2;
    }

    public int getFieldIndent(int n) {
        int n2 = 0;
        if (n > this.fieldWidths.size()) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n) {
            n2 += this.getFieldWidth(n3);
            ++n3;
        }
        return n2;
    }

    public String getField(int n) {
        if (n > this.fieldWidths.size()) {
            return null;
        }
        int n2 = this.getFieldIndent(n);
        int n3 = this.getFieldWidth(n);
        String string = this.sb.toString();
        if (string.length() <= n2) {
            return null;
        }
        return string.substring(n2, n2 + n3).trim();
    }

    public boolean setField(int n, String string) {
        if (n >= this.fieldWidths.size()) {
            return false;
        }
        int n2 = this.getFieldIndent(n);
        int n3 = this.getFieldWidth(n);
        string = this.trim(string, n);
        int n4 = 0;
        while (n4 < n3) {
            this.sb.setCharAt(n4 + n2, string.charAt(n4));
            ++n4;
        }
        return true;
    }

    public String toString() {
        return this.sb.toString();
    }

    public void fromString(String string) {
        this.sb = new StringBuffer(string);
    }

    public String getDisplay() {
        return this.sb.toString();
    }

    public static void updateList(Vector vector, ColorListBox colorListBox) {
        ParsedStringBuffer.updateList(vector, colorListBox, null);
    }

    public static void updateList(Vector vector, ColorListBox colorListBox, Vector vector2) {
        boolean bl = colorListBox.updateEnabled();
        String string = colorListBox.getSelectedItem();
        if (bl) {
            colorListBox.enableUpdate(false);
        }
        colorListBox.clear();
        int n = 0;
        while (n < vector.size()) {
            ParsedStringBuffer parsedStringBuffer = (ParsedStringBuffer)vector.elementAt(n);
            Color color = vector2 != null ? (Color)vector2.elementAt(n) : null;
            colorListBox.addItem(parsedStringBuffer.getDisplay(), color);
            ++n;
        }
        if (string != null) {
            int n2 = 0;
            while (n2 < colorListBox.countItems()) {
                String string2 = colorListBox.getItem(n2);
                if (string2.equals(string)) {
                    colorListBox.setSelect(n2);
                    break;
                }
                ++n2;
            }
        }
        if (bl) {
            colorListBox.enableUpdate(true);
        }
    }

    public static void updateList(Vector vector, List list) {
        String string = list.getSelectedItem();
        int n = 0;
        if (vector.size() == 0) {
            list.clear();
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            ParsedStringBuffer parsedStringBuffer = (ParsedStringBuffer)vector.elementAt(n2);
            if (n >= list.countItems()) {
                list.addItem(parsedStringBuffer.getDisplay());
                ++n;
            } else if (list.getItem(n).equals(parsedStringBuffer.getDisplay())) {
                ++n;
            } else {
                boolean bl = false;
                int n3 = n + 1;
                while (n3 < list.countItems()) {
                    if (list.getItem(n3).equals(parsedStringBuffer.getDisplay())) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    list.delItems(n, n3 - 1);
                    ++n;
                } else {
                    list.addItem(parsedStringBuffer.getDisplay(), n);
                    ++n;
                }
            }
            ++n2;
        }
        if (n < list.countItems()) {
            list.delItems(n, list.countItems() - 1);
        }
        if (list.getSelectedIndex() == -1) {
            int n4 = 0;
            while (n4 < list.countItems()) {
                String string2 = list.getItem(n4);
                if (string2.equals(string)) {
                    list.select(n4);
                    return;
                }
                ++n4;
            }
        }
    }

    public static void sort(Vector vector, int n, boolean bl) {
        ParsedStringBuffer.sort(vector, n, bl, null);
    }

    public static void sort(Vector vector, int n, boolean bl, Vector vector2) {
        int n2;
        ParsedStringBuffer parsedStringBuffer;
        int n3;
        int n4 = -1;
        boolean bl2 = true;
        Object e = null;
        Vector<ParsedStringBuffer> vector3 = new Vector<ParsedStringBuffer>();
        Vector vector4 = new Vector();
        if (vector.size() < 2) {
            return;
        }
        if (bl) {
            n4 = 1;
        }
        try {
            n3 = 0;
            while (n3 < vector.size()) {
                parsedStringBuffer = (ParsedStringBuffer)vector.elementAt(n3);
                n2 = Integer.parseInt(parsedStringBuffer.getField(n));
                ++n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        while (vector.size() > 0) {
            int n5 = 0;
            ParsedStringBuffer parsedStringBuffer2 = (ParsedStringBuffer)vector.elementAt(0);
            n3 = 1;
            while (n3 < vector.size()) {
                parsedStringBuffer = (ParsedStringBuffer)vector.elementAt(n3);
                String string = parsedStringBuffer2.getField(n);
                String string2 = parsedStringBuffer.getField(n);
                if (bl2) {
                    int n6 = Integer.parseInt(string);
                    int n7 = Integer.parseInt(string2);
                    n2 = n6 - n7;
                } else {
                    n2 = string.compareTo(string2);
                }
                if ((n2 *= n4) > 0) {
                    n5 = n3;
                    parsedStringBuffer2 = (ParsedStringBuffer)vector.elementAt(n3);
                }
                ++n3;
            }
            parsedStringBuffer = (ParsedStringBuffer)vector.elementAt(n5);
            vector3.addElement(parsedStringBuffer);
            vector.removeElementAt(n5);
            if (vector2 == null) continue;
            e = vector2.elementAt(n5);
            vector4.addElement(e);
            vector2.removeElementAt(n5);
        }
        n3 = 0;
        while (n3 < vector3.size()) {
            vector.addElement(vector3.elementAt(n3));
            if (vector2 != null) {
                vector2.addElement(vector4.elementAt(n3));
            }
            ++n3;
        }
    }

    public static int findString(Vector vector, String string) {
        if (string == null) {
            return -1;
        }
        int n = 0;
        while (n < vector.size()) {
            ParsedStringBuffer parsedStringBuffer = (ParsedStringBuffer)vector.elementAt(n);
            if (parsedStringBuffer.toString().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

