/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.Window;

class FlowSpecDialog
extends ICDialog {
    FlowSpec flow;
    FlowSpec parentFlow;
    FlowSpecDlg dlg;
    String errMsg = "Unknown Error";
    boolean addMode = false;
    boolean madeChange = false;
    int lineRate;

    FlowSpecDialog(ICFrame iCFrame, EditMPOADialog editMPOADialog, FlowSpec flowSpec) {
        super(iCFrame, editMPOADialog, "Edit Flow Specification", true);
        ParsedStringBuffer parsedStringBuffer;
        if (flowSpec == null) {
            this.addMode = true;
            int n = editMPOADialog.getReadOnlyIndex(0, true) - 1;
            this.parentFlow = (FlowSpec)editMPOADialog.flowSpecs.elementAt(n);
            this.setTitle("Add Flow Specification");
        } else {
            this.parentFlow = flowSpec;
        }
        this.flow = new FlowSpec(this.parentFlow);
        this.lineRate = editMPOADialog.lineRate;
        this.dlg = new FlowSpecDlg(this);
        this.dlg.CreateControls();
        ((Component)this).setFont(this.frame.fixFont);
        this.dlg.setControlFont(this.frame.baseFont);
        this.dlg.IPMask.setFont(this.frame.fixFont);
        this.dlg.protocol.setFont(this.frame.fixFont);
        this.dlg.dstPort.setFont(this.frame.fixFont);
        this.dlg.srcPort.setFont(this.frame.fixFont);
        this.dlg.pcr.setFont(this.frame.fixFont);
        this.dlg.scr.setFont(this.frame.fixFont);
        this.dlg.maxBurst.setFont(this.frame.fixFont);
        this.dlg.LANEThreshold.setFont(this.frame.fixFont);
        this.dlg.MPOAThreshold.setFont(this.frame.fixFont);
        if (editMPOADialog.MPOAThreshold_default != -1) {
            this.dlg.MPOADefault.setText(String.valueOf(editMPOADialog.MPOAThreshold_default));
        } else {
            this.dlg.MPOADefault.setText("N/A");
        }
        ((TextComponent)this.dlg.IPMask).setText(this.flow.IPMask);
        if (this.flow.protocol < 1) {
            ((TextComponent)this.dlg.protocol).setText("*");
        } else {
            ((TextComponent)this.dlg.protocol).setText(String.valueOf(this.flow.protocol));
        }
        if (this.flow.dstPort < 1) {
            ((TextComponent)this.dlg.dstPort).setText("*");
        } else {
            ((TextComponent)this.dlg.dstPort).setText(String.valueOf(this.flow.dstPort));
        }
        if (this.flow.srcPort < 1) {
            ((TextComponent)this.dlg.srcPort).setText("*");
        } else {
            ((TextComponent)this.dlg.srcPort).setText(String.valueOf(this.flow.srcPort));
        }
        int n = 0;
        while (n < FlowSpec.protocols.size()) {
            parsedStringBuffer = (ParsedStringBuffer)FlowSpec.protocols.elementAt(n);
            this.dlg.protocolList.addItem(parsedStringBuffer.getField(0));
            String string = this.dlg.protocol.getText();
            if (parsedStringBuffer.getField(1).equals(string)) {
                this.enableField(this.dlg.protocol, false);
                this.dlg.protocolList.select(n);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < FlowSpec.ports.size()) {
            parsedStringBuffer = (ParsedStringBuffer)FlowSpec.ports.elementAt(n2);
            this.dlg.srcPortList.addItem(parsedStringBuffer.getField(0));
            this.dlg.dstPortList.addItem(parsedStringBuffer.getField(0));
            String string = this.dlg.srcPort.getText();
            if (parsedStringBuffer.getField(1).equals(string)) {
                this.enableField(this.dlg.srcPort, false);
                this.dlg.srcPortList.select(n2);
            }
            string = this.dlg.dstPort.getText();
            if (parsedStringBuffer.getField(1).equals(string)) {
                this.enableField(this.dlg.dstPort, false);
                this.dlg.dstPortList.select(n2);
            }
            ++n2;
        }
        if (this.flow.vcType.equals("CBR")) {
            this.dlg.typeCBR.setState(true);
        } else if (this.flow.vcType.equals("VBR")) {
            this.dlg.typeVBR.setState(true);
        } else if (this.flow.vcType.equals("UBR")) {
            this.dlg.typeUBR.setState(true);
        } else {
            this.dlg.typeShared.setState(true);
        }
        if (ICTop.cellUnits) {
            this.dlg.pcrUnits.setText("Cells/sec");
            this.dlg.scrUnits.setText("Cells/sec");
            this.dlg.mbsUnits.setText("Cells");
            ((TextComponent)this.dlg.pcr).setText(String.valueOf(this.flow.pcr));
            ((TextComponent)this.dlg.scr).setText(String.valueOf(this.flow.scr));
            ((TextComponent)this.dlg.maxBurst).setText(String.valueOf(this.flow.maxBurst));
        } else {
            this.dlg.pcrUnits.setText("Kbits/sec");
            this.dlg.scrUnits.setText("Kbits/sec");
            this.dlg.mbsUnits.setText("Kbits");
            ((TextComponent)this.dlg.pcr).setText(String.valueOf(ICTop.Cells2Kbits(this.flow.pcr)));
            ((TextComponent)this.dlg.scr).setText(String.valueOf(ICTop.Cells2Kbits(this.flow.scr)));
            ((TextComponent)this.dlg.maxBurst).setText(String.valueOf(ICTop.Cells2Kbits(this.flow.maxBurst)));
        }
        if (this.flow.LANEThreshold < 0) {
            this.flow.LANEThreshold = 0;
        }
        ((TextComponent)this.dlg.LANEThreshold).setText(String.valueOf(this.flow.LANEThreshold));
        if (this.flow.MPOAThreshold == -1) {
            ((TextComponent)this.dlg.MPOAThreshold).setText("*");
        } else {
            ((TextComponent)this.dlg.MPOAThreshold).setText(String.valueOf(this.flow.MPOAThreshold));
        }
        this.dlg.min_back_pcr.setState((this.flow.qos_flags & 8) > 0);
        this.dlg.max_back_pcr.setState(!this.dlg.min_back_pcr.getState());
        this.setVCControls();
        if (this.flow.readOnly) {
            this.dlg.protocol.disable();
            this.dlg.dstPort.disable();
            this.dlg.srcPort.disable();
            this.dlg.typeCBR.disable();
            this.dlg.typeVBR.disable();
            this.dlg.typeUBR.disable();
            this.dlg.typeShared.disable();
            this.dlg.IPMask.disable();
            this.dlg.scr.disable();
            this.dlg.pcr.disable();
            this.dlg.maxBurst.disable();
            this.dlg.min_back_pcr.disable();
            this.dlg.max_back_pcr.disable();
            this.dlg.LANEThreshold.disable();
            this.dlg.MPOAThreshold.disable();
            this.dlg.srcPortList.disable();
            this.dlg.dstPortList.disable();
            this.dlg.protocolList.disable();
            this.dlg.IDOK.disable();
            this.setTitle("View Flow Specification");
        }
        Point point = this.parent.location();
        this.move(point.x + 50, point.y + 50);
        this.setResizable(false);
        this.parent.disable();
        this.show();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.dlg.IDOK) {
            if (!this.flow.readOnly) {
                if (!this.updateFlow()) {
                    new MessageBox(this.frame, (Window)this, this.errMsg, 1);
                    return true;
                }
                int n = -2;
                if (this.addMode) {
                    n = ((EditMPOADialog)this.parent).flowSpecs.size();
                }
                ((EditMPOADialog)this.parent).updateList(n);
            }
            this.dispose();
            return true;
        }
        if (event.target == this.dlg.IDCANCEL) {
            if (this.addMode) {
                ((EditMPOADialog)this.parent).flowSpecs.removeElement(this.parentFlow);
            }
            this.dispose();
            return true;
        }
        if (event.target == this.dlg.protocolList) {
            ParsedStringBuffer parsedStringBuffer = FlowSpec.pTemplate.Clone();
            int n = this.dlg.protocolList.getSelectedIndex();
            ParsedStringBuffer parsedStringBuffer2 = (ParsedStringBuffer)FlowSpec.protocols.elementAt(n);
            if (parsedStringBuffer2.getField(1).equals(parsedStringBuffer.getField(1))) {
                this.enableField(this.dlg.protocol, true);
            } else {
                this.enableField(this.dlg.protocol, false);
                ((TextComponent)this.dlg.protocol).setText(parsedStringBuffer2.getField(1));
            }
            return true;
        }
        if (event.target == this.dlg.srcPortList) {
            ParsedStringBuffer parsedStringBuffer = FlowSpec.pTemplate.Clone();
            int n = this.dlg.srcPortList.getSelectedIndex();
            ParsedStringBuffer parsedStringBuffer3 = (ParsedStringBuffer)FlowSpec.ports.elementAt(n);
            if (parsedStringBuffer3.getField(1).equals(parsedStringBuffer.getField(1))) {
                this.enableField(this.dlg.srcPort, true);
            } else {
                this.enableField(this.dlg.srcPort, false);
                ((TextComponent)this.dlg.srcPort).setText(parsedStringBuffer3.getField(1));
            }
            return true;
        }
        if (event.target == this.dlg.dstPortList) {
            ParsedStringBuffer parsedStringBuffer = FlowSpec.pTemplate.Clone();
            int n = this.dlg.dstPortList.getSelectedIndex();
            ParsedStringBuffer parsedStringBuffer4 = (ParsedStringBuffer)FlowSpec.ports.elementAt(n);
            if (parsedStringBuffer4.getField(1).equals(parsedStringBuffer.getField(1))) {
                this.enableField(this.dlg.dstPort, true);
            } else {
                this.enableField(this.dlg.dstPort, false);
                ((TextComponent)this.dlg.dstPort).setText(parsedStringBuffer4.getField(1));
            }
            return true;
        }
        if (event.target == this.dlg.typeCBR || event.target == this.dlg.typeVBR || event.target == this.dlg.typeUBR || event.target == this.dlg.typeShared) {
            this.setVCControls();
            return true;
        }
        return super.action(event, object);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 201: {
                this.dispose();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public void setVCControls() {
        this.enableField(this.dlg.pcr, !this.dlg.typeShared.getState());
        if (this.dlg.typeShared.getState() && this.flow.readOnly) {
            ((TextComponent)this.dlg.pcr).setText("N/A");
        }
        this.enableField(this.dlg.scr, this.dlg.typeVBR.getState());
        if (!this.dlg.typeVBR.getState() && this.flow.readOnly) {
            ((TextComponent)this.dlg.scr).setText("N/A");
        }
        this.enableField(this.dlg.maxBurst, this.dlg.typeVBR.getState());
        if (!this.dlg.typeVBR.getState() && this.flow.readOnly) {
            ((TextComponent)this.dlg.maxBurst).setText("N/A");
        }
        this.dlg.min_back_pcr.enable(!this.dlg.typeShared.getState());
        this.dlg.max_back_pcr.enable(!this.dlg.typeShared.getState());
    }

    boolean updateFlow() {
        try {
            double d;
            double d2;
            double d3;
            this.flow.IPMask = this.dlg.IPMask.getText().trim();
            String[] stringArray = new String[1];
            if (!this.frame.topLayer.get_IP_addr(this, this.flow.IPMask, stringArray)) {
                this.errMsg = "Unknown IP Hostname, or Invalid IP Address.";
                return false;
            }
            this.flow.IPMask = stringArray[0];
            if (this.dlg.protocol.getText().startsWith("*")) {
                this.flow.protocol = -1;
            } else {
                this.errMsg = "Protocol value must be '*' or 1-255";
                this.flow.protocol = Integer.parseInt(this.dlg.protocol.getText().trim());
                this.errMsg = "Protocol value must be greater than 0";
                if (this.flow.protocol < 1) {
                    return false;
                }
                this.errMsg = "Protocol value must be less than 256";
                if (this.flow.protocol > 255) {
                    return false;
                }
            }
            if (this.dlg.dstPort.getText().startsWith("*")) {
                this.flow.dstPort = -1;
            } else {
                this.errMsg = "Destination port value must be '*' or 1-65535";
                this.flow.dstPort = Integer.parseInt(this.dlg.dstPort.getText().trim());
                this.errMsg = "Destination port value must be greater than 0";
                if (this.flow.dstPort < 1) {
                    return false;
                }
                this.errMsg = "Destination port value must be less than 65536";
                if (this.flow.dstPort > 65535) {
                    return false;
                }
            }
            if (this.dlg.srcPort.getText().startsWith("*")) {
                this.flow.srcPort = -1;
            } else {
                this.errMsg = "Source port value must be '*' or 1-65535";
                this.flow.srcPort = Integer.parseInt(this.dlg.srcPort.getText().trim());
                this.errMsg = "Source port value must be greater than 0";
                if (this.flow.srcPort < 1) {
                    return false;
                }
                this.errMsg = "Source port value must be less than 65536";
                if (this.flow.srcPort > 65535) {
                    return false;
                }
            }
            this.flow.vcType = "Shared VC";
            if (this.dlg.typeCBR.getState()) {
                this.flow.vcType = "CBR";
            } else if (this.dlg.typeVBR.getState()) {
                this.flow.vcType = "VBR";
            } else if (this.dlg.typeUBR.getState()) {
                this.flow.vcType = "UBR";
            }
            if (this.flow.vcType != "Shared VC") {
                this.errMsg = "Peak Cell Rate value must be a positive (non-zero) numeric";
                if (ICTop.cellUnits) {
                    this.flow.pcr = Integer.parseInt(this.dlg.pcr.getText().trim());
                    this.errMsg = "Peak Cell Rate must be from 1 to " + this.lineRate;
                } else {
                    d3 = Double.valueOf(this.dlg.pcr.getText().trim());
                    this.flow.pcr = ICTop.Kbits2Cells(d3);
                    d2 = ICTop.Cells2Kbits(1);
                    d = ICTop.Cells2Kbits(this.lineRate);
                    this.errMsg = "Peak Cell Rate must be from " + d2 + " to " + d;
                }
                if (this.flow.pcr < 1) {
                    return false;
                }
                if (this.flow.pcr > this.lineRate) {
                    return false;
                }
            }
            if (this.flow.vcType == "VBR") {
                this.errMsg = "Sustained Cell Rate value must be positive (non-zero) numeric";
                if (ICTop.cellUnits) {
                    this.flow.scr = Integer.parseInt(this.dlg.scr.getText().trim());
                    this.errMsg = "Sustained Cell Rate must be from 1 to " + (this.flow.pcr - 1);
                } else {
                    d3 = Double.valueOf(this.dlg.scr.getText().trim());
                    this.flow.scr = ICTop.Kbits2Cells(d3);
                    d2 = ICTop.Cells2Kbits(1);
                    d = ICTop.Cells2Kbits(this.flow.pcr - 1);
                    this.errMsg = "Sustained Cell Rate must from " + d2 + " to " + d;
                }
                if (this.flow.scr < 1) {
                    return false;
                }
                if (this.flow.scr >= this.flow.pcr) {
                    return false;
                }
                this.errMsg = "Max Burst value must be positive (non-zero) numeric";
                if (ICTop.cellUnits) {
                    this.flow.maxBurst = Integer.parseInt(this.dlg.maxBurst.getText().trim());
                    this.errMsg = "Max Burst value must be from 1 to 400000";
                } else {
                    d3 = Double.valueOf(this.dlg.maxBurst.getText().trim());
                    this.flow.maxBurst = ICTop.Kbits2Cells(d3);
                    d2 = ICTop.Cells2Kbits(1);
                    d = ICTop.Cells2Kbits(400000);
                    this.errMsg = "Max Burst value must be from " + d2 + " to " + d;
                }
                if (this.flow.maxBurst < 1) {
                    return false;
                }
                if (this.flow.maxBurst > 400000) {
                    return false;
                }
            }
            this.errMsg = "LANE VC threshold value must be numeric 0-999999";
            String string = this.dlg.LANEThreshold.getText().trim();
            this.flow.LANEThreshold = Integer.parseInt(string);
            if (this.flow.LANEThreshold < 0) {
                return false;
            }
            if (this.flow.LANEThreshold > 999999) {
                return false;
            }
            this.errMsg = "MPOA VC threshold value must be '*' or 0-999999";
            string = this.dlg.MPOAThreshold.getText().trim();
            if (string.equals("*")) {
                this.flow.MPOAThreshold = -1;
            } else {
                this.flow.MPOAThreshold = Integer.parseInt(string);
                if (this.flow.MPOAThreshold < 0) {
                    return false;
                }
                if (this.flow.MPOAThreshold > 999999) {
                    return false;
                }
            }
            this.flow.qos_flags = 0;
            if (this.dlg.min_back_pcr.getState()) {
                this.flow.qos_flags += 8;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (this.parentFlow.setFlow(this.flow) | this.addMode) {
            ((EditMPOADialog)this.parent).madeChange();
        }
        return true;
    }

    void enableField(Component component, boolean bl) {
        component.enable(bl);
        if (bl) {
            component.setBackground(Color.white);
            return;
        }
        component.setBackground(Color.gray);
    }
}

