/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Point;
import java.awt.Window;

class AddForeDialog
extends ICDialog {
    AddForeDlg dlg = new AddForeDlg(this);
    String errMsg = "Unknown Error";
    public static final int NULL_ENCAP = 0;
    public static final int LLC_ENCAP = 1;
    public static final int LLC_ROUTED = 1;
    public static final int LLC_BRIDGED = 2;
    public static final int OUT_HOST = 0;
    public static final int OUT_MULTICAST = 1;
    public static final int INCOMING = 2;
    String host;
    String vlan;
    int vpi;
    int vci;
    int rate;
    int capsulation;
    int dir;

    AddForeDialog(ICFrame iCFrame) {
        super(iCFrame, "Add FORE IP PVC", true);
        Object object;
        this.dlg.CreateControls();
        ((Component)this).setFont(this.frame.fixFont);
        this.dlg.setControlFont(this.frame.baseFont);
        this.dlg.vlanChoice.setBackground(Color.white);
        int n = 0;
        while (n < this.frame.vlanPanel.vlanList.size()) {
            VlanPSB vlanPSB = (VlanPSB)this.frame.vlanPanel.vlanList.elementAt(n);
            if (vlanPSB.getField(2).equals("FORE IP")) {
                this.dlg.vlanChoice.addItem(vlanPSB.getField(1));
            }
            ++n;
        }
        if (this.frame.adapPanel.adapList.size() > 0) {
            object = this.dlg.vlanChoice.getItem(0);
            this.dlg.vlanChoice.select((String)object);
        }
        this.dlg.Routed.setState(true);
        this.dlg.OutgoingHost.setState(true);
        this.dlg.EncapNull.setState(true);
        if (ICTop.cellUnits) {
            this.dlg.pcrUnits.setText("cells/sec");
        } else {
            this.dlg.pcrUnits.setText("Kbits/sec");
        }
        this.dlg.VPI.requestFocus();
        object = this.frame.location();
        this.move(((Point)object).x + 100, ((Point)object).y + 100);
        this.setResizable(false);
        this.show();
    }

    public boolean addConnection() {
        this.vlan = this.dlg.vlanChoice.getSelectedItem();
        this.capsulation = 0;
        if (this.dlg.Routed.getState()) {
            this.capsulation = 1;
        } else if (this.dlg.Bridged.getState()) {
            this.capsulation = 2;
        }
        this.dir = 0;
        if (this.dlg.Outgoing.getState()) {
            this.dir = 1;
        } else if (this.dlg.Incoming.getState()) {
            this.dir = 2;
        }
        try {
            String string = this.dlg.VPI.getText();
            this.errMsg = "VPI missing or invalid";
            this.vpi = Integer.parseInt(string);
            string = this.dlg.VCI.getText();
            this.errMsg = "VCI missing or invalid";
            this.vci = Integer.parseInt(string);
            string = this.dlg.PeakCellRate.getText();
            this.errMsg = "Peak Cell Rate missing or invalid";
            if (ICTop.cellUnits) {
                this.rate = Integer.parseInt(string);
            } else {
                double d = Double.valueOf(string);
                this.rate = ICTop.Kbits2Cells(d);
            }
            if (this.rate < 1) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (this.vci < 1) {
            this.errMsg = "VCI field is invalid";
            return false;
        }
        this.host = this.dlg.Hostname.getText().trim();
        int n = 0;
        while (n < this.frame.connPanel.connList.size()) {
            ConnectionPSB connectionPSB = (ConnectionPSB)this.frame.connPanel.connList.elementAt(n);
            if (connectionPSB.getField(4).equals(String.valueOf(this.vpi)) && connectionPSB.getField(5).equals(String.valueOf(this.vci)) && connectionPSB.getField(11).equals(this.vlan.trim())) {
                this.errMsg = "Requested PVC already exists on selected VLAN";
                return false;
            }
            ++n;
        }
        String[] stringArray = new String[1];
        if (!this.frame.topLayer.get_IP_addr(this, this.host, stringArray)) {
            this.errMsg = "Unknown IP Hostname, or Invalid IP Address.";
            return false;
        }
        this.errMsg = "Wildcards not permitted in IP Address.";
        int n2 = 0;
        while (n2 < stringArray[0].length()) {
            char c = stringArray[0].charAt(n2);
            if (c == '*') {
                return false;
            }
            ++n2;
        }
        this.host = stringArray[0];
        this.frame.connPanel.addForePVC(this);
        return true;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.dlg.IDOK) {
            if (!this.addConnection()) {
                new MessageBox(this.frame, (Window)this, this.errMsg, 1);
                return true;
            }
            this.dispose();
            return true;
        }
        if (event.target == this.dlg.IDCANCEL) {
            this.dispose();
            return true;
        }
        if (event.target == this.dlg.OutgoingHost) {
            this.dlg.Hostname.enable(true);
            this.dlg.RoutedLabel.setText("(Routed)");
            this.dlg.Bridged.enable(true);
            return true;
        }
        if (event.target == this.dlg.Outgoing) {
            this.dlg.Hostname.enable(false);
            this.dlg.RoutedLabel.setText("(Routed)");
            this.dlg.Bridged.enable(true);
            return true;
        }
        if (event.target == this.dlg.Incoming) {
            this.dlg.Hostname.enable(false);
            this.dlg.RoutedLabel.setText("");
            this.dlg.Bridged.enable(false);
            if (this.dlg.Bridged.getState()) {
                this.dlg.EncapNull.setState(true);
            }
            return true;
        }
        return super.action(event, object);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 201: {
                this.dispose();
                return true;
            }
        }
        return super.handleEvent(event);
    }
}

