/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.UID;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.IncomingRefTableEntry;
import sun.rmi.transport.LiveRef;

class ConnectionInputStream
extends MarshalInputStream {
    private boolean dgcAckNeeded = false;
    private Hashtable incomingRefTable = new Hashtable();
    private UID ackID = new UID();

    ConnectionInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    void readID() throws IOException {
        this.ackID = UID.read(this);
    }

    void saveRef(LiveRef liveRef) {
        Endpoint endpoint = liveRef.getEndpoint();
        IncomingRefTableEntry incomingRefTableEntry = (IncomingRefTableEntry)this.incomingRefTable.get(endpoint);
        if (incomingRefTableEntry == null) {
            incomingRefTableEntry = new IncomingRefTableEntry();
            this.incomingRefTable.put(endpoint, incomingRefTableEntry);
        }
        incomingRefTableEntry.refList.addElement(liveRef);
    }

    void registerRefs() throws IOException {
        try {
            block6: {
                try {
                    if (!this.incomingRefTable.isEmpty()) {
                        Enumeration enumeration = this.incomingRefTable.elements();
                        while (enumeration.hasMoreElements()) {
                            IncomingRefTableEntry incomingRefTableEntry = (IncomingRefTableEntry)enumeration.nextElement();
                            if (incomingRefTableEntry.refList.isEmpty()) continue;
                            Object[] objectArray = new LiveRef[incomingRefTableEntry.refList.size()];
                            incomingRefTableEntry.refList.copyInto(objectArray);
                            DGCClient.referenced((LiveRef[])objectArray);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    if (DGCImpl.logLevel < 10) break block6;
                    LogStream logStream = LogStream.log("dgc");
                    logStream.println("ConnectionInputStream.registerRefs: exception: ");
                    remoteException.printStackTrace(logStream);
                }
            }
            Object var2_6 = null;
            this.incomingRefTable.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            this.incomingRefTable.clear();
            throw throwable;
        }
    }

    void setAckNeeded() {
        this.dgcAckNeeded = true;
    }

    void done(Connection connection) {
        if (this.dgcAckNeeded) {
            Connection connection2 = null;
            Channel channel = null;
            boolean bl = true;
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("ConnectionInputStream.done: send ack");
            }
            try {
                channel = connection.getChannel();
                connection2 = channel.newConnection();
                DataOutputStream dataOutputStream = new DataOutputStream(connection2.getOutputStream());
                dataOutputStream.writeByte(84);
                this.ackID.write(dataOutputStream);
                connection2.releaseOutputStream();
            }
            catch (RemoteException remoteException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            try {
                if (connection2 != null) {
                    channel.free(connection2, bl);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }
}

