/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Enumeration;
import sun.misc.FIFOQueueEnumerator;
import sun.misc.LIFOQueueEnumerator;
import sun.misc.QueueElement;

public class Queue {
    int length;
    QueueElement head;
    QueueElement tail;

    public synchronized void enqueue(Object object) {
        QueueElement queueElement = new QueueElement(object);
        if (this.head == null) {
            this.head = queueElement;
            this.tail = queueElement;
            this.length = 1;
        } else {
            queueElement.next = this.head;
            this.head.prev = queueElement;
            this.head = queueElement;
            ++this.length;
        }
        this.notify();
    }

    public Object dequeue() throws InterruptedException {
        return this.dequeue(0L);
    }

    public synchronized Object dequeue(long l) throws InterruptedException {
        while (this.tail == null) {
            this.wait(l);
        }
        QueueElement queueElement = this.tail;
        this.tail = queueElement.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        --this.length;
        return queueElement.obj;
    }

    public synchronized boolean isEmpty() {
        return this.tail == null;
    }

    public final synchronized Enumeration elements() {
        return new LIFOQueueEnumerator(this);
    }

    public final synchronized Enumeration reverseElements() {
        return new FIFOQueueEnumerator(this);
    }

    public synchronized void dump(String string) {
        System.err.println(">> " + string);
        System.err.println("[" + this.length + " elt(s); head = " + (this.head == null ? "null" : String.valueOf(this.head.obj)) + " tail = " + (this.tail == null ? "null" : String.valueOf(this.tail.obj)));
        QueueElement queueElement = this.head;
        QueueElement queueElement2 = null;
        while (queueElement != null) {
            System.err.println("  " + queueElement);
            queueElement2 = queueElement;
            queueElement = queueElement.next;
        }
        if (queueElement2 != this.tail) {
            System.err.println("  tail != last: " + this.tail + ", " + queueElement2);
        }
        System.err.println("]");
    }
}

