/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Identity;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Security;
import java.util.Enumeration;

public abstract class IdentityScope
extends Identity {
    private static IdentityScope scope;

    private static void initializeSystemScope() {
        String string = Security.getProperty("system.scope");
        if (string == null) {
            return;
        }
        try {
            Class.forName(string);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Security.error("unable to establish a system scope from " + string);
            classNotFoundException.printStackTrace();
            return;
        }
    }

    protected IdentityScope() {
        this("restoring...");
    }

    public IdentityScope(String string) {
        super(string);
    }

    public IdentityScope(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public static IdentityScope getSystemScope() {
        if (scope == null) {
            IdentityScope.initializeSystemScope();
        }
        return scope;
    }

    protected static void setSystemScope(IdentityScope identityScope) {
        Identity.staticCheck("set.system.scope");
        scope = identityScope;
    }

    public abstract int size();

    public abstract Identity getIdentity(String var1);

    public Identity getIdentity(Principal principal) {
        return this.getIdentity(principal.getName());
    }

    public abstract Identity getIdentity(PublicKey var1);

    public abstract void addIdentity(Identity var1) throws KeyManagementException;

    public abstract void removeIdentity(Identity var1) throws KeyManagementException;

    public abstract Enumeration identities();

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.size() + "]";
    }
}

