/*
    Video.h

    Header file for the video display routines in Video.asm.
*/

#ifndef VIDEO_H
#define VIDEO_H

/*************************************************************************/
/*                                                                       */
/* Macros.                                                               */
/*                                                                       */
/*************************************************************************/

    /* Directory entry types. */
#define DRIVETYPE 0
#define DIRTYPE 1
#define FILETYPE 2

#define NDIRROWS    18      /* number of rows in directory list display */
#define NDIRCOLS    6       /* number of columns in directory list display */

    /* Keystroke defines. */
#define ESC         0x011b      /* <esc> key */
#define BACKSPACE   0x0e08      /* <backspace> key */
#define INSERT      0x5200      /* <insert> key */
#define HOME        0x4700      /* <home> key */
#define DELETE      0x5300      /* <delete> key */
#define END         0x4f00      /* <end> key */
#define ENTER       0x1c0d      /* <enter> key */
#define LEFT        0x4b00      /* <left arrow> key */
#define RIGHT       0x4d00      /* <right arrow> key */
#define LOWERL      0x266c      /* lower-case "l" */
#define LOWERP      0x1970      /* lower-case "p" */
#define LOWERJ      0x246a      /* lower-case "j" */
#define LESSTHAN    0x333c      /* "less than" character */
#define GREATERTHAN 0x343e      /* "greater than" character */
#define UPPERP      0x1950      /* upper-case "P" */
#define UPPERR      0x1352      /* upper-case "R" */
#define LOWERS      0x1f73      /* lower-case "s" */
#define LOWERU      0x1675      /* lower-case "u" */
#define LOWERR      0x1372      /* lower-case "r" */
#define CTRLR       0x1312      /* <control>-R */
#define UPPERS      0x1f53      /* upper-case "S" */
#define CTRLD       0x2004      /* <control>-D */
#define LOWERV      0x2f76      /* lower-case "v" */
#define UPPERV      0x2f56      /* upper-case "V" */
#define UPPERL      0x264c      /* upper-case "L" */
#define CTRLO       0x180f      /* <control>-O */
#define LOWERT      0x1474      /* lower-case "t" */
#define UPPERT      0x1454      /* upper-case "T" */
#define LOWERB      0x3062      /* lower-case "b" */
#define UPPERB      0x3042      /* upper-case "B" */
#define LOWERF      0x2166      /* lower-case "f" */
#define F1          0x3b00      /* F1 key */
#define UP          0x4800      /* <up arrow> key */
#define DOWN        0x5000      /* <down arrow> key */
#define PGUP        0x4900      /* <page up> key */
#define PGDOWN      0x5100      /* <page down> key */
#define CTRLHOME    0x7700      /* <control>-<home> key */
#define CTRLEND     0x7500      /* <control>-<end> key */
#define LOWERG      0x2267      /* lower-case "g" */
#define UPPERG      0x2247      /* upper-case "G" */
#define ALTX        0x2d00      /* <alt>-X */
#define ALTS        0x1f00      /* <alt>-S */
#define ALTO        0x1800      /* <alt>-O */


/*************************************************************************/
/*                                                                       */
/* Types.                                                                */
/*                                                                       */
/*************************************************************************/



/*************************************************************************/
/*                                                                       */
/* Global variables.                                                     */
/*                                                                       */
/*************************************************************************/



/*************************************************************************/
/*                                                                       */
/* Function prototypes.                                                  */
/*                                                                       */
/*************************************************************************/

    /* video initialization routine */
void pascal initvid( void );
    /* video finalization routine */
void pascal endvid( void );
    /* routine to put pattern table entry on screen */
void pascal vidputentry( unsigned patentry );
    /* routine to put size of pattern table on screen */
void pascal vidputnentries( void );
    /* routine to put pattern number on screen */
void pascal vidputpatnum( unsigned patnum );
    /* routine to put number of patterns on screen */
void pascal vidputnpatterns( void );
    /* routine to put a note number on screen */
void pascal vidputnotenum( unsigned char notenum );
    /* routine to set all numbers on the screen */
void pascal vidputnums( unsigned segnum );
    /* routine to update numbers during song playback */
void pascal vidupdatenums( unsigned dmaold, unsigned dmanew );
    /* routine to put the DAC volume on screen */
void pascal vidputvolume( void );
    /* routine to put output sampling rate on screen */
void pascal vidputrate( void );
    /* routine to put loop disable setting on screen */
void pascal vidputloopen( void );
    /* routine to put ticks/division on screen */
void pascal vidputticksper( unsigned ticksper );
    /* routine to put beats/minute on screen */
void pascal vidputbpm( unsigned char bpm );
    /* routine to put number of channels on screen */
void pascal vidputnchans( void );
    /* routine to put number of instruments on screen */
void pascal vidputninstrs( void );
    /* routine to put global volume on screen */
void pascal vidputglobalvol( signed char gvol );
    /* routine to put EMS enable setting on screen */
void pascal vidputemsen( void );
    /* routine to put save memory setting on screen */
void pascal vidputsavemem( void );
    /* routine to put loading optimization setting on screen */
void pascal vidputloadopt( void );
    /* routine to put a message/prompt on screen */
void pascal vidputmsg( char *msg );
    /* routine to put an error message on screen */
void pascal vidputerrmsg( char *msg );
    /* routine to clear input line on screen */
void pascal vidstartinput( void );
    /* routine to make the cursor a block */
void pascal vidblockcurs( void );
    /* routine to make the cursor an underline */
void pascal vidlinecurs( void );
    /* routine to get a character from the BIOS */
unsigned pascal vidgetchar( void );
    /* nonblocking routine to get a character */
unsigned pascal vidgetnchar( void );
    /* routine to check for a particular character */
unsigned pascal vidpollchar( unsigned pollchar );
    /* routine to flush the keyboard buffer */
void pascal vidflushkey( void );
    /* routine to hide input line on screen */
void pascal videndinput( void );
    /* routine to move the cursor */
void pascal vidmovecurs( int position );
    /* routine to put a string on the input line */
void pascal vidputinput( char *str );
    /* routine to put a message on the input line */
void pascal vidputmsg2( char *str );
    /* routine to put the mod file name on screen */
void pascal vidputfilnam( char *filnam );
    /* routine to redisplay the commands */
void pascal vidputcmds( void );
    /* routine to clear the screen for the file selector */
void pascal vidstartsel( void );
    /* routine to display a directory entry for the file selector */
void pascal vidputdirent( char *name, int type, int row, int column );
    /* routine to highlight a directory entry */
void pascal vidhilight( int row, int column );
    /* routine to unhighlight a directory entry */
void pascal vidunhilight( int row, int column );
    /* routine to send a string out COM2: */
void pascal debugstring( char *str );
    /* routine to get the system time */
unsigned long pascal getsystime( void );

#endif
