; MULTBL1.ASM
;
; This is the first part of the multiplication table for the 8086 version,
; used in the resampler to multiply the sample by the volume.  The 286 can
; multiply fast enough and does not need a precomputed multiplication table
; like this one.
;
; This table is too long to fit into a single 64k-or-less source file, but
; the A86 assembler will assemble a sequence of source files into a single
; object file.
;

;
; Globally-visible stuff.
;
PUBLIC	MULTBL		; multiplication table for 8086

;
; Establish the segment ordering.  Code comes first.  This is the C
; standard segment ordering for Small model.
;
_TEXT	SEGMENT PUBLIC 'CODE'
_TEXT	ENDS

_DATA	SEGMENT PARA PUBLIC 'DATA'
_DATA	ENDS

CONST	SEGMENT WORD PUBLIC 'CONST'
CONST	ENDS

_BSS	SEGMENT WORD PUBLIC 'BSS'
_BSS	ENDS

STACK	SEGMENT PARA STACK 'STACK'
STACK	ENDS

DGROUP	GROUP	_DATA,CONST,_BSS,STACK

_DATA	SEGMENT PARA PUBLIC 'DATA'
		;
		; Multiplication table for 8086.
		;
		EVEN
MULTBL		LABEL	WORD
		; volume 0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		DW	    0,     0,     0,     0,     0,     0,     0,     0
		; volume 1
		DW	    0,     1,     2,     3,     4,     5,     6,     7
		DW	    8,     9,    10,    11,    12,    13,    14,    15
		DW	   16,    17,    18,    19,    20,    21,    22,    23
		DW	   24,    25,    26,    27,    28,    29,    30,    31
		DW	   32,    33,    34,    35,    36,    37,    38,    39
		DW	   40,    41,    42,    43,    44,    45,    46,    47
		DW	   48,    49,    50,    51,    52,    53,    54,    55
		DW	   56,    57,    58,    59,    60,    61,    62,    63
		DW	   64,    65,    66,    67,    68,    69,    70,    71
		DW	   72,    73,    74,    75,    76,    77,    78,    79
		DW	   80,    81,    82,    83,    84,    85,    86,    87
		DW	   88,    89,    90,    91,    92,    93,    94,    95
		DW	   96,    97,    98,    99,   100,   101,   102,   103
		DW	  104,   105,   106,   107,   108,   109,   110,   111
		DW	  112,   113,   114,   115,   116,   117,   118,   119
		DW	  120,   121,   122,   123,   124,   125,   126,   127
		DW	 -128,  -127,  -126,  -125,  -124,  -123,  -122,  -121
		DW	 -120,  -119,  -118,  -117,  -116,  -115,  -114,  -113
		DW	 -112,  -111,  -110,  -109,  -108,  -107,  -106,  -105
		DW	 -104,  -103,  -102,  -101,  -100,   -99,   -98,   -97
		DW	  -96,   -95,   -94,   -93,   -92,   -91,   -90,   -89
		DW	  -88,   -87,   -86,   -85,   -84,   -83,   -82,   -81
		DW	  -80,   -79,   -78,   -77,   -76,   -75,   -74,   -73
		DW	  -72,   -71,   -70,   -69,   -68,   -67,   -66,   -65
		DW	  -64,   -63,   -62,   -61,   -60,   -59,   -58,   -57
		DW	  -56,   -55,   -54,   -53,   -52,   -51,   -50,   -49
		DW	  -48,   -47,   -46,   -45,   -44,   -43,   -42,   -41
		DW	  -40,   -39,   -38,   -37,   -36,   -35,   -34,   -33
		DW	  -32,   -31,   -30,   -29,   -28,   -27,   -26,   -25
		DW	  -24,   -23,   -22,   -21,   -20,   -19,   -18,   -17
		DW	  -16,   -15,   -14,   -13,   -12,   -11,   -10,    -9
		DW	   -8,    -7,    -6,    -5,    -4,    -3,    -2,    -1
		; volume 2
		DW	    0,     2,     4,     6,     8,    10,    12,    14
		DW	   16,    18,    20,    22,    24,    26,    28,    30
		DW	   32,    34,    36,    38,    40,    42,    44,    46
		DW	   48,    50,    52,    54,    56,    58,    60,    62
		DW	   64,    66,    68,    70,    72,    74,    76,    78
		DW	   80,    82,    84,    86,    88,    90,    92,    94
		DW	   96,    98,   100,   102,   104,   106,   108,   110
		DW	  112,   114,   116,   118,   120,   122,   124,   126
		DW	  128,   130,   132,   134,   136,   138,   140,   142
		DW	  144,   146,   148,   150,   152,   154,   156,   158
		DW	  160,   162,   164,   166,   168,   170,   172,   174
		DW	  176,   178,   180,   182,   184,   186,   188,   190
		DW	  192,   194,   196,   198,   200,   202,   204,   206
		DW	  208,   210,   212,   214,   216,   218,   220,   222
		DW	  224,   226,   228,   230,   232,   234,   236,   238
		DW	  240,   242,   244,   246,   248,   250,   252,   254
		DW	 -256,  -254,  -252,  -250,  -248,  -246,  -244,  -242
		DW	 -240,  -238,  -236,  -234,  -232,  -230,  -228,  -226
		DW	 -224,  -222,  -220,  -218,  -216,  -214,  -212,  -210
		DW	 -208,  -206,  -204,  -202,  -200,  -198,  -196,  -194
		DW	 -192,  -190,  -188,  -186,  -184,  -182,  -180,  -178
		DW	 -176,  -174,  -172,  -170,  -168,  -166,  -164,  -162
		DW	 -160,  -158,  -156,  -154,  -152,  -150,  -148,  -146
		DW	 -144,  -142,  -140,  -138,  -136,  -134,  -132,  -130
		DW	 -128,  -126,  -124,  -122,  -120,  -118,  -116,  -114
		DW	 -112,  -110,  -108,  -106,  -104,  -102,  -100,   -98
		DW	  -96,   -94,   -92,   -90,   -88,   -86,   -84,   -82
		DW	  -80,   -78,   -76,   -74,   -72,   -70,   -68,   -66
		DW	  -64,   -62,   -60,   -58,   -56,   -54,   -52,   -50
		DW	  -48,   -46,   -44,   -42,   -40,   -38,   -36,   -34
		DW	  -32,   -30,   -28,   -26,   -24,   -22,   -20,   -18
		DW	  -16,   -14,   -12,   -10,    -8,    -6,    -4,    -2
		; volume 3
		DW	    0,     3,     6,     9,    12,    15,    18,    21
		DW	   24,    27,    30,    33,    36,    39,    42,    45
		DW	   48,    51,    54,    57,    60,    63,    66,    69
		DW	   72,    75,    78,    81,    84,    87,    90,    93
		DW	   96,    99,   102,   105,   108,   111,   114,   117
		DW	  120,   123,   126,   129,   132,   135,   138,   141
		DW	  144,   147,   150,   153,   156,   159,   162,   165
		DW	  168,   171,   174,   177,   180,   183,   186,   189
		DW	  192,   195,   198,   201,   204,   207,   210,   213
		DW	  216,   219,   222,   225,   228,   231,   234,   237
		DW	  240,   243,   246,   249,   252,   255,   258,   261
		DW	  264,   267,   270,   273,   276,   279,   282,   285
		DW	  288,   291,   294,   297,   300,   303,   306,   309
		DW	  312,   315,   318,   321,   324,   327,   330,   333
		DW	  336,   339,   342,   345,   348,   351,   354,   357
		DW	  360,   363,   366,   369,   372,   375,   378,   381
		DW	 -384,  -381,  -378,  -375,  -372,  -369,  -366,  -363
		DW	 -360,  -357,  -354,  -351,  -348,  -345,  -342,  -339
		DW	 -336,  -333,  -330,  -327,  -324,  -321,  -318,  -315
		DW	 -312,  -309,  -306,  -303,  -300,  -297,  -294,  -291
		DW	 -288,  -285,  -282,  -279,  -276,  -273,  -270,  -267
		DW	 -264,  -261,  -258,  -255,  -252,  -249,  -246,  -243
		DW	 -240,  -237,  -234,  -231,  -228,  -225,  -222,  -219
		DW	 -216,  -213,  -210,  -207,  -204,  -201,  -198,  -195
		DW	 -192,  -189,  -186,  -183,  -180,  -177,  -174,  -171
		DW	 -168,  -165,  -162,  -159,  -156,  -153,  -150,  -147
		DW	 -144,  -141,  -138,  -135,  -132,  -129,  -126,  -123
		DW	 -120,  -117,  -114,  -111,  -108,  -105,  -102,   -99
		DW	  -96,   -93,   -90,   -87,   -84,   -81,   -78,   -75
		DW	  -72,   -69,   -66,   -63,   -60,   -57,   -54,   -51
		DW	  -48,   -45,   -42,   -39,   -36,   -33,   -30,   -27
		DW	  -24,   -21,   -18,   -15,   -12,    -9,    -6,    -3
		; volume 4
		DW	    0,     4,     8,    12,    16,    20,    24,    28
		DW	   32,    36,    40,    44,    48,    52,    56,    60
		DW	   64,    68,    72,    76,    80,    84,    88,    92
		DW	   96,   100,   104,   108,   112,   116,   120,   124
		DW	  128,   132,   136,   140,   144,   148,   152,   156
		DW	  160,   164,   168,   172,   176,   180,   184,   188
		DW	  192,   196,   200,   204,   208,   212,   216,   220
		DW	  224,   228,   232,   236,   240,   244,   248,   252
		DW	  256,   260,   264,   268,   272,   276,   280,   284
		DW	  288,   292,   296,   300,   304,   308,   312,   316
		DW	  320,   324,   328,   332,   336,   340,   344,   348
		DW	  352,   356,   360,   364,   368,   372,   376,   380
		DW	  384,   388,   392,   396,   400,   404,   408,   412
		DW	  416,   420,   424,   428,   432,   436,   440,   444
		DW	  448,   452,   456,   460,   464,   468,   472,   476
		DW	  480,   484,   488,   492,   496,   500,   504,   508
		DW	 -512,  -508,  -504,  -500,  -496,  -492,  -488,  -484
		DW	 -480,  -476,  -472,  -468,  -464,  -460,  -456,  -452
		DW	 -448,  -444,  -440,  -436,  -432,  -428,  -424,  -420
		DW	 -416,  -412,  -408,  -404,  -400,  -396,  -392,  -388
		DW	 -384,  -380,  -376,  -372,  -368,  -364,  -360,  -356
		DW	 -352,  -348,  -344,  -340,  -336,  -332,  -328,  -324
		DW	 -320,  -316,  -312,  -308,  -304,  -300,  -296,  -292
		DW	 -288,  -284,  -280,  -276,  -272,  -268,  -264,  -260
		DW	 -256,  -252,  -248,  -244,  -240,  -236,  -232,  -228
		DW	 -224,  -220,  -216,  -212,  -208,  -204,  -200,  -196
		DW	 -192,  -188,  -184,  -180,  -176,  -172,  -168,  -164
		DW	 -160,  -156,  -152,  -148,  -144,  -140,  -136,  -132
		DW	 -128,  -124,  -120,  -116,  -112,  -108,  -104,  -100
		DW	  -96,   -92,   -88,   -84,   -80,   -76,   -72,   -68
		DW	  -64,   -60,   -56,   -52,   -48,   -44,   -40,   -36
		DW	  -32,   -28,   -24,   -20,   -16,   -12,    -8,    -4
		; volume 5
		DW	    0,     5,    10,    15,    20,    25,    30,    35
		DW	   40,    45,    50,    55,    60,    65,    70,    75
		DW	   80,    85,    90,    95,   100,   105,   110,   115
		DW	  120,   125,   130,   135,   140,   145,   150,   155
		DW	  160,   165,   170,   175,   180,   185,   190,   195
		DW	  200,   205,   210,   215,   220,   225,   230,   235
		DW	  240,   245,   250,   255,   260,   265,   270,   275
		DW	  280,   285,   290,   295,   300,   305,   310,   315
		DW	  320,   325,   330,   335,   340,   345,   350,   355
		DW	  360,   365,   370,   375,   380,   385,   390,   395
		DW	  400,   405,   410,   415,   420,   425,   430,   435
		DW	  440,   445,   450,   455,   460,   465,   470,   475
		DW	  480,   485,   490,   495,   500,   505,   510,   515
		DW	  520,   525,   530,   535,   540,   545,   550,   555
		DW	  560,   565,   570,   575,   580,   585,   590,   595
		DW	  600,   605,   610,   615,   620,   625,   630,   635
		DW	 -640,  -635,  -630,  -625,  -620,  -615,  -610,  -605
		DW	 -600,  -595,  -590,  -585,  -580,  -575,  -570,  -565
		DW	 -560,  -555,  -550,  -545,  -540,  -535,  -530,  -525
		DW	 -520,  -515,  -510,  -505,  -500,  -495,  -490,  -485
		DW	 -480,  -475,  -470,  -465,  -460,  -455,  -450,  -445
		DW	 -440,  -435,  -430,  -425,  -420,  -415,  -410,  -405
		DW	 -400,  -395,  -390,  -385,  -380,  -375,  -370,  -365
		DW	 -360,  -355,  -350,  -345,  -340,  -335,  -330,  -325
		DW	 -320,  -315,  -310,  -305,  -300,  -295,  -290,  -285
		DW	 -280,  -275,  -270,  -265,  -260,  -255,  -250,  -245
		DW	 -240,  -235,  -230,  -225,  -220,  -215,  -210,  -205
		DW	 -200,  -195,  -190,  -185,  -180,  -175,  -170,  -165
		DW	 -160,  -155,  -150,  -145,  -140,  -135,  -130,  -125
		DW	 -120,  -115,  -110,  -105,  -100,   -95,   -90,   -85
		DW	  -80,   -75,   -70,   -65,   -60,   -55,   -50,   -45
		DW	  -40,   -35,   -30,   -25,   -20,   -15,   -10,    -5
		; volume 6
		DW	    0,     6,    12,    18,    24,    30,    36,    42
		DW	   48,    54,    60,    66,    72,    78,    84,    90
		DW	   96,   102,   108,   114,   120,   126,   132,   138
		DW	  144,   150,   156,   162,   168,   174,   180,   186
		DW	  192,   198,   204,   210,   216,   222,   228,   234
		DW	  240,   246,   252,   258,   264,   270,   276,   282
		DW	  288,   294,   300,   306,   312,   318,   324,   330
		DW	  336,   342,   348,   354,   360,   366,   372,   378
		DW	  384,   390,   396,   402,   408,   414,   420,   426
		DW	  432,   438,   444,   450,   456,   462,   468,   474
		DW	  480,   486,   492,   498,   504,   510,   516,   522
		DW	  528,   534,   540,   546,   552,   558,   564,   570
		DW	  576,   582,   588,   594,   600,   606,   612,   618
		DW	  624,   630,   636,   642,   648,   654,   660,   666
		DW	  672,   678,   684,   690,   696,   702,   708,   714
		DW	  720,   726,   732,   738,   744,   750,   756,   762
		DW	 -768,  -762,  -756,  -750,  -744,  -738,  -732,  -726
		DW	 -720,  -714,  -708,  -702,  -696,  -690,  -684,  -678
		DW	 -672,  -666,  -660,  -654,  -648,  -642,  -636,  -630
		DW	 -624,  -618,  -612,  -606,  -600,  -594,  -588,  -582
		DW	 -576,  -570,  -564,  -558,  -552,  -546,  -540,  -534
		DW	 -528,  -522,  -516,  -510,  -504,  -498,  -492,  -486
		DW	 -480,  -474,  -468,  -462,  -456,  -450,  -444,  -438
		DW	 -432,  -426,  -420,  -414,  -408,  -402,  -396,  -390
		DW	 -384,  -378,  -372,  -366,  -360,  -354,  -348,  -342
		DW	 -336,  -330,  -324,  -318,  -312,  -306,  -300,  -294
		DW	 -288,  -282,  -276,  -270,  -264,  -258,  -252,  -246
		DW	 -240,  -234,  -228,  -222,  -216,  -210,  -204,  -198
		DW	 -192,  -186,  -180,  -174,  -168,  -162,  -156,  -150
		DW	 -144,  -138,  -132,  -126,  -120,  -114,  -108,  -102
		DW	  -96,   -90,   -84,   -78,   -72,   -66,   -60,   -54
		DW	  -48,   -42,   -36,   -30,   -24,   -18,   -12,    -6
		; volume 7
		DW	    0,     7,    14,    21,    28,    35,    42,    49
		DW	   56,    63,    70,    77,    84,    91,    98,   105
		DW	  112,   119,   126,   133,   140,   147,   154,   161
		DW	  168,   175,   182,   189,   196,   203,   210,   217
		DW	  224,   231,   238,   245,   252,   259,   266,   273
		DW	  280,   287,   294,   301,   308,   315,   322,   329
		DW	  336,   343,   350,   357,   364,   371,   378,   385
		DW	  392,   399,   406,   413,   420,   427,   434,   441
		DW	  448,   455,   462,   469,   476,   483,   490,   497
		DW	  504,   511,   518,   525,   532,   539,   546,   553
		DW	  560,   567,   574,   581,   588,   595,   602,   609
		DW	  616,   623,   630,   637,   644,   651,   658,   665
		DW	  672,   679,   686,   693,   700,   707,   714,   721
		DW	  728,   735,   742,   749,   756,   763,   770,   777
		DW	  784,   791,   798,   805,   812,   819,   826,   833
		DW	  840,   847,   854,   861,   868,   875,   882,   889
		DW	 -896,  -889,  -882,  -875,  -868,  -861,  -854,  -847
		DW	 -840,  -833,  -826,  -819,  -812,  -805,  -798,  -791
		DW	 -784,  -777,  -770,  -763,  -756,  -749,  -742,  -735
		DW	 -728,  -721,  -714,  -707,  -700,  -693,  -686,  -679
		DW	 -672,  -665,  -658,  -651,  -644,  -637,  -630,  -623
		DW	 -616,  -609,  -602,  -595,  -588,  -581,  -574,  -567
		DW	 -560,  -553,  -546,  -539,  -532,  -525,  -518,  -511
		DW	 -504,  -497,  -490,  -483,  -476,  -469,  -462,  -455
		DW	 -448,  -441,  -434,  -427,  -420,  -413,  -406,  -399
		DW	 -392,  -385,  -378,  -371,  -364,  -357,  -350,  -343
		DW	 -336,  -329,  -322,  -315,  -308,  -301,  -294,  -287
		DW	 -280,  -273,  -266,  -259,  -252,  -245,  -238,  -231
		DW	 -224,  -217,  -210,  -203,  -196,  -189,  -182,  -175
		DW	 -168,  -161,  -154,  -147,  -140,  -133,  -126,  -119
		DW	 -112,  -105,   -98,   -91,   -84,   -77,   -70,   -63
		DW	  -56,   -49,   -42,   -35,   -28,   -21,   -14,    -7
		; volume 8
		DW	    0,     8,    16,    24,    32,    40,    48,    56
		DW	   64,    72,    80,    88,    96,   104,   112,   120
		DW	  128,   136,   144,   152,   160,   168,   176,   184
		DW	  192,   200,   208,   216,   224,   232,   240,   248
		DW	  256,   264,   272,   280,   288,   296,   304,   312
		DW	  320,   328,   336,   344,   352,   360,   368,   376
		DW	  384,   392,   400,   408,   416,   424,   432,   440
		DW	  448,   456,   464,   472,   480,   488,   496,   504
		DW	  512,   520,   528,   536,   544,   552,   560,   568
		DW	  576,   584,   592,   600,   608,   616,   624,   632
		DW	  640,   648,   656,   664,   672,   680,   688,   696
		DW	  704,   712,   720,   728,   736,   744,   752,   760
		DW	  768,   776,   784,   792,   800,   808,   816,   824
		DW	  832,   840,   848,   856,   864,   872,   880,   888
		DW	  896,   904,   912,   920,   928,   936,   944,   952
		DW	  960,   968,   976,   984,   992,  1000,  1008,  1016
		DW	-1024, -1016, -1008, -1000,  -992,  -984,  -976,  -968
		DW	 -960,  -952,  -944,  -936,  -928,  -920,  -912,  -904
		DW	 -896,  -888,  -880,  -872,  -864,  -856,  -848,  -840
		DW	 -832,  -824,  -816,  -808,  -800,  -792,  -784,  -776
		DW	 -768,  -760,  -752,  -744,  -736,  -728,  -720,  -712
		DW	 -704,  -696,  -688,  -680,  -672,  -664,  -656,  -648
		DW	 -640,  -632,  -624,  -616,  -608,  -600,  -592,  -584
		DW	 -576,  -568,  -560,  -552,  -544,  -536,  -528,  -520
		DW	 -512,  -504,  -496,  -488,  -480,  -472,  -464,  -456
		DW	 -448,  -440,  -432,  -424,  -416,  -408,  -400,  -392
		DW	 -384,  -376,  -368,  -360,  -352,  -344,  -336,  -328
		DW	 -320,  -312,  -304,  -296,  -288,  -280,  -272,  -264
		DW	 -256,  -248,  -240,  -232,  -224,  -216,  -208,  -200
		DW	 -192,  -184,  -176,  -168,  -160,  -152,  -144,  -136
		DW	 -128,  -120,  -112,  -104,   -96,   -88,   -80,   -72
		DW	  -64,   -56,   -48,   -40,   -32,   -24,   -16,    -8
		; volume 9
		DW	    0,     9,    18,    27,    36,    45,    54,    63
		DW	   72,    81,    90,    99,   108,   117,   126,   135
		DW	  144,   153,   162,   171,   180,   189,   198,   207
		DW	  216,   225,   234,   243,   252,   261,   270,   279
		DW	  288,   297,   306,   315,   324,   333,   342,   351
		DW	  360,   369,   378,   387,   396,   405,   414,   423
		DW	  432,   441,   450,   459,   468,   477,   486,   495
		DW	  504,   513,   522,   531,   540,   549,   558,   567
		DW	  576,   585,   594,   603,   612,   621,   630,   639
		DW	  648,   657,   666,   675,   684,   693,   702,   711
		DW	  720,   729,   738,   747,   756,   765,   774,   783
		DW	  792,   801,   810,   819,   828,   837,   846,   855
		DW	  864,   873,   882,   891,   900,   909,   918,   927
		DW	  936,   945,   954,   963,   972,   981,   990,   999
		DW	 1008,  1017,  1026,  1035,  1044,  1053,  1062,  1071
		DW	 1080,  1089,  1098,  1107,  1116,  1125,  1134,  1143
		DW	-1152, -1143, -1134, -1125, -1116, -1107, -1098, -1089
		DW	-1080, -1071, -1062, -1053, -1044, -1035, -1026, -1017
		DW	-1008,  -999,  -990,  -981,  -972,  -963,  -954,  -945
		DW	 -936,  -927,  -918,  -909,  -900,  -891,  -882,  -873
		DW	 -864,  -855,  -846,  -837,  -828,  -819,  -810,  -801
		DW	 -792,  -783,  -774,  -765,  -756,  -747,  -738,  -729
		DW	 -720,  -711,  -702,  -693,  -684,  -675,  -666,  -657
		DW	 -648,  -639,  -630,  -621,  -612,  -603,  -594,  -585
		DW	 -576,  -567,  -558,  -549,  -540,  -531,  -522,  -513
		DW	 -504,  -495,  -486,  -477,  -468,  -459,  -450,  -441
		DW	 -432,  -423,  -414,  -405,  -396,  -387,  -378,  -369
		DW	 -360,  -351,  -342,  -333,  -324,  -315,  -306,  -297
		DW	 -288,  -279,  -270,  -261,  -252,  -243,  -234,  -225
		DW	 -216,  -207,  -198,  -189,  -180,  -171,  -162,  -153
		DW	 -144,  -135,  -126,  -117,  -108,   -99,   -90,   -81
		DW	  -72,   -63,   -54,   -45,   -36,   -27,   -18,    -9
		; volume 10
		DW	    0,    10,    20,    30,    40,    50,    60,    70
		DW	   80,    90,   100,   110,   120,   130,   140,   150
		DW	  160,   170,   180,   190,   200,   210,   220,   230
		DW	  240,   250,   260,   270,   280,   290,   300,   310
		DW	  320,   330,   340,   350,   360,   370,   380,   390
		DW	  400,   410,   420,   430,   440,   450,   460,   470
		DW	  480,   490,   500,   510,   520,   530,   540,   550
		DW	  560,   570,   580,   590,   600,   610,   620,   630
		DW	  640,   650,   660,   670,   680,   690,   700,   710
		DW	  720,   730,   740,   750,   760,   770,   780,   790
		DW	  800,   810,   820,   830,   840,   850,   860,   870
		DW	  880,   890,   900,   910,   920,   930,   940,   950
		DW	  960,   970,   980,   990,  1000,  1010,  1020,  1030
		DW	 1040,  1050,  1060,  1070,  1080,  1090,  1100,  1110
		DW	 1120,  1130,  1140,  1150,  1160,  1170,  1180,  1190
		DW	 1200,  1210,  1220,  1230,  1240,  1250,  1260,  1270
		DW	-1280, -1270, -1260, -1250, -1240, -1230, -1220, -1210
		DW	-1200, -1190, -1180, -1170, -1160, -1150, -1140, -1130
		DW	-1120, -1110, -1100, -1090, -1080, -1070, -1060, -1050
		DW	-1040, -1030, -1020, -1010, -1000,  -990,  -980,  -970
		DW	 -960,  -950,  -940,  -930,  -920,  -910,  -900,  -890
		DW	 -880,  -870,  -860,  -850,  -840,  -830,  -820,  -810
		DW	 -800,  -790,  -780,  -770,  -760,  -750,  -740,  -730
		DW	 -720,  -710,  -700,  -690,  -680,  -670,  -660,  -650
		DW	 -640,  -630,  -620,  -610,  -600,  -590,  -580,  -570
		DW	 -560,  -550,  -540,  -530,  -520,  -510,  -500,  -490
		DW	 -480,  -470,  -460,  -450,  -440,  -430,  -420,  -410
		DW	 -400,  -390,  -380,  -370,  -360,  -350,  -340,  -330
		DW	 -320,  -310,  -300,  -290,  -280,  -270,  -260,  -250
		DW	 -240,  -230,  -220,  -210,  -200,  -190,  -180,  -170
		DW	 -160,  -150,  -140,  -130,  -120,  -110,  -100,   -90
		DW	  -80,   -70,   -60,   -50,   -40,   -30,   -20,   -10
		; volume 11
		DW	    0,    11,    22,    33,    44,    55,    66,    77
		DW	   88,    99,   110,   121,   132,   143,   154,   165
		DW	  176,   187,   198,   209,   220,   231,   242,   253
		DW	  264,   275,   286,   297,   308,   319,   330,   341
		DW	  352,   363,   374,   385,   396,   407,   418,   429
		DW	  440,   451,   462,   473,   484,   495,   506,   517
		DW	  528,   539,   550,   561,   572,   583,   594,   605
		DW	  616,   627,   638,   649,   660,   671,   682,   693
		DW	  704,   715,   726,   737,   748,   759,   770,   781
		DW	  792,   803,   814,   825,   836,   847,   858,   869
		DW	  880,   891,   902,   913,   924,   935,   946,   957
		DW	  968,   979,   990,  1001,  1012,  1023,  1034,  1045
		DW	 1056,  1067,  1078,  1089,  1100,  1111,  1122,  1133
		DW	 1144,  1155,  1166,  1177,  1188,  1199,  1210,  1221
		DW	 1232,  1243,  1254,  1265,  1276,  1287,  1298,  1309
		DW	 1320,  1331,  1342,  1353,  1364,  1375,  1386,  1397
		DW	-1408, -1397, -1386, -1375, -1364, -1353, -1342, -1331
		DW	-1320, -1309, -1298, -1287, -1276, -1265, -1254, -1243
		DW	-1232, -1221, -1210, -1199, -1188, -1177, -1166, -1155
		DW	-1144, -1133, -1122, -1111, -1100, -1089, -1078, -1067
		DW	-1056, -1045, -1034, -1023, -1012, -1001,  -990,  -979
		DW	 -968,  -957,  -946,  -935,  -924,  -913,  -902,  -891
		DW	 -880,  -869,  -858,  -847,  -836,  -825,  -814,  -803
		DW	 -792,  -781,  -770,  -759,  -748,  -737,  -726,  -715
		DW	 -704,  -693,  -682,  -671,  -660,  -649,  -638,  -627
		DW	 -616,  -605,  -594,  -583,  -572,  -561,  -550,  -539
		DW	 -528,  -517,  -506,  -495,  -484,  -473,  -462,  -451
		DW	 -440,  -429,  -418,  -407,  -396,  -385,  -374,  -363
		DW	 -352,  -341,  -330,  -319,  -308,  -297,  -286,  -275
		DW	 -264,  -253,  -242,  -231,  -220,  -209,  -198,  -187
		DW	 -176,  -165,  -154,  -143,  -132,  -121,  -110,   -99
		DW	  -88,   -77,   -66,   -55,   -44,   -33,   -22,   -11
		; volume 12
		DW	    0,    12,    24,    36,    48,    60,    72,    84
		DW	   96,   108,   120,   132,   144,   156,   168,   180
		DW	  192,   204,   216,   228,   240,   252,   264,   276
		DW	  288,   300,   312,   324,   336,   348,   360,   372
		DW	  384,   396,   408,   420,   432,   444,   456,   468
		DW	  480,   492,   504,   516,   528,   540,   552,   564
		DW	  576,   588,   600,   612,   624,   636,   648,   660
		DW	  672,   684,   696,   708,   720,   732,   744,   756
		DW	  768,   780,   792,   804,   816,   828,   840,   852
		DW	  864,   876,   888,   900,   912,   924,   936,   948
		DW	  960,   972,   984,   996,  1008,  1020,  1032,  1044
		DW	 1056,  1068,  1080,  1092,  1104,  1116,  1128,  1140
		DW	 1152,  1164,  1176,  1188,  1200,  1212,  1224,  1236
		DW	 1248,  1260,  1272,  1284,  1296,  1308,  1320,  1332
		DW	 1344,  1356,  1368,  1380,  1392,  1404,  1416,  1428
		DW	 1440,  1452,  1464,  1476,  1488,  1500,  1512,  1524
		DW	-1536, -1524, -1512, -1500, -1488, -1476, -1464, -1452
		DW	-1440, -1428, -1416, -1404, -1392, -1380, -1368, -1356
		DW	-1344, -1332, -1320, -1308, -1296, -1284, -1272, -1260
		DW	-1248, -1236, -1224, -1212, -1200, -1188, -1176, -1164
		DW	-1152, -1140, -1128, -1116, -1104, -1092, -1080, -1068
		DW	-1056, -1044, -1032, -1020, -1008,  -996,  -984,  -972
		DW	 -960,  -948,  -936,  -924,  -912,  -900,  -888,  -876
		DW	 -864,  -852,  -840,  -828,  -816,  -804,  -792,  -780
		DW	 -768,  -756,  -744,  -732,  -720,  -708,  -696,  -684
		DW	 -672,  -660,  -648,  -636,  -624,  -612,  -600,  -588
		DW	 -576,  -564,  -552,  -540,  -528,  -516,  -504,  -492
		DW	 -480,  -468,  -456,  -444,  -432,  -420,  -408,  -396
		DW	 -384,  -372,  -360,  -348,  -336,  -324,  -312,  -300
		DW	 -288,  -276,  -264,  -252,  -240,  -228,  -216,  -204
		DW	 -192,  -180,  -168,  -156,  -144,  -132,  -120,  -108
		DW	  -96,   -84,   -72,   -60,   -48,   -36,   -24,   -12
		; volume 13
		DW	    0,    13,    26,    39,    52,    65,    78,    91
		DW	  104,   117,   130,   143,   156,   169,   182,   195
		DW	  208,   221,   234,   247,   260,   273,   286,   299
		DW	  312,   325,   338,   351,   364,   377,   390,   403
		DW	  416,   429,   442,   455,   468,   481,   494,   507
		DW	  520,   533,   546,   559,   572,   585,   598,   611
		DW	  624,   637,   650,   663,   676,   689,   702,   715
		DW	  728,   741,   754,   767,   780,   793,   806,   819
		DW	  832,   845,   858,   871,   884,   897,   910,   923
		DW	  936,   949,   962,   975,   988,  1001,  1014,  1027
		DW	 1040,  1053,  1066,  1079,  1092,  1105,  1118,  1131
		DW	 1144,  1157,  1170,  1183,  1196,  1209,  1222,  1235
		DW	 1248,  1261,  1274,  1287,  1300,  1313,  1326,  1339
		DW	 1352,  1365,  1378,  1391,  1404,  1417,  1430,  1443
		DW	 1456,  1469,  1482,  1495,  1508,  1521,  1534,  1547
		DW	 1560,  1573,  1586,  1599,  1612,  1625,  1638,  1651
		DW	-1664, -1651, -1638, -1625, -1612, -1599, -1586, -1573
		DW	-1560, -1547, -1534, -1521, -1508, -1495, -1482, -1469
		DW	-1456, -1443, -1430, -1417, -1404, -1391, -1378, -1365
		DW	-1352, -1339, -1326, -1313, -1300, -1287, -1274, -1261
		DW	-1248, -1235, -1222, -1209, -1196, -1183, -1170, -1157
		DW	-1144, -1131, -1118, -1105, -1092, -1079, -1066, -1053
		DW	-1040, -1027, -1014, -1001,  -988,  -975,  -962,  -949
		DW	 -936,  -923,  -910,  -897,  -884,  -871,  -858,  -845
		DW	 -832,  -819,  -806,  -793,  -780,  -767,  -754,  -741
		DW	 -728,  -715,  -702,  -689,  -676,  -663,  -650,  -637
		DW	 -624,  -611,  -598,  -585,  -572,  -559,  -546,  -533
		DW	 -520,  -507,  -494,  -481,  -468,  -455,  -442,  -429
		DW	 -416,  -403,  -390,  -377,  -364,  -351,  -338,  -325
		DW	 -312,  -299,  -286,  -273,  -260,  -247,  -234,  -221
		DW	 -208,  -195,  -182,  -169,  -156,  -143,  -130,  -117
		DW	 -104,   -91,   -78,   -65,   -52,   -39,   -26,   -13
		; volume 14
		DW	    0,    14,    28,    42,    56,    70,    84,    98
		DW	  112,   126,   140,   154,   168,   182,   196,   210
		DW	  224,   238,   252,   266,   280,   294,   308,   322
		DW	  336,   350,   364,   378,   392,   406,   420,   434
		DW	  448,   462,   476,   490,   504,   518,   532,   546
		DW	  560,   574,   588,   602,   616,   630,   644,   658
		DW	  672,   686,   700,   714,   728,   742,   756,   770
		DW	  784,   798,   812,   826,   840,   854,   868,   882
		DW	  896,   910,   924,   938,   952,   966,   980,   994
		DW	 1008,  1022,  1036,  1050,  1064,  1078,  1092,  1106
		DW	 1120,  1134,  1148,  1162,  1176,  1190,  1204,  1218
		DW	 1232,  1246,  1260,  1274,  1288,  1302,  1316,  1330
		DW	 1344,  1358,  1372,  1386,  1400,  1414,  1428,  1442
		DW	 1456,  1470,  1484,  1498,  1512,  1526,  1540,  1554
		DW	 1568,  1582,  1596,  1610,  1624,  1638,  1652,  1666
		DW	 1680,  1694,  1708,  1722,  1736,  1750,  1764,  1778
		DW	-1792, -1778, -1764, -1750, -1736, -1722, -1708, -1694
		DW	-1680, -1666, -1652, -1638, -1624, -1610, -1596, -1582
		DW	-1568, -1554, -1540, -1526, -1512, -1498, -1484, -1470
		DW	-1456, -1442, -1428, -1414, -1400, -1386, -1372, -1358
		DW	-1344, -1330, -1316, -1302, -1288, -1274, -1260, -1246
		DW	-1232, -1218, -1204, -1190, -1176, -1162, -1148, -1134
		DW	-1120, -1106, -1092, -1078, -1064, -1050, -1036, -1022
		DW	-1008,  -994,  -980,  -966,  -952,  -938,  -924,  -910
		DW	 -896,  -882,  -868,  -854,  -840,  -826,  -812,  -798
		DW	 -784,  -770,  -756,  -742,  -728,  -714,  -700,  -686
		DW	 -672,  -658,  -644,  -630,  -616,  -602,  -588,  -574
		DW	 -560,  -546,  -532,  -518,  -504,  -490,  -476,  -462
		DW	 -448,  -434,  -420,  -406,  -392,  -378,  -364,  -350
		DW	 -336,  -322,  -308,  -294,  -280,  -266,  -252,  -238
		DW	 -224,  -210,  -196,  -182,  -168,  -154,  -140,  -126
		DW	 -112,   -98,   -84,   -70,   -56,   -42,   -28,   -14
		; volume 15
		DW	    0,    15,    30,    45,    60,    75,    90,   105
		DW	  120,   135,   150,   165,   180,   195,   210,   225
		DW	  240,   255,   270,   285,   300,   315,   330,   345
		DW	  360,   375,   390,   405,   420,   435,   450,   465
		DW	  480,   495,   510,   525,   540,   555,   570,   585
		DW	  600,   615,   630,   645,   660,   675,   690,   705
		DW	  720,   735,   750,   765,   780,   795,   810,   825
		DW	  840,   855,   870,   885,   900,   915,   930,   945
		DW	  960,   975,   990,  1005,  1020,  1035,  1050,  1065
		DW	 1080,  1095,  1110,  1125,  1140,  1155,  1170,  1185
		DW	 1200,  1215,  1230,  1245,  1260,  1275,  1290,  1305
		DW	 1320,  1335,  1350,  1365,  1380,  1395,  1410,  1425
		DW	 1440,  1455,  1470,  1485,  1500,  1515,  1530,  1545
		DW	 1560,  1575,  1590,  1605,  1620,  1635,  1650,  1665
		DW	 1680,  1695,  1710,  1725,  1740,  1755,  1770,  1785
		DW	 1800,  1815,  1830,  1845,  1860,  1875,  1890,  1905
		DW	-1920, -1905, -1890, -1875, -1860, -1845, -1830, -1815
		DW	-1800, -1785, -1770, -1755, -1740, -1725, -1710, -1695
		DW	-1680, -1665, -1650, -1635, -1620, -1605, -1590, -1575
		DW	-1560, -1545, -1530, -1515, -1500, -1485, -1470, -1455
		DW	-1440, -1425, -1410, -1395, -1380, -1365, -1350, -1335
		DW	-1320, -1305, -1290, -1275, -1260, -1245, -1230, -1215
		DW	-1200, -1185, -1170, -1155, -1140, -1125, -1110, -1095
		DW	-1080, -1065, -1050, -1035, -1020, -1005,  -990,  -975
		DW	 -960,  -945,  -930,  -915,  -900,  -885,  -870,  -855
		DW	 -840,  -825,  -810,  -795,  -780,  -765,  -750,  -735
		DW	 -720,  -705,  -690,  -675,  -660,  -645,  -630,  -615
		DW	 -600,  -585,  -570,  -555,  -540,  -525,  -510,  -495
		DW	 -480,  -465,  -450,  -435,  -420,  -405,  -390,  -375
		DW	 -360,  -345,  -330,  -315,  -300,  -285,  -270,  -255
		DW	 -240,  -225,  -210,  -195,  -180,  -165,  -150,  -135
		DW	 -120,  -105,   -90,   -75,   -60,   -45,   -30,   -15
		; volume 16
		DW	    0,    16,    32,    48,    64,    80,    96,   112
		DW	  128,   144,   160,   176,   192,   208,   224,   240
		DW	  256,   272,   288,   304,   320,   336,   352,   368
		DW	  384,   400,   416,   432,   448,   464,   480,   496
		DW	  512,   528,   544,   560,   576,   592,   608,   624
		DW	  640,   656,   672,   688,   704,   720,   736,   752
		DW	  768,   784,   800,   816,   832,   848,   864,   880
		DW	  896,   912,   928,   944,   960,   976,   992,  1008
		DW	 1024,  1040,  1056,  1072,  1088,  1104,  1120,  1136
		DW	 1152,  1168,  1184,  1200,  1216,  1232,  1248,  1264
		DW	 1280,  1296,  1312,  1328,  1344,  1360,  1376,  1392
		DW	 1408,  1424,  1440,  1456,  1472,  1488,  1504,  1520
		DW	 1536,  1552,  1568,  1584,  1600,  1616,  1632,  1648
		DW	 1664,  1680,  1696,  1712,  1728,  1744,  1760,  1776
		DW	 1792,  1808,  1824,  1840,  1856,  1872,  1888,  1904
		DW	 1920,  1936,  1952,  1968,  1984,  2000,  2016,  2032
		DW	-2048, -2032, -2016, -2000, -1984, -1968, -1952, -1936
		DW	-1920, -1904, -1888, -1872, -1856, -1840, -1824, -1808
		DW	-1792, -1776, -1760, -1744, -1728, -1712, -1696, -1680
		DW	-1664, -1648, -1632, -1616, -1600, -1584, -1568, -1552
		DW	-1536, -1520, -1504, -1488, -1472, -1456, -1440, -1424
		DW	-1408, -1392, -1376, -1360, -1344, -1328, -1312, -1296
		DW	-1280, -1264, -1248, -1232, -1216, -1200, -1184, -1168
		DW	-1152, -1136, -1120, -1104, -1088, -1072, -1056, -1040
		DW	-1024, -1008,  -992,  -976,  -960,  -944,  -928,  -912
		DW	 -896,  -880,  -864,  -848,  -832,  -816,  -800,  -784
		DW	 -768,  -752,  -736,  -720,  -704,  -688,  -672,  -656
		DW	 -640,  -624,  -608,  -592,  -576,  -560,  -544,  -528
		DW	 -512,  -496,  -480,  -464,  -448,  -432,  -416,  -400
		DW	 -384,  -368,  -352,  -336,  -320,  -304,  -288,  -272
		DW	 -256,  -240,  -224,  -208,  -192,  -176,  -160,  -144
		DW	 -128,  -112,   -96,   -80,   -64,   -48,   -32,   -16
		; volume 17
		DW	    0,    17,    34,    51,    68,    85,   102,   119
		DW	  136,   153,   170,   187,   204,   221,   238,   255
		DW	  272,   289,   306,   323,   340,   357,   374,   391
		DW	  408,   425,   442,   459,   476,   493,   510,   527
		DW	  544,   561,   578,   595,   612,   629,   646,   663
		DW	  680,   697,   714,   731,   748,   765,   782,   799
		DW	  816,   833,   850,   867,   884,   901,   918,   935
		DW	  952,   969,   986,  1003,  1020,  1037,  1054,  1071
		DW	 1088,  1105,  1122,  1139,  1156,  1173,  1190,  1207
		DW	 1224,  1241,  1258,  1275,  1292,  1309,  1326,  1343
		DW	 1360,  1377,  1394,  1411,  1428,  1445,  1462,  1479
		DW	 1496,  1513,  1530,  1547,  1564,  1581,  1598,  1615
		DW	 1632,  1649,  1666,  1683,  1700,  1717,  1734,  1751
		DW	 1768,  1785,  1802,  1819,  1836,  1853,  1870,  1887
		DW	 1904,  1921,  1938,  1955,  1972,  1989,  2006,  2023
		DW	 2040,  2057,  2074,  2091,  2108,  2125,  2142,  2159
		DW	-2176, -2159, -2142, -2125, -2108, -2091, -2074, -2057
		DW	-2040, -2023, -2006, -1989, -1972, -1955, -1938, -1921
		DW	-1904, -1887, -1870, -1853, -1836, -1819, -1802, -1785
		DW	-1768, -1751, -1734, -1717, -1700, -1683, -1666, -1649
		DW	-1632, -1615, -1598, -1581, -1564, -1547, -1530, -1513
		DW	-1496, -1479, -1462, -1445, -1428, -1411, -1394, -1377
		DW	-1360, -1343, -1326, -1309, -1292, -1275, -1258, -1241
		DW	-1224, -1207, -1190, -1173, -1156, -1139, -1122, -1105
		DW	-1088, -1071, -1054, -1037, -1020, -1003,  -986,  -969
		DW	 -952,  -935,  -918,  -901,  -884,  -867,  -850,  -833
		DW	 -816,  -799,  -782,  -765,  -748,  -731,  -714,  -697
		DW	 -680,  -663,  -646,  -629,  -612,  -595,  -578,  -561
		DW	 -544,  -527,  -510,  -493,  -476,  -459,  -442,  -425
		DW	 -408,  -391,  -374,  -357,  -340,  -323,  -306,  -289
		DW	 -272,  -255,  -238,  -221,  -204,  -187,  -170,  -153
		DW	 -136,  -119,  -102,   -85,   -68,   -51,   -34,   -17
		; volume 18
		DW	    0,    18,    36,    54,    72,    90,   108,   126
		DW	  144,   162,   180,   198,   216,   234,   252,   270
		DW	  288,   306,   324,   342,   360,   378,   396,   414
		DW	  432,   450,   468,   486,   504,   522,   540,   558
		DW	  576,   594,   612,   630,   648,   666,   684,   702
		DW	  720,   738,   756,   774,   792,   810,   828,   846
		DW	  864,   882,   900,   918,   936,   954,   972,   990
		DW	 1008,  1026,  1044,  1062,  1080,  1098,  1116,  1134
		DW	 1152,  1170,  1188,  1206,  1224,  1242,  1260,  1278
		DW	 1296,  1314,  1332,  1350,  1368,  1386,  1404,  1422
		DW	 1440,  1458,  1476,  1494,  1512,  1530,  1548,  1566
		DW	 1584,  1602,  1620,  1638,  1656,  1674,  1692,  1710
		DW	 1728,  1746,  1764,  1782,  1800,  1818,  1836,  1854
		DW	 1872,  1890,  1908,  1926,  1944,  1962,  1980,  1998
		DW	 2016,  2034,  2052,  2070,  2088,  2106,  2124,  2142
		DW	 2160,  2178,  2196,  2214,  2232,  2250,  2268,  2286
		DW	-2304, -2286, -2268, -2250, -2232, -2214, -2196, -2178
		DW	-2160, -2142, -2124, -2106, -2088, -2070, -2052, -2034
		DW	-2016, -1998, -1980, -1962, -1944, -1926, -1908, -1890
		DW	-1872, -1854, -1836, -1818, -1800, -1782, -1764, -1746
		DW	-1728, -1710, -1692, -1674, -1656, -1638, -1620, -1602
		DW	-1584, -1566, -1548, -1530, -1512, -1494, -1476, -1458
		DW	-1440, -1422, -1404, -1386, -1368, -1350, -1332, -1314
		DW	-1296, -1278, -1260, -1242, -1224, -1206, -1188, -1170
		DW	-1152, -1134, -1116, -1098, -1080, -1062, -1044, -1026
		DW	-1008,  -990,  -972,  -954,  -936,  -918,  -900,  -882
		DW	 -864,  -846,  -828,  -810,  -792,  -774,  -756,  -738
		DW	 -720,  -702,  -684,  -666,  -648,  -630,  -612,  -594
		DW	 -576,  -558,  -540,  -522,  -504,  -486,  -468,  -450
		DW	 -432,  -414,  -396,  -378,  -360,  -342,  -324,  -306
		DW	 -288,  -270,  -252,  -234,  -216,  -198,  -180,  -162
		DW	 -144,  -126,  -108,   -90,   -72,   -54,   -36,   -18
		; volume 19
		DW	    0,    19,    38,    57,    76,    95,   114,   133
		DW	  152,   171,   190,   209,   228,   247,   266,   285
		DW	  304,   323,   342,   361,   380,   399,   418,   437
		DW	  456,   475,   494,   513,   532,   551,   570,   589
		DW	  608,   627,   646,   665,   684,   703,   722,   741
		DW	  760,   779,   798,   817,   836,   855,   874,   893
		DW	  912,   931,   950,   969,   988,  1007,  1026,  1045
		DW	 1064,  1083,  1102,  1121,  1140,  1159,  1178,  1197
		DW	 1216,  1235,  1254,  1273,  1292,  1311,  1330,  1349
		DW	 1368,  1387,  1406,  1425,  1444,  1463,  1482,  1501
		DW	 1520,  1539,  1558,  1577,  1596,  1615,  1634,  1653
		DW	 1672,  1691,  1710,  1729,  1748,  1767,  1786,  1805
		DW	 1824,  1843,  1862,  1881,  1900,  1919,  1938,  1957
		DW	 1976,  1995,  2014,  2033,  2052,  2071,  2090,  2109
		DW	 2128,  2147,  2166,  2185,  2204,  2223,  2242,  2261
		DW	 2280,  2299,  2318,  2337,  2356,  2375,  2394,  2413
		DW	-2432, -2413, -2394, -2375, -2356, -2337, -2318, -2299
		DW	-2280, -2261, -2242, -2223, -2204, -2185, -2166, -2147
		DW	-2128, -2109, -2090, -2071, -2052, -2033, -2014, -1995
		DW	-1976, -1957, -1938, -1919, -1900, -1881, -1862, -1843
		DW	-1824, -1805, -1786, -1767, -1748, -1729, -1710, -1691
		DW	-1672, -1653, -1634, -1615, -1596, -1577, -1558, -1539
		DW	-1520, -1501, -1482, -1463, -1444, -1425, -1406, -1387
		DW	-1368, -1349, -1330, -1311, -1292, -1273, -1254, -1235
		DW	-1216, -1197, -1178, -1159, -1140, -1121, -1102, -1083
		DW	-1064, -1045, -1026, -1007,  -988,  -969,  -950,  -931
		DW	 -912,  -893,  -874,  -855,  -836,  -817,  -798,  -779
		DW	 -760,  -741,  -722,  -703,  -684,  -665,  -646,  -627
		DW	 -608,  -589,  -570,  -551,  -532,  -513,  -494,  -475
		DW	 -456,  -437,  -418,  -399,  -380,  -361,  -342,  -323
		DW	 -304,  -285,  -266,  -247,  -228,  -209,  -190,  -171
		DW	 -152,  -133,  -114,   -95,   -76,   -57,   -38,   -19
		; volume 20
		DW	    0,    20,    40,    60,    80,   100,   120,   140
		DW	  160,   180,   200,   220,   240,   260,   280,   300
		DW	  320,   340,   360,   380,   400,   420,   440,   460
		DW	  480,   500,   520,   540,   560,   580,   600,   620
		DW	  640,   660,   680,   700,   720,   740,   760,   780
		DW	  800,   820,   840,   860,   880,   900,   920,   940
		DW	  960,   980,  1000,  1020,  1040,  1060,  1080,  1100
		DW	 1120,  1140,  1160,  1180,  1200,  1220,  1240,  1260
		DW	 1280,  1300,  1320,  1340,  1360,  1380,  1400,  1420
		DW	 1440,  1460,  1480,  1500,  1520,  1540,  1560,  1580
		DW	 1600,  1620,  1640,  1660,  1680,  1700,  1720,  1740
		DW	 1760,  1780,  1800,  1820,  1840,  1860,  1880,  1900
		DW	 1920,  1940,  1960,  1980,  2000,  2020,  2040,  2060
		DW	 2080,  2100,  2120,  2140,  2160,  2180,  2200,  2220
		DW	 2240,  2260,  2280,  2300,  2320,  2340,  2360,  2380
		DW	 2400,  2420,  2440,  2460,  2480,  2500,  2520,  2540
		DW	-2560, -2540, -2520, -2500, -2480, -2460, -2440, -2420
		DW	-2400, -2380, -2360, -2340, -2320, -2300, -2280, -2260
		DW	-2240, -2220, -2200, -2180, -2160, -2140, -2120, -2100
		DW	-2080, -2060, -2040, -2020, -2000, -1980, -1960, -1940
		DW	-1920, -1900, -1880, -1860, -1840, -1820, -1800, -1780
		DW	-1760, -1740, -1720, -1700, -1680, -1660, -1640, -1620
		DW	-1600, -1580, -1560, -1540, -1520, -1500, -1480, -1460
		DW	-1440, -1420, -1400, -1380, -1360, -1340, -1320, -1300
		DW	-1280, -1260, -1240, -1220, -1200, -1180, -1160, -1140
		DW	-1120, -1100, -1080, -1060, -1040, -1020, -1000,  -980
		DW	 -960,  -940,  -920,  -900,  -880,  -860,  -840,  -820
		DW	 -800,  -780,  -760,  -740,  -720,  -700,  -680,  -660
		DW	 -640,  -620,  -600,  -580,  -560,  -540,  -520,  -500
		DW	 -480,  -460,  -440,  -420,  -400,  -380,  -360,  -340
		DW	 -320,  -300,  -280,  -260,  -240,  -220,  -200,  -180
		DW	 -160,  -140,  -120,  -100,   -80,   -60,   -40,   -20
		; volume 21
		DW	    0,    21,    42,    63,    84,   105,   126,   147
		DW	  168,   189,   210,   231,   252,   273,   294,   315
		DW	  336,   357,   378,   399,   420,   441,   462,   483
		DW	  504,   525,   546,   567,   588,   609,   630,   651
		DW	  672,   693,   714,   735,   756,   777,   798,   819
		DW	  840,   861,   882,   903,   924,   945,   966,   987
		DW	 1008,  1029,  1050,  1071,  1092,  1113,  1134,  1155
		DW	 1176,  1197,  1218,  1239,  1260,  1281,  1302,  1323
		DW	 1344,  1365,  1386,  1407,  1428,  1449,  1470,  1491
		DW	 1512,  1533,  1554,  1575,  1596,  1617,  1638,  1659
		DW	 1680,  1701,  1722,  1743,  1764,  1785,  1806,  1827
		DW	 1848,  1869,  1890,  1911,  1932,  1953,  1974,  1995
		DW	 2016,  2037,  2058,  2079,  2100,  2121,  2142,  2163
		DW	 2184,  2205,  2226,  2247,  2268,  2289,  2310,  2331
		DW	 2352,  2373,  2394,  2415,  2436,  2457,  2478,  2499
		DW	 2520,  2541,  2562,  2583,  2604,  2625,  2646,  2667
		DW	-2688, -2667, -2646, -2625, -2604, -2583, -2562, -2541
		DW	-2520, -2499, -2478, -2457, -2436, -2415, -2394, -2373
		DW	-2352, -2331, -2310, -2289, -2268, -2247, -2226, -2205
		DW	-2184, -2163, -2142, -2121, -2100, -2079, -2058, -2037
		DW	-2016, -1995, -1974, -1953, -1932, -1911, -1890, -1869
		DW	-1848, -1827, -1806, -1785, -1764, -1743, -1722, -1701
		DW	-1680, -1659, -1638, -1617, -1596, -1575, -1554, -1533
		DW	-1512, -1491, -1470, -1449, -1428, -1407, -1386, -1365
		DW	-1344, -1323, -1302, -1281, -1260, -1239, -1218, -1197
		DW	-1176, -1155, -1134, -1113, -1092, -1071, -1050, -1029
		DW	-1008,  -987,  -966,  -945,  -924,  -903,  -882,  -861
		DW	 -840,  -819,  -798,  -777,  -756,  -735,  -714,  -693
		DW	 -672,  -651,  -630,  -609,  -588,  -567,  -546,  -525
		DW	 -504,  -483,  -462,  -441,  -420,  -399,  -378,  -357
		DW	 -336,  -315,  -294,  -273,  -252,  -231,  -210,  -189
		DW	 -168,  -147,  -126,  -105,   -84,   -63,   -42,   -21
		; volume 22
		DW	    0,    22,    44,    66,    88,   110,   132,   154
		DW	  176,   198,   220,   242,   264,   286,   308,   330
		DW	  352,   374,   396,   418,   440,   462,   484,   506
		DW	  528,   550,   572,   594,   616,   638,   660,   682
		DW	  704,   726,   748,   770,   792,   814,   836,   858
		DW	  880,   902,   924,   946,   968,   990,  1012,  1034
		DW	 1056,  1078,  1100,  1122,  1144,  1166,  1188,  1210
		DW	 1232,  1254,  1276,  1298,  1320,  1342,  1364,  1386
		DW	 1408,  1430,  1452,  1474,  1496,  1518,  1540,  1562
		DW	 1584,  1606,  1628,  1650,  1672,  1694,  1716,  1738
		DW	 1760,  1782,  1804,  1826,  1848,  1870,  1892,  1914
		DW	 1936,  1958,  1980,  2002,  2024,  2046,  2068,  2090
		DW	 2112,  2134,  2156,  2178,  2200,  2222,  2244,  2266
		DW	 2288,  2310,  2332,  2354,  2376,  2398,  2420,  2442
		DW	 2464,  2486,  2508,  2530,  2552,  2574,  2596,  2618
		DW	 2640,  2662,  2684,  2706,  2728,  2750,  2772,  2794
		DW	-2816, -2794, -2772, -2750, -2728, -2706, -2684, -2662
		DW	-2640, -2618, -2596, -2574, -2552, -2530, -2508, -2486
		DW	-2464, -2442, -2420, -2398, -2376, -2354, -2332, -2310
		DW	-2288, -2266, -2244, -2222, -2200, -2178, -2156, -2134
		DW	-2112, -2090, -2068, -2046, -2024, -2002, -1980, -1958
		DW	-1936, -1914, -1892, -1870, -1848, -1826, -1804, -1782
		DW	-1760, -1738, -1716, -1694, -1672, -1650, -1628, -1606
		DW	-1584, -1562, -1540, -1518, -1496, -1474, -1452, -1430
		DW	-1408, -1386, -1364, -1342, -1320, -1298, -1276, -1254
		DW	-1232, -1210, -1188, -1166, -1144, -1122, -1100, -1078
		DW	-1056, -1034, -1012,  -990,  -968,  -946,  -924,  -902
		DW	 -880,  -858,  -836,  -814,  -792,  -770,  -748,  -726
		DW	 -704,  -682,  -660,  -638,  -616,  -594,  -572,  -550
		DW	 -528,  -506,  -484,  -462,  -440,  -418,  -396,  -374
		DW	 -352,  -330,  -308,  -286,  -264,  -242,  -220,  -198
		DW	 -176,  -154,  -132,  -110,   -88,   -66,   -44,   -22
		; volume 23
		DW	    0,    23,    46,    69,    92,   115,   138,   161
		DW	  184,   207,   230,   253,   276,   299,   322,   345
		DW	  368,   391,   414,   437,   460,   483,   506,   529
		DW	  552,   575,   598,   621,   644,   667,   690,   713
		DW	  736,   759,   782,   805,   828,   851,   874,   897
		DW	  920,   943,   966,   989,  1012,  1035,  1058,  1081
		DW	 1104,  1127,  1150,  1173,  1196,  1219,  1242,  1265
		DW	 1288,  1311,  1334,  1357,  1380,  1403,  1426,  1449
		DW	 1472,  1495,  1518,  1541,  1564,  1587,  1610,  1633
		DW	 1656,  1679,  1702,  1725,  1748,  1771,  1794,  1817
		DW	 1840,  1863,  1886,  1909,  1932,  1955,  1978,  2001
		DW	 2024,  2047,  2070,  2093,  2116,  2139,  2162,  2185
		DW	 2208,  2231,  2254,  2277,  2300,  2323,  2346,  2369
		DW	 2392,  2415,  2438,  2461,  2484,  2507,  2530,  2553
		DW	 2576,  2599,  2622,  2645,  2668,  2691,  2714,  2737
		DW	 2760,  2783,  2806,  2829,  2852,  2875,  2898,  2921
		DW	-2944, -2921, -2898, -2875, -2852, -2829, -2806, -2783
		DW	-2760, -2737, -2714, -2691, -2668, -2645, -2622, -2599
		DW	-2576, -2553, -2530, -2507, -2484, -2461, -2438, -2415
		DW	-2392, -2369, -2346, -2323, -2300, -2277, -2254, -2231
		DW	-2208, -2185, -2162, -2139, -2116, -2093, -2070, -2047
		DW	-2024, -2001, -1978, -1955, -1932, -1909, -1886, -1863
		DW	-1840, -1817, -1794, -1771, -1748, -1725, -1702, -1679
		DW	-1656, -1633, -1610, -1587, -1564, -1541, -1518, -1495
		DW	-1472, -1449, -1426, -1403, -1380, -1357, -1334, -1311
		DW	-1288, -1265, -1242, -1219, -1196, -1173, -1150, -1127
		DW	-1104, -1081, -1058, -1035, -1012,  -989,  -966,  -943
		DW	 -920,  -897,  -874,  -851,  -828,  -805,  -782,  -759
		DW	 -736,  -713,  -690,  -667,  -644,  -621,  -598,  -575
		DW	 -552,  -529,  -506,  -483,  -460,  -437,  -414,  -391
		DW	 -368,  -345,  -322,  -299,  -276,  -253,  -230,  -207
		DW	 -184,  -161,  -138,  -115,   -92,   -69,   -46,   -23
		; volume 24
		DW	    0,    24,    48,    72,    96,   120,   144,   168
		DW	  192,   216,   240,   264,   288,   312,   336,   360
		DW	  384,   408,   432,   456,   480,   504,   528,   552
		DW	  576,   600,   624,   648,   672,   696,   720,   744
		DW	  768,   792,   816,   840,   864,   888,   912,   936
		DW	  960,   984,  1008,  1032,  1056,  1080,  1104,  1128
		DW	 1152,  1176,  1200,  1224,  1248,  1272,  1296,  1320
		DW	 1344,  1368,  1392,  1416,  1440,  1464,  1488,  1512
		DW	 1536,  1560,  1584,  1608,  1632,  1656,  1680,  1704
		DW	 1728,  1752,  1776,  1800,  1824,  1848,  1872,  1896
		DW	 1920,  1944,  1968,  1992,  2016,  2040,  2064,  2088
		DW	 2112,  2136,  2160,  2184,  2208,  2232,  2256,  2280
		DW	 2304,  2328,  2352,  2376,  2400,  2424,  2448,  2472
		DW	 2496,  2520,  2544,  2568,  2592,  2616,  2640,  2664
		DW	 2688,  2712,  2736,  2760,  2784,  2808,  2832,  2856
		DW	 2880,  2904,  2928,  2952,  2976,  3000,  3024,  3048
		DW	-3072, -3048, -3024, -3000, -2976, -2952, -2928, -2904
		DW	-2880, -2856, -2832, -2808, -2784, -2760, -2736, -2712
		DW	-2688, -2664, -2640, -2616, -2592, -2568, -2544, -2520
		DW	-2496, -2472, -2448, -2424, -2400, -2376, -2352, -2328
		DW	-2304, -2280, -2256, -2232, -2208, -2184, -2160, -2136
		DW	-2112, -2088, -2064, -2040, -2016, -1992, -1968, -1944
		DW	-1920, -1896, -1872, -1848, -1824, -1800, -1776, -1752
		DW	-1728, -1704, -1680, -1656, -1632, -1608, -1584, -1560
		DW	-1536, -1512, -1488, -1464, -1440, -1416, -1392, -1368
		DW	-1344, -1320, -1296, -1272, -1248, -1224, -1200, -1176
		DW	-1152, -1128, -1104, -1080, -1056, -1032, -1008,  -984
		DW	 -960,  -936,  -912,  -888,  -864,  -840,  -816,  -792
		DW	 -768,  -744,  -720,  -696,  -672,  -648,  -624,  -600
		DW	 -576,  -552,  -528,  -504,  -480,  -456,  -432,  -408
		DW	 -384,  -360,  -336,  -312,  -288,  -264,  -240,  -216
		DW	 -192,  -168,  -144,  -120,   -96,   -72,   -48,   -24
		; volume 25
		DW	    0,    25,    50,    75,   100,   125,   150,   175
		DW	  200,   225,   250,   275,   300,   325,   350,   375
		DW	  400,   425,   450,   475,   500,   525,   550,   575
		DW	  600,   625,   650,   675,   700,   725,   750,   775
		DW	  800,   825,   850,   875,   900,   925,   950,   975
		DW	 1000,  1025,  1050,  1075,  1100,  1125,  1150,  1175
		DW	 1200,  1225,  1250,  1275,  1300,  1325,  1350,  1375
		DW	 1400,  1425,  1450,  1475,  1500,  1525,  1550,  1575
		DW	 1600,  1625,  1650,  1675,  1700,  1725,  1750,  1775
		DW	 1800,  1825,  1850,  1875,  1900,  1925,  1950,  1975
		DW	 2000,  2025,  2050,  2075,  2100,  2125,  2150,  2175
		DW	 2200,  2225,  2250,  2275,  2300,  2325,  2350,  2375
		DW	 2400,  2425,  2450,  2475,  2500,  2525,  2550,  2575
		DW	 2600,  2625,  2650,  2675,  2700,  2725,  2750,  2775
		DW	 2800,  2825,  2850,  2875,  2900,  2925,  2950,  2975
		DW	 3000,  3025,  3050,  3075,  3100,  3125,  3150,  3175
		DW	-3200, -3175, -3150, -3125, -3100, -3075, -3050, -3025
		DW	-3000, -2975, -2950, -2925, -2900, -2875, -2850, -2825
		DW	-2800, -2775, -2750, -2725, -2700, -2675, -2650, -2625
		DW	-2600, -2575, -2550, -2525, -2500, -2475, -2450, -2425
		DW	-2400, -2375, -2350, -2325, -2300, -2275, -2250, -2225
		DW	-2200, -2175, -2150, -2125, -2100, -2075, -2050, -2025
		DW	-2000, -1975, -1950, -1925, -1900, -1875, -1850, -1825
		DW	-1800, -1775, -1750, -1725, -1700, -1675, -1650, -1625
		DW	-1600, -1575, -1550, -1525, -1500, -1475, -1450, -1425
		DW	-1400, -1375, -1350, -1325, -1300, -1275, -1250, -1225
		DW	-1200, -1175, -1150, -1125, -1100, -1075, -1050, -1025
		DW	-1000,  -975,  -950,  -925,  -900,  -875,  -850,  -825
		DW	 -800,  -775,  -750,  -725,  -700,  -675,  -650,  -625
		DW	 -600,  -575,  -550,  -525,  -500,  -475,  -450,  -425
		DW	 -400,  -375,  -350,  -325,  -300,  -275,  -250,  -225
		DW	 -200,  -175,  -150,  -125,  -100,   -75,   -50,   -25
		; volume 26
		DW	    0,    26,    52,    78,   104,   130,   156,   182
		DW	  208,   234,   260,   286,   312,   338,   364,   390
		DW	  416,   442,   468,   494,   520,   546,   572,   598
		DW	  624,   650,   676,   702,   728,   754,   780,   806
		DW	  832,   858,   884,   910,   936,   962,   988,  1014
		DW	 1040,  1066,  1092,  1118,  1144,  1170,  1196,  1222
		DW	 1248,  1274,  1300,  1326,  1352,  1378,  1404,  1430
		DW	 1456,  1482,  1508,  1534,  1560,  1586,  1612,  1638
		DW	 1664,  1690,  1716,  1742,  1768,  1794,  1820,  1846
		DW	 1872,  1898,  1924,  1950,  1976,  2002,  2028,  2054
		DW	 2080,  2106,  2132,  2158,  2184,  2210,  2236,  2262
		DW	 2288,  2314,  2340,  2366,  2392,  2418,  2444,  2470
		DW	 2496,  2522,  2548,  2574,  2600,  2626,  2652,  2678
		DW	 2704,  2730,  2756,  2782,  2808,  2834,  2860,  2886
		DW	 2912,  2938,  2964,  2990,  3016,  3042,  3068,  3094
		DW	 3120,  3146,  3172,  3198,  3224,  3250,  3276,  3302
		DW	-3328, -3302, -3276, -3250, -3224, -3198, -3172, -3146
		DW	-3120, -3094, -3068, -3042, -3016, -2990, -2964, -2938
		DW	-2912, -2886, -2860, -2834, -2808, -2782, -2756, -2730
		DW	-2704, -2678, -2652, -2626, -2600, -2574, -2548, -2522
		DW	-2496, -2470, -2444, -2418, -2392, -2366, -2340, -2314
		DW	-2288, -2262, -2236, -2210, -2184, -2158, -2132, -2106
		DW	-2080, -2054, -2028, -2002, -1976, -1950, -1924, -1898
		DW	-1872, -1846, -1820, -1794, -1768, -1742, -1716, -1690
		DW	-1664, -1638, -1612, -1586, -1560, -1534, -1508, -1482
		DW	-1456, -1430, -1404, -1378, -1352, -1326, -1300, -1274
		DW	-1248, -1222, -1196, -1170, -1144, -1118, -1092, -1066
		DW	-1040, -1014,  -988,  -962,  -936,  -910,  -884,  -858
		DW	 -832,  -806,  -780,  -754,  -728,  -702,  -676,  -650
		DW	 -624,  -598,  -572,  -546,  -520,  -494,  -468,  -442
		DW	 -416,  -390,  -364,  -338,  -312,  -286,  -260,  -234
		DW	 -208,  -182,  -156,  -130,  -104,   -78,   -52,   -26
		; volume 27
		DW	    0,    27,    54,    81,   108,   135,   162,   189
		DW	  216,   243,   270,   297,   324,   351,   378,   405
		DW	  432,   459,   486,   513,   540,   567,   594,   621
		DW	  648,   675,   702,   729,   756,   783,   810,   837
		DW	  864,   891,   918,   945,   972,   999,  1026,  1053
		DW	 1080,  1107,  1134,  1161,  1188,  1215,  1242,  1269
		DW	 1296,  1323,  1350,  1377,  1404,  1431,  1458,  1485
		DW	 1512,  1539,  1566,  1593,  1620,  1647,  1674,  1701
		DW	 1728,  1755,  1782,  1809,  1836,  1863,  1890,  1917
		DW	 1944,  1971,  1998,  2025,  2052,  2079,  2106,  2133
		DW	 2160,  2187,  2214,  2241,  2268,  2295,  2322,  2349
		DW	 2376,  2403,  2430,  2457,  2484,  2511,  2538,  2565
		DW	 2592,  2619,  2646,  2673,  2700,  2727,  2754,  2781
		DW	 2808,  2835,  2862,  2889,  2916,  2943,  2970,  2997
		DW	 3024,  3051,  3078,  3105,  3132,  3159,  3186,  3213
		DW	 3240,  3267,  3294,  3321,  3348,  3375,  3402,  3429
		DW	-3456, -3429, -3402, -3375, -3348, -3321, -3294, -3267
		DW	-3240, -3213, -3186, -3159, -3132, -3105, -3078, -3051
		DW	-3024, -2997, -2970, -2943, -2916, -2889, -2862, -2835
		DW	-2808, -2781, -2754, -2727, -2700, -2673, -2646, -2619
		DW	-2592, -2565, -2538, -2511, -2484, -2457, -2430, -2403
		DW	-2376, -2349, -2322, -2295, -2268, -2241, -2214, -2187
		DW	-2160, -2133, -2106, -2079, -2052, -2025, -1998, -1971
		DW	-1944, -1917, -1890, -1863, -1836, -1809, -1782, -1755
		DW	-1728, -1701, -1674, -1647, -1620, -1593, -1566, -1539
		DW	-1512, -1485, -1458, -1431, -1404, -1377, -1350, -1323
		DW	-1296, -1269, -1242, -1215, -1188, -1161, -1134, -1107
		DW	-1080, -1053, -1026,  -999,  -972,  -945,  -918,  -891
		DW	 -864,  -837,  -810,  -783,  -756,  -729,  -702,  -675
		DW	 -648,  -621,  -594,  -567,  -540,  -513,  -486,  -459
		DW	 -432,  -405,  -378,  -351,  -324,  -297,  -270,  -243
		DW	 -216,  -189,  -162,  -135,  -108,   -81,   -54,   -27
		; volume 28
		DW	    0,    28,    56,    84,   112,   140,   168,   196
		DW	  224,   252,   280,   308,   336,   364,   392,   420
		DW	  448,   476,   504,   532,   560,   588,   616,   644
		DW	  672,   700,   728,   756,   784,   812,   840,   868
		DW	  896,   924,   952,   980,  1008,  1036,  1064,  1092
		DW	 1120,  1148,  1176,  1204,  1232,  1260,  1288,  1316
		DW	 1344,  1372,  1400,  1428,  1456,  1484,  1512,  1540
		DW	 1568,  1596,  1624,  1652,  1680,  1708,  1736,  1764
		DW	 1792,  1820,  1848,  1876,  1904,  1932,  1960,  1988
		DW	 2016,  2044,  2072,  2100,  2128,  2156,  2184,  2212
		DW	 2240,  2268,  2296,  2324,  2352,  2380,  2408,  2436
		DW	 2464,  2492,  2520,  2548,  2576,  2604,  2632,  2660
		DW	 2688,  2716,  2744,  2772,  2800,  2828,  2856,  2884
		DW	 2912,  2940,  2968,  2996,  3024,  3052,  3080,  3108
		DW	 3136,  3164,  3192,  3220,  3248,  3276,  3304,  3332
		DW	 3360,  3388,  3416,  3444,  3472,  3500,  3528,  3556
		DW	-3584, -3556, -3528, -3500, -3472, -3444, -3416, -3388
		DW	-3360, -3332, -3304, -3276, -3248, -3220, -3192, -3164
		DW	-3136, -3108, -3080, -3052, -3024, -2996, -2968, -2940
		DW	-2912, -2884, -2856, -2828, -2800, -2772, -2744, -2716
		DW	-2688, -2660, -2632, -2604, -2576, -2548, -2520, -2492
		DW	-2464, -2436, -2408, -2380, -2352, -2324, -2296, -2268
		DW	-2240, -2212, -2184, -2156, -2128, -2100, -2072, -2044
		DW	-2016, -1988, -1960, -1932, -1904, -1876, -1848, -1820
		DW	-1792, -1764, -1736, -1708, -1680, -1652, -1624, -1596
		DW	-1568, -1540, -1512, -1484, -1456, -1428, -1400, -1372
		DW	-1344, -1316, -1288, -1260, -1232, -1204, -1176, -1148
		DW	-1120, -1092, -1064, -1036, -1008,  -980,  -952,  -924
		DW	 -896,  -868,  -840,  -812,  -784,  -756,  -728,  -700
		DW	 -672,  -644,  -616,  -588,  -560,  -532,  -504,  -476
		DW	 -448,  -420,  -392,  -364,  -336,  -308,  -280,  -252
		DW	 -224,  -196,  -168,  -140,  -112,   -84,   -56,   -28
