New Tandy .Snd File Format
--------------------------

These files are created by the 1990 version of DeskMate Sound.pdm, bundled 
with the Tandy 2500-series computers.  See Snd.for for more information.

This information was provided by John Ball (john.ball@two-t.com), author of 
Playsnd, and by the PSSJ Digital Sound Toolkit of Frank Durda IV.

Like the old format, the new format header consists of a fixed part 
followed by one or more sample descriptors.  The fixed part is 114 bytes; 
the sample descriptors are 46 bytes each.  Samples are still 8-bit unsigned 
PCM, possibly compressed.

Fixed header:
    offset       size        what
    ------       ----        ----
      0          44 bytes    Name or description of the sound.  According 
                             to John Ball, this is null-terminated ASCII.  
                             According to Frank Durda, this is ASCII 
                             terminated with carriage return, line feed, 
                             and <control>-Z (1Ah).
      2Ch        byte        <Control>-Z (1Ah).  As with the old format, 
                             this prevents the file from being typed to the 
                             screen with the DOS TYPE command.
      2Dh        byte        Format code:  80h.
      2Eh        word        Number of sounds in the file, 1 for sound 
                             files.  Instrument files may have more than 1 
                             sound (note).
      30h        byte        Instrument number of an instrument file.  
                             Sound files have 0 here.
      31h        17 bytes    Reserved, set to 0.
      42h        word        Compression code (0 = no compression, 1 =
                             music compression, 2 = speech compression).
      44h        20 bytes    Compression information; refer to the PSSJ 
                             Digital Sound Toolkit.  This information does 
                             not seem to be needed to decompress if 
                             compression types 1 or 2 were used.
      58h        word        Sampling rate in Hz.
      5Ah        word        Reserved, set to 0.
      5Ch        word        Hardware bias value, refers to the recording 
                             hardware used.  Refer to the PSSJ Digital 
                             Sound Toolkit.  If writing the file, you can 
                             set this to 0.
      5Eh        20 bytes    Reserved, set to 0.
      72h        variable    Sample descriptors begin.

Sample descriptors (number given by word at 2Eh above):
    offset       size        what
    ------       ----        ----
      0          dword       Link to next sample descriptor (offset in file
                             of next sample descriptor record).  0 if last.
      4          word        Sound options, refer to the PSSJ Digital Sound 
                             Toolkit.  1 = player should close the file 
                             after playback.  If writing the file, you can 
                             set this to 0.
      6          byte        Pitch of note (01h-3Fh), 01 = A1 in American
                             Standard Pitch; 0FFh if not set.
      7          byte        Unknown (compare old .snd format; value is 00
                             or FF, but seemingly unrelated to pitch 
                             setting).  Only used by Sound.pdm, according 
                             to Mr. Durda.
      8          2 bytes     Range of note.  First byte is lower limit,
                             second is higher limit.  Values as for byte
                             at offset 6 above; FF FFh if not set.
      0Ah        dword       Offset in file of start of sound data for
                             this sample.
      0Eh        dword       Length of sample sound data in bytes, after 
                             compression if that was done.
      12h        dword       Uncompressed length of sound data (number of
                             samples).
      16h        dword       Start of sustain region.
      1Ah        dword       End of sustain region.
      1Eh        16 bytes    Reserved, set to 0.
