/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	table.H					(c)	YoY'00						WEB: www.aestesis.org
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef							_TABLE_H_
#define							_TABLE_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include						"elektrodef.h"
#include						"thread.h"
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define							guidtable						(Atable::CI.guid)
#define							guidtableFront					(AtableFront::CI.guid)
#define							guidtableBack					(AtableBack::CI.guid)

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define							MAXEFFECTINFO					1024
#define							MAXEFFECT						1024
#define							MAXCONTROL						MAXEFFECT*16

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Atable : public Aobject, public Athread
{
public:
	ELIBOBJ

	EDLL						Atable							(char *name, Aobject *l, int x, int y, int w, int h);
	EDLL virtual				~Atable							();

	EDLL virtual void			paint							(Abitmap *);
	EDLL virtual bool			notify							(Anode *o, int event, dword p=0);
	EDLL virtual bool			size							(int w, int h);

	EDLL virtual bool			add								(class Aplugz *ei);

	EDLL virtual bool			add								(class Apin *p);
	EDLL virtual bool			del								(class Apin *p);

	EDLL virtual bool			add								(class Aconnect *c);
	EDLL virtual bool			del								(class Aconnect *c);

	EDLL virtual bool			del								(class Aeffect *e);

	EDLL void					arrange							();
	EDLL void					order							();
	EDLL void					clear							();

	EDLL bool					stop							();
	EDLL virtual void			run								();

	EDLL virtual int			getTime							();

	EDLL virtual void			settings						();

	EDLL bool					save							(Afile *f);
	EDLL bool					load							(Afile *f);


	EDLL bool					add								(class Acontrol *c);
	EDLL void					del								(class Acontrol *c);
	EDLL bool					record							(class Acontrol *c, int ctrl, int value);

	// video

	int							bpmPhase;
	int							bpmFreq;
	int							videoW;
	int							videoH;
	int							frameRate;
	bool						render;
	bool						recording;

	class Aitem					*plugz;

	char						rootdir[MAX_PATH];

	// private

	bool						test							(class Aeffect *e0, class Aeffect *e1);


	class Aitem					*effectItems;
	class AeffectInfo			*effectInfo[MAXEFFECTINFO];
	int							nbEffectInfo;
	class Aeffect				*effect[MAXEFFECT];
	int							nbEffect;
	class Aeffect				*effectOrder[MAXEFFECT];
	int							nbEffectOrder;
	class Acontrol				*control[MAXCONTROL];
	int							nbControl;

	class Apin					*pins;
	class Aconnect				*connects;

	int							nbPins;
	int							idEffect;

	class Aobject				*layer;
	class AtableFront			*front;
	class AtableBack			*back;
	class AtableSelect			*select;
	class Apattern				*pattern;

	class Amapping				*mapping;

	Asection					synchronize;
	bool						running;
	int							timeStart;
	int							timeCurrent;

};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class AtableFront : public Aobject
{
public:
	ELIBOBJ

	EDLL						AtableFront						(char *name, Aobject *l, Atable *t, int x, int y, int w, int h);
	EDLL virtual				~AtableFront					();

	EDLL virtual bool			notify							(Anode *o, int event, dword p=0);
	EDLL virtual bool			mouse							(int x, int y, int state, int event);

	int							wy,ly;
	bool						bac;

	Atable						*table;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class AtableBack : public Aobject
{
public:
	ELIBOBJ

	EDLL						AtableBack						(char *name, Aobject *l, Atable *t, int x, int y, int w, int h);
	EDLL virtual				~AtableBack						();

	EDLL virtual bool			notify							(Anode *o, int event, dword p=0);
	EDLL virtual bool			mouse							(int x, int y, int state, int event);
	EDLL virtual void			update							(Abitmap *b);

	int							wy,ly;
	bool						bac;

	Atable						*table;

// connect mode
	Apin						*fromPin;
	int							fromX,fromY;
	Apin						*toPin;
	int							toX,toY;

	void						drawConnects					(Abitmap *b);
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif							//_TABLE_H
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
