/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	MAIN.CPP					(c)	YoY'01						WEB: www.aestesis.org
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include						"main.h"
#include						"resource.h"
#include						<math.h>
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// elektronika SDK effect sample
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// if you want to use MFC/AFX
// add the MFC/AFX includes
// select "MFC  shared dll" in general tab of the project settings
// and remove the _USRDLL define in the project settings
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

ACI								AexampleInfo::CI	= ACI("AexampleInfo",	GUID(0x50000000,0x00000020), &AeffectInfo::CI, 0, NULL);
ACI								Aexample::CI		= ACI("Aexample",		GUID(0x50000000,0x00000021), &Aeffect::CI, 0, NULL);
ACI								AexampleFront::CI	= ACI("AexampleFront",	GUID(0x50000000,0x00000022), &AeffectFront::CI, 0, NULL);
ACI								AexampleBack::CI	= ACI("AexampleBack",	GUID(0x50000000,0x00000023), &AeffectBack::CI, 0, NULL);

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static int						count=0;
static Aresource				resdll=Aresource("example01", GetModuleHandle("example01.dll"));

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static void init()
{
	if(count==0)
	{
		// make globals inits as somes tables
	}
	count++;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static void end()
{
	count--;
	if(count==0)
	{
		// free globals inits
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Aexample::Aexample(char *name, Atable *table) : Aeffect(name, table)
{
	front=new AexampleFront("moonster front", this, 50);
	front->setTooltips("moonster front");
	back=new AexampleBack("moonster back", this, 50);
	back->setTooltips("moonster back");
	init();	// global init
	settings();
//	you can get table->videoW or table->videoH 
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Aexample::~Aexample()
{
	end();	// global free
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Aexample::save(class Afile *f)
{
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Aexample::settings()
{
//	table->videoW or table->videoH have been changed
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Aexample::setBox(Abitmap *b,int x, int y, sword *s, int n, dword color, float l)
{
	if(n)
	{
		int		d=y<<1;
		int		i;
		float	a=0.2f/n;
		for(i=0; i<n; i++)
		{
			int	i0=i<<1;
			int	v=(int)((float)s[i]*(float)d*l)>>15;
			b->boxfa(x-v, y-v, x+v, y+v, color, a, lineaADD|lineaSATURATION);
		}
	}
}

bool Aexample::action(int time, int dtime)
{
	int				w=table->videoW;
	int				h=table->videoH;
	float			l=((AexampleFront *)front)->level->get();
	dword			cl=((AexampleFront *)front)->color0->get();
	dword			cc=((AexampleFront *)front)->color1->get();
	dword			cr=((AexampleFront *)front)->color2->get();
	Asample			*snd=((AexampleBack *)back)->in;
	Avideo			*vin=((AexampleBack *)back)->vin;
	Avideo			*out=((AexampleBack *)back)->out;
	sword			smp[64*2];
	sword			bas[64*2];
	sword			med[64*2];
	sword			tre[64*2];
	int				nget=0;

	l=(l<0.5f)?(l*2.f):((l-0.5f)*10.f+1.f);

	if(snd->isConnected())
	{
		snd->enter();
		snd->skip(maxi(snd->avaible()-1024, 0));
		nget=snd->getBuffer(smp, bas, med, tre, 1);
		snd->leave();
	}

	out->enter();
	vin->enter();
	{
		Abitmap *b=out->getBitmap();
		Abitmap	*bin=vin->getBitmap();
		if(b)
		{
			int		nx=b->w>>2;
			int		ny=b->h>>1;
			int		v=0;
			if(bin)
			{
				bin->flags|=bitmapGLOBALALPHA;
				bin->alpha=0.05f;
				b->set(0, 0, bin);
			}
			else
				b->boxfa(0, 0, b->w, b->h, 0xff000000, 0.05f);
			setBox(b, v+=nx, ny, bas, nget, cl, l);
			setBox(b, v+=nx, ny, med, nget, cc, l);
			setBox(b, v+=nx, ny, tre, nget, cr, l);
		}
	}
	vin->leave();
	out->leave();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void AexampleFront::paint(Abitmap *b)
{
	b->set(0, 0, back);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

AexampleFront::AexampleFront(char *name, Aexample *e, int h) : AeffectFront(name, e, h)
{
	setTooltips("MooNSTER");
	Aresobj	o=resdll.get(MAKEINTRESOURCE(PNG_MOONSTER_FRONT), "PNG");
	back=new Abitmap(&o);

	level=new Apaddle("level", this, 20, 10, paddleBUTTON07);
	level->setTooltips("level");
	level->set(0.5f);
	level->show(TRUE);

	color0=new Aselcolor("left color", this, 50, 16);
	color0->setTooltips("left color");
	color0->set(0xffff0080);
	color0->show(true);

	color1=new Aselcolor("center color", this, 70, 16);
	color1->setTooltips("center color");
	color1->set(0xff80ff00);
	color1->show(true);

	color2=new Aselcolor("right color", this, 90, 16);
	color2->setTooltips("right color");
	color2->set(0xff0080ff);
	color2->show(true);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

AexampleFront::~AexampleFront()
{
	delete(back);
	delete(level);
	delete(color0);
	delete(color1);
	delete(color2);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool AexampleFront::notify(Anode *o, int event, dword p)
{
	switch(event)
	{
		case nyCHANGE:
		break;
	}
	return AeffectFront::notify(o, event, p);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

AexampleBack::AexampleBack(char *name, Aexample *e, int h) : AeffectBack(name, e, h)
{
	Aresobj	o=resdll.get(MAKEINTRESOURCE(PNG_MOONSTER_BACK), "PNG");
	back=new Abitmap(&o);

	in=new Asample("audio input", this, pinIN, 10, 10);
	in->setTooltips("audio input");
	in->show(TRUE);

	vin=new Avideo("video input", this, pinIN, 30, 10);
	vin->setTooltips("video input");
	vin->show(TRUE);

	out=new Avideo("video output", this, pinOUT, pos.w-18, 10);
	out->setTooltips("video output");
	out->show(TRUE);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

AexampleBack::~AexampleBack()
{
	delete(in);
	delete(vin);
	delete(out);
	delete(back);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void AexampleBack::paint(Abitmap *b)
{
	b->set(0, 0, back);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

AexampleInfo::~AexampleInfo()
{
	int	a=5;
	a++;
}


Aeffect * AexampleInfo::create(char *name, Atable *t)
{
	return new Aexample(name, t);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern "C" 
{
	DLLEXPORT class Aplugz * getPlugz()
	{
		return new AexampleInfo("example 01", &Aexample::CI, "SDK example 01", "SDK example 01");
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
