#!/usr/bin/perl

###############################################################################
#
# _AFEdSubjRename.cgi - Change list of Topics for the forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/10/09 22:43:45 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdSubjRename.cgi,v 1.27.2.8 2001/10/09 22:43:45 stepper Exp $';
$Version = '1.4.0';

if ($ARGV[0] eq "-v" || $ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "T_Init.pl";

# Turn off buffering - for the response page
$| = 1;

$Class = $CGIQuery->param('fid');
$Subject = $CGIQuery->param('tid');
$Subject =~ s/ /\+/g;
$func = $CGIQuery->param('func');

&lookupClass;
&lookupUser($CGIEnvUser);

&loadColors($ColorQueryString);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if (($func eq "showedit" || $func eq "doedit") && $Subject ne "") {
	# Class and subject chosen, print out editing page.
	
	$done = "<font color=#00AA00>done.</font><br>\n";
	
	if ($func eq "doedit") {
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
		
		$ERROR = $FontRed . $FontSize2 . "Error:</font></font> ";
		
		# Turn on signal Handling
		$trapSignals = 1;
		
		$BodyTag = &makeBodyTag("Content", "onLoad=\"closeWin()\"");
	
		&showHeaderBackHTML("Renaming Topics. Please Wait.");
			
		# Javascript for wait window
		print "<script language=javascript>\n<!--\n\n";
		print "	window.onError = null;\n";
		print "	var wWin;\n";
		print "	function waitWin() {\n";
		print "		wWin = window.open(\"\", \"waiting\", \"toolbar=0,location=0,",
				"directories=0,status=0,menubar=0,scrollbars=0,resizable=0,",
				"width=200,height=100\");\n";
		print "		wWin.document.write(\"<html><head><title>Please Wait</title>",
								"</head>\\n<body bgcolor=#FFFFFF ",
								"marginwidth=0 marginheight=0>\\n\");\n";
		print "		wWin.document.write(\"", $FontFace, $FontSize, "\");\n";
		print "\t\twWin.document.write(\"<table border=0 cellpadding=0",
				" cellspacing=0 width=100%>\\n\");\n";
		print "\t\twWin.document.write(\"<tr><td bgcolor=", $FCheaderback, ">",
				"<font color=", $FCheadertext, ">", 
				$FontFace, $FontSize2, "<b>\\n\");\n";
		print "\t\twWin.document.write(\"Renaming Topics...</b></td></tr></table>\\n\");\n";
		print "		wWin.document.write(\"Please wait while all topics are renamed.\\n\");\n";
		print "		wWin.document.close();\n";
		print "		// return true;\n";
		print "	}\n";
		print "\n";
		print "	function closeWin() {\n";
		print "		if ((wWin) && !wWin.closed) {\n";
		print "			wWin.close();\n";
		print "		}\n";
		print "	}\n";
		print "\n";
		print "	waitWin();\n";
		print "// -->\n</script>\n\n";

		print "<p>\n";
		
		print "Reading submitted data...";
		
		@names = $CGIQuery->param;
		
		# Rename Submission
		
		@names = sort(@names);
		
		$badTopics = 0;
		
		for ($i=0; $i < @names; $i++) {
			$val = $CGIQuery->param($names[$i]);
			$names[$i] =~ s/ /\+/g;
			if ($val !~ /\S/) {
				$origvalues{$names[$i]} = $val;
				push(@values, "");
				$badTopics = 1;
			} else {
				push(@values, &escapeTopicSlash(&escapeTopic($val)));
				$origvalues{$names[$i]} = $val;
			}
		}
		
		# Load up all existing topics into associative array
		$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
		foreach $line (`$prtDB $dbfile -tbtree -a -q`) {
			($key, $data) = split(/\t/, $line);
			$oldTopics{$key} = $data;
		}
		
		print $done;
		
		print "Sorting data...";
		
		@match = split(//, $Subject);
		for ($i=0; $i < @match; $i++) {
			$match[$i] =~ s/([^a-zA-Z0-9-_])/\\$1/g;
		}
		$match = join("", @match);
		
		for ($i=0; $i < @names; $i++) {
			if ($names[$i] =~ /^$match\// || $names[$i] eq $Subject) {
				@junk = split(/\//, $names[$i]);
				
				$ind = $#junk;
				
				$check = pop(@junk);
				$parent = join("/", @junk);
				$parent =~ s/^\///;
				$new = $values[$i];
				if ($check ne $new && $new ne "" && $new =~ /\S/) {
					# This one has been renamed.
					push(@changed, $names[$i]);
					
					@changed = &unique(@changed);
					
					if ($newname{$names[$i]} ne "") {
						# This one's parent has already been modified
						@junk = split(/\//, $newname{$names[$i]});
						pop(@junk);
						$parent = join("/", @junk);
						$parent =~ s/^\///;
					}
					
					# Is the user trying to rename two topics to the same name?
					foreach $key (keys %newname) {
						if ($newname{$key} eq $parent . "/" . $new) {
							# Two new names are the same
							print "<p>", $ERROR, "You attempted to rename two ",
								"topics to the same name. Please go back and ",
								"correct this error.<p>\n";
							print "You attempted to rename <b>",
								&printPretty(&unEscapeTopic($key)),
								"</b> to <b>",
								&printPretty(&unEscapeTopic($newname{$key})),
								"</b> and <b>",
								&printPretty(&unEscapeTopic($names[$i])),
								"</b> to <b>",
								&printPretty(&unEscapeTopic($parent . "/" . $new)),
								"</b>.<p>\n";
							print "</body></html>";
							exit();
						}
					}
					
					$newname{$names[$i]} = $parent . "/" . $new;
					$newname{$names[$i]} =~ s/^\///;
					$newname{$names[$i]}{"parent"} = $parent;
					
					# If the new name already exists, exit out with
					# an error
					if ($oldTopics{$newname{$names[$i]}} ne "") {
						print "<p>", $ERROR, "The topic: <b>",
							&printPretty(&unEscapeTopic($newname{$names[$i]})),
							"</b> already exists. You tried to rename <b>",
							&printPretty(&unEscapeTopic($names[$i])),
							"</b> to <b>",
							&printPretty(&unEscapeTopic($newname{$names[$i]})),
							"</b>. Please go back and choose ",
							"a different name. Aborting rename operation.<p>\n";
						print $FontRed, "Note:</font> You may need to do your ",
							"rename operation in two steps to achieve the ",
							"desired topic structure.<p>\n";
						print "</body></html>";
						exit();
					}
					
					@match = split(//, $names[$i]);
					for ($j=0; $j < @match; $j++) {
						$match[$j] =~ s/([^a-zA-Z0-9-_])/\\$1/g;
					}
					$match2 = join("", @match);
					
					# Modify all children
					for ($j = $i + 1; $j < @names; $j++) {
						if ($names[$j] =~ /^$match2\//) {
							# This is a child
							push(@changed, $names[$j]);
							@changed = &unique(@changed);
							
							if ($newname{$names[$j]} ne "") {
								# This child has already been modified
							} else {
								$newname{$names[$j]} = $names[$j];
							}
							
							@new = split(/\//, $newname{$names[$j]});
							$new[$ind] = $new;
							
							$newname{$names[$j]} = join("/", @new);
							pop(@new);
							$newname{$names[$j]}{"parent"} = join("/", @new);
						}
					}
				}
			}
		}
		
		print $done;
		
		# Got full list of what's changed. Now rename directories and 
		# modify the topics database
		
		print "Updating topics database...";
		
		$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
		$back = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ . ".tmp";
		&copy($dbfile, $back);
		
		foreach (`$prtDB $dbfile -tbtree -a -q`) {
			($DB_Key, $value) = split(/\t/, $_);
			$value = &UnEscape($value);
			chomp($value);
			
			@value = split(/\t/, $value);
		
			$status = &dbErrorCheck($?, $DB_Key);
			if ($status) {
				print "<p>$status<p>Unable to read from $dbfile. Aborting Rename Operation";
				exit();
			}
		
			for ($i=0; $i < @changed; $i++) {
				if ($changed[$i] eq $DB_Key) {
					# Delete old value
					@retval = `$delDB $back -tbtree -k \"$DB_Key\"`;
					$status = &dbErrorCheck($?, $retval[0]);
					if ($status) {
						print "<p>$status<p>Unable to delete $DB_Key from Topics database: $back. Aborting Rename Operation";
						exit();
					}
					
					# Insert new value
					$value[1] = $origvalues{$changed[$i]};
					$value[4] = $newname{$changed[$i]}{"parent"};
					$key = $newname{$changed[$i]};
					
					$value = join("\\t", @value);
					chomp($value);
					
					@retval = `$setDB $back -tbtree -q -k \"$key\" -d \"$value\"`;
					$status = &dbErrorCheck($?, $retval[0]);
					if ($status) {
						print "<p>$status<p>Unable to add $key to Topics database: $back. Aborting Rename Operation.";
						exit();
					}
				}
			}
					
		}
		
		print $done;
		
		print "Renaming directories...";
		
		@rename = reverse(@changed);
		
		for ($i=0; $i < @rename; $i++) {
			@junk = split(/\//, $rename[$i]);
			pop(@junk);
			$parent = join("/", @junk);
			
			@junk = split(/\//, $newname{$rename[$i]});
			$new = $parent . "/" . pop(@junk);
			$new =~ s/^\///;
			
			if ($new ne $rename[$i]) {
				$oldfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $rename[$i];
				$newfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $new;
				
				if (-e $newfile) {
					print "<p>Error: Directory ", $newfile;
					print " already exists. Please choose a different name ";
					print "instead of ", $origname{$rename[$i]};
					print ". All renaming aborted.\n";
					exit();
				}
				
				if (!rename($oldfile, $newfile)) {
					# Rename may not always work...
					$move = "mv";
					if ($isWin) {
						$move = "move";
					}
					
					$retval = `$move $oldfile $newfile`;
					
					$status = &dbErrorCheck($?, $retval);
					if ($status) {
						print "<p>Unable to rename ", $C_rootpath . "/" . $rename[$i];
						print " to ", $C_rootpath . "/" . $new;
						print ". Rename Operation Aborted.\n";
						exit();
					}
				}
			}
		}
		
		# Now copy the tmp Topics file back to the original
		rename($back, $dbfile);
		
		print $done;
		
		# Now that the critical part is done, go through all of the 
		# other databases making necessary changes in the topic
		# specifications.
		
		print "Updating Global View Databases...";
		
		# Start with new.db
		$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FALL";
		if (! -e $dbfile) {
			$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FNEW";
		}
		foreach (`$prtDB $dbfile -tbtree -a -q`) {
			($key, $value) = split(/\t/, $_);
			$value = &UnEscape($value);
			chomp($value);
			
			(@val) = split(/\t/, $value);
			
			for ($i=0; $i < @changed; $i++) {
				if ($changed[$i] eq $val[1]) {
					# Replace this one
					$val[1] = $newname{$changed[$i]};
					
					# Put it back in
					$value = join("\\t", @val);
					@retval = `$setDB $dbfile -tbtree -q -sn -k \"$key\" -d \"$value\"`;
					$status = &dbErrorCheck($?, $retval[0]);
					if ($status) {
						print "<p>$status<p>Unable to update $key in New database: $dbfile.";
					}
				}
			}
		}
		
		# Now the global authors db
		# The topic shows up in the authors.db local to a topic, but it is
		# never actually used.
		$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FAUTHOR";
		foreach (`$prtDB $dbfile -tbtree -a -q`) {
			($key, $value) = split(/\t/, $_);
			$value = &UnEscape($value);
			chomp($value);
			
			(@val) = split(/\t/, $value);
			
			for ($i=0; $i < @changed; $i++) {
				if ($changed[$i] eq $val[4]) {
					# Replace this one
					$val[4] = $newname{$changed[$i]};
					
					# Put it back in
					$value = join("\\t", @val);
					@retval = `$setDB $dbfile -tbtree -q -san -k \"$key\" -d \"$value\"`;
					$status = &dbErrorCheck($?, $retval[0]);
					if ($status) {
						print "<p>$status<p>Unable to update $key in Authors database: $dbfile.";
					}
				}
			}
		}
		
		# Lastly, update all of the replies databases. This is what will take
		# a long time
		$repdir = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DIR_FORUMREPLIES;
		@files = <$repdir/*.db>;
		for ($k=0; $k < @files; $k++) {
			$dbfile = $files[$k];
		
			if ($dbfile =~ /\.del\.db$/) {
				next;
			}
			
			foreach (`$prtDB $dbfile -tbtree -a -q`) {
				($key, $value) = split(/\t/, $_);
				$value = &UnEscape($value);
				chomp($value);
			
				(@val) = split(/\t/, $value);
				
				for ($i=0; $i < @changed; $i++) {
					if ($changed[$i] eq $val[0]) {
						# Replace this one
						$val[0] = $newname{$changed[$i]};
					
						# Put it back in
						$value = join("\\t", @val);
						@retval = `$setDB $dbfile -tbtree -q -sna -k \"$key\" -d \"$value\"`;
						$status = &dbErrorCheck($?, $retval[0]);
						if ($status) {
							print "<p>$status<p>Unable to update $key in Replies database: $dbfile.";
						}
					}
				}
			}
		}
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}
		
		print $done;
		
		print "<p>Finished!<p>";
		
		if (@changed > 0) {
			print "The following topics were renamed successfully.<p>\n";
		
			print "<table border=1 cellpadding=0 cellspacing=2>\n";
			print "<tr><td>", $FontFace, $FontSize;
			print "<b>Original Name</b></td>\n";
			print "<td>", $FontFace, $FontSize;
			print "<b>New Name</b></td></tr>\n";
		
			for ($i=0; $i < @changed; $i++) {
				print "<tr><td>", $FontFace, $FontSize;
				print &printPretty(&unEscapeTopic($changed[$i]));
				print "</td><td>", $FontFace, $FontSize;
				print &printPretty(&unEscapeTopic($newname{$changed[$i]}));
				print "</td></tr>\n";
			}
			
			print "</table>\n";
		}
		
		if ($badTopics) {
			print "<p>$FontRed Warning!</font>";
			print "The following topics contained invalid characters in ";
			print "their names, and could not be changed.<p>\n";
			print "<table border=1 cellpadding=0 cellspacing=2>\n";
			print "<tr><td>", $FontFace, $FontSize;
			print "<b>Original Name</b></td>\n";
			print "<td>", $FontFace, $FontSize;
			print "<b>Attempted New Name</b></td></tr>\n";
			
			for ($i=0; $i < @names; $i++) {
				if ($values[$i] eq "") {
					print "<tr><td>", $FontFace, $FontSize;
					print &printPretty(&unEscapeTopic($names[$i]));
					print "</td><td>", $FontFace, $FontSize;
					print &printPretty(&unEscapeTopic($origvalues{$names[$i]}));
					print "</td></tr>\n";
				}
			}
			
			print "</table>\n";
			
		}
		
		print "<script language=javascript>\n";
		print "parent.subjectmenu.document.location.reload();\n";
		print "</script>\n";
		
		print "<p><a href=\"", $CGIEnvScript, "?fid=$Class&func=showedit&tid=$Subject\">";
		print "Return to Editing</a>\n";
		
		print "</body></html>\n";
		
		exit();
	}
	
	########################
	# Print out the web page
	########################

	$header = "Rename Topics in " . &printPretty(&unEscapeTopic($Subject));
	$helplink = "file=TopicRenameCORP_Admin.html&anchor=RenameTopicEdtFSummary";
	$helplink .= "&helptitle=Rename%20Topics%20Editing%20Frame";
	&showHeaderBackHTML($header,"", 0, 0, 0, $helplink);
	
	print @msgs;
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=tid value=\"$Subject\">\n";
	print "<input type=hidden name=func value=doedit>\n";

	print "<table cellpadding=0 cellspacing=1 border=0 width=100%>\n";
	
	print "<tr><td>", $FontFace, $FontSize;	

	&printsubjectlist($Subject);

	print "<br>&nbsp;</td></tr>\n";

	print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";

	print "<tr>";
	print "<td>", $FontFace,$FontSize;
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</td></tr></table>\n\n";
	
	print "</form>\n\n";
	
	# Debugging
	for ($i=0; $i < @changed; $i++) {
		print "Orig: ", $changed[$i];
		print " New: ", $newname{$changed[$i]};
		print " Parent: ", $newname{$changed[$i]}{"parent"}, "<br>\n";
	}
	
	print "</body></html>\n";
	
# End of data processing
#
##########################################################	

} elsif ($func eq "menu") {

	#####################################################
	# Class chosen, but no subject. Print list of subjects
	#####################################################

	@selected = $CGIQuery->param('selected');
	$selleng = @selected;
	$BtnSelected = @selected[$selleng - 1];
	
	$helplink = "file=TopicRenameCORP_Admin.html&anchor=RenameTopicTskFSummary";
	$helplink .= "&helptitle=Rename%20Topics%20Task%20Frame";
	&showHeaderBackHTML("Rename Topics for $CorF - $Class", 
		"", 0, 1, 0, $helplink);

	# Start Form
	print "<form action=$CGIEnvScript method=GET target=subjectedit>\n";
	print "<input type=hidden name=func value=showedit>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";

	# Print form
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	print "<tr><td valign=middle align=right>";
	print $FontFace, $FontSize, $ImgClear88;
	print "<select name=tid size=4>\n";
	
	# Get the list of existing subjects
	@ls = &gettopsubjectlist($Subject);
	
	# Put the list of subjects in the selection box
	for ($i=0; $i < @ls; $i++) {
		$ls[$i] =~ s/ /\+/g;
		print "<option value=\"", $ls[$i], "\"";
		if ($BtnSelected eq $ls[$i]) {
			print " SELECTED";
		}
		print "> ";
		print &printPretty(&unEscapeTopic($ls[$i])), "\n";
	}
	
	print "</select></td>";
	print "<td valign=middle align=left>", $FontSize, $FontFace;
	# print "<input type=submit name=submit value='Edit'>";
	print $BtnFormSubmit;
	print "</td>";
	
	print "<td><img src=images/cleardot.gif width=5 height=20 align=top>";
	print "</td><td valign=middle width=90%>";
	print $FontFace, $FontSize, "Choose a topic to change topic names, for ";
	print "it and any of its subtopics.</td>\n";
	
	print"</tr>\n\n";

	print "</table>\n";
	print "</form>\n";
	
} elsif ($func eq "nothing" || $func eq "showedit") {

	# User input nothing, tell them to select something
	
	&printEmptyTaskFrame("Please choose a Topic above.");
	
} else {
	# Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Topic Renaming</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=subjectmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=subjectedit src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}


########

sub printsubjectlist {
	local($Subject) = @_;

	# Start a table
	print "<table border=0 cellpadding=0 cellspacing=0>\n";

	# Get the listing from the database
	
	$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
	
	@match = split(//, $Subject);
	for ($i=0; $i < @match; $i++) {
		$match[$i] =~ s/([^a-zA-Z0-9-_])/\\$1/g;
	}
	$match = join("", @match);
	
	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, $posttime, $nicename, $ImgIndents, $subdirs, $parent, $allowpost, $posts) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
			exit();
		}

		if ($DB_Key eq $Subject || $DB_Key =~ /^$match\//) {
	
			print "<tr>";
			print "<td valign=top nowrap>", $FontFace, $FontSize;
			
			# Print a spacer for the margin
			print $ImgClear88;
		
			# Print the indents
			for ($k=0; $k < $ImgIndents; $k++) {
				print $ImgClear88;
			}
		
			if ($subdirs ne "" && $subdirs == 1) {
				print $BtnExpanded;
			} else {
				print $IcoNoReplies;
			}
		
			print $ImgIndentSmall;
			print "\n<input type=text size=50 name=\"$DB_Key\" value=\"";
			print $nicename;
			print "\" maxlength=$MAX_TOPIC_LENGTH>";
			print "</td></tr>\n";
		}
	}
	
	print "</table>\n\n";
}

sub printSectionSelection {
	for ($j=1; $j <= $C_Sect_n; $j++) {
		print $C_Sects{$j}{"name"}, "\n";
		print "<br>";
	}
}
