#!/usr/bin/perl

###############################################################################
#
# _AFEdSubjDel.cgi - Delete Topics for the forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdSubjDel.cgi,v 1.33.2.3 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "T_Init.pl";
require "M_Init.pl";

# Turn off buffering - for the response page
$| = 1;

$done = "<font color=#00AA00>done.</font><br>\n";

$Class = $CGIQuery->param('fid');

@delsubject = $CGIQuery->param('delsubject');
for ($i=0; $i < @delsubject; $i++) {
	@delsubject[$i] =~ s/ /\+/g;
}
$Subject = $CGIQuery->param('tid');
$Subject =~ s/ /\+/g;
$func = $CGIQuery->param('func');

&lookupClass;
&lookupUser($CGIEnvUser);

&loadColors($ColorQueryString);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if ($func eq "showdel" && $Subject ne "") {
	# Class and subject chosen, print out deleting page.
	
	if (@delsubject > 0) {
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
	
		# Delete a subject
		$dorefresh = 1;
		
		# Do a confirmation
		$confirm = $CGIQuery->param('confirm');
		if ($confirm eq "") {
			&dosubconf;
			exit();
		} elsif ($confirm eq "NO") {
			&showHeaderBackHTML("Topic Deletion Cancelled", "You have cancelled topic deletion.");
			exit();
		}
		
		&showHeaderBackHTML("Deleting Topics...");
		print "<p>\n";
		print "Reading submitted data...";
		
					
		@delsubject = sort(@delsubject);
		@delsubject = reverse(@delsubject);
		
		print $done;
		
		# Turn on signal Handling
		$trapSignals = 1;

		for ($l=0; $l < @delsubject; $l++) {
			$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
		
			splice(@keys, 0);
			splice(@values, 0);
			splice(@threadids, 0);
		
			$delsubject = @delsubject[$l];

			($DB_Key, $time, $prettysub, $ImgIndents, $subdirs, $parent, $allowpost, $posts) =  split(/\t/, `$prtDB $dbfile -tbtree -k \"$delsubject\"`);
		
			$status = &dbErrorCheck($?, $DB_Key);
			if ($status) {
				print "<p>$status<p>Topic: $delsubject does not exist and can not be deleted.";
				exit();
			}

			$multchild=0;
			$count = 0;
			@keys[$count] = $delsubject;
			@values[$count] = "$time\\t" . $prettysub . "\\t$ImgIndents\\t$subdirs\\t" . $parent . "\\t$allowpost\\t$posts";
			$count++;
		
			foreach (`$prtDB $dbfile -tbtree -a`) {
				($DB_Key, $time2, $prettysub2, $ImgIndents2, $subdirs2, $parent2, $allowpost2, $posts2) = split(/\t/, $_);
			
				$status = &dbErrorCheck($?, $DB_Key);
				if ($status) {
					print "<p>$status<p>Unable to read from Topics database: $dbfile.";
					exit();
				}

				if ($parent ne "") {
					# May have to change subdirs flag on parent
					if ($parent2 eq $parent && $DB_Key ne $delsubject) {
						# Don't have to change parent
						$multchild = 1;
					}
				}
		
				if ($subdirs) {
					# Have to delete children also
					@match = split(//, $delsubject);
					for ($i=0; $i < @match; $i++) {
						@match[$i] =~ s/([^a-zA-Z0-9-_])/\\$1/g;
					}
					$match = join("", @match);
					
					if ($parent2 =~ /^$match/) {
						# this record needs to be deleted
						@keys[$count] = $DB_Key;
						@values[$count] = "$time2\\t" . $prettysub2 . "\\t$ImgIndents2\\t$subdirs2\\t" . $parent2 . "\\t$allowpost2\\t$posts2";
						$count ++;
					}
				}
			}
			
			# Delete messages in topic to be deleted.
			
			# Read in contents of new.db
			$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FALL";
			if (! -e $dbfile) {
				$dbfile = "$C_rootpath/$DIR_CLASSFORUM/$DBFILE_FNEW";
			}
			foreach (`$prtDB $dbfile -tbtree -a -q`) {
				($key, $value) = split(/\t/, $_);
				$value = &UnEscape($value);
				
				($id, $topic, @junk) = split(/\t/, $value);
				push(@newtopics, $topic);
				push(@newids, $id);
			}
			
			# Go through new db for each topic, picking out msgids to be deleted
			for ($i=0; $i < @keys; $i++) {
				$topic = @keys[$i];
				print "Collecting Messages in Topic: ";
				print &printPretty(&unEscapeTopic($topic));
				print "...";
				
				for ($j=0; $j < @newtopics; $j++) {
					if (@newtopics[$j] eq $topic) {
						# delete this one
						if (@newids[$j] =~ /\./) {
							@gettop = split(/\./, @newids[$j]);
							$topid = @gettop[0];
						} else {
							$topid = @newids[$j];
						}
						push(@threadids, $topid);
						$topicatid{$topid} = @newtopics[$j];
					}
				}
				
				print $done;
			}
			
			@threadids = &unique(@threadids);

			if (@threadids > 0) {
				$what = "thread";
				for ($i=0; $i < @threadids; $i++) {
					$top = $topicatid{@threadids[$i]};
					print "Deleting Thread: ", @threadids[$i], "...";
					
					&delFromMsg($top, @threadids[$i], $what);
					&delFromSubjThreads($top, @threadids[$i], $what);
					&delFromAuth($top, @threadids[$i], $what, "global");
					&delFromAuth($top, @threadids[$i], $what, "local");
					&delFromReplies(@threadids[$i], $what);
					&delFromNew(@threadids[$i], $what);
					
					print $done;
				}
			}
		
			# Delete keys marked for deletion
			print "Deleting Topics...";
			$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
			for ($i=0; $i <= $count; $i++) {
				$DB_Key = @keys[$i];
				@retval = `$delDB $dbfile -tbtree -k \"$DB_Key\"`;
				$status = &dbErrorCheck($?, @retval[0]);
				if ($status) {
					print "<p>$status<p>Unable to delete key: $DB_Key from $dbfile.";
					exit();
				}
			}
		
			# Change subdirs value of parent, if necessary
			if (!$multchild && $parent ne "") {
				($key, @getit) = split(/\t/, `$prtDB $dbfile -tbtree -k \"$parent\"`);
			
				$status = &dbErrorCheck($?, $key);
				if ($status) {
					&showErrorBackHTML("$status<p>Unable to read parent of $key from Topics database: $dbfile.");
					exit();
				}

				@getit[3] = 0;
				$value = join("\\t", @getit);

				@retval = `$setDB $dbfile -tbtree -q -k \"$parent\" -d \"$value\"`;

				$status = &dbErrorCheck($?, @retval[0]);
				if ($status) {
					print "<p>$status<p>Unable to write key: $parent to Topics database: $dbfile. Check permissions and try again.";
					exit();
				}
			}
			print $done;
		
			############################################################
		
			# Now move the directories, and create the database of deleted entries
		
			print "Deleting Directories...";
			$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FDELSUBJ;
		
			for ($i=0; $i < @keys; $i++) {
				$DB_Key = @keys[$i];
				$value = @values[$i];
				$dir = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DB_Key;
				
				if ($MsgBackup) {
					$newdir = $dir . "~";
					rename($dir, $newdir);
			
					# No big deal if this fails. It's not being used anyway
					$retval = `$setDB $dbfile -tbtree -q -k \"$DB_Key\" -d \"$value\"`;
				} else {
					# Recurse into directory, deleting everything in it
					if ($isWin) {
						$dosdir = $dir;
						$dosdir =~ s/\//\\/g;
						system("rmdir /S /Q $dosdir");
					} else {
						system("rm -rf $dir");
					}
				}
			}
			print $done;
			
		}
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}
		
		print "<p>Finished!<p>\n";
			
		print "<script language=javascript>\n";
		print "parent.subjectmenu.document.location.reload();\n";
		print "</script>\n";
			
		print "</body></html>\n";
		
		exit();
	}
	
	########################
	# Print out the web page
	########################

	$header = "Delete Topics in " . &printPretty(&unEscapeTopic($Subject));
	
	$helplink = "file=TopicDeleteCORP_Admin.html&anchor=DeleteTopicEdtFSummary";
	$helplink .= "&helptitle=Delete%20Topics%20Editing%20Frame";
	&showHeaderBackHTML("$header", "", 0, 0, 0, $helplink);
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=func value=showdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=tid value=\"$Subject\">\n";

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	print "<tr><td>", $FontFace, $FontSize;
	print "Check all topics to delete. All subtopics of the selected topic ";
	print "will also be deleted. All messages in deleted topics will be ";
	print "deleted.<br>&nbsp;";
	print "</td></tr>\n";
	
	print "<tr><td>";
	print $FontFace, $FontSize;	

	&printsubjectlist($Subject);
	
	print "<br>&nbsp;</td></tr>\n";

	print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";

	print "<tr><td>", $FontFace, $FontSize;	
	if ($Demo) {
		print $BtnFormDelDemo;
	} else {
		print $BtnFormDel;
	}
	print "</td></tr>\n";
	
	print "</table>\n";
	
	if ($dorefresh) {
		print "<script language=javascript>\n";
		print "parent.subjectmenu.document.location.reload();\n";
		print "</script>\n";
	}
	
	print "</form>\n";
	print "</body></html>\n";
	
# End of data processing
#
##########################################################	

} elsif ($func eq "menu") {

	#####################################################
	# Class chosen, but no subject. Print list of subjects
	#####################################################

	$Class = $CGIQuery->param('fid');
	@selected = $CGIQuery->param('selected');
	$selleng = @selected;
	$BtnSelected = @selected[$selleng - 1];
	
	$helplink = "file=TopicDeleteCORP_Admin.html&anchor=DeleteTopicTskFSummary";
	$helplink .= "&helptitle=Delete%20Topics%20Task%20Frame";
	&showHeaderBackHTML("Delete Topics for $CorF - $Class", 
		"", 0, 1, 0, $helplink);

	# Start Form
	print "<form action=$CGIEnvScript method=GET target=subjectdel>\n";
	print "<input type=hidden name=func value=showdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";

	# Spacer Row
	# print "<tr><td colspan=2>$ImgClear88</td></tr>\n\n";
	print $ImgIndentSmall, "<br>\n";
	
	# Print form
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr><td valign=middle align=right>";
	print $FontFace, $FontSize, $ImgClear88;
	print "<select name=tid size=4>\n";
	
	# Get the list of existing subjects
	@ls = &gettopsubjectlist($Subject);
	
	# Put the list of subjects in the selection box
	for ($i=0; $i < @ls; $i++) {
		print "<option value=\"", @ls[$i], "\"";
		if ($BtnSelected eq @ls[$i]) {
			print " SELECTED";
		}
		print "> ";
		print &printPretty(&unEscapeTopic(@ls[$i])), "\n";
	}
	
	print "</select></td>";
	print "<td align=left valign=middle>", $FontSize, $FontFace;
	print $BtnFormSubmit;
	print "</td>\n";
	
	print "<td><img src=images/cleardot.gif width=5 height=20 align=top>";
	print "</td><td valign=middle>";
	print $FontFace, $FontSize, "Choose a topic to display ";
	print "it and its subtopics. You will then be able to select individual ";
	print "topics for deletion.</td>\n";
	print "</tr>\n\n";

	print "</table>\n";
	print "</form>\n";
	
} elsif ($func eq "nothing" || $func eq "showdel") {

########
#
# No data submitted

	# User input nothing, tell them to select something
	
	&printEmptyTaskFrame("Please choose a Topic above.");
	
} else {

	# Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Forum User Editing</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=subjectmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=subjectdel src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}


#
########

sub printsubjectlist {
	local($Subject) = @_;
	local(@match, $match, $status, $dbfile, $DB_Key, $k, $i, $count);

	# Start a table
	print "<table border=0 cellpadding=0 cellspacing=0>\n";

	# Get the listing from the database
	
	$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;

	@match = split(//, $Subject);
	for ($i=0; $i < @match; $i++) {
		@match[$i] =~ s/([^a-zA-Z0-9-_])/\\$1/g;
	}
	$match = join("", @match);

	$count = 0;

	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, $posttime, $nicename, $indents, $subdirs, $parent, $allowpost, $posts) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
			exit();
		}

		if ($DB_Key eq $Subject || $DB_Key =~ /^$match\//) {
			$count++;
	
			print "<tr>";
			print "<td valign=top>", $FontFace, $FontSize;
			
			# Print a spacer for the margin
			print $ImgClear88;
		
			# Print the indents
			for ($k=0; $k < $indents; $k++) {
				print $ImgClear88;
			}
		
			if ($subdirs ne "" && $subdirs == 1) {
				print $BtnExpanded;
			} else {
				print $IcoNoReplies;
			}
		
			print $ImgIndentSmall;
			print $nicename;
			print "<input type=checkbox name=delsubject value=\"$DB_Key\">";
			print "</td></tr>\n";
		}
	}
	
	if ($count == 0) {
		print "<tr>";
		print "<td valign=top>", $FontFace, $FontSize2;
		print "<b>No subtopics found in ", &printPretty(&unEscapeTopic($Subject)), "</b>";
		print "</td></tr>\n";
	}
	
	print "</table>\n\n";
}

sub dosubconf {
	@qnames = $CGIQuery->param;

	$helplink = "file=TopicDeleteCORP_Admin.html&anchor=DeleteTopicEdtFSummary";
	$helplink .= "&helptitle=Delete%20Topics%20Editing%20Frame";
	&showHeaderBackHTML("Are you sure?", "", 0, 0, 0, $helplink);
	
	print $FontFace,$FontSize;
	
	print "<form action=$CGIEnvScript method=POST>\n";
	
	print "$FontRed Are you sure you ";
	print "want to delete the following topics? </font>";
	print "<ul>";
	for ($i=0; $i < @delsubject; $i++) {
		print "<li>";
		print "<input type=hidden name=delsubject value=\"";
		print @delsubject[$i], "\" checked>\n";
		&printHdrTxtPretty(&unEscapeTopic(@delsubject[$i]));
		print "</li>\n";
	}
	print "</ul><p>";

	print "<input type=hidden name=func value=showdel>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=tid value=\"$Subject\">\n";
	print "&nbsp;&nbsp;<input type=radio name=confirm value='YES'> Yes &nbsp;\n";
	print "<input type=radio name=confirm value='NO'> No<br>\n";
	
	print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
	print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	print "</table>\n";
	
	print $BtnFormSubmit;
	print "\n</form>\n";
}
