#!/usr/bin/perl

###############################################################################
#
# _AFEdSubjPost.cgi - Allow/disallow posting to topics
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdSubjPost.cgi,v 1.33.2.2 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "T_Init.pl";

$Class = $CGIQuery->param('fid');
$Subject = $CGIQuery->param('tid');
$Subject =~ s/ /\+/g;

@perm = $CGIQuery->param('perm');
for ($i=0; $i < @perm; $i++) {
	@perm[$i] =~ s/ /\+/g;
	$addperm{@perm[$i]} = 1;
}
@perm = &unique(@perm);

@reply = $CGIQuery->param('reply');
for ($i=0; $i < @reply; $i++) {
	@reply[$i] =~ s/ /\+/g;
	$addreply{@reply[$i]} = 1;
}
@reply = &unique(@reply);

@over = $CGIQuery->param('override');
for ($i=0; $i < @over; $i++) {
	@over[$i] =~ s/ /\+/g;
	$addover{@over[$i]} = 1;
}
@over = &unique(@over);

$alltopics = $CGIQuery->param('alltopics');

$func = $CGIQuery->param('func');

&lookupClass;
&lookupUser($CGIEnvUser);

&loadColors($ColorQueryString);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if (($func eq "showedit" || $func eq "doperms") && $Subject ne "") {
	# Class and subject chosen, print out deleting page.
	local($value);
	
	if ($func eq "doperms") {
		# Permissions changes submitted
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
		
		# Make a list of the subjects submitted
		@allsub = split(/\,/, $alltopics);
		
		@allsub = &unique(@allsub);
		
		# Set the value for permissions on all submitted topics
		for ($i=0; $i < @allsub; $i++) {
			$sub = @allsub[$i];
			
			if ($addperm{$sub} == 1 && $addreply{$sub} == 1) {
				$set{$sub} = "all";
			} elsif ($addperm{$sub} == 1 && $addreply{$sub} != 1) {
				$set{$sub} = "post";
			} elsif ($addperm{$sub} != 1 && $addreply{$sub} == 1) {
				$set{$sub} = "reply";
			} elsif ($addperm{$sub} != 1 && $addreply{$sub} != 1) {
				$set{$sub} = "nopost";
			}
			if ($addover{$sub} == 1 && $set{$sub} ne "all") {
				$set{$sub} .= ":override";
			}
		}

		$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
		
		# Turn on signal Handling
		$trapSignals = 1;
		
		for ($i=0; $i < @allsub; $i++) {
			$DB_Key = @allsub[$i];
			
			($key, $time, $prettysub, $ImgIndents, $subdirs, $parent, $allowpost, $posts) = split(/\t/, `$prtDB $dbfile -tbtree -k \"$DB_Key\"`);

			$status = &dbErrorCheck($?, $key);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to read from Topics database: $dbfile.");
				exit();
			}

			# Modify allowpost, if it is not already set.
			if ($allowpost ne $set{$DB_Key}) {
				push(@modified, $DB_Key);
			
				$allowpost = $set{$DB_Key};
				$value = "$time\\t" . $prettysub . "\\t$ImgIndents\\t$subdirs\\t" . $parent . "\\t$allowpost\\t$posts";

				# Put in the changed record
				@retval = `$setDB $dbfile -tbtree -q -k \"$DB_Key\" -d \"$value\"`;
				$status = &dbErrorCheck($?, @retval[0]);
				if ($status) {
					&showErrorHTML("$status<p>Unable to write to Topics database: $dbfile. Check file permissions and try again.");
					exit();
				}
			}
		}
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}

	}
	
	########################
	# Print out the web page
	########################

	$header = "Change Posting Permissions for Topics in " . &printPretty(&unEscapeTopic($Subject));
	
	$helplink = "file=TopicEditPostPermissionCORP_Admin.html";
	$helplink .= "&anchor=EditPostPermissionEdtFSummary";
	$helplink .= "&helptitle=Topics%20Posting%20Permissions%20Editing%20Frame";
	&showHeaderBackHTML("$header","", 0, 0, 0, $helplink);
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=tid value=\"$Subject\">\n";
	print "<input type=hidden name=func value=\"doperms\">\n";

	print "<table cellpadding=0 cellspacing=1 border=0>\n";
	
	# Show the user the changes made.
	if (@modified > 0) {
		print "<tr><td valign=top nowrap>", $FontFace, $FontSize, $ImgClear88;
		print "<font color=#e31616>Permissions have been changed for:</td>\n";
		print "<td width=80% nowrap>";
		print $FontFace, $FontSize;
		for ($j=0; $j < @modified; $j++) {
			if ($j > 0) { print "<br>";}
			print &printPretty(&unEscapeTopic(@modified[$j]));
		}
		print "<br>&nbsp;</td></tr>\n";
	}
	
	print "<tr><td colspan=2>", $FontFace, $FontSize, $ImgClear88;
	print "Check to give permissions, uncheck to remove.";
	print "</td></tr>\n";
	
	# Spacer Row
	print "<tr><td colspan=2>$ImgClear88</td></tr>\n\n";
	
	print "<tr><td colspan=2>";
	print $FontFace, $FontSize;	
	# Get subjects - Now a subroutine!!!
	&printsubjectlist($Subject);
	
	print "<br>&nbsp;</td></tr>\n";
	
	print "<tr><td bgcolor=$FTheaderback colspan=2>", $FontFace, $FontSize;	
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";

	print "<tr><td colspan=2>", $FontFace, $FontSize;	
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</td></tr>\n";
	
	print "</table>\n";
	
	print "</form>\n";
	print "</body></html>\n";
	
# End of data processing
#
##########################################################	

} elsif ($func eq "menu") {

	#####################################################
	# Class chosen, but no subject. Print list of subjects
	#####################################################

	$Class = $CGIQuery->param('fid');
	@selected = $CGIQuery->param('selected');
	$selleng = @selected;
	$BtnSelected = @selected[$selleng - 1];
	
	$helplink = "file=TopicEditPostPermissionCORP_Admin.html";
	$helplink .= "&anchor=EditPostPermissionTskFSummary";
	$helplink .= "&helptitle=Topics%20Posting%20Permissions%20Task%20Frame";
	&showHeaderBackHTML("Change Posting Permissions for $CorF - $Class",
		"", 0, 1, 0, $helplink);

	# Start Form
	print "<form action=$CGIEnvScript method=GET target=subjectperm>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=func value=showedit>\n\n";

	print $ImgIndentSmall, "<br>\n";
	
	# Print form
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr><td valign=middle align=right>";
	print $FontFace, $FontSize, $ImgClear88;
	print "<select name=tid size=4>\n";
	
	# Get the list of existing subjects
	@ls = &gettopsubjectlist($Subject);
	
	# Put the list of subjects in the selection box
	for ($i=0; $i < @ls; $i++) {
		print "<option value=\"", @ls[$i], "\"";
		if ($BtnSelected eq @ls[$i]) {
			print " SELECTED";
		}
		print "> ";
		print &printPretty(&unEscapeTopic(@ls[$i])), "\n";
	}
	
	print "</select></td>";
	print "<td valign=middle align=left>", $FontSize, $FontFace;
	print $BtnFormSubmit;
	print "</td>\n";
	
	print "<td><img src=images/cleardot.gif width=5 height=20 align=top>";
	print "</td><td>";
	print "$FontFace $FontSize Choose a topic to change posting permissions ";
	print "for it and any of its subtopics.";
	print "</td>\n</tr>\n\n";

	print "</table>\n";
	print "</form>\n";
	
} elsif ($func eq "nothing" || ($func eq "showedit" && $Subject eq "")) {

########
#
# No data submitted

	# User input nothing, tell them to select something
	
	&printEmptyTaskFrame("Please choose a Topic above.");
	
} else {
	# Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Topic Posting Permissions</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=subjectmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=subjectperm src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

#
########

sub printsubjectlist {
	local($Subject) = @_;
	local($i);

	# Start a table
	print "<table border=0 cellpadding=1 cellspacing=0>\n";
			
	# Header row.
	print "<tr>";
	print "<td>$ImgClear88</td>\n";
	print "<td valign=middle bgcolor=$FCheaderback>", $FontFace, $FontSize;
	print "<font color=$FCheadertext>";
	print "<b>Topic</b>&nbsp;&nbsp;";
	print "</font></font></font></td>\n";
	print "<td valign=middle bgcolor=$FCheaderback>", $FontFace, $FontSize;
	print "<font color=$FCheadertext>";
	print "<b>Allow Post</b>&nbsp;&nbsp;";
	print "</font></font></font></td>\n";
	print "<td valign=middle bgcolor=$FCheaderback>", $FontFace, $FontSize;
	print "<font color=$FCheadertext>";
	print "<b>Allow Reply</b>&nbsp;&nbsp;";
	print "</font></font></font></td>\n";
	print "<td valign=middle bgcolor=$FCheaderback>", $FontFace, $FontSize;
	print "<font color=$FCheadertext>";
	print "<b>Admin/$ForM Override</b>&nbsp;&nbsp;";
	print "</font></font></font></td>\n";
	print "</tr>\n\n";

	# Get the listing from the database
	
	$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
	
	@match = split(//, $Subject);
	for ($i=0; $i < @match; $i++) {
		@match[$i] =~ s/([^a-zA-Z0-9-_])/\\$1/g;
	}
	$match = join("", @match);
	
	$alltopics = "";
	
	# Loop through each db entry
	$i = 0;

	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, $posttime, $nicename, $ImgIndents, $subdirs, $parent, $allowpost, $posts) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
			exit();
		}
		
		if ($DB_Key eq $Subject || $DB_Key =~ /^$match\//) {
			$alltopics .= $DB_Key . ",";
	
			print "<tr>";
			
			# Spacer column
			print "<td>$ImgClear88</td>\n";
			
			print "<td valign=middle";
			if (!($i % 2)) {
				print " bgcolor=", $FCmsghilight;
			}
			print ">", $FontFace, $FontSize;
			
			# Print a spacer for the margin
			# print $ImgClear88;
		
			# Print the indents
			for ($k=0; $k < $ImgIndents; $k++) {
				print $ImgClear88;
			}
		
			if ($subdirs) {
				print $BtnExpanded;
			} else {
				print $IcoNoReplies;
			}
		
			print $ImgIndentSmall;
			if ($ImgIndents == 0) {
				print "<b>";
			}
			print $nicename;
			if ($ImgIndents == 0) {
				print "</b>";
			}
			
			print "</td>\n";
			
			# Allow Post
			print "<td valign=middle";
			if (!($i % 2)) {
				print " bgcolor=", $FCmsghilight;
			}
			print ">", $FontFace, $FontSize;
			print "<input type=checkbox name=perm value=\"$DB_Key\"";
			if ($allowpost eq "all" || $allowpost eq "1" || $allowpost eq "" 
					|| $allowpost =~ /^post/i) {
				print " checked";
				$origperm .= $DB_Key . ",";
			} else {
				$orignoperm .= $DB_Key . ",";
			}
			print ">";
			print "</td>\n";
			
			# Allow Reply
			print "<td valign=middle";
			if (!($i % 2)) {
				print " bgcolor=", $FCmsghilight;
			}
			print ">", $FontFace, $FontSize;
			print "<input type=checkbox name=reply value=\"$DB_Key\"";
			if ($allowpost eq "all" || $allowpost eq "1" || $allowpost eq "" 
					|| $allowpost =~ /reply/i) {
				print " checked";
				$origreply .= $DB_Key . ",";
			} else {
				$orignoreply .= $DB_Key . ",";
			}
			print ">";
			print "</td>\n";
			
			# Override
			print "<td valign=middle";
			if (!($i % 2)) {
				print " bgcolor=", $FCmsghilight;
			}
			print ">", $FontFace, $FontSize;
			print "<input type=checkbox name=override value=\"$DB_Key\"";
			if ($allowpost =~ /\:override/i) {
				print " checked";
				$origover .= $DB_Key . ",";
			} else {
				$orignoover .= $DB_Key . ",";
			}
			print ">";
			print "</td>\n";
			
			print "</tr>\n\n";
			
			$i++;
		}
	}

	print "</table>\n\n";
	
	chop($alltopics);
	print "<input type=hidden name=alltopics value=\"", $alltopics, "\">\n";
}

