#!/usr/bin/perl

###############################################################################
#
# _AFEdSubjBatch.cgi - Change list of Topics for the forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdSubjBatch.cgi,v 1.25.2.2 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "T_Init.pl";

$Class = $CGIQuery->param('fid');
$func = $CGIQuery->param('func');

&lookupClass;

&loadColors($ColorQueryString);

if ($CGIEnvUser eq "") {
	&showErrorBackHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupUser($CGIEnvUser);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

$BodyTag = &makeBodyTag("Content");

###############################################################################
#
# Process submitted data

if ($func eq "doedit") {
	$subjects = &cleanTabs($CGIQuery->param('subjects'));
	
	&showHeaderBackHTML("Batch Topic Editing", "<br>");
	
	if ($subjects !~ /\n/ && $subjects =~ /\r/) {
		@subjects = split(/\r/, $subjects);
	} else {
		@subjects = split(/\n/, $subjects);
	}
	
	# Process subject list into the database format.
	for ($l=0; $l < @subjects; $l++) {
		@subjects[$l] =~ s/\s+$//g;
		@subjects[$l] = &replaceNonAlpha(@subjects[$l]);
		if (@subjects[$l] =~ /^(-+)/) {
			# a child
			$level = length($1);
			@subjects[$l] =~ s/^-+//;
			
			while (length(@subjects[$l]) > $MAX_TOPIC_LENGTH) {
				chop(@subjects[$l]);
			}
			
			@parents[$level] = @subjects[$l];
			splice(@parents, $level + 1);
			$newsub = "";
			for ($k=0; $k < $level; $k++) {
				$newsub = $newsub . @parents[$k] . "/";
			}
			@subjects[$l] = $newsub . @subjects[$l];
		} else {
			splice(@parents, 0);
			@parents[0] = @subjects[$l];
		}
	}
	
	@subjects = &unique(@subjects);
	
	$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	for ($l=0; $l < @subjects; $l++) {
		$key = @subjects[$l];
		$newloc = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . @subjects[$l];

		if (-e $dbfile) {
			($dkey, @value) = split(/\t/, `$prtDB $dbfile -tbtree -k \"$key\"`);
			$status = &dbErrorCheck($?, $dkey);
		} else {
			$dkey = "";
		}
		
		if ($dkey eq "") {
			if (! -e $newloc) {
				if (!mkdir($newloc, 0775)) {
					print "Unable to create directory $newloc. Check ";
					print "directory permissions and try again.<br>\n";
				}
			}
			
			# Add it to the database
   			$prettysub = $key;
			$prettysub =~ s/_/ /g;
			$prettysub =~ s/.*\///;
			$parent = $key;
			if ($parent !~ /\//) {
				$parent = "";
			} else {
				$parent =~ s/\/[^\/]+$//;
			}
			@getindents = split(/\//, $parent);
			$ImgIndents = @getindents;
			
   			$value = "0\\t$prettysub\\t$ImgIndents\\t0\\t$parent\\tall\\t0";
			
			@retval = `$setDB $dbfile -tbtree -q -k \"$key\" -d \"$value\"`;
			$status = &dbErrorCheck($?, @retval[0]);
			if ($status) {
				print "$status<p>Unable to write to $dbfile. ";
				print "Check file permissions and try again.";
				exit();
			}
			
			# Update subdirs for the parent
			if ($parent ne "") {
				($dkey, @getvalues) = split(/\t/, `$prtDB $dbfile -tbtree -k \"$parent\"`);
				$status = &dbErrorCheck($?, $dkey);
				
				if ($status) {
					print "<p>$status<p>Cannot get parent topic: $parent from $dbfile<br>\n";
				} else {
					@getvalues[3] = 1;
					$value = join("\\t", @getvalues);
				
					@retval = `$setDB $dbfile -tbtree -q -k \"$parent\" -d \"$value\"`;
					$status = &dbErrorCheck($?, @retval[0]);
					if ($status) {
						print "<p>$status<p>Unable to write to Topics database: $dbfile. Check permissions and try again";
						exit();
					}
				}
			}
		}
	}
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	print "Finished adding Topics.<p>\n";
	
	&printsubjectlist;

# End of data processing
#
###############################################################################

} elsif ($func eq "preview") { 
	$subjects = $CGIQuery->param('subjects');
	
	&showHeaderBackHTML("Topic Editing Preview", "<br>");

	print "<table border=0 cellpadding=0 cellspacing=0>\n";
	
	if ($subjects !~ /\n/ && $subjects =~ /\r/) {
		@subjects = split(/\r/, $subjects);
	} else {
		@subjects = split(/\n/, $subjects);
	}
	for ($l=0; $l < @subjects; $l++) {
		@subjects[$l] =~ s/\s+$//g;
		@subjects[$l] = &replaceNonAlpha(@subjects[$l]);
		
		print "<tr>";
		print "<td valign=top>", $FontFace, $FontSize;
			
		# Print a spacer for the margin
		print $ImgClear88;
		
		if (@subjects[$l] =~ /^(-+)/) {
			# a child
			$dashes = $1;
			$level = length($dashes);
			@subjects[$l] =~ s/^-+//;
			
			while (length(@subjects[$l]) > $MAX_TOPIC_LENGTH) {
				chop(@subjects[$l]);
			}
			
			# Print the indents
			for ($k=0; $k < $level; $k++) {
				print $ImgClear88;
			}

			if (@subjects[$l + 1] =~ /-$dashes/) {
				print $BtnExpanded;
			} else {
				print $IcoNoReplies;
			}
		} else {
			if (@subjects[$l + 1] =~ /-/) {
				print $BtnExpanded;
			} else {
				print $IcoNoReplies;
			}
		}
		
		print $ImgIndentSmall;
		$prettysub = @subjects[$l];
		$prettysub =~ s/_/ /g;
		print $prettysub;
		print "</td></tr>\n";
	}
	
	print "</table><br>\n\n";
	
	print "<form onSubmit='return false'>\n";
	print "<input type=button value='Close Window' onClick='window.close()'>\n";
	print "</form>\n";

} else {

	#####################################################
	# Print list of subjects
	#####################################################

	&showHeaderBackHTML("Batch Topic Editing", "<br>");
	
	print "This method of adding topics should only be used by advanced ";
	print "users.\n You can not delete topics through this interface. \n";
	print "Topics to be added can be added anywhere in the existing \n";
	print "hierarchy. Dashes (-) are used to denote lower levels in the \n";
	print "hierarchy. Multiple dashes are used to create lower sublevels. \n";
	print "Please use the preview button to check your additions before ";
	print "submitting.<br>\n";

	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=func value=doedit>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";
	
	# Print form
	print "<table cellpadding=3 cellspacing=0 border=0 width=100%>\n";
	
	print "<tr><td valign=middle>";
	print $FontFace, $FontSize;
	print "<textarea name=subjects rows=35 cols=70>";
	
	# Get the list of existing subjects
	&printAllSubjectsForm;
	
	print "</textarea></td></tr>";
	
	print "<tr><td>", $FontSize, $FontFace;
	print "<a href=javascript:previewWin()>$BtnFormPreview</a> ";
	print $BtnFormSubmit;
	print "</td></tr>\n\n";

	print "</table>\n";
	print "</form>\n";
	
	print "<script language=javascript>\n";
	print "<!--\n";
	print "function previewWin(){\n";
	print "	var F = document.forms[0];\n";
	print "	var loc = F.action + '?';\n";
	print "	loc += 'fid=' + '$Class';\n";
	print "	loc += '\&func=preview';\n";
	print "	loc += '\&subjects=' + escape(F.subjects.value);\n";

	print "	var options = 'location=0,toolbar=0,menubar=0,resizable=1,scrollbars=1,width=300,height=400';\n";
	print "	preWin = window.open(loc, 'preWin', options);\n";
	print "}\n";
	print "// -->\n";
	print "</script>\n";
}

#
########

sub printAllSubjectsForm {

	# Get the listing from the database
	
	$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
	
	if (! -e $dbfile) {
		return;
	}

	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, $posttime, $nicename, $ImgIndents, $subdirs, $parent, $posts) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		
		if (! $status) {
			# Print the indents
			for ($k=0; $k < $ImgIndents; $k++) {
				print "-";
			}

			print $nicename, "\n";
		}
	}
}

sub printsubjectlist {
		
	$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
	if (! -e $dbfile) {
		return;
	}

	# Start a table
	print "<table border=0 cellpadding=0 cellspacing=0>\n";

	# Get the listing from the database

	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, $posttime, $nicename, $ImgIndents, $subdirs, $parent, $posts) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
			exit();
		}
	
		print "<tr>";
		print "<td valign=top>", $FontFace, $FontSize;
			
		# Print a spacer for the margin
		print $ImgClear88;
		
		# Print the indents
		for ($k=0; $k < $ImgIndents; $k++) {
			print $ImgClear88;
		}
		
		if ($subdirs) {
			print $BtnExpanded;
		} else {
			print $IcoNoReplies;
		}
		
		print $ImgIndentSmall;
		print $nicename;
		print "</td></tr>\n";
	}
	
	print "</table>\n\n";
}
