#!/usr/bin/perl

###############################################################################
#
# _AAViewOne.cgi - Delete Announcements
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AAViewOne.cgi,v 1.14.2.2 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

###############################################################################
#
# Process submitted data

$Class = $CGIQuery->param('fid');
$func = $CGIQuery->param('func');
$section = $CGIQuery->param('group');
$msgid = $CGIQuery->param('mid');

if ($Class eq "") {
	&showErrorHTML("$CorF not specified");
	exit();
}
	
&lookupClass;
	
&loadColors($ColorQueryString);

if ($CGIEnvUser eq "") {
	&showErrorBackHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupUser($CGIEnvUser);

&checkCookieGuest($CGIEnvUser, $C_authtype);

$BodyTag = &makeBodyTag("Content");

# Get the post

$anndbfile = $DBFILE_ANNPRE . $C_Sects{$section}{"num"} . ".db";
$dbfile = "$C_rootpath/$DIR_CLASSANNOUNCE/$anndbfile";

($key, $value) = split(/\t/, `$prtDB $dbfile -tbtree -q -k \"$msgid\"`);
$value = &UnEscape($value);

$status = &dbErrorCheck($?, $key);
if ($status) {
	&showErrorBackHTML("$status<p>Unable to read Announcement with ID $msgid from $dbfile. Specified Announcement does not exist.");
	exit();
}

($posterid, $posteremail, $postclass, $anntype, $unknown, $title, $content) = split(/\t/, $value);

$pdate = &formatDate($msgid);

$head = "Announcement: $title for " . $C_Sects{$section}{"name"};

&showHeaderBackHTML("$head");

print "<table border=0 width=100% cellpadding=0>\n";
print "<tr><td background=$ImgSrcTableBg>", $FontFace, $FontSize2;
print "Sent by <a href=\"mailto:$posteremail\">", $ImgIndent;
print "<i>$posterid</i></a>", $ImgIndent;
print "<i><b>$pdate</b></i>", $ImgIndent;
print "</td></tr>\n";
print "<tr><td width=100% align=left>", $FontFace, $FontSize2, $FontRed;
print "<b>$title</b></font></font></td></tr>\n";
print "<tr><td width=100%>", $FontFace, $FontSize2;
print "$content</font></font></td></tr>\n";
print "</table>\n";
