#!/usr/bin/perl

###############################################################################
#
# FHexToRGB.pl - RGB to Hex converter
#	Largely based on Rob Malda's code at http://cmdrtaco.net/color.shtml
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: FHexToRGB.cgi,v 1.9.2.2 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";

$Class = $CGIQuery->param('fid');
$color = $CGIQuery->param('color');

if ($Class eq "") {
	$ColorQueryString = &lookupColors(1);
} else {
	&lookupClass;
}
&loadColors($ColorQueryString);

if ($color eq "") {
	$color = "#FFFFFF";
}

$BodyTag = "<body bgcolor=$color marginwidth=0 marginheight=0 leftmargin=0 topmargin=0 onLoad=\"hexToRGB()\">";

$helplink = "file=ColorSchemeCORP_Admin.html";
$helplink .= "&anchor=ColorPickerSummary";
$helplink .= "&helptitle=Hex%20to%20RGB";

&showHeaderBackHTML("Hex --&gt; RGB --&gt; Hex", "<br>", 0, 0, 0, $helplink);

&printJavascript;

$Font = $FontSize . $FontFace;

print <<end_print;

<script language="JavaScript">
<!--

tohex = new Array;
for(var i = 0; i < 10; i++) {
	tohex[i] = i;
}
tohex[10] = "A"; 
tohex[11] = "B";
tohex[12] = "C";
tohex[13] = "D";
tohex[14] = "E";
tohex[15] = "F";

torgb = new Array;
for(var i = 0; i < 10; i++) {
	torgb[i] = i;
}
torgb["A"] = 10; 
torgb["B"] = 11;
torgb["C"] = 12;
torgb["D"] = 13;
torgb["E"] = 14;
torgb["F"] = 15;

function hex(i) {
	if (i < 0) {
		return "00";
	} else if (i > 255) {
		return "FF";
	}
	
	return "" + tohex[Math.floor(i/16)] + tohex[i%16];
}

function hexToRGB() {
	var f = document.forms[0];
	var code = f.hexcode.value;
	code = code.toUpperCase();
	if (code.indexOf("#") == 0) {
		code = code.substring(1, code.length);
	}
	var r1 = code.substring(0,1);
	var r2 = code.substring(1,2);
	var g1 = code.substring(2,3);
	var g2 = code.substring(3,4);
	var b1 = code.substring(4,5);
	var b2 = code.substring(5,6);
	
	var r = (torgb[r1] * 16) + torgb[r2];
	var g = (torgb[g1] * 16) + torgb[g2];
	var b = (torgb[b1] * 16) + torgb[b2];
	
	f.r.value = r;
	f.g.value = g;
	f.b.value = b;
	
	document.bgColor = "#" + code;
	convDn();
}

function RGBToHex() {
	var f = document.forms[0];
	var hr = hex(f.r.value);
	var hg = hex(f.g.value);
	var hb = hex(f.b.value);
	f.hexcode.value = "#" + hr + hg + hb;
	
	document.bgColor = "#" + hr + hg + hb;
	convDn();
}

function convUp() {
	document.images[3].src = "images/ConvertUp.gif";
}

function convDn() {
	document.images[3].src = "images/ConvertDn.gif";
}

// -->

</script>

<form>
<table border=0 cellpadding=0 cellspacing=5>
<tr>
	<td valign=bottom>$Font<b>&nbsp;Red&nbsp;</b></td>
	<td valign=bottom>$Font<b>&nbsp;Green&nbsp;</b></td>
	<td valign=bottom>$Font<b>&nbsp;Blue&nbsp;</b></td>
	<td valign=bottom>$Font &nbsp;</td>
	<td valign=bottom>$Font<b>&nbsp;Hex Value&nbsp;</td>
	<td valign=bottom>$Font &nbsp;</td>
</td>
<tr>
	<td>$Font
	<input type=name name=r size=4 value=255 maxlength=3 onChange="RGBToHex()" onFocus="convUp()">
	</td>

	<td>$Font
	<input type=name name=g size=4 value=255 maxlength=3 onChange="RGBToHex()" onFocus="convUp()">
	</td>
	<td>$Font
	<input type=name name=b size=4 value=255 maxlength=3 onChange="RGBToHex()" onFocus="convUp()">
	</td>
	<td>$Font
end_print

if ($color eq "") {
	print "<a href=\"#\" onClick=\"RGBToHex()\">$BtnConvertUp</a>\n";
} else {
	print "<a href=\"#\" onClick=\"RGBToHex()\">$BtnConvertDn</a>\n";
}
	
print <<end_print;
	</td>
	<td>$Font
	<input type=name name=hexcode size=8 value="$color" maxlength=7 onChange="hexToRGB()" onFocus="convUp()">
	</td>
	<td>$Font
	<a href="#" onClick="window.opener.parent.showColor(document.forms[0].hexcode.value)">$BtnCopyPickerLarge</a>
	</td>
</tr>

</table>

<a href="#" onClick="window.close()">$BtnClose</a>


</form>

</body>
</html>

end_print
