// StartIsolated.cpp : Defines the entry point for the console application.
//
/* 
Using: StartIsolated <CPU> <Cmd>
<CPU> cpu id 0|1
<cmd> commandline to start prg
*/
#include "stdafx.h"

int checkArg(int argc, char* argv[], int* cpuid, char** cmd)
{
	int i,l = 0;
	if (argc < 3) return -1;	//malo argumentu
	*cpuid = (int)atoi(argv[1]);
	for ( i=2; i<argc; ++i)
	{
		l +=strlen(argv[i]);
		l++;
	}
	l++;
	*cmd = (char*)malloc(l);
	*(cmd[0]) = '\0';
	for ( i=2; i<argc; ++i)
	{
		strcat( *cmd, argv[i] );
		strcat( *cmd, " " );
	}
	
	return 0;		// OK
}

BOOL SetPrivilege(
				  HANDLE hToken,          // access token handle
				  LPCTSTR lpszPrivilege,  // name of privilege to enable/disable
				  BOOL bEnablePrivilege   // to enable or disable privilege
				  ) 
{
	TOKEN_PRIVILEGES tp;
	LUID luid;
	
	if ( !LookupPrivilegeValue( 
        NULL,            // lookup privilege on local system
        lpszPrivilege,   // privilege to lookup 
        &luid ) ) {      // receives LUID of privilege
		printf("LookupPrivilegeValue error: %u\n", GetLastError() ); 
		return FALSE; 
	}
	
	tp.PrivilegeCount = 1;
	tp.Privileges[0].Luid = luid;
	if (bEnablePrivilege)
		tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
	else
		tp.Privileges[0].Attributes = 0;
	
	// Enable the privilege or disable all privileges.
	
	AdjustTokenPrivileges(
		hToken, 
		FALSE, 
		&tp, 
		sizeof(TOKEN_PRIVILEGES), 
		(PTOKEN_PRIVILEGES) NULL, 
		(PDWORD) NULL); 
	
	// Call GetLastError to determine whether the function succeeded.
	
	if (GetLastError() != ERROR_SUCCESS) { 
		printf("AdjustTokenPrivileges failed: %u\n", GetLastError() ); 
		return FALSE; 
	} 
	
	return TRUE;
}


HANDLE GetProcessHandle(DWORD ProcessId)
{
	HANDLE hProcess	= NULL;
	hProcess = OpenProcess (PROCESS_QUERY_INFORMATION |
		PROCESS_VM_READ|PROCESS_SET_INFORMATION, FALSE, ProcessId);
	
    if (!hProcess)
	{
        HANDLE hToken;
		
        // enable SeDebugPrivilege
        if(OpenProcessToken(GetCurrentProcess(),
			TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken))
			
            if (SetPrivilege(hToken, SE_DEBUG_NAME, TRUE))
            {
				hProcess = OpenProcess (PROCESS_QUERY_INFORMATION |
					PROCESS_VM_READ|PROCESS_SET_INFORMATION, FALSE, ProcessId);
			}
			
            // close token handle
            CloseHandle(hToken);
    }
	return hProcess;
	
}

int main(int argc, char* argv[])
{
	int iCPUid = -1, err;
	char *cmd	= NULL;
	
	err = checkArg(argc,argv,&iCPUid, &cmd);
	
	if (err < 0) return err;
	/*
	*	continue to process enum and set affinity
	*/
	DWORD p_mask	= 1 << iCPUid;		// mask for new process
	
	// enum all process, store and change affinity
    DWORD aProcesses[1024], cbNeeded, cProcesses;
	DWORD aAffinity[1024], ProcessAffinityMask, SystemAffinityMask;
	HANDLE aHandles[1024];
    unsigned int i;
	DWORD newMask;
    if ( !EnumProcesses( aProcesses, sizeof(aProcesses), &cbNeeded ) )
        return -1;
	cProcesses = cbNeeded / sizeof(DWORD);
	for ( i = 0; i < cProcesses; i++ )
	{
		aHandles[i]	= GetProcessHandle(aProcesses[i]);
		if (aHandles[i] != NULL)
		{
			GetProcessAffinityMask(aHandles[i],&ProcessAffinityMask,
				&SystemAffinityMask);
			aAffinity[i]	= ProcessAffinityMask;
			newMask = SystemAffinityMask ^ p_mask;
			SetProcessAffinityMask(aHandles[i],newMask);
		}
	}
	
	
	/*
	*	start new process and set affinity
	*/
	STARTUPINFO StartupInfo;
    PROCESS_INFORMATION ProcessInformation;
	
	ZeroMemory(&StartupInfo, sizeof STARTUPINFO);
    StartupInfo.cb = sizeof STARTUPINFO;
	StartupInfo.wShowWindow = SW_NORMAL;
    ZeroMemory(&ProcessInformation, sizeof PROCESS_INFORMATION);
	
	CreateProcess(NULL, cmd, NULL, NULL, FALSE, 0, NULL, NULL, 
		&StartupInfo, &ProcessInformation);
	free(cmd);
	SetProcessAffinityMask(ProcessInformation.hProcess,p_mask);
	
    // Wait until child process exits.
    WaitForSingleObject( ProcessInformation.hProcess, INFINITE );
	
    // Close process and thread handles. 
    CloseHandle( ProcessInformation.hProcess );
    CloseHandle( ProcessInformation.hThread );
	/*
	*	set everyting back
	*/
	for ( i = 0; i < cProcesses; i++ )
	{
		if (aHandles[i] != NULL)
		{
			SetProcessAffinityMask(aHandles[i],aAffinity[i]);
		}
	}
	
	return 0;
}






















