/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin.marshal;

import com.develop.io.LittleEndianInputStream;
import com.develop.jawin.COMException;
import com.develop.jawin.GUID;
import com.develop.jawin.IdentityManager;
import java.io.IOException;

public class StructConverter {
    public static long parseLong(String string) {
        int n = string.length();
        if (n > 16) {
            throw new NumberFormatException("too many digits");
        }
        int n2 = 0;
        long l = 0L;
        int n3 = n - 1;
        while (n3 >= 0) {
            l += (long)Character.digit(string.charAt(n3), 16) << n2;
            n2 += 4;
            --n3;
        }
        return l;
    }

    public static int parseInt(String string) {
        int n = string.length();
        if (n > 8) {
            throw new NumberFormatException("too many digits");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n - 1;
        while (n4 >= 0) {
            n3 += Character.digit(string.charAt(n4), 16) << n2;
            n2 += 4;
            --n4;
        }
        return n3;
    }

    public static short parseShort(String string) {
        int n = string.length();
        if (n > 4) {
            throw new NumberFormatException("too many digits");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n - 1;
        while (n4 >= 0) {
            n3 += Character.digit(string.charAt(n4), 16) << n2;
            n2 += 4;
            --n4;
        }
        return (short)n3;
    }

    public static int longIntoBEBytes(long l, byte[] byArray, int n) {
        byArray[n++] = (byte)(l >>> 56);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 8);
        byArray[n++] = (byte)l;
        return n;
    }

    public static long bytesIntoLong(byte[] byArray, int n) {
        int n2 = StructConverter.bytesIntoInt(byArray, n);
        int n3 = StructConverter.bytesIntoInt(byArray, n + 4);
        return ((long)n3 << 32) + ((long)n2 & 0xFFFFFFFFL);
    }

    public static double bytesIntoDouble(byte[] byArray, int n) {
        double d = Double.longBitsToDouble(StructConverter.bytesIntoLong(byArray, n));
        return d;
    }

    public static boolean bytesIntoBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public static int bytesIntoInt(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        return n2;
    }

    public static int BEBytesIntoInt(byte[] byArray, int n) {
        int n2 = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 0] & 0xFF) << 24;
        return n2;
    }

    public static short bytesIntoShort(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
        return (short)n2;
    }

    public static int longIntoBytes(long l, byte[] byArray, int n) {
        byArray[n++] = (byte)l;
        byArray[n++] = (byte)(l >>> 8);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 56);
        return n;
    }

    public static int intIntoBytes(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 24);
        return n2;
    }

    public static int shortIntoBytes(short s, byte[] byArray, int n) {
        byArray[n++] = (byte)s;
        byArray[n++] = (byte)(s >>> 8);
        return n;
    }

    public static int byteArrayIntoBytes(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        return n + byArray.length;
    }

    public static String[] readStringArray(LittleEndianInputStream littleEndianInputStream) throws IOException {
        byte by = littleEndianInputStream.readByte();
        if (by == 0) {
            return null;
        }
        int n = littleEndianInputStream.readInt();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = littleEndianInputStream.readStringUnicode();
            ++n2;
        }
        return stringArray;
    }

    public static int[] readIntArray(LittleEndianInputStream littleEndianInputStream) throws IOException {
        byte by = littleEndianInputStream.readByte();
        if (by == 0) {
            return null;
        }
        int n = littleEndianInputStream.readInt();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = littleEndianInputStream.readInt();
            ++n2;
        }
        return nArray;
    }

    public static Object[] readObjectArray(LittleEndianInputStream littleEndianInputStream, GUID gUID) throws IOException, COMException {
        byte by = littleEndianInputStream.readByte();
        if (by == 0) {
            return null;
        }
        int n = littleEndianInputStream.readInt();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = IdentityManager.getCOMPtr(littleEndianInputStream, gUID);
            ++n2;
        }
        return objectArray;
    }
}

