/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin.win32;

import com.develop.io.LittleEndianInputStream;
import com.develop.io.LittleEndianOutputStream;
import com.develop.io.NakedByteStream;
import com.develop.jawin.COMError;
import com.develop.jawin.COMException;
import com.develop.jawin.FuncPtr;
import com.develop.jawin.marshal.GenericStub;
import com.develop.jawin.marshal.MarshalConstants;
import com.develop.jawin.marshal.SharedStubs;
import com.develop.jawin.marshal.StructConverter;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Registry
implements MarshalConstants {
    private static final FuncPtr fpOK;
    private static final FuncPtr fpQV;
    private static final FuncPtr fpCK;
    private static final FuncPtr fpCrK;
    private static final FuncPtr fpDK;
    private static final FuncPtr fpEnum;

    public static int OpenKey(int n, String string) throws IOException, COMException {
        return SharedStubs.invokeIGO(n, string, fpOK.getPeer(), 3);
    }

    public static int CreateKey(int n, String string) throws IOException, COMException {
        return SharedStubs.invokeIGO(n, string, fpCrK.getPeer(), 3);
    }

    public static void DeleteKey(int n, String string) throws IOException, COMException {
        SharedStubs.invokeIG_I(n, string, fpDK.getPeer(), 3);
    }

    public static String QueryStringValue(int n, String string) throws IOException, COMException {
        byte[] byArray = Registry.RawQueryValue(n, string);
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
        return littleEndianInputStream.readUnicodeSz(byArray.length / 2);
    }

    public static byte[] RawQueryValue(int n, String string) throws IOException, COMException {
        NakedByteStream nakedByteStream = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
        littleEndianOutputStream.writeInt(n);
        littleEndianOutputStream.writeStringUnicode(string);
        littleEndianOutputStream.writeInt(0);
        littleEndianOutputStream.writeInt(0);
        byte[] byArray = GenericStub.win32Invoke(fpQV.getPeer(), "IGIIkA:T7:L20n4", 24, littleEndianOutputStream.size(), nakedByteStream.getInternalBuffer(), null);
        int n2 = StructConverter.bytesIntoInt(byArray, 0);
        littleEndianOutputStream.writeInt(n2);
        byte[] byArray2 = GenericStub.win32Invoke(fpQV.getPeer(), "IGIIM" + n2 + "P4:T7:L16n" + n2, 24, littleEndianOutputStream.size(), nakedByteStream.getInternalBuffer(), null);
        return byArray2;
    }

    public static void CloseKey(int n) throws IOException, COMException {
        SharedStubs.invokeI_I(n, fpCK.getPeer(), 3);
    }

    public static String RegEnumKey(int n, int n2) throws Exception {
        byte[] byArray;
        NakedByteStream nakedByteStream = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
        int n3 = 520;
        littleEndianOutputStream.writeInt(n);
        littleEndianOutputStream.writeInt(n2);
        littleEndianOutputStream.writeInt(n3);
        try {
            byArray = GenericStub.win32Invoke(fpEnum.getPeer(), "IIM" + n3 + "I:T7:L8n" + n3, 16, 16, nakedByteStream.getInternalBuffer(), null);
        }
        catch (COMException cOMException) {
            if (cOMException.hresult == -2147024637) {
                return null;
            }
            throw cOMException;
        }
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
        return littleEndianInputStream.readUnicodeSz(byArray.length / 2);
    }

    static {
        try {
            fpOK = new FuncPtr("ADVAPI32.DLL", "RegOpenKeyW");
            fpQV = new FuncPtr("ADVAPI32.DLL", "RegQueryValueExW");
            fpCK = new FuncPtr("ADVAPI32.DLL", "RegCloseKey");
            fpCrK = new FuncPtr("ADVAPI32.DLL", "RegCreateKeyW");
            fpDK = new FuncPtr("ADVAPI32.DLL", "RegDeleteKeyW");
            fpEnum = new FuncPtr("ADVAPI32.DLL", "RegEnumKeyW");
        }
        catch (COMException cOMException) {
            throw new COMError("Unable to load registry entry points");
        }
    }
}

