/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin.tools;

import com.develop.jawin.tools.COMType;
import java.io.PrintStream;

public class COMSharedStubBuilder {
    public String decl;
    public String baseName;
    public String baseSig;
    public String methodIntro;
    public String methodInvoke;
    public String invokeClose;
    public String methodExit;
    public String methodClose;
    private int typeLength;
    private int typeIndex;
    private COMType[][] types;
    private boolean done;
    private int[] pos;

    public COMType[] getTypeArray(int n) {
        return this.types[n + this.typeIndex];
    }

    public COMType getTypeAtPos(int n) {
        return this.getTypeArray(n)[this.pos[n]];
    }

    public void buildStubs(COMType[][] cOMTypeArray, int n, PrintStream printStream, boolean bl) {
        this.types = cOMTypeArray;
        int n2 = n;
        while (n2 > 0) {
            this.buildDepth(n2, printStream, bl);
            ++this.typeIndex;
            --n2;
        }
    }

    public String getName(COMType cOMType, boolean bl) {
        return bl ? cOMType.nativeName : cOMType.name;
    }

    public String retval(boolean bl) {
        COMType cOMType = this.getTypeAtPos(this.pos.length - 1);
        if (cOMType.isOut) {
            return this.getName(cOMType, bl);
        }
        return "void";
    }

    public String returnStatement() {
        COMType cOMType = this.getTypeAtPos(this.pos.length - 1);
        if (cOMType.isOut) {
            return cOMType.returnStatement;
        }
        return "";
    }

    public void buildDepth(int n, PrintStream printStream, boolean bl) {
        if (n > 4) {
            throw new Error("too deep -- this would build a lot of stubs!");
        }
        System.out.println("//methods with " + n + " args");
        this.typeLength = this.types.length;
        this.pos = new int[n];
        this.done = false;
        while (!this.done) {
            printStream.print(this.decl);
            printStream.print(this.retval(bl));
            printStream.print(this.baseName);
            printStream.print(this.varName());
            printStream.print(this.baseSig);
            printStream.print(this.varSig(true, bl));
            if (bl) {
                printStream.print(this.replace(this.methodIntro, '%', new Integer(n + 1).toString()));
                printStream.print(this.preInvokeArgs());
                printStream.print(this.methodInvoke);
                printStream.print(this.listArgs(n));
                printStream.print(this.invokeClose);
                printStream.print(this.postInvokeArgs());
                printStream.print(this.methodExit);
                printStream.print(this.returnStatement());
            }
            printStream.print(this.methodClose);
            this.incPos();
        }
    }

    public void incPos() {
        int n = this.pos.length;
        while (n > 0) {
            int n2 = --n;
            this.pos[n2] = this.pos[n2] + 1;
            if (this.pos[n] < this.getTypeArray(n).length) break;
            this.pos[n] = 0;
            if (n != 0) continue;
            this.done = true;
        }
    }

    public String listArgs(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(", ").append("inv").append(n2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String varName() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.pos.length) {
            stringBuffer.append(this.getTypeAtPos((int)n).code);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String varSig(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.pos.length) {
            if (!this.getTypeAtPos((int)n).isOut) {
                if (n != 0 || bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getName(this.getTypeAtPos(n), bl2)).append(" arg").append(n);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String preInvokeArgs() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.pos.length) {
            stringBuffer.append(this.replace(this.getTypeAtPos((int)n).preInvoke, '%', new Integer(n).toString()));
            ++n;
        }
        return stringBuffer.toString();
    }

    public String postInvokeArgs() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.pos.length) {
            stringBuffer.append(this.replace(this.getTypeAtPos((int)n).postInvoke, '%', new Integer(n).toString()));
            ++n;
        }
        return stringBuffer.toString();
    }

    public String replace(String string, char c, String string2) {
        if (-1 != string2.lastIndexOf(c)) {
            throw new Error("cannot include match char in replacement string");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == c) {
                stringBuffer.replace(n, n + 1, string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

