/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.util;

import org.tritonus.TDebug;

public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private int m_nReadPos;
    private int m_nWritePos;
    private Trigger m_trigger;
    private boolean m_bOpen;

    public TCircularBuffer(int nSize, boolean bBlockingRead, boolean bBlockingWrite, Trigger trigger) {
        this.m_bBlockingRead = bBlockingRead;
        this.m_bBlockingWrite = bBlockingWrite;
        this.m_nSize = nSize;
        this.m_abData = new byte[this.m_nSize];
        this.m_nReadPos = 0;
        this.m_nWritePos = 0;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public void close() {
        this.m_bOpen = false;
    }

    public int availableRead() {
        return this.m_nWritePos - this.m_nReadPos;
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private int getReadPos() {
        return this.m_nReadPos % this.m_nSize;
    }

    private int getWritePos() {
        return this.m_nWritePos % this.m_nSize;
    }

    public int read(byte[] abData) {
        return this.read(abData, 0, abData.length);
    }

    public int read(byte[] abData, int nOffset, int nLength) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out("TCircularBuffer.read(): called.");
        }
        if (!this.m_bOpen) {
            return -1;
        }
        TCircularBuffer tCircularBuffer = this;
        synchronized (tCircularBuffer) {
            if (!this.m_bBlockingRead) {
                if (this.m_trigger != null && this.availableRead() < nLength) {
                    if (TDebug.TraceCircularBuffer) {
                        TDebug.out("TCircularBuffer.read(): executing trigger.");
                    }
                    this.m_trigger.execute();
                }
                nLength = Math.min(this.availableRead(), nLength);
            }
            int nRemainingBytes = nLength;
            while (nRemainingBytes > 0) {
                while (this.availableRead() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                int nAvailable = Math.min(this.availableRead(), nRemainingBytes);
                while (nAvailable > 0) {
                    int nToRead = Math.min(nAvailable, this.m_nSize - this.getReadPos());
                    System.arraycopy(this.m_abData, this.getReadPos(), abData, nOffset, nToRead);
                    this.m_nReadPos += nToRead;
                    nOffset += nToRead;
                    nAvailable -= nToRead;
                    nRemainingBytes -= nToRead;
                }
                this.notifyAll();
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("TCircularBuffer.read(): completed.");
            }
            int n = nLength;
            return n;
        }
    }

    public int write(byte[] abData) {
        return this.write(abData, 0, abData.length);
    }

    public int write(byte[] abData, int nOffset, int nLength) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out("TCircularBuffer.write(): called; nLength: ".concat(String.valueOf(String.valueOf(nLength))));
        }
        TCircularBuffer tCircularBuffer = this;
        synchronized (tCircularBuffer) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("TCircularBuffer.write(): entered synchronized block.");
            }
            if (!this.m_bBlockingWrite) {
                nLength = Math.min(this.availableWrite(), nLength);
            }
            int nRemainingBytes = nLength;
            while (nRemainingBytes > 0) {
                while (this.availableWrite() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                int nAvailable = Math.min(this.availableWrite(), nRemainingBytes);
                while (nAvailable > 0) {
                    int nToWrite = Math.min(nAvailable, this.m_nSize - this.getWritePos());
                    System.arraycopy(abData, nOffset, this.m_abData, this.getWritePos(), nToWrite);
                    this.m_nWritePos += nToWrite;
                    nOffset += nToWrite;
                    nAvailable -= nToWrite;
                    nRemainingBytes -= nToWrite;
                }
                this.notifyAll();
            }
            int n = nLength;
            return n;
        }
    }

    public static interface Trigger {
        public void execute();
    }
}

