/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.ID3v2FormatException;
import helliker.id3.MP3File;
import helliker.id3.MP3FileFilter;
import helliker.id3.PlaylistException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class Playlist
extends LinkedList {
    public static int WINAMP_FORMAT = 0;
    public static int MUSICMATCH_FORMAT = 1;
    private final String PLAYLIST_EXT = ".m3u";

    public void sort() {
        Collections.sort(this);
    }

    public void sort(Comparator comparator) {
        Collections.sort(this, comparator);
    }

    public void addDirectory(File file) throws IOException {
        this.addDirectory(file, true, true);
    }

    public void addDirectory(File file, boolean bl, boolean bl2) throws IOException {
        if (file.isDirectory()) {
            Object[] objectArray = file.listFiles(new MP3FileFilter(true));
            if (bl2) {
                Arrays.sort(objectArray);
            }
            MP3File mP3File = null;
            for (int i = 0; i < objectArray.length; ++i) {
                if (((File)objectArray[i]).isFile()) {
                    try {
                        mP3File = new MP3File((File)objectArray[i]);
                        this.add(mP3File);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!bl) continue;
                this.addDirectory((File)objectArray[i], bl, bl2);
            }
        } else {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Error loading playlist from a directory: ").append(file.getAbsolutePath()).append(" is not a ").append("directory"))));
        }
    }

    public void loadFromFile(File file, int n) throws IOException, FileNotFoundException, PlaylistException {
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        if (n == WINAMP_FORMAT) {
            this.loadWinampFile(bufferedReader, file);
        } else if (n == MUSICMATCH_FORMAT) {
            this.loadMusicMatchFile(bufferedReader);
        }
        bufferedReader.close();
        fileReader.close();
    }

    private void loadWinampFile(BufferedReader bufferedReader, File file) throws IOException, PlaylistException {
        String string = bufferedReader.readLine();
        MP3File mP3File = null;
        if (string.equals("#EXTM3U")) {
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("EXTINF:") != -1) {
                    string = bufferedReader.readLine();
                    if (string.length() != 0 && (string.charAt(0) != '/' || string.indexOf(":") != -1)) {
                        string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.getParent()))).append(File.separator).append(string)));
                    }
                    try {
                        mP3File = new MP3File(string);
                        this.add(mP3File);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                throw new PlaylistException();
            }
        } else {
            throw new PlaylistException();
        }
    }

    private void loadMusicMatchFile(BufferedReader bufferedReader) throws IOException, PlaylistException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            try {
                this.add(new MP3File(string));
            }
            catch (Exception exception) {}
        }
    }

    public void writeToFile(File file, int n) throws IOException {
        File file2 = file;
        if (file.isDirectory()) {
            file2 = new File(file, String.valueOf(String.valueOf(file.getName())).concat(".m3u"));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        if (n == WINAMP_FORMAT) {
            this.writeWinampFile(printWriter);
        } else if (n == MUSICMATCH_FORMAT) {
            this.writeMusicMatchFile(printWriter);
        }
        printWriter.close();
        fileOutputStream.close();
    }

    private void writeWinampFile(PrintWriter printWriter) throws IOException {
        Iterator iterator = this.iterator();
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        printWriter.println("#EXTM3U");
        while (iterator.hasNext()) {
            MP3File mP3File = (MP3File)iterator.next();
            printWriter.print("#EXTINF:");
            printWriter.print(mP3File.getPlayingTime());
            printWriter.print(",");
            try {
                string = mP3File.getArtist();
            }
            catch (ID3v2FormatException iD3v2FormatException) {
                // empty catch block
            }
            try {
                string2 = mP3File.getTitle();
            }
            catch (ID3v2FormatException iD3v2FormatException) {
                // empty catch block
            }
            if (string.length() != 0 && string2.length() != 0) {
                string3 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" - ").append(string2)));
            } else if (string2.length() != 0) {
                string3 = string2;
            } else {
                string3 = mP3File.getFileName();
                string3 = string3.substring(0, string3.length() - 4);
            }
            printWriter.println(string3);
            printWriter.println(mP3File.getPath());
        }
    }

    private void writeMusicMatchFile(PrintWriter printWriter) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            MP3File mP3File = (MP3File)iterator.next();
            printWriter.println(mP3File.getPath());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }
}

