/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.ID3Tag;
import helliker.id3.ID3v2ExtendedHeader;
import helliker.id3.ID3v2Footer;
import helliker.id3.ID3v2FormatException;
import helliker.id3.ID3v2Frame;
import helliker.id3.ID3v2Frames;
import helliker.id3.ID3v2Header;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ID3v2Tag
implements ID3Tag {
    private final String ENC_TYPE = "ISO-8859-1";
    private final String MP3EXT_BADID = "MP3e";
    private final int NEWTAG_LIMIT = 16000;
    private File mp3 = null;
    private ID3v2Header head = null;
    private ID3v2ExtendedHeader ext_head = null;
    private ID3v2Frames frames = null;
    private ID3v2Footer foot = null;
    private int padding;
    private int writtenTagSize;
    private int writtenPadding;
    private boolean exists;
    private long mpegOffset;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ID3v2Tag(File file, long l) throws ID3v2FormatException, IOException, FileNotFoundException {
        this.mp3 = file;
        this.mpegOffset = l;
        this.frames = new ID3v2Frames();
        this.head = new ID3v2Header(file);
        this.padding = 0;
        this.exists = this.head.headerExists();
        if (this.exists) {
            block7: {
                if (this.head.getExtendedHeader()) {
                    this.ext_head = new ID3v2ExtendedHeader(file);
                }
                if (this.head.getFooter()) {
                    this.foot = new ID3v2Footer(file, this.head.getTagSize() + this.head.getHeaderSize());
                }
                RandomAccessFile randomAccessFile = null;
                try {
                    randomAccessFile = new RandomAccessFile(file, "r");
                    if (this.head.getMajorVersion() >= 3) {
                        this.parseFrames(randomAccessFile);
                    }
                    Object var6_4 = null;
                    if (randomAccessFile == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    throw throwable;
                }
                randomAccessFile.close();
            }
            this.writtenTagSize = this.head.getTagSize();
            this.writtenPadding = this.padding;
        }
    }

    private void parseFrames(RandomAccessFile randomAccessFile) throws ID3v2FormatException, IOException {
        int n = this.head.getHeaderSize();
        int n2 = this.head.getTagSize();
        int n3 = 0;
        int n4 = 0;
        ID3v2Frame iD3v2Frame = null;
        String string = null;
        boolean bl = false;
        if (this.head.getExtendedHeader()) {
            n2 -= this.ext_head.getSize();
            n += this.ext_head.getSize();
        }
        randomAccessFile.seek(n);
        while (n3 < n2 && !bl) {
            byte[] byArray = new byte[4];
            n3 += randomAccessFile.read(byArray);
            string = new String(byArray);
            if (!string.equals("MP3e") && string.indexOf(0) == -1) {
                n4 = randomAccessFile.readInt();
                if (n4 < 0 || n4 > n2 - (n3 += 4)) {
                    throw new ID3v2FormatException("ID3v2Tag.parseFrames: Invalid frame size");
                }
                byte[] byArray2 = new byte[2];
                n3 += randomAccessFile.read(byArray2);
                byArray = new byte[n4];
                n3 += randomAccessFile.read(byArray);
                iD3v2Frame = new ID3v2Frame(string, byArray2, byArray);
                this.frames.put(string, iD3v2Frame);
                continue;
            }
            bl = true;
            n3 -= byArray.length;
        }
        Long l = new Long(this.mpegOffset - (long)n - (long)n3);
        this.padding = l.intValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTag() throws IOException, FileNotFoundException {
        int n;
        block6: {
            RandomAccessFile randomAccessFile = null;
            n = this.getTotalSize();
            this.head.setTagSize(this.getSize());
            try {
                randomAccessFile = new RandomAccessFile(this.mp3, "rw");
                if (this.mpegOffset >= (long)n) {
                    byte[] byArray = this.getBytes();
                    randomAccessFile.seek(0L);
                    randomAccessFile.write(byArray);
                } else {
                    byte[] byArray = this.getBytes();
                    long l = randomAccessFile.length() - this.mpegOffset;
                    byte[] byArray2 = new byte[(int)l];
                    randomAccessFile.seek(this.mpegOffset);
                    if (randomAccessFile.read(byArray2) != byArray2.length) {
                        throw new IOException("ID3v2Tag.removeTag: unexpected end of file encountered");
                    }
                    randomAccessFile.setLength(l + (long)byArray.length);
                    randomAccessFile.seek(0L);
                    randomAccessFile.write(byArray);
                    randomAccessFile.write(byArray2);
                }
                Object var8_7 = null;
                if (randomAccessFile == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                throw throwable;
            }
            randomAccessFile.close();
        }
        this.writtenTagSize = n;
        this.writtenPadding = this.padding;
        this.exists = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeTag() throws IOException, FileNotFoundException {
        if (this.exists) {
            block6: {
                RandomAccessFile randomAccessFile = null;
                int n = this.writtenTagSize + this.head.getHeaderSize();
                if (this.head.getFooter()) {
                    n += this.foot.getFooterSize();
                }
                try {
                    Long l = new Long(this.mp3.length() - (long)n);
                    byte[] byArray = new byte[l.intValue()];
                    randomAccessFile = new RandomAccessFile(this.mp3, "rw");
                    randomAccessFile.seek(n);
                    if (randomAccessFile.read(byArray) != byArray.length) {
                        throw new IOException("ID3v2Tag.removeTag: unexpected end of file encountered");
                    }
                    randomAccessFile.setLength(l);
                    randomAccessFile.seek(0L);
                    randomAccessFile.write(byArray);
                    randomAccessFile.close();
                    Object var6_5 = null;
                    if (randomAccessFile == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    throw throwable;
                }
                randomAccessFile.close();
            }
            this.exists = false;
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.getTotalSize()];
        int n = 0;
        int n2 = 0;
        this.padding = this.getUpdatedPadding();
        n2 = this.head.getHeaderSize();
        System.arraycopy(this.head.getBytes(), 0, byArray, n, n2);
        n += n2;
        if (this.head.getExtendedHeader()) {
            n2 = this.ext_head.getSize();
            System.arraycopy(this.ext_head.getBytes(), 0, byArray, n, n2);
            n += n2;
        }
        n2 = this.frames.getLength();
        System.arraycopy(this.frames.getBytes(), 0, byArray, n, n2);
        n += n2;
        if (this.padding > 0) {
            System.arraycopy(new byte[this.padding], 0, byArray, n, this.padding);
            n += this.padding;
        }
        if (this.head.getFooter()) {
            n2 = this.foot.getFooterSize();
            System.arraycopy(this.foot.getBytes(), 0, byArray, n, n2);
            n += n2;
        }
        return byArray;
    }

    public void setTextFrame(String string, String string2) {
        if (string.charAt(0) == 'T' && !string.equals(ID3v2Frames.USER_DEFINED_TEXT_INFO)) {
            try {
                byte[] byArray = new byte[string2.length() + 1];
                byArray[0] = 0;
                System.arraycopy(string2.getBytes("ISO-8859-1"), 0, byArray, 1, string2.length());
                this.updateFrameData(string, byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public void setURLFrame(String string, String string2) {
        if (string.charAt(0) == 'W' && !string.equals(ID3v2Frames.USER_DEFINED_URL)) {
            this.updateFrameData(string, string2.getBytes());
        }
    }

    public void setUserDefinedTextFrame(String string, String string2) {
        try {
            byte[] byArray = new byte[string.length() + string2.length() + 2];
            int n = 0;
            byArray[n++] = 0;
            System.arraycopy(string.getBytes("ISO-8859-1"), 0, byArray, n, string.length());
            n += string.length();
            byArray[n++] = 0;
            System.arraycopy(string2.getBytes("ISO-8859-1"), 0, byArray, n, string2.length());
            n += string2.length();
            this.updateFrameData(ID3v2Frames.USER_DEFINED_TEXT_INFO, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void setUserDefinedURLFrame(String string, String string2) {
        try {
            byte[] byArray = new byte[string.length() + string2.length() + 2];
            int n = 0;
            byArray[n++] = 0;
            System.arraycopy(string.getBytes("ISO-8859-1"), 0, byArray, n, string.length());
            n += string.length();
            byArray[n++] = 0;
            System.arraycopy(string2.getBytes(), 0, byArray, n, string2.length());
            n += string2.length();
            this.updateFrameData(ID3v2Frames.USER_DEFINED_URL, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void setCommentFrame(String string, String string2) {
        try {
            byte[] byArray = new byte[string.length() + string2.length() + 5];
            int n = 0;
            byArray[n++] = 0;
            byArray[n++] = 101;
            byArray[n++] = 110;
            byArray[n++] = 103;
            System.arraycopy(string.getBytes("ISO-8859-1"), 0, byArray, n, string.length());
            n += string.length();
            byArray[n++] = 0;
            System.arraycopy(string2.getBytes("ISO-8859-1"), 0, byArray, n, string2.length());
            n += string2.length();
            this.updateFrameData(ID3v2Frames.COMMENTS, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void removeFrame(String string) {
        this.frames.remove(string);
    }

    public void updateFrameData(String string, byte[] byArray) {
        if (this.frames.containsKey(string)) {
            ((ID3v2Frame)this.frames.get(string)).setFrameData(byArray);
        } else {
            ID3v2Frame iD3v2Frame = new ID3v2Frame(string, byArray);
            this.frames.put(string, iD3v2Frame);
        }
    }

    public String getFrameDataString(String string) throws ID3v2FormatException {
        String string2 = new String();
        if (this.frames.containsKey(string)) {
            string2 = ((ID3v2Frame)this.frames.get(string)).getDataString();
        }
        return string2;
    }

    public byte[] getFrameData(String string) {
        byte[] byArray = new byte[]{};
        if (this.frames.containsKey(string)) {
            byArray = ((ID3v2Frame)this.frames.get(string)).getFrameData();
        }
        return byArray;
    }

    public boolean tagExists() {
        return this.exists;
    }

    private int getUpdatedPadding() {
        int n = this.padding;
        int n2 = this.frames.getLength();
        int n3 = 0;
        if (this.head.getExtendedHeader()) {
            n2 += this.ext_head.getSize();
        }
        n3 = (n2 += this.padding) - this.writtenTagSize;
        if (this.padding == this.writtenPadding && n3 != 0 && this.exists) {
            if (n3 < 0) {
                n += Math.abs(n3);
            } else if (n3 <= this.padding) {
                n -= n3;
            } else {
                int n4;
                for (n4 = 2 * this.writtenTagSize; n4 < n2; n4 += this.writtenTagSize) {
                }
                n = n4 <= 16000 ? n4 - n2 : 0;
            }
        }
        return n;
    }

    public int getSize() {
        int n = this.frames.getLength();
        int n2 = 0;
        if (this.head.getExtendedHeader()) {
            n += this.ext_head.getSize();
        }
        n2 = (n += this.padding) - this.writtenTagSize;
        if (this.padding == this.writtenPadding && n2 != 0 && (n2 < 0 || n2 <= this.padding)) {
            n = this.head.getTagSize();
        }
        return n;
    }

    public int getTotalSize() {
        int n = this.getSize();
        n += this.head.getHeaderSize();
        if (this.head.getFooter()) {
            n += this.foot.getFooterSize();
        }
        return n;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n) {
        if (!this.head.getFooter() && n >= 0) {
            this.padding = n;
        }
    }

    public String toString() {
        String string = this.head.toString();
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("\nPadding:\t\t\t").append(this.getPadding()).append(" bytes").append("\nTotalSize:\t\t\t").append(this.getTotalSize()).append(" bytes"))))));
        if (this.head.getExtendedHeader()) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(this.ext_head.toString()))))));
        }
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(this.frames.toString()))))));
        if (this.head.getFooter()) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.foot.toString())));
        }
        return string;
    }

    public void copyFrom(ID3Tag iD3Tag) {
    }
}

