/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javazoom.Util.Config;
import javazoom.Util.Debug;
import javazoom.Util.FileSelector;
import javazoom.jlGui.BasicPlayer;
import javazoom.jlGui.BasicPlayerListener;
import javazoom.jlGui.playlist.Playlist;
import javazoom.jlGui.playlist.PlaylistFactory;
import javazoom.jlGui.playlist.PlaylistItem;
import javazoom.jlGui.playlist.ui.MP3Files;
import javazoom.jlGui.skin.SkinLoader;
import javazoom.jlGui.skin.UrlDialog;
import javazoom.jlGui.skin.activeComponent;
import javazoom.jlGui.skin.taftb;

public class Player
extends Window
implements ActionListener,
BasicPlayerListener,
DropTargetListener,
WindowListener {
    private static int TEXT_LENGTH_MAX = 30;
    private static String TITLETEXT = "jlGui 2.2 ";
    private static String initConfig = "jlgui.ini";
    private static String initSong = null;
    private static String showPlaylist = null;
    private static String skinVersion = "1";
    private static int volumeHeight = 6;
    private static boolean autoRun = false;
    private MP3Files fileList = null;
    private String currentFileOrURL = null;
    private String currentSongName = null;
    private boolean currentIsFile;
    private Image offScreenImage;
    private Graphics offScreenGraphics;
    private int WinWidth;
    private int WinHeight;
    private int OrigineX = 0;
    private int OrigineY = 0;
    private int screenWidth = -1;
    private int screenHeight = -1;
    private String thePath = "";
    private String theMain = "main.bmp";
    private String theButtons = "cbuttons.bmp";
    private Image imMain;
    private Image imButtons;
    private activeComponent acPrevious;
    private activeComponent acPlay;
    private activeComponent acPause;
    private activeComponent acStop;
    private activeComponent acNext;
    private activeComponent acEject;
    private Image imPrevious;
    private Image imPlay;
    private Image imPause;
    private Image imStop;
    private Image imNext;
    private Image imEject;
    private Image[] releasedImage = new Image[]{this.imPrevious, this.imPlay, this.imPause, this.imStop, this.imNext, this.imEject};
    private Image[] pressedImage = new Image[]{this.imPrevious, this.imPlay, this.imPause, this.imStop, this.imNext, this.imEject};
    private int[] releasedPanel = new int[]{0, 0, 23, 18, 23, 0, 23, 18, 46, 0, 23, 18, 69, 0, 23, 18, 92, 0, 22, 18, 114, 0, 22, 16};
    private int[] pressedPanel = new int[]{0, 18, 23, 18, 23, 18, 23, 18, 46, 18, 23, 18, 69, 18, 23, 18, 92, 18, 22, 18, 114, 16, 22, 16};
    private int[] panelLocation = new int[]{16, 88, 39, 88, 62, 88, 85, 88, 108, 88, 137, 89};
    private boolean FirstDrag = true;
    private int XDrag = 0;
    private int YDrag = 0;
    private String theTitleBar = "titlebar.bmp";
    private Image imTitleBar;
    private activeComponent acTitleBar;
    private Image imTitleB;
    private Image[] releasedTitleIm = new Image[]{this.imTitleB};
    private Image[] pressedTitleIm = new Image[]{this.imTitleB};
    private int[] releasedTitlePanel = new int[]{27, 0, 244, 14};
    private int[] pressedTitlePanel = new int[]{27, 15, 244, 14};
    private int[] titleBarLocation = new int[]{0, 0};
    private activeComponent acExit;
    private int[] releasedExitPanel = new int[]{18, 0, 9, 9};
    private int[] pressedExitPanel = new int[]{18, 9, 9, 9};
    private Image[] releasedExitIm = new Image[]{null};
    private Image[] pressedExitIm = new Image[]{null};
    private int[] exitLocation = new int[]{264, 3};
    private activeComponent acMinimize;
    private int[] releasedMinimizePanel = new int[]{9, 0, 9, 9};
    private int[] pressedMinimizePanel = new int[]{9, 9, 9, 9};
    private Image[] releasedMinimizeIm = new Image[]{null};
    private Image[] pressedMinimizeIm = new Image[]{null};
    private int[] minimizeLocation = new int[]{244, 3};
    private int fontWidth = 5;
    private int fontHeight = 6;
    private String theText = "text.bmp";
    private Image imText;
    private String fontIndex = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\"@a  0123456789  :()-'!_+ /[]^&%.=$#   ?*";
    private Image sampleRateImage;
    private String sampleRateClearText = "  ";
    private Image sampleRateClearImage;
    private int[] sampleRateLocation = new int[]{156, 43};
    private String bitsRateClearText = "    ";
    private Image bitsRateClearImage;
    private Image bitsRateImage;
    private int[] bitsRateLocation = new int[]{107, 43};
    private String titleText = TITLETEXT.toUpperCase();
    private String clearText = "                                     ";
    private Image clearImage;
    private Image titleImage;
    private int[] titleLocation = new int[]{111, 27};
    private int numberWidth = 9;
    private int numberHeight = 13;
    private String theNumbers = "numbers.bmp";
    private String theNumEx = "nums_ex.bmp";
    private Image imNumbers;
    private String numberIndex = "0123456789 ";
    private Image minuteImage;
    private Image secondImage;
    private Image minuteDImage;
    private Image secondDImage;
    private Image[] timeImage = new Image[]{null, null, null, null, null, null, null, null, null, null, null};
    private int[] minuteDLocation = new int[]{48, 26};
    private int[] minuteLocation = new int[]{60, 26};
    private int[] secondDLocation = new int[]{78, 26};
    private int[] secondLocation = new int[]{90, 26};
    private String theMode = "monoster.bmp";
    private Image imMode;
    private int[] activeModePanel = new int[]{0, 0, 28, 12, 29, 0, 27, 12};
    private int[] passiveModePanel = new int[]{0, 12, 28, 12, 29, 12, 27, 12};
    private Image imSA;
    private Image imMA;
    private Image imSI;
    private Image imMI;
    private Image[] activeModeImage = new Image[]{this.imSA, this.imMA};
    private Image[] passiveModeImage = new Image[]{this.imSI, this.imMI};
    private int[] monoLocation = new int[]{212, 40};
    private int[] stereoLocation = new int[]{239, 40};
    private boolean FirstVolumeDrag = true;
    private int XVolumeDrag = 0;
    private String theVolume = "volume.bmp";
    private Image imVolume;
    private activeComponent acVolume;
    private activeComponent acBalance;
    private Image[] volumeImage = new Image[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String fakeIndex = "abcdefghijklmnopqrstuvwxyz01";
    private int[] volumeBarLocation = new int[]{107, 57};
    private Image[] releasedVolumeImage = new Image[]{null};
    private Image[] pressedVolumeImage = new Image[]{null};
    private int[] releasedVolumePanel0 = new int[]{15, 422, 14, 11};
    private int[] pressedVolumePanel0 = new int[]{0, 422, 14, 11};
    private int[] releasedVolumePanel1 = new int[]{75, 376, 14, 11};
    private int[] pressedVolumePanel1 = new int[]{90, 376, 14, 11};
    private int minGain = 0;
    private int maxGain = 100;
    private int gainValue = 80;
    private int deltaVolume = 50;
    private int[] volumeLocation = new int[]{107 + this.deltaVolume * this.gainValue / this.maxGain, 58};
    private int[] volumeBounds = new int[]{107, 107 + this.deltaVolume};
    private Image[] balanceImage = new Image[]{null};
    private boolean FirstBalanceDrag = true;
    private int XBalanceDrag = 0;
    private double minBalance = -1.0;
    private double maxBalance = 1.0;
    private double balanceValue = 0.0;
    private int deltaBalance = 24;
    private int[] balanceLocation = new int[]{177 + this.deltaBalance / 2, 58};
    private int[] balanceBounds = new int[]{177, 177 + this.deltaBalance};
    private int[] balanceBarLocation = new int[]{177, 57};
    private String theIcons = "playpaus.bmp";
    private Image imIcons;
    private Image[] iconsImage = new Image[]{null, null, null, null, null};
    private int[] iconsPanel = new int[]{0, 0, 9, 9, 9, 0, 9, 9, 18, 0, 9, 9, 36, 0, 3, 9, 27, 0, 2, 9};
    private int[] iconsLocation = new int[]{26, 27, 24, 27};
    private boolean FirstPosBarDrag = true;
    private int XPosBarDrag = 0;
    private String thePosBar = "posbar.bmp";
    private Image imPosBar;
    private activeComponent acPosBar;
    private Image[] releasedPosIm = new Image[]{null};
    private Image[] pressedPosIm = new Image[]{null};
    private int[] releasedPosPanel = new int[]{248, 0, 28, 10};
    private int[] pressedPosPanel = new int[]{278, 0, 28, 10};
    private double minPos = 0.0;
    private double maxPos = 1.0;
    private double posValue = 0.0;
    private int deltaPosBar = 219;
    private int[] posBarLocation = new int[]{16, 72};
    private int[] posBarBounds = new int[]{16, 16 + this.deltaPosBar};
    private String theEPSRButtons = "shufrep.bmp";
    private Image imEPSRButtons;
    private activeComponent acEqualizer;
    private activeComponent acPlaylist;
    private activeComponent acShuffle;
    private activeComponent acRepeat;
    private Image imEqualizer;
    private Image imPlaylist;
    private Image imShuffle;
    private Image imRepeat;
    private Image[] releasedEPSRImage = new Image[]{this.imEqualizer, this.imPlaylist, this.imShuffle, this.imRepeat};
    private Image[] pressedEPSRImage = new Image[]{this.imEqualizer, this.imPlaylist, this.imShuffle, this.imRepeat};
    private int[] releasedEPSRPanel = new int[]{0, 61, 22, 12, 23, 61, 22, 12, 28, 0, 47, 14, 0, 0, 28, 14};
    private int[] pressedEPSRPanel = new int[]{0, 73, 22, 12, 23, 73, 22, 12, 28, 30, 47, 14, 0, 30, 28, 14};
    private int[] panelEPSRLocation = new int[]{219, 58, 242, 58, 166, 89, 212, 89};
    public static final int INIT = 0;
    public static final int OPEN = 1;
    public static final int PLAY = 2;
    public static final int PAUSE = 3;
    public static final int STOP = 4;
    private int playerState = 0;
    private long secondsAmount = 0L;
    private Playlist playlist = null;
    private BasicPlayer theSoundPlayer = null;
    private Config config = null;
    private Frame topFrame = null;

    public Player(String string, int n, String string2, Frame frame) {
        super(frame);
        Serializable serializable;
        Serializable serializable2;
        Object object;
        this.topFrame = frame;
        this.releasedVolumePanel0[3] = this.releasedVolumePanel0[3] - volumeHeight;
        this.pressedVolumePanel0[3] = this.pressedVolumePanel0[3] - volumeHeight;
        this.releasedVolumePanel1[3] = this.releasedVolumePanel1[3] - volumeHeight;
        this.pressedVolumePanel1[3] = this.pressedVolumePanel1[3] - volumeHeight;
        Debug debug = Debug.getInstance();
        if (string2 != null && !string2.equals("")) {
            debug.init(string2, n);
        } else {
            debug.setLogLevel(n);
        }
        this.config = Config.getInstance();
        this.config.load(initConfig);
        this.OrigineX = this.config.getXLocation();
        this.OrigineY = this.config.getYLocation();
        try {
            object = Toolkit.getDefaultToolkit();
            serializable2 = ((Toolkit)object).getScreenSize();
            this.screenWidth = serializable2.width;
            this.screenHeight = serializable2.height;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.topFrame.addWindowListener(this);
        this.topFrame.setLocation(this.OrigineX, this.OrigineY);
        this.topFrame.setSize(0, 0);
        object = this.getClass().getClassLoader();
        serializable2 = ((ClassLoader)object).getResource("jlguiicon.gif");
        if (serializable2 != null) {
            serializable = new ImageIcon((URL)serializable2);
            this.topFrame.setIconImage(serializable.getImage());
        }
        this.topFrame.show();
        serializable = new DropTarget(this, 1, this, true);
        boolean bl = false;
        bl = initSong != null && !initSong.equals("") ? this.loadPlaylist(initSong) : this.loadPlaylist(this.config.getPlaylistFilename());
        if (string != null) {
            this.thePath = string;
            this.trace(2, this.getClass().getName(), "Load default skin from " + this.thePath);
            this.loadSkin(this.thePath);
            this.config.setDefaultSkin(this.thePath);
        } else if (this.config.getDefaultSkin() != null && !this.config.getDefaultSkin().trim().equals("")) {
            this.trace(2, this.getClass().getName(), "Load default skin from " + this.config.getDefaultSkin());
            this.loadSkin(this.config.getDefaultSkin());
        } else {
            InputStream inputStream = ((ClassLoader)object).getResourceAsStream("skins/metrix.wsz");
            this.trace(2, this.getClass().getName(), "Load default skin for JAR");
            this.loadSkin(inputStream);
        }
        this.theSoundPlayer = new BasicPlayer(this);
        if (this.playlist != null && bl && this.playlist.getPlaylistSize() > 0) {
            this.acNext.fireEvent();
        }
        this.hide();
        this.show();
        this.repaint();
    }

    public boolean loadPlaylist(String string) {
        boolean bl = false;
        PlaylistFactory playlistFactory = PlaylistFactory.getInstance();
        this.playlist = playlistFactory.getPlaylist();
        if (string.toLowerCase().endsWith(".m3u")) {
            bl = this.playlist.load(string);
        } else {
            String string2 = string;
            if (!string.toLowerCase().startsWith("http")) {
                int n = string.lastIndexOf(File.separatorChar);
                if (n != -1) {
                    string2 = string.substring(n + 1);
                }
                PlaylistItem playlistItem = new PlaylistItem(string2, string, -1L, true);
                this.playlist.appendItem(playlistItem);
                bl = true;
            } else {
                PlaylistItem playlistItem = new PlaylistItem(string2, string, -1L, false);
                this.playlist.appendItem(playlistItem);
                bl = true;
            }
        }
        return bl;
    }

    public void loadSkin(String string) {
        SkinLoader skinLoader = new SkinLoader(string);
        try {
            this.loadSkin(skinLoader);
        }
        catch (Exception exception) {
            this.trace(2, this.getClass().getName(), "Can't load skin : " + exception.getMessage());
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("skins/metrix.wsz");
            this.trace(2, this.getClass().getName(), "Load default skin for JAR");
            this.loadSkin(inputStream);
        }
    }

    public void loadSkin(InputStream inputStream) {
        SkinLoader skinLoader = new SkinLoader(inputStream);
        try {
            this.loadSkin(skinLoader);
        }
        catch (Exception exception) {
            this.trace(2, this.getClass().getName(), "Can't load skin : " + exception.getMessage());
            InputStream inputStream2 = this.getClass().getClassLoader().getResourceAsStream("skins/metrix.wsz");
            this.trace(2, this.getClass().getName(), "Load default skin for JAR");
            this.loadSkin(inputStream2);
        }
    }

    private void loadSkin(SkinLoader skinLoader) throws Exception {
        skinLoader.loadImages();
        this.imMain = skinLoader.getImage(this.theMain);
        this.imButtons = skinLoader.getImage(this.theButtons);
        this.imTitleBar = skinLoader.getImage(this.theTitleBar);
        this.imText = skinLoader.getImage(this.theText);
        this.imMode = skinLoader.getImage(this.theMode);
        this.imNumbers = skinLoader.getImage(this.theNumbers);
        if (this.imNumbers == null) {
            this.trace(2, this.getClass().getName(), "Try load nums_ex.bmp !");
            this.imNumbers = skinLoader.getImage(this.theNumEx);
        }
        this.imVolume = skinLoader.getImage(this.theVolume);
        this.imIcons = skinLoader.getImage(this.theIcons);
        this.imPosBar = skinLoader.getImage(this.thePosBar);
        this.imEPSRButtons = skinLoader.getImage(this.theEPSRButtons);
        this.WinHeight = this.imMain.getHeight(this);
        this.WinWidth = this.imMain.getWidth(this);
        this.setSize(this.WinWidth, this.WinHeight);
        this.setLocation(this.OrigineX, this.OrigineY);
        this.setBackground(Color.black);
        this.show();
        this.offScreenImage = this.createImage(this.WinWidth, this.WinHeight);
        this.offScreenGraphics = this.offScreenImage.getGraphics();
        this.hide();
        this.offScreenGraphics.drawImage(this.imMain, 0, 0, this);
        if (this.acPrevious != null) {
            this.remove(this.acPrevious);
            this.remove(this.acPlay);
            this.remove(this.acPause);
            this.remove(this.acStop);
            this.remove(this.acNext);
            this.remove(this.acEject);
            this.remove(this.acTitleBar);
            this.remove(this.acExit);
            this.remove(this.acMinimize);
            this.remove(this.acVolume);
            this.remove(this.acBalance);
            this.remove(this.acPosBar);
            this.remove(this.acPlaylist);
            this.remove(this.acRepeat);
            this.remove(this.acShuffle);
            this.remove(this.acEqualizer);
            if (this.fileList != null) {
                this.fileList.dispose();
            }
            System.gc();
        }
        this.readPanel(this.releasedImage, this.releasedPanel, this.pressedImage, this.pressedPanel, this.imButtons);
        this.setButtonsPanel();
        if (skinVersion.equals("1")) {
            this.readPanel(this.releasedVolumeImage, this.releasedVolumePanel0, this.pressedVolumeImage, this.pressedVolumePanel0, this.imVolume);
        } else {
            this.readPanel(this.releasedVolumeImage, this.releasedVolumePanel1, this.pressedVolumeImage, this.pressedVolumePanel1, this.imVolume);
        }
        this.setVolumePanel();
        this.readPanel(this.releasedTitleIm, this.releasedTitlePanel, this.pressedTitleIm, this.pressedTitlePanel, this.imTitleBar);
        this.setTitleBarPanel();
        this.readPanel(this.releasedExitIm, this.releasedExitPanel, this.pressedExitIm, this.pressedExitPanel, this.imTitleBar);
        this.setExitPanel();
        this.readPanel(this.releasedMinimizeIm, this.releasedMinimizePanel, this.pressedMinimizeIm, this.pressedMinimizePanel, this.imTitleBar);
        this.setMinimizePanel();
        this.readPanel(this.activeModeImage, this.activeModePanel, this.passiveModeImage, this.passiveModePanel, this.imMode);
        this.offScreenGraphics.drawImage(this.passiveModeImage[0], this.stereoLocation[0], this.stereoLocation[1], this);
        this.offScreenGraphics.drawImage(this.passiveModeImage[1], this.monoLocation[0], this.monoLocation[1], this);
        this.sampleRateClearImage = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, this.sampleRateClearText).getBanner();
        this.bitsRateClearImage = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, this.bitsRateClearText).getBanner();
        this.clearImage = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, this.clearText).getBanner(0, 0, 155, 6);
        this.titleImage = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, this.titleText).getBanner(0, 0, 155, 6);
        this.offScreenGraphics.drawImage(this.titleImage, this.titleLocation[0], this.titleLocation[1], this);
        int n = 0;
        while (n < this.numberIndex.length()) {
            this.timeImage[n] = new taftb(this.numberIndex, this.imNumbers, this.numberWidth, this.numberHeight, 0, "" + this.numberIndex.charAt(n)).getBanner();
            ++n;
        }
        this.readPanel(this.iconsImage, this.iconsPanel, null, null, this.imIcons);
        this.offScreenGraphics.drawImage(this.iconsImage[2], this.iconsLocation[0], this.iconsLocation[1], this);
        this.readPanel(this.releasedPosIm, this.releasedPosPanel, this.pressedPosIm, this.pressedPosPanel, this.imPosBar);
        this.setPosBarPanel();
        this.readPanel(this.releasedEPSRImage, this.releasedEPSRPanel, this.pressedEPSRImage, this.pressedEPSRPanel, this.imEPSRButtons);
        this.setEPSRButtonsPanel();
        PopupMenu popupMenu = new PopupMenu("Setup");
        MenuItem menuItem = new MenuItem(TITLETEXT + "- JavaZOOM");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        popupMenu.addSeparator();
        menuItem = new MenuItem("Preferences");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        menuItem = new MenuItem("Skins");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        popupMenu.addSeparator();
        menuItem = new MenuItem("Exit");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        this.acTitleBar.setPopup(popupMenu);
        if (showPlaylist != null) {
            this.config.setPlaylistEnabled(true);
        }
        this.fileList = new MP3Files(this.topFrame, this, this.playlist, skinLoader, this.OrigineX, this.OrigineY + this.WinHeight, this.config.isPlaylistEnabled());
        this.show();
    }

    private void readPanel(Image[] imageArray, int[] nArray, Image[] imageArray2, int[] nArray2, Image image) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        if (imageArray != null) {
            n5 = 0;
            while (n5 < imageArray.length) {
                imageArray[n5] = this.createImage(nArray[n6 + 2], nArray[n6 + 3]);
                n4 = nArray[n6];
                n3 = nArray[n6 + 1];
                n2 = nArray[n6] + nArray[n6 + 2];
                n = nArray[n6 + 1] + nArray[n6 + 3];
                imageArray[n5].getGraphics().drawImage(image, 0, 0, nArray[n6 + 2], nArray[n6 + 3], n4, n3, n2, n, null);
                n6 += 4;
                ++n5;
            }
        }
        n6 = 0;
        if (imageArray2 != null) {
            n5 = 0;
            while (n5 < imageArray2.length) {
                imageArray2[n5] = this.createImage(nArray2[n6 + 2], nArray2[n6 + 3]);
                n4 = nArray2[n6];
                n3 = nArray2[n6 + 1];
                n2 = nArray2[n6] + nArray2[n6 + 2];
                n = nArray2[n6 + 1] + nArray2[n6 + 3];
                imageArray2[n5].getGraphics().drawImage(image, 0, 0, nArray2[n6 + 2], nArray2[n6 + 3], n4, n3, n2, n, null);
                n6 += 4;
                ++n5;
            }
        }
    }

    private void setButtonsPanel() {
        int n = 0;
        this.setLayout(null);
        this.acPrevious = new activeComponent(this.releasedImage[0], this.pressedImage[0], 16L);
        this.acPrevious.setLocation(this.panelLocation[n++], this.panelLocation[n++]);
        this.add(this.acPrevious);
        this.acPrevious.setActionCommand("Previous");
        this.acPrevious.addActionListener(this);
        this.acPlay = new activeComponent(this.releasedImage[1], this.pressedImage[1], 16L);
        this.acPlay.setLocation(this.panelLocation[n++], this.panelLocation[n++]);
        this.add(this.acPlay);
        this.acPlay.setActionCommand("Play");
        this.acPlay.addActionListener(this);
        this.acPause = new activeComponent(this.releasedImage[2], this.pressedImage[2], 16L);
        this.acPause.setLocation(this.panelLocation[n++], this.panelLocation[n++]);
        this.add(this.acPause);
        this.acPause.setActionCommand("Pause");
        this.acPause.addActionListener(this);
        this.acStop = new activeComponent(this.releasedImage[3], this.pressedImage[3], 16L);
        this.acStop.setLocation(this.panelLocation[n++], this.panelLocation[n++]);
        this.add(this.acStop);
        this.acStop.setActionCommand("Stop");
        this.acStop.addActionListener(this);
        this.acNext = new activeComponent(this.releasedImage[4], this.pressedImage[4], 16L);
        this.acNext.setLocation(this.panelLocation[n++], this.panelLocation[n++]);
        this.add(this.acNext);
        this.acNext.setActionCommand("Next");
        this.acNext.addActionListener(this);
        this.acEject = new activeComponent(this.releasedImage[5], this.pressedImage[5], 24L);
        this.acEject.setLocation(this.panelLocation[n++], this.panelLocation[n++]);
        this.add(this.acEject);
        this.acEject.setActionCommand("Eject");
        this.acEject.addActionListener(this);
    }

    private void setTitleBarPanel() {
        int n = 0;
        this.acTitleBar = new activeComponent(this.releasedTitleIm[0], this.pressedTitleIm[0], 48L);
        this.acTitleBar.setLocation(this.titleBarLocation[n++], this.titleBarLocation[n++]);
        this.add(this.acTitleBar);
        this.acTitleBar.setActionCommand("TitleBar");
        this.acTitleBar.addActionListener(this);
    }

    private void setExitPanel() {
        int n = 0;
        this.acExit = new activeComponent(this.releasedExitIm[0], this.pressedExitIm[0], 16L);
        this.acExit.setLocation(this.exitLocation[n++], this.exitLocation[n++]);
        this.add(this.acExit);
        this.acExit.setActionCommand("Exit");
        this.acExit.addActionListener(this);
    }

    private void setMinimizePanel() {
        int n = 0;
        this.acMinimize = new activeComponent(this.releasedMinimizeIm[0], this.pressedMinimizeIm[0], 16L);
        this.acMinimize.setLocation(this.minimizeLocation[n++], this.minimizeLocation[n++]);
        this.add(this.acMinimize);
        this.acMinimize.setActionCommand("Minimize");
        this.acMinimize.addActionListener(this);
    }

    private void setVolumePanel() {
        int n = 0;
        this.acVolume = new activeComponent(this.releasedVolumeImage[0], this.pressedVolumeImage[0], 48L);
        this.acVolume.setLocation(this.volumeLocation[n++], this.volumeLocation[n++]);
        this.add(this.acVolume);
        this.acVolume.setActionCommand("Volume");
        this.acVolume.addActionListener(this);
        int n2 = 0;
        while (n2 < this.volumeImage.length) {
            this.volumeImage[n2] = new taftb(this.fakeIndex, this.imVolume, 68, 13, 2, "" + this.fakeIndex.charAt(n2)).getBanner();
            ++n2;
        }
        this.offScreenGraphics.drawImage(this.volumeImage[(int)Math.round((double)this.gainValue / (double)this.maxGain * (double)(this.volumeImage.length - 1))], this.volumeBarLocation[0], this.volumeBarLocation[1], this);
        n = 0;
        this.acBalance = new activeComponent(this.releasedVolumeImage[0], this.pressedVolumeImage[0], 48L);
        this.acBalance.setLocation(this.balanceLocation[n++], this.balanceLocation[n++]);
        this.add(this.acBalance);
        this.acBalance.setActionCommand("Balance");
        this.acBalance.addActionListener(this);
        this.balanceImage[0] = new taftb("a", this.imVolume, this.deltaBalance + 14, 13, 2, "a").getBanner();
        this.offScreenGraphics.drawImage(this.balanceImage[0], this.balanceBarLocation[0], this.balanceBarLocation[1], this);
    }

    private void setPosBarPanel() {
        int n = 0;
        this.acPosBar = new activeComponent(this.releasedPosIm[0], this.pressedPosIm[0], 48L);
        this.acPosBar.setLocation(this.posBarLocation[n++], this.posBarLocation[n++]);
        this.add(this.acPosBar);
        this.acPosBar.setActionCommand("Seek");
        this.acPosBar.addActionListener(this);
        this.remove(this.acPosBar);
    }

    private void setEPSRButtonsPanel() {
        int n = 0;
        this.setLayout(null);
        this.acEqualizer = new activeComponent(this.releasedEPSRImage[0], this.pressedEPSRImage[0], 16L, true, this.config.isEqualizerEnabled());
        this.acEqualizer.setLocation(this.panelEPSRLocation[n++], this.panelEPSRLocation[n++]);
        this.add(this.acEqualizer);
        this.acEqualizer.setActionCommand("Equalizer");
        this.acEqualizer.addActionListener(this);
        this.acPlaylist = new activeComponent(this.releasedEPSRImage[1], this.pressedEPSRImage[1], 16L, true, this.config.isPlaylistEnabled());
        this.acPlaylist.setLocation(this.panelEPSRLocation[n++], this.panelEPSRLocation[n++]);
        this.add(this.acPlaylist);
        this.acPlaylist.setActionCommand("Playlist");
        this.acPlaylist.addActionListener(this);
        this.acShuffle = new activeComponent(this.releasedEPSRImage[2], this.pressedEPSRImage[2], 16L, true, this.config.isShuffleEnabled());
        this.acShuffle.setLocation(this.panelEPSRLocation[n++], this.panelEPSRLocation[n++]);
        this.add(this.acShuffle);
        this.acShuffle.setActionCommand("Shuffle");
        this.acShuffle.addActionListener(this);
        this.acRepeat = new activeComponent(this.releasedEPSRImage[3], this.pressedEPSRImage[3], 16L, true, this.config.isRepeatEnabled());
        this.acRepeat.setLocation(this.panelEPSRLocation[n++], this.panelEPSRLocation[n++]);
        this.add(this.acRepeat);
        this.acRepeat.setActionCommand("Repeat");
        this.acRepeat.addActionListener(this);
    }

    public void setCurrentSong(PlaylistItem playlistItem) {
        int n = this.playerState;
        if (this.playerState == 3 || this.playerState == 2) {
            this.theSoundPlayer.stopPlayback();
            this.playerState = 4;
            this.secondsAmount = 0L;
            this.acPosBar.setLocation(this.posBarBounds[0], this.posBarLocation[1]);
            this.offScreenGraphics.drawImage(this.iconsImage[2], this.iconsLocation[0], this.iconsLocation[1], this);
            this.offScreenGraphics.drawImage(this.iconsImage[4], this.iconsLocation[2], this.iconsLocation[3], this);
        }
        this.playerState = 1;
        if (playlistItem != null) {
            this.currentSongName = playlistItem.getFormattedName();
            this.currentFileOrURL = playlistItem.getLocation();
            this.currentIsFile = playlistItem.isFile();
        } else if (this.config.isRepeatEnabled()) {
            if (this.playlist != null) {
                if (this.playlist.getPlaylistSize() > 0) {
                    this.playlist.begin();
                    PlaylistItem playlistItem2 = this.playlist.getCursor();
                    if (playlistItem2 != null) {
                        this.currentSongName = playlistItem2.getFormattedName();
                        this.currentFileOrURL = playlistItem2.getLocation();
                        this.currentIsFile = playlistItem2.isFile();
                    }
                } else {
                    this.currentSongName = TITLETEXT;
                    this.currentFileOrURL = null;
                    this.currentIsFile = false;
                }
            }
        } else {
            this.currentSongName = TITLETEXT;
            this.currentFileOrURL = null;
            this.currentIsFile = false;
        }
        if (this.currentIsFile) {
            this.add(this.acPosBar);
        } else {
            this.config.setLastURL(this.currentFileOrURL);
            this.remove(this.acPosBar);
        }
        this.titleText = this.currentSongName.toUpperCase();
        this.showMessage(this.titleText);
        this.repaint();
        if (n == 2 || n == 3) {
            this.acPlay.fireEvent();
        }
    }

    public void updateCursor(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if ((n8 = (n %= 6000) - (n7 = n / 60) * 60) < 10) {
            n6 = 0;
            n5 = n8;
        } else {
            n6 = n8 / 10;
            n5 = n8 - n8 / 10 * 10;
        }
        if (n7 < 10) {
            n4 = 0;
            n3 = n7;
        } else {
            n4 = n7 / 10;
            n3 = n7 - n7 / 10 * 10;
        }
        if (n2 != 0) {
            if (this.FirstPosBarDrag) {
                this.posBarLocation[0] = Math.round(n * this.deltaPosBar / n2) + this.posBarBounds[0];
                if (this.posBarLocation[0] < this.posBarBounds[0]) {
                    this.posBarLocation[0] = this.posBarBounds[0];
                } else if (this.posBarLocation[0] > this.posBarBounds[1]) {
                    this.posBarLocation[0] = this.posBarBounds[1];
                }
                this.acPosBar.setLocation(this.posBarLocation[0], this.posBarLocation[1]);
            }
        } else {
            this.posBarLocation[0] = this.posBarBounds[0];
        }
        this.offScreenGraphics.drawImage(this.timeImage[n4], this.minuteDLocation[0], this.minuteDLocation[1], this);
        this.offScreenGraphics.drawImage(this.timeImage[n3], this.minuteLocation[0], this.minuteLocation[1], this);
        this.offScreenGraphics.drawImage(this.timeImage[n6], this.secondDLocation[0], this.secondDLocation[1], this);
        this.offScreenGraphics.drawImage(this.timeImage[n5], this.secondLocation[0], this.secondLocation[1], this);
        this.repaint();
    }

    public void updateMediaState(String string) {
        if (string.equals("EOM") && (this.playerState == 3 || this.playerState == 2)) {
            this.playlist.nextCursor();
            this.fileList.nextCursor();
            PlaylistItem playlistItem = this.playlist.getCursor();
            this.setCurrentSong(playlistItem);
        }
    }

    public void updateMediaData(byte[] byArray) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Seek")) {
            if (!this.acPosBar.isMousePressed()) {
                this.FirstPosBarDrag = true;
                try {
                    this.theSoundPlayer.setSeek(this.posValue);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.repaint();
            } else {
                int n = 0;
                if (!this.FirstPosBarDrag) {
                    n = this.acPosBar.getMouseX() - this.XPosBarDrag;
                    this.XPosBarDrag = this.acPosBar.getMouseX() - n;
                    this.posBarLocation[0] = this.posBarLocation[0] + n < this.posBarBounds[0] ? this.posBarBounds[0] : (this.posBarLocation[0] + n > this.posBarBounds[1] ? this.posBarBounds[1] : this.posBarLocation[0] + n);
                    this.acPosBar.setLocation(this.posBarLocation[0], this.posBarLocation[1]);
                    double d = (this.maxPos - this.minPos) / (double)(this.posBarBounds[1] - this.posBarBounds[0]);
                    this.posValue = d * (double)(this.posBarLocation[0] - this.posBarBounds[0]) + this.minPos;
                } else {
                    this.FirstPosBarDrag = false;
                    this.XPosBarDrag = this.acPosBar.getMouseX();
                }
            }
        } else if (actionEvent.getActionCommand().equals("Volume")) {
            if (!this.acVolume.isMousePressed()) {
                this.FirstVolumeDrag = true;
                this.offScreenGraphics.drawImage(this.clearImage, this.titleLocation[0], this.titleLocation[1], this);
                this.offScreenGraphics.drawImage(this.titleImage, this.titleLocation[0], this.titleLocation[1], this);
                this.repaint();
            } else {
                int n = 0;
                if (!this.FirstVolumeDrag) {
                    n = this.acVolume.getMouseX() - this.XVolumeDrag;
                    this.XVolumeDrag = this.acVolume.getMouseX() - n;
                    this.volumeLocation[0] = this.volumeLocation[0] + n < this.volumeBounds[0] ? this.volumeBounds[0] : (this.volumeLocation[0] + n > this.volumeBounds[1] ? this.volumeBounds[1] : this.volumeLocation[0] + n);
                    this.acVolume.setLocation(this.volumeLocation[0], this.volumeLocation[1]);
                    double d = (this.maxGain - this.minGain) / (this.volumeBounds[1] - this.volumeBounds[0]);
                    this.gainValue = (int)(d * (double)(this.volumeLocation[0] - this.volumeBounds[0]) + (double)this.minGain);
                    if (this.gainValue == 0) {
                        this.theSoundPlayer.setGain(0.0);
                    } else {
                        this.theSoundPlayer.setGain((double)this.gainValue / (double)this.maxGain);
                    }
                    String string = "VOLUME: " + Math.round(100 / (this.volumeBounds[1] - this.volumeBounds[0]) * (this.volumeLocation[0] - this.volumeBounds[0])) + "%";
                    Image image = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, string).getBanner();
                    this.offScreenGraphics.drawImage(this.volumeImage[(int)Math.round((double)this.gainValue / (double)this.maxGain * (double)(this.volumeImage.length - 1))], this.volumeBarLocation[0], this.volumeBarLocation[1], this);
                    this.offScreenGraphics.drawImage(this.clearImage, this.titleLocation[0], this.titleLocation[1], this);
                    this.offScreenGraphics.drawImage(image, this.titleLocation[0], this.titleLocation[1], this);
                } else {
                    this.FirstVolumeDrag = false;
                    this.XVolumeDrag = this.acVolume.getMouseX();
                }
            }
        } else if (actionEvent.getActionCommand().equals("Balance")) {
            if (!this.acBalance.isMousePressed()) {
                this.FirstBalanceDrag = true;
                this.offScreenGraphics.drawImage(this.clearImage, this.titleLocation[0], this.titleLocation[1], this);
                this.offScreenGraphics.drawImage(this.titleImage, this.titleLocation[0], this.titleLocation[1], this);
                this.repaint();
            } else {
                int n = 0;
                if (!this.FirstBalanceDrag) {
                    n = this.acBalance.getMouseX() - this.XBalanceDrag;
                    this.XBalanceDrag = this.acBalance.getMouseX() - n;
                    this.balanceLocation[0] = this.balanceLocation[0] + n < this.balanceBounds[0] ? this.balanceBounds[0] : (this.balanceLocation[0] + n > this.balanceBounds[1] ? this.balanceBounds[1] : this.balanceLocation[0] + n);
                    this.acBalance.setLocation(this.balanceLocation[0], this.balanceLocation[1]);
                    double d = (this.maxBalance - this.minBalance) / (double)(this.balanceBounds[1] - this.balanceBounds[0]);
                    this.balanceValue = d * (double)(this.balanceLocation[0] - this.balanceBounds[0]) + this.minBalance;
                    this.theSoundPlayer.setPan((float)this.balanceValue);
                    String string = "BALANCE: " + (int)Math.abs(this.balanceValue * 100.0) + "%";
                    string = this.balanceValue > 0.0 ? string + " RIGHT" : (this.balanceValue < 0.0 ? string + " LEFT" : "BALANCE: CENTER");
                    Image image = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, string).getBanner();
                    this.offScreenGraphics.drawImage(this.balanceImage[0], this.balanceBarLocation[0], this.balanceBarLocation[1], this);
                    this.offScreenGraphics.drawImage(this.clearImage, this.titleLocation[0], this.titleLocation[1], this);
                    this.offScreenGraphics.drawImage(image, this.titleLocation[0], this.titleLocation[1], this);
                } else {
                    this.FirstBalanceDrag = false;
                    this.XBalanceDrag = this.acBalance.getMouseX();
                }
            }
        } else if (actionEvent.getActionCommand().equals("Eject")) {
            if (this.playerState == 2 || this.playerState == 3) {
                this.theSoundPlayer.stopPlayback();
                this.playerState = 4;
            }
            if (this.playerState == 0 || this.playerState == 4 || this.playerState == 1) {
                System.gc();
                PlaylistItem playlistItem = null;
                if (this.acEject.getMouseButton() == 16) {
                    Frame frame = new Frame();
                    frame.setLocation(this.getBounds().x, this.getBounds().y + 10);
                    FileSelector.setWindow(frame);
                    String string = FileSelector.selectFile(1, this.config.getExtensions(), this.config.getLastDir());
                    string = FileSelector.getFile();
                    if (string != null) {
                        this.config.setLastDir(FileSelector.getDirectory());
                        if (string != null) {
                            if (string.toLowerCase().endsWith(".m3u")) {
                                if (this.loadPlaylist(this.config.getLastDir() + string)) {
                                    this.config.setPlaylistFilename(this.config.getLastDir() + string);
                                    this.playlist.begin();
                                    this.fileList.initPlayList();
                                    this.setCurrentSong(this.playlist.getCursor());
                                    this.fileList.repaint();
                                }
                            } else if (string.toLowerCase().endsWith(".wsz")) {
                                this.dispose();
                                this.loadSkin(this.config.getLastDir() + string);
                                this.config.setDefaultSkin(this.config.getLastDir() + string);
                            } else {
                                playlistItem = new PlaylistItem(string, this.config.getLastDir() + string, -1L, true);
                            }
                        }
                    }
                } else if (this.acEject.getMouseButton() == 4) {
                    UrlDialog urlDialog = new UrlDialog("Open location", this.getBounds().x, this.getBounds().y + 10, 280, 120, this.config.getLastURL());
                    urlDialog.show();
                    if (urlDialog.getFile() != null) {
                        playlistItem = new PlaylistItem(urlDialog.getFile(), urlDialog.getURL(), -1L, false);
                        this.config.setLastURL(urlDialog.getURL());
                    }
                }
                if (playlistItem != null) {
                    this.playlist.removeAllItems();
                    this.playlist.appendItem(playlistItem);
                    this.playlist.nextCursor();
                    this.fileList.initPlayList();
                    this.setCurrentSong(playlistItem);
                }
            }
            this.offScreenGraphics.drawImage(this.iconsImage[2], this.iconsLocation[0], this.iconsLocation[1], this);
            this.offScreenGraphics.drawImage(this.iconsImage[4], this.iconsLocation[2], this.iconsLocation[3], this);
            this.repaint();
        } else if (actionEvent.getActionCommand().equals("Play")) {
            if (this.playlist.isModified()) {
                PlaylistItem playlistItem = this.playlist.getCursor();
                if (playlistItem == null) {
                    this.playlist.begin();
                    playlistItem = this.playlist.getCursor();
                }
                this.setCurrentSong(playlistItem);
                this.playlist.setModified(false);
                this.fileList.repaint();
            }
            if (this.playerState == 3) {
                this.theSoundPlayer.resumePlayback();
                this.playerState = 2;
                this.offScreenGraphics.drawImage(this.iconsImage[0], this.iconsLocation[0], this.iconsLocation[1], this);
                this.offScreenGraphics.drawImage(this.iconsImage[3], this.iconsLocation[2], this.iconsLocation[3], this);
                this.repaint();
            } else if (this.playerState == 2) {
                this.theSoundPlayer.stopPlayback();
                this.playerState = 2;
                this.secondsAmount = 0L;
                this.offScreenGraphics.drawImage(this.timeImage[0], this.minuteDLocation[0], this.minuteDLocation[1], this);
                this.offScreenGraphics.drawImage(this.timeImage[0], this.minuteLocation[0], this.minuteLocation[1], this);
                this.offScreenGraphics.drawImage(this.timeImage[0], this.secondDLocation[0], this.secondDLocation[1], this);
                this.offScreenGraphics.drawImage(this.timeImage[0], this.secondLocation[0], this.secondLocation[1], this);
                this.repaint();
                if (this.currentFileOrURL != null) {
                    try {
                        if (this.currentIsFile) {
                            this.theSoundPlayer.setDataSource(this.openFile(this.currentFileOrURL));
                        } else {
                            this.theSoundPlayer.setDataSource(new URL(this.currentFileOrURL));
                        }
                        this.theSoundPlayer.startPlayback();
                    }
                    catch (Exception exception) {
                        this.trace(0, this.getClass().getName(), "Cannot read file : " + this.currentFileOrURL + ", " + exception.getMessage());
                        this.showMessage("INVALID FILE");
                    }
                }
            } else if (this.playerState == 4 || this.playerState == 1) {
                this.theSoundPlayer.stopPlayback();
                if (this.currentFileOrURL != null) {
                    try {
                        if (this.currentIsFile) {
                            this.theSoundPlayer.setDataSource(this.openFile(this.currentFileOrURL));
                        } else {
                            this.theSoundPlayer.setDataSource(new URL(this.currentFileOrURL));
                        }
                        this.theSoundPlayer.startPlayback();
                        this.theSoundPlayer.setGain((double)this.gainValue / (double)this.maxGain);
                        this.theSoundPlayer.setPan((float)this.balanceValue);
                        int n = Math.round(this.theSoundPlayer.getBitRate() / 1000);
                        this.sampleRateImage = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, "" + Math.round(this.theSoundPlayer.getAudioFormat().getSampleRate() / 1000.0f)).getBanner();
                        this.bitsRateImage = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, "" + n).getBanner();
                        this.offScreenGraphics.drawImage(this.sampleRateImage, this.sampleRateLocation[0], this.sampleRateLocation[1], this);
                        this.offScreenGraphics.drawImage(this.bitsRateImage, this.bitsRateLocation[0], this.bitsRateLocation[1], this);
                        if (this.theSoundPlayer.getAudioFormat().getChannels() == 2) {
                            this.offScreenGraphics.drawImage(this.activeModeImage[0], this.stereoLocation[0], this.stereoLocation[1], this);
                        } else if (this.theSoundPlayer.getAudioFormat().getChannels() == 1) {
                            this.offScreenGraphics.drawImage(this.activeModeImage[1], this.monoLocation[0], this.monoLocation[1], this);
                        }
                        this.titleText = this.currentSongName.toUpperCase();
                        this.titleImage = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, this.titleText).getBanner(0, 0, 155, 6);
                        this.offScreenGraphics.drawImage(this.clearImage, this.titleLocation[0], this.titleLocation[1], this);
                        this.offScreenGraphics.drawImage(this.titleImage, this.titleLocation[0], this.titleLocation[1], this);
                        this.offScreenGraphics.drawImage(this.timeImage[0], this.minuteDLocation[0], this.minuteDLocation[1], this);
                        this.offScreenGraphics.drawImage(this.timeImage[0], this.minuteLocation[0], this.minuteLocation[1], this);
                        this.offScreenGraphics.drawImage(this.timeImage[0], this.secondDLocation[0], this.secondDLocation[1], this);
                        this.offScreenGraphics.drawImage(this.timeImage[0], this.secondLocation[0], this.secondLocation[1], this);
                        this.offScreenGraphics.drawImage(this.iconsImage[0], this.iconsLocation[0], this.iconsLocation[1], this);
                        this.offScreenGraphics.drawImage(this.iconsImage[3], this.iconsLocation[2], this.iconsLocation[3], this);
                        if (this.theSoundPlayer.getAudioFileFormat().getFrameLength() != -1) {
                            this.trace(1, this.getClass().getName(), "Frames = " + this.theSoundPlayer.getAudioFileFormat().getFrameLength());
                        }
                        this.trace(1, this.getClass().getName(), "SampleRate (Hz) = " + this.theSoundPlayer.getAudioFormat().getSampleRate());
                        this.trace(1, this.getClass().getName(), "FrameRate = " + this.theSoundPlayer.getAudioFormat().getFrameRate());
                        this.trace(1, this.getClass().getName(), "FrameSize (bytes) = " + this.theSoundPlayer.getAudioFormat().getFrameSize());
                        this.trace(1, this.getClass().getName(), "AudioFileFormat = " + this.theSoundPlayer.getAudioFileFormat());
                    }
                    catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                        this.trace(0, this.getClass().getName(), "Stream error :" + this.currentFileOrURL + ", " + unsupportedAudioFileException.getMessage());
                        this.showMessage("INVALID FILE");
                    }
                    catch (LineUnavailableException lineUnavailableException) {
                        this.trace(0, this.getClass().getName(), "Stream error :" + this.currentFileOrURL + ", " + lineUnavailableException.getMessage());
                        this.showMessage("INVALID FILE");
                    }
                    catch (IOException iOException) {
                        this.trace(0, this.getClass().getName(), "Stream error :" + this.currentFileOrURL + ", " + iOException.getMessage());
                        this.showMessage("INVALID FILE");
                    }
                    this.playerState = 2;
                    this.repaint();
                    this.trace(1, this.getClass().getName(), this.titleText);
                }
            }
        } else if (actionEvent.getActionCommand().equals("Pause")) {
            if (this.playerState == 2) {
                this.theSoundPlayer.pausePlayback();
                this.playerState = 3;
                this.offScreenGraphics.drawImage(this.iconsImage[1], this.iconsLocation[0], this.iconsLocation[1], this);
                this.offScreenGraphics.drawImage(this.iconsImage[4], this.iconsLocation[2], this.iconsLocation[3], this);
                this.repaint();
            } else if (this.playerState == 3) {
                this.theSoundPlayer.resumePlayback();
                this.playerState = 2;
                this.offScreenGraphics.drawImage(this.iconsImage[0], this.iconsLocation[0], this.iconsLocation[1], this);
                this.offScreenGraphics.drawImage(this.iconsImage[3], this.iconsLocation[2], this.iconsLocation[3], this);
                this.repaint();
            }
        } else if (actionEvent.getActionCommand().equals("Stop")) {
            if (this.playerState == 3 || this.playerState == 2) {
                this.theSoundPlayer.stopPlayback();
                this.playerState = 4;
                this.secondsAmount = 0L;
                this.acPosBar.setLocation(this.posBarBounds[0], this.posBarLocation[1]);
                this.offScreenGraphics.drawImage(this.iconsImage[2], this.iconsLocation[0], this.iconsLocation[1], this);
                this.offScreenGraphics.drawImage(this.iconsImage[4], this.iconsLocation[2], this.iconsLocation[3], this);
                this.repaint();
            }
        } else if (actionEvent.getActionCommand().equals("Next")) {
            this.playlist.nextCursor();
            this.fileList.nextCursor();
            PlaylistItem playlistItem = this.playlist.getCursor();
            this.setCurrentSong(playlistItem);
        } else if (actionEvent.getActionCommand().equals("Previous")) {
            this.playlist.previousCursor();
            this.fileList.nextCursor();
            PlaylistItem playlistItem = this.playlist.getCursor();
            this.setCurrentSong(playlistItem);
        } else if (actionEvent.getActionCommand().equals("Exit")) {
            this.closePlayer();
        } else if (actionEvent.getActionCommand().equals("Minimize")) {
            this.topFrame.setLocation(this.OrigineX, this.OrigineY);
            this.topFrame.setState(1);
        } else if (actionEvent.getActionCommand().equals("TitleBar")) {
            if (!this.acTitleBar.isMousePressed()) {
                this.FirstDrag = true;
            } else {
                int n = 0;
                int n2 = 0;
                if (!this.FirstDrag) {
                    n = this.acTitleBar.getMouseX() - this.XDrag;
                    n2 = this.acTitleBar.getMouseY() - this.YDrag;
                    this.XDrag = this.acTitleBar.getMouseX() - n;
                    this.YDrag = this.acTitleBar.getMouseY() - n2;
                    this.OrigineX += n;
                    this.OrigineY += n2;
                    if (this.OrigineX < 0) {
                        this.OrigineX = 0;
                    }
                    if (this.OrigineY < 0) {
                        this.OrigineY = 0;
                    }
                    if (this.screenWidth != -1 && this.OrigineX > this.screenWidth - this.WinWidth) {
                        this.OrigineX = this.screenWidth - this.WinWidth;
                    }
                    if (this.screenHeight != -1 && this.OrigineY > this.screenHeight - this.WinHeight) {
                        this.OrigineY = this.screenHeight - this.WinHeight;
                    }
                    this.topFrame.setLocation(this.OrigineX, this.OrigineY);
                    this.topFrame.setSize(0, 0);
                    this.setLocation(this.OrigineX, this.OrigineY);
                    this.fileList.setLocation(this.OrigineX, this.OrigineY + this.WinHeight);
                } else {
                    this.FirstDrag = false;
                    this.XDrag = this.acTitleBar.getMouseX();
                    this.YDrag = this.acTitleBar.getMouseY();
                }
            }
        } else if (actionEvent.getActionCommand().equals("Playlist")) {
            if (this.acPlaylist.getCheckboxState()) {
                this.config.setPlaylistEnabled(true);
                this.fileList.setVisible(true);
            } else {
                this.config.setPlaylistEnabled(false);
                this.fileList.setVisible(false);
            }
        } else if (actionEvent.getActionCommand().equals("Shuffle")) {
            if (this.acShuffle.getCheckboxState()) {
                this.config.setShuffleEnabled(true);
                if (this.playlist != null) {
                    this.playlist.shuffle();
                    this.fileList.initPlayList();
                    PlaylistItem playlistItem = this.playlist.getCursor();
                    this.setCurrentSong(playlistItem);
                }
            } else {
                this.config.setShuffleEnabled(false);
            }
        } else if (actionEvent.getActionCommand().equals("Repeat")) {
            if (this.acRepeat.getCheckboxState()) {
                this.config.setRepeatEnabled(true);
            } else {
                this.config.setRepeatEnabled(false);
            }
        } else if (actionEvent.getActionCommand().equals("Equalizer")) {
            if (this.acEqualizer.getCheckboxState()) {
                this.config.setEqualizerEnabled(true);
            } else {
                this.config.setEqualizerEnabled(false);
            }
        }
    }

    private void showMessage(String string) {
        if (string.length() > TEXT_LENGTH_MAX) {
            string = string.substring(0, TEXT_LENGTH_MAX);
        }
        this.titleImage = new taftb(this.fontIndex, this.imText, this.fontWidth, this.fontHeight, 0, string).getBanner();
        this.offScreenGraphics.drawImage(this.clearImage, this.titleLocation[0], this.titleLocation[1], this);
        this.offScreenGraphics.drawImage(this.titleImage, this.titleLocation[0], this.titleLocation[1], this);
        this.offScreenGraphics.drawImage(this.sampleRateClearImage, this.sampleRateLocation[0], this.sampleRateLocation[1], this);
        this.offScreenGraphics.drawImage(this.bitsRateClearImage, this.bitsRateLocation[0], this.bitsRateLocation[1], this);
        this.offScreenGraphics.drawImage(this.passiveModeImage[0], this.stereoLocation[0], this.stereoLocation[1], this);
        this.offScreenGraphics.drawImage(this.passiveModeImage[1], this.monoLocation[0], this.monoLocation[1], this);
        this.offScreenGraphics.drawImage(this.timeImage[0], this.minuteDLocation[0], this.minuteDLocation[1], this);
        this.offScreenGraphics.drawImage(this.timeImage[0], this.minuteLocation[0], this.minuteLocation[1], this);
        this.offScreenGraphics.drawImage(this.timeImage[0], this.secondDLocation[0], this.secondDLocation[1], this);
        this.offScreenGraphics.drawImage(this.timeImage[0], this.secondLocation[0], this.secondLocation[1], this);
    }

    public void paint(Graphics graphics) {
        if (this.offScreenImage != null) {
            graphics.drawImage(this.offScreenImage, 0, 0, this);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.topFrame.setSize(0, 0);
        this.show();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.topFrame.setSize(0, 0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.closePlayer();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.topFrame.setSize(0, 0);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.topFrame.setLocation(this.OrigineX, this.OrigineY);
        this.topFrame.setSize(0, 0);
        this.toFront();
        this.show();
        if (this.acPlaylist.getCheckboxState()) {
            this.fileList.setVisible(true);
        } else {
            this.fileList.setVisible(false);
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.topFrame.setLocation(this.OrigineX, this.OrigineY);
        this.topFrame.setSize(0, 0);
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.topFrame.setSize(0, 0);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
        DataFlavor dataFlavor = null;
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (DataFlavor.javaFileListFlavor.equals(dataFlavorArray[n])) {
                dataFlavor = dataFlavorArray[n];
                break;
            }
            ++n;
        }
        if (dataFlavor != null) {
            if ((dropTargetDropEvent.getSourceActions() & 1) == 0) {
                return;
            }
            dropTargetDropEvent.acceptDrop(1);
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                Object object = transferable.getTransferData(dataFlavor);
                if (object instanceof List) {
                    List list = (List)object;
                    if (list.size() > 0) {
                        File file = null;
                        if (this.playerState == 2 || this.playerState == 3) {
                            this.theSoundPlayer.stopPlayback();
                            this.playerState = 4;
                        }
                        this.playlist.removeAllItems();
                        ListIterator listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            file = (File)listIterator.next();
                            PlaylistItem playlistItem = null;
                            if (file == null || (playlistItem = new PlaylistItem(file.getName(), file.getAbsolutePath(), -1L, true)) == null) continue;
                            this.playlist.appendItem(playlistItem);
                        }
                        this.playlist.nextCursor();
                        this.fileList.initPlayList();
                        this.setCurrentSong(this.playlist.getCursor());
                    }
                } else {
                    this.trace(2, this.getClass().getName(), "Unknown dropped objects");
                }
            }
            catch (IOException iOException) {
                this.trace(2, this.getClass().getName(), "Drop error :" + iOException.getMessage());
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                this.trace(2, this.getClass().getName(), "Drop error :" + unsupportedFlavorException.getMessage());
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            catch (Exception exception) {
                this.trace(2, this.getClass().getName(), "Drop error :" + exception.getMessage());
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            dropTargetDropEvent.dropComplete(true);
        }
    }

    private boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        DataFlavor dataFlavor = null;
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (DataFlavor.javaFileListFlavor.equals(dataFlavorArray[n])) {
                dataFlavor = dataFlavorArray[n];
                break;
            }
            ++n;
        }
        if (dataFlavor != null) {
            return (dropTargetDragEvent.getSourceActions() & 1) != 0;
        }
        return false;
    }

    private File openFile(String string) {
        return new File(string);
    }

    public void setSkin(String string) {
        this.thePath = string;
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    protected int getPlayerState() {
        return this.playerState;
    }

    private void closePlayer() {
        if (this.playerState == 3 || this.playerState == 2) {
            this.theSoundPlayer.stopPlayback();
        }
        this.config.setLocation(this.OrigineX, this.OrigineY);
        this.config.save();
        this.topFrame.dispose();
        System.gc();
        this.exit(0);
    }

    public void exit(int n) {
        System.exit(n);
    }

    public void pressStart() {
        this.acPlay.fireEvent();
    }

    public void pressStop() {
        this.acStop.fireEvent();
    }

    public void pressNext() {
        this.acNext.fireEvent();
    }

    public void pressPrevious() {
        this.acPrevious.fireEvent();
    }

    public void pressEject() {
        this.acEject.fireEvent();
    }

    private void trace(int n, String string, String string2) {
        Debug debug = Debug.getInstance();
        debug.log(n, string + ":" + string2);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            string = stringArray[n2];
            if (string.startsWith("-")) {
                if (string.toLowerCase().equals("-init")) {
                    if (++n2 >= stringArray.length) {
                        Player.usage("init value missing");
                    }
                    initConfig = (string2 = stringArray[n2]).toLowerCase().startsWith("http") ? string2 : string2.replace('\\', '/').replace('/', File.separatorChar);
                } else if (string.toLowerCase().equals("-song")) {
                    if (++n2 >= stringArray.length) {
                        Player.usage("song value missing");
                    }
                    initSong = (string2 = stringArray[n2]).toLowerCase().startsWith("http") ? string2 : string2.replace('\\', '/').replace('/', File.separatorChar);
                } else if (string.toLowerCase().equals("-start")) {
                    autoRun = true;
                } else if (string.toLowerCase().equals("-showplaylist")) {
                    showPlaylist = "true";
                } else if (string.toLowerCase().equals("-skin")) {
                    if (++n2 >= stringArray.length) {
                        Player.usage("skin value missing");
                    }
                    string2 = stringArray[n2];
                    volumeHeight = 0;
                    string3 = string2.toLowerCase().startsWith("http") ? string2 : string2.replace('\\', '/').replace('/', File.separatorChar);
                } else if (string.toLowerCase().equals("-loglevel")) {
                    if (++n2 >= stringArray.length) {
                        Player.usage("loglevel value missing");
                    }
                    string2 = stringArray[n2];
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Player.usage("Invalid number : " + numberFormatException.getMessage());
                    }
                } else if (string.toLowerCase().equals("-logfile")) {
                    if (++n2 >= stringArray.length) {
                        Player.usage("logfile value missing");
                    }
                    string2 = stringArray[n2];
                    string4 = string2.replace('\\', '/').replace('/', File.separatorChar);
                } else if (string.toLowerCase().equals("-v")) {
                    if (++n2 >= stringArray.length) {
                        Player.usage("skin version value missing");
                    }
                    skinVersion = stringArray[n2];
                } else if (string.toLowerCase().equals("-h")) {
                    if (++n2 >= stringArray.length) {
                        Player.usage("height value missing");
                    }
                    try {
                        volumeHeight = Integer.parseInt(stringArray[n2]);
                    }
                    catch (Exception exception) {}
                } else {
                    Player.usage("Unknown parameter : " + string);
                }
            } else {
                Player.usage("Invalid parameter :" + string);
            }
            ++n2;
        }
        Player player = new Player(string3, n, string4, new Frame(TITLETEXT));
        player.show();
        if (autoRun) {
            player.pressStart();
        }
    }

    private static void usage(String string) {
        System.out.println(TITLETEXT + " : " + string);
        System.out.println("");
        System.out.println(TITLETEXT + " : Usage");
        System.out.println("              java javazoom.jlGui.Player [-skin skinFilename] [-song audioFilename] [-start] [-loglevel number] [-logfile logFilename] [-init configFilename] [-v skinversion] [-h volheight]");
        System.out.println("");
        System.out.println("              skinFilename   : Filename or URL to a Winamp Skin2.x");
        System.out.println("              audioFilename  : Filename or URL to initial song or playlist");
        System.out.println("              start          : Starts playing song (from the playlist)");
        System.out.println("              showplaylist   : Show playlist");
        System.out.println("              number         : Level of traces (0,1,2)");
        System.out.println("              logFilename    : Filename for traces");
        System.out.println("");
        System.out.println("              Advanced parameters :");
        System.out.println("              skinversion    : 1 or 2 (default 1)");
        System.out.println("              volheight      : Custom volume height");
        System.out.println("              configFilename : Filename or URL to jlGui initial configuration (playlist,skin,parameters ...)");
        System.out.println("                               Initial configuration won't be overriden by -skin and -song arguments");
        System.out.println("");
        System.out.println("Homepage    : http://www.javazoom.net");
        System.exit(0);
    }
}

