/*
 * Decompiled with CFR 0.152.
 */
package javazoom.Util;

import java.io.File;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javazoom.Util.Config;

public class FileUtil {
    private static Vector supportedExtensions = null;

    public static File[] findFilesRecursively(File file) {
        if (file.isFile()) {
            File[] fileArray = new File[]{file};
            return fileArray;
        }
        Vector vector = new Vector();
        FileUtil.addSongsRecursive(vector, file);
        return vector.toArray(new File[vector.size()]);
    }

    private static void addSongsRecursive(Vector vector, File file) {
        if (file == null) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file + File.separator + stringArray[n]);
            if (file2.isDirectory()) {
                FileUtil.addSongsRecursive(vector, file2);
            } else if (FileUtil.isMusicFile(stringArray[n])) {
                vector.addElement(file2);
            }
            ++n;
        }
    }

    public static boolean isMusicFile(String string) {
        Vector vector = FileUtil.getSupportedExtensions();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            if (!string2.equals(".wsz") && !string2.equals(".m3u") && string.endsWith(vector.elementAt(n2).toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Vector getSupportedExtensions() {
        if (supportedExtensions == null) {
            String string = Config.getInstance().getExtensions();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            supportedExtensions = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                supportedExtensions.add("." + stringTokenizer.nextElement());
            }
        }
        return supportedExtensions;
    }

    public static String getSupprtedExtensions() {
        Vector vector = FileUtil.getSupportedExtensions();
        String string = "";
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            if (!string2.equals(".wsz") && !string2.equals(".m3u")) {
                string = n2 == 0 ? string + string2 : string + ";" + string2;
            }
            ++n2;
        }
        return string;
    }

    public static String padString(String string, int n) {
        return FileUtil.padString(string, ' ', n);
    }

    public static String padString(String string, char c, int n) {
        int n2 = 0;
        if (string == null) {
            string = "";
            n2 = n;
        } else {
            int n3 = string.length();
            if (n3 > n) {
                string = string.substring(0, n);
            } else if (n3 < n) {
                n2 = n - n3;
            }
        }
        if (n2 == 0) {
            return string;
        }
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        return string + new String(cArray);
    }

    public static String rightPadString(String string, int n) {
        return FileUtil.rightPadString(string, ' ', n);
    }

    public static String rightPadString(String string, char c, int n) {
        int n2 = 0;
        if (string == null) {
            string = "";
            n2 = n;
        } else {
            int n3 = string.length();
            if (n3 > n) {
                string = string.substring(n);
            } else if (n3 < n) {
                n2 = n - n3;
            }
        }
        if (n2 == 0) {
            return string;
        }
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c);
        return new String(cArray) + string;
    }
}

