// Server.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "RFSSRV.h"
#include <stdlib.h>



HWND hWnd;

const  MSG_RFS_EVENT = WM_USER + 1 ;

bool DisplayError(int nErrorCode)
{
	char sError[1024];
	RFS_GetErrorText(nErrorCode, sError);
	printf("Error: %s\n",sError);
	Sleep(5000);
	return TRUE;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	if (message != MSG_RFS_EVENT)
		return DefWindowProc(hWnd, message, wParam, lParam);

	char sMsg[1024];
	switch ( wParam ) 
	{
		case MSG_CLIENT_CONNECTED:
			strcpy(sMsg,"Client connected");
			break;
		case MSG_CLIENT_DISCONNECTED:
			strcpy(sMsg,"Client disconnected");
			break;
		case MSG_CLIENT_FILEOPEN:
			strcpy(sMsg,"File Open");
			break;
		case MSG_CLIENT_FILEEXISTS:
			strcpy(sMsg,"File Exists");
			break;
		case MSG_CLIENT_FILECLOSE:
			strcpy(sMsg,"File Close");
			break;
		case MSG_CLIENT_FILEREAD:
			strcpy(sMsg,"File Read");
			break;
		case MSG_CLIENT_FILEWRITE:
			strcpy(sMsg,"File Write");
			break;
		case MSG_CLIENT_FILECREATE:
			strcpy(sMsg,"File Create");
			break;
		case MSG_CLIENT_FILESETPOINTER:
			strcpy(sMsg,"Set File Pointer");
			break;
		case MSG_CLIENT_FILEFINDFIRST:
			strcpy(sMsg,"Find first file");
			break;
		case MSG_CLIENT_FILEFINDNEXT:
			strcpy(sMsg,"Find next file");
			break;
		case MSG_CLIENT_AUTH_FAILED:
			strcpy(sMsg,"Login failed");
			break;
		case MSG_SERVER_STARTED:
			strcpy(sMsg,"Server Started");
			break;
		case MSG_SERVER_STOPPED:
			strcpy(sMsg,"Server Stopped");
			break;
		case MSG_CLIENT_CREATEDIR:
			strcpy(sMsg,"Create Directory");
			break;
		case MSG_CLIENT_DELETEDIR:
			strcpy(sMsg,"Delete Directory");
			break;
		case MSG_CLIENT_GETFILEINFO:
			strcpy(sMsg,"Get File Info");
			break;
		case MSG_CLIENT_FILEDELETE:
			strcpy(sMsg,"Delete File");
			break;
	}
	strcat(sMsg," - ");
	strcat(sMsg,(char*)lParam);
	strcat(sMsg,"\n");
	printf(sMsg);
	return 0;
}

int CreateHiddenWindow ()
{
	WNDCLASS wc;	
	wc.lpfnWndProc = (WNDPROC) WndProc; 
	wc.style = wc.cbClsExtra = wc.cbWndExtra = 0; 
	wc.hIcon = wc.hCursor = NULL;
	wc.lpszMenuName = NULL; 
	wc.hbrBackground = 0; 
	wc.lpszClassName = "RFS_SERVER"; 
	if (!RegisterClass(&wc)) 
		return FALSE;
	hWnd = CreateWindow("RFS_SERVER", "", WS_OVERLAPPEDWINDOW, 0, 0, 0,0, NULL, NULL, NULL, NULL);
	if (!hWnd) 
		return FALSE;
	return TRUE;
}

int main(int argc, char* argv[])
{
	CreateHiddenWindow();
	RFS_SetRegistrationCode("A1B2C3D4E5F6");

	//----------------------------------------
	// Load users and devices to server
	//----------------------------------------
	int nRet;
	if ((nRet=RFS_UserAdd("adm","addm"))!=0) return DisplayError(nRet);
	RFS_UserSetPassword("adm","adm");
	if ((nRet=RFS_UserAdd("usr","usr"))!=0) return DisplayError(nRet);
	if ((nRet=RFS_DeviceAdd("CDRIVE","C:"))!=0) return DisplayError(nRet);
	if ((nRet=RFS_DeviceAdd("TEMP","C:\\Temp"))!=0) return DisplayError(nRet);

	//----------------------------------------
	// Load users rights
	//----------------------------------------
	if ((nRet=RFS_SetUserDeviceRights("adm","CDRIVE","RWCLD"))!=0) return DisplayError(nRet);
	if ((nRet=RFS_SetUserDeviceRights("adm","TEMP","RWL"))!=0) return DisplayError(nRet);
	if ((nRet=RFS_SetUserDeviceRights("usr","CDRIVE","RL"))!=0) return DisplayError(nRet);
	if ((nRet=RFS_SetUserDeviceRights("usr","TEMP","RWL"))!=0) return DisplayError(nRet);

	//----------------------------------------
	// Dispaly current users rights for devices
	//----------------------------------------
	char sUser[100]; char sDeviceName[100];char sDevicePath[MAX_PATH]; char sRights[10];
	printf("User\tDevice(rights)\n");
	printf("-------------------------\n");
	if (RFS_EnumUsersFirst(sUser)==0){
		while (TRUE){
			printf("%s\t",sUser);
			// Loop for Devices
			if (RFS_EnumDevicesFirst(sDeviceName,sDevicePath)==0){
				while (TRUE){
					if (RFS_GetUserDeviceRights(sUser,sDeviceName,sRights)==0)
						printf("%s(%s) ",sDeviceName,sRights);
					if (!RFS_EnumDevicesNext(sDeviceName,sDevicePath)==0) // Next Device
						break;
				}
			}
			printf("\n",sUser);
		    if (!RFS_EnumUsersNext(sUser)==0) // Next User
				break;
		}
	}
	printf("-------------------------\n");

	//----------------------------------------
	// Start Server 
	//----------------------------------------
	MSG msg;
	if ((nRet=RFS_StartServer(7007,hWnd,MSG_RFS_EVENT))!=0)
		return FALSE;
	while (GetMessage( &msg, NULL, 0, 0 ))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return 0;
}

