//Dial - Win32 phone dialer
//
//this source code is public domain.. feel free to make any changes, and (re)distribute.
//also feel free to give me all kinds of credit if you use this code in anything...and if you
//don't, well, may your guilt eat away at you for the rest of your miserable existence.
//
//oh, and please excuse my horrible coding style. ;)

#include <windows.h>
#include "resource.h"

//map a letter to a number on a phone. assumes lower case.. returns 0 if unknown
//q and z aren't on the phone, but they'll be mapped to 7 and 9 respectively
unsigned char chartonum(unsigned char c)
{
	if((c>='a')&&(c<='c')) return '2';
	if((c>='d')&&(c<='f')) return '3';
	if((c>='g')&&(c<='i')) return '4';
	if((c>='j')&&(c<='l')) return '5';
	if((c>='m')&&(c<='o')) return '6';
	if((c>='p')&&(c<='s')) return '7';
	if((c>='t')&&(c<='v')) return '8';
	if((c>='w')&&(c<='z')) return '9';
	return '0';
}


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hprevInstance,LPSTR lpcl,int cmdshow)
{
	int i, tone;

	//first, let's convert any letters to numbers. this involves first looping through the string
	//checking for uppercase chars and altering if necessary. next, calling chartonum for any
	//lowercase chars found (and due to the first line of code, any previously-ucase chars
	//will be lcase now)
	for(i=0;lpcl[i]!='\0';i++) if((lpcl[i]>='A')&&(lpcl[i]<='Z')) lpcl[i]+=32;
	for(i=0;lpcl[i]!='\0';i++) if((lpcl[i]>='a')&&(lpcl[i]<='z')) lpcl[i]=chartonum(lpcl[i]);

	//check command line for invalid chars
	for(i=0;lpcl[i]!='\0';i++)
		if((lpcl[i]<'0')||(lpcl[i]>'9')) {
			if((lpcl[i]==',')||(lpcl[i]=='.')||(lpcl[i]=='-')||(lpcl[i]==' ')||(lpcl[i]=='#')||(lpcl[i]=='*')) continue;
			MessageBox(NULL,"Only digits (0-9), letters (a-z and A-Z), commas, periods, hyphens, pound keys (#), and stars (*) are allowed.","Dial",MB_OK);
			return 1;
		}

	//command line's fine..
	//start a simple loop, playing the appropriate sound, or pause. this probably won't make much
	//sense unless you look at the resources.. wav tones for 0-9, *, and # are set as integer values
	//which just happen to correspond to the ascii values of the characters. this makes
	//it much more efficient than a switch() calling PlaySound for each individual number. this way
	//it's compiled as a few ifs and one call to PlaySound, as opposed to a bunch of ifs and just as 
	//many calls to PlaySound.
	for(i=0;lpcl[i]!='\0';i++) {
		if(lpcl[i]==',') { Sleep(1000); continue; }
		if(lpcl[i]=='.') { Sleep(500); continue; }
		
		tone=0;
		if(((lpcl[i]>'0')&&(lpcl[i]<='9'))||(lpcl[i]=='*')||(lpcl[i]=='#')) tone=lpcl[i];

		if(tone) PlaySound(MAKEINTRESOURCE(tone),hInstance,SND_SYNC|SND_RESOURCE);
		Sleep(50);
	}

	//exit
	return 0;
}