/* fi32.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.12.29.
 * versiom 0.02
 *             - Added Wizard and Welcome screen
 *			   - Option in preferences not to show Welcome screen
 *			   - Help menu: - Changed help to Read Manual
 *							- Added 'help' as real help
 *			   - Changed About and Acknowledgments
 *
 * version 0.01 released 2000.09.14. JWi
 *  */

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <string.h>
#include "fi32res.h"
#include "flokecore.h"
#include <winuser.h>

unsigned char inifile[]="fi32.ini";
unsigned char fi32exepath[MAX_PATH];
unsigned char fi32exe[]="fi32.exe";
unsigned char hlpfile[]="fi32002.hlp";

unsigned int i=0;

int wiz_screen=0; // What Wizard Screen to display
BOOL isWelcome=FALSE; // Is this the welcome screen

static BOOL CALLBACK DLG_WIZARDFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);

//Pointers for Dynamical mem
unsigned char *txtCopyright;
unsigned char *txtACK;


CREATESTRUCT	btnStart;
HWND hwnd, btnhwnd;

struct dialoginfostruct {
	BOOL isStart;
	BOOL TASKOPTN;
	BOOL DISPLAYLOG;
	unsigned char LINE1[MAX_PATH];
	unsigned char LINE2[MAX_PATH];
	BOOL Ready;
} *dialoginfo;

BOOL waitInit=TRUE;
BOOL taskNeverRun=TRUE;
BOOL hasBeenRead=FALSE;


unsigned long helpcontext=20;

DWORD dwThreadId, dwThrdParam = 1;
HANDLE hThread;
DWORD MainThreadFunc(HWND hDlg);
unsigned char *txtSUM;

int APIENTRY WinMain(HINSTANCE hinst, HINSTANCE hinstPrev, LPSTR lpCmdLine, int nCmdShow)
{

	MSG msg;

	//btnStart.lpCreateParams=

	hinstGLB=hinst;
	init();
	dialoginfo=(struct dialoginfostruct *)malloc(sizeof(struct dialoginfostruct));
	initApp();
	WNDCLASS wc;

	memset(&wc,0,sizeof(wc));
	wc.lpfnWndProc = DefDlgProc;//DialogFunc;//DefWindowProc;//DefDlgProc;
	wc.cbWndExtra = DLGWINDOWEXTRA;
	wc.hInstance = hinst;
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
	wc.lpszClassName = "fi32";
	//wc.hIcon=LoadIcon(hinst, MAKEINTRESOURCE(ICON_APPWND));
	wc.hIcon=LoadIcon(hinst, MAKEINTRESOURCE(ICON_APPWND));
	//wc.hIcon=LoadIcon(NULL,MAKEINTRESOURCE(IDI_ASTERISK));
	RegisterClass(&wc);

//	return DialogBox(hinst, MAKEINTRESOURCE(IDD_MAINDIALOG), NULL, (DLGPROC) DialogFunc);
	DialogBox(hinst, MAKEINTRESOURCE(IDD_MAINDIALOG), NULL, (DLGPROC) DialogFunc);
	/* hwnd = CreateWindow (TEXT("fi32"), TEXT("TempAppCaption"),
                     WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                     CW_USEDEFAULT, CW_USEDEFAULT,
                     CW_USEDEFAULT, CW_USEDEFAULT,
                     NULL, NULL, hinst, NULL) ;


	ShowWindow(hwnd,SW_SHOW);
	UpdateWindow(hwnd);

	while (GetMessage (&msg, NULL, 0, 0))
		{
		     TranslateMessage (&msg) ;
		     DispatchMessage (&msg) ;
		}
	return msg.wParam ;
*/
	//return TRUE;
}

static int InitializeApp(HWND hDlg,WPARAM wParam, LPARAM lParam)
{
	//ModifyMenu(GetDlgItem(hDlg,ID_MENU),IDM_TASKOPTN, MF_GRAYED	,IDM_TASKOPTN,NULL);
	EnableMenuItem(GetMenu(hDlg),IDM_TASKOPTN,MF_GRAYED);
	DrawMenuBar(hDlg);
	return 1;
}

void initApp()
{
	loadpreferences();

	txtSUM=(unsigned char *)malloc(sizeof(unsigned char)*140);
	txtSUM[0]=0;
	dialoginfo->isStart=TRUE;
	dialoginfo->TASKOPTN=FALSE;
	dialoginfo->DISPLAYLOG=FALSE;
	strcpy(dialoginfo->LINE1,"\n");
	strcpy(dialoginfo->LINE2,"\n");
	dialoginfo->Ready=FALSE;
	int i=0;




}
void initWindow(HWND hDlg)
{
	unsigned char txtStart[]="&Start";
	unsigned char txtStop[]="&Stop";
	if(dialoginfo->isStart==TRUE)
		{
			SendDlgItemMessage(hDlg,IDSTART,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txtStart);

		}
	if(dialoginfo->isStart==FALSE)
		{
			SendDlgItemMessage(hDlg,IDSTART,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txtStop);

		}
	if(dialoginfo->TASKOPTN==TRUE)
		{
			EnableMenuItem(GetMenu(hDlg),IDM_TASKOPTN,MF_ENABLED);
		}
	if(dialoginfo->TASKOPTN==FALSE)
		{
			EnableMenuItem(GetMenu(hDlg),IDM_TASKOPTN,MF_GRAYED);
		}
	if(dialoginfo->DISPLAYLOG==TRUE)
		{
			if(report->reportfile[0]!=0)
				{
					EnableMenuItem(GetMenu(hDlg),IDM_DISPLAYLOG,MF_ENABLED);
					EnableWindow(GetDlgItem(hDlg,IDDISPLAYLOG),TRUE);
					//SendDlgItemMessage(hDlg,IDDISPLAYLOG,BM_SETSTYLE,BS_3STATE,MAKELPARAM(TRUE, 0));
				}
		}
	if(dialoginfo->DISPLAYLOG==FALSE)
		{
			EnableMenuItem(GetMenu(hDlg),IDM_DISPLAYLOG,MF_GRAYED);
			EnableWindow(GetDlgItem(hDlg,IDDISPLAYLOG),FALSE);
			//SendDlgItemMessage(hDlg,IDDISPLAYLOG,BM_SETSTYLE,BS_3STATE,MAKELPARAM(TRUE, 0));
		}

	SendDlgItemMessage(hDlg,ID_LINE1,WM_SETTEXT,0,(LPARAM)(LPCTSTR)dialoginfo->LINE1);
	SendDlgItemMessage(hDlg,ID_LINE2,WM_SETTEXT,0,(LPARAM)(LPCTSTR)dialoginfo->LINE2);
	DrawMenuBar(hDlg);
	sprintf(dialoginfo->LINE1,"Task File: %s\n",databasefile);
	//strcpy(dialoginfo->LINE1,"\n");
	//strcpy(dialoginfo->LINE2,"\n");
	sprintf(dialoginfo->LINE2,"Report File: %s\n",report->reportfile);
	SendDlgItemMessage(mainDLG,ID_DISPLAY,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txtSUM);
}
static OPENFILENAME ofn ;

BOOL handelOpenFile(HWND hDlg)
{
     BOOL tmpBOOL;
	 unsigned char pstrFileName[MAX_PATH];
	 unsigned char pstrTitleName[MAX_PATH];

	 pstrFileName[0]=0;
	 databasefile[0]=0;
	 static TCHAR szFilter[] = TEXT ("Floke Files (*.FLO)\0*.FLO\0")  \
                               TEXT ("All Files (*.*)\0*.*\0\0") ;

     ofn.lStructSize       = sizeof (OPENFILENAME) ;
     ofn.hwndOwner         = hDlg ;
     ofn.hInstance         = NULL ;
     ofn.lpstrFilter       = szFilter ;
     ofn.lpstrCustomFilter = NULL ;
     ofn.nMaxCustFilter    = 0 ;
     ofn.nFilterIndex      = 0 ;
     ofn.lpstrFile         = NULL ;          // Set in Open and Close functions
     ofn.nMaxFile          = MAX_PATH ;
     ofn.lpstrFileTitle    = NULL ;          // Set in Open and Close functions
     ofn.nMaxFileTitle     = MAX_PATH ;
     ofn.lpstrInitialDir   = NULL ;
     ofn.lpstrTitle        = NULL ;
     ofn.Flags             = 0 ;             // Set in Open and Close functions
     ofn.nFileOffset       = 0 ;
     ofn.nFileExtension    = 0 ;
     ofn.lpstrDefExt       = TEXT ("txt") ;
     ofn.lCustData         = 0L ;
     ofn.lpfnHook          = NULL ;
     ofn.lpTemplateName    = NULL ;

	 ofn.lpstrFile         = databasefile;
     ofn.lpstrFileTitle    = pstrTitleName ;
     ofn.Flags             = OFN_HIDEREADONLY | OFN_CREATEPROMPT ;

     tmpBOOL=GetOpenFileName (&ofn);

	 if(tmpBOOL==FALSE)
		 {
			pstrFileName[0]=0;
	 		databasefile[0]=0;
			 return FALSE;
			}
	//disAllocate, before we fill again
	disAllocatealldirentries(memstartdir);
	memstartdir=memAllocdir(NULL);
	disAllocatealldirentries(memfilestartdir);
	memfilestartdir=memAllocdir(NULL);

	readFromFileToMem(databasefile);


	//dialoginfo->DISPLAYLOG=TRUE; //Just to test

	dialoginfo->TASKOPTN=TRUE;
	sprintf(dialoginfo->LINE1,"Task File: %s\n",databasefile);
	//strcpy(dialoginfo->LINE1,"\n");
	//strcpy(dialoginfo->LINE2,"\n");
	sprintf(dialoginfo->LINE2,"Report File: %s\n",report->reportfile);
	dialoginfo->Ready=TRUE;
	initWindow(hDlg);
	hasBeenRead=TRUE;
	taskNeverRun=FALSE;
	dialoginfo->DISPLAYLOG=TRUE;
	txtSUM[0]=0;
	initWindow(mainDLG);
	return TRUE;
}

BOOL handelStart(HWND hDlg)
{

	if(dialoginfo->Ready==FALSE)
		{

			if(handelOpenFile(hDlg)==FALSE)
				{
					return FALSE;
				}
		}


    	hThread = CreateThread(
        NULL,
        0,
        (LPTHREAD_START_ROUTINE) MainThreadFunc,
        hDlg,

        0,
        &dwThreadId);


}

DWORD MainThreadFunc(HWND hDlg)
{


	files=0;
	EnableWindow(GetDlgItem(hDlg,IDSTART),FALSE);
	EnableWindow(GetDlgItem(hDlg,ID_EMERGENCYSTOP),TRUE);

	proccesssearch();


	if(taskNeverRun==FALSE)
		{
			compare_start(memfilestartdir,memstartdir);
			//compare_start(memstartdir,memfilestartdir);
			make_repport();
		}

	comitAllEntriesToFile(databasefile);

	if(hasBeenRead==FALSE)
		{
			readFromFileToMem(databasefile);
			hasBeenRead==TRUE;
		}
	taskNeverRun=FALSE;

	dialoginfo->DISPLAYLOG=TRUE;
	initWindow(mainDLG);

 	EnableWindow(GetDlgItem(hDlg,IDSTART),TRUE);
 	EnableWindow(GetDlgItem(hDlg,ID_EMERGENCYSTOP),FALSE);


	//disAllocate, before we fill again

	disAllocatealldirentries(memstartdir);
	//free(memfilecurdir);
	//free(memfilecurfile);

	disAllocatealldirentries(memfilestartdir);
	memstartdir=memAllocdir(NULL);
	memfilestartdir=memAllocdir(NULL);
	//deinit();
	#ifdef DEBUGHELPERS
	fclose(errverboseout);
	#endif
	free(hashinfo);
	free(report);
	init();
/*
	free(memcurdir);
	free(memstartdir);
	free(mempriordir);
	free(memfilecurdir);
	free(memfilestartdir);
	free(memfilepriordir);


	free(memcurfile);
	free(memstartfile);
	free(mempriorfile);
	free(memfilecurfile);
	free(memfilestartfile);
	free(memfilepriorfile);*/

	readFromFileToMem(databasefile);

	return 0;

}


int volla;
unsigned char exe_dspllogwithfile[MAX_PATH];
unsigned char exe_dsplhelp[MAX_PATH];
unsigned char exe_dspltxt[MAX_PATH];
unsigned char licensefile[]="COPYING";
unsigned char htmlhlpfile[]="flokedoc002.html";
unsigned char space[]=" ";


BOOL display_file(unsigned char *exe,unsigned char *datafile)
{

	unsigned char exewithdata[MAX_PATH*2];
	//strcpy(exe,"notepad");
	int i=0;
	int j=0;

	while(exe[i]!=0)
		{
			exewithdata[i]=exe[i];
			i++;
		}
	exewithdata[i]=space[0];
	i++;
	while(datafile[j]!=0)
		{
			exewithdata[i]=datafile[j];
			i++;
			j++;
		}
	exewithdata[i]=0;
	if(WinExec(exewithdata,SW_SHOW)<31)
		{
			//Get New reader
			DialogBox(hinstGLB, MAKEINTRESOURCE(DLGPREF), NULL, (DLGPROC) PREFFunc);
		}
	return TRUE;

}



BOOL display_log(void)
{

	//strcpy(exe_dsplhelp,"notepad");
	int i=0;
	int j=0;

	while(exe_dsplhelp[i]!=0)
		{
			exe_dspllogwithfile[i]=exe_dsplhelp[i];
			i++;
		}
	exe_dspllogwithfile[i]=space[0];
	i++;
	while(report->reportfile[j]!=0)
		{
			exe_dspllogwithfile[i]=report->reportfile[j];
			i++;
			j++;
		}
	exe_dspllogwithfile[i]=0;
	WinExec(exe_dspllogwithfile,SW_SHOW);
	return TRUE;

}

static BOOL CALLBACK DialogFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	mainDLG=hwndDlg;
	switch (msg) {
	/*
	case WM_CREATE:
		//volla=IDSTART;
		//return TRUE;
		//CreateWindow(TEXT("button"),TEXT("&Start"), TEXT("#BS_DEFPUSHBUTTON"), 172, 15, 43, 14,hwndDlg,101,hinstGLB,((LPCREATESTRUCT) lParam)->hInstance, 0);
		btnhwnd=CreateWindow (TEXT ("button"), NULL,
              WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
              10, 10, 10, 10,
              hwnd, (HMENU) 1, hinstGLB, NULL) ;

		ShowWindow(btnhwnd,SW_SHOW);
		UpdateWindow(btnhwnd);
		return TRUE;*/

	case WM_INITDIALOG:
		SendMessage(hwndDlg,WM_SETICON,TRUE,(LPARAM) (HICON)LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		initWindow(hwndDlg);
		InitializeApp(hwndDlg,wParam,lParam);
		if(isWelcome==TRUE)
			{
				wiz_screen=20;
				DialogBox(hinstGLB, MAKEINTRESOURCE(DLG_WIZARD), NULL, (DLGPROC) DLG_WIZARDFunc);
			}
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
			case ID_EMERGENCYSTOP:
				TerminateThread(hThread,255);
				EnableWindow(GetDlgItem(hwndDlg,IDSTART),TRUE);
				EnableWindow(GetDlgItem(hwndDlg,ID_EMERGENCYSTOP),FALSE);
				sprintf(txtSUM,"Floke Integrity has now been safly emergency stopped!\nSome system resources might be tied up,\nbut a closure of Floke Integrity will free them.");
				//disAllocate
				disAllocatealldirentries(memstartdir);
				memstartdir=memAllocdir(NULL);
				disAllocatealldirentries(memfilestartdir);
				memfilestartdir=memAllocdir(NULL);

				//re-read file
				readFromFileToMem(databasefile);


				initWindow(mainDLG);
				return TRUE;
			case ID_DISPLAY:
				InitializeApp(hwndDlg,wParam,lParam);
				return TRUE;
			case IDM_HELP:
				i=GetModuleFileName(GetModuleHandle(fi32exe),fi32exepath,MAX_PATH);
				fi32exepath[(i-(strlen(fi32exe)))]=0;
				strcpy(&fi32exepath[(i-(strlen(fi32exe)))],htmlhlpfile);
				return display_file(exe_dsplhelp,fi32exepath);
			case IDM_DISPLAYLOG:
				return display_file(exe_dspltxt,report->reportfile);
			case IDDISPLAYLOG:
				return display_file(exe_dspltxt,report->reportfile);
			case IDSTART:
				handelStart(hwndDlg);
				return TRUE;
			case IDM_WINPREF:
				DialogBox(hinstGLB, MAKEINTRESOURCE(DLGPREF), NULL, (DLGPROC) PREFFunc);
				return TRUE;
			case IDM_NEW_WIZ:
				disAllocatealldirentries(memstartdir);
				memstartdir=memAllocdir(NULL);
				disAllocatealldirentries(memfilestartdir);
				memfilestartdir=memAllocdir(NULL);

				deinit();
				init();
				txtSUM[0]=0;
				waitInit=TRUE;
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLG_WIZARD), NULL, (DLGPROC) DLG_WIZARDFunc);
			//case IDCANCEL:
			//	EndDialog(hwndDlg,0);
			//	return 1;
			case IDM_EXIT:
				disAllocatealldirentries(memstartdir);
				//memstartdir=memAllocdir(NULL);
				disAllocatealldirentries(memfilestartdir);
				//memfilestartdir=memAllocdir(NULL);

				deinit();
				EndDialog(hwndDlg,0);
				return 1;
			case IDM_ABOUT:
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGABOUT), NULL, (DLGPROC) DLGABOUTFunc);
			case 1020:
				handelOpenFile(hwndDlg);
				return TRUE;
			case IDM_TASKOPTN:
				waitInit=TRUE;
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGTSKOPTN), NULL, (DLGPROC) DLGTSKOPTNFunc);
			case 1010:
				disAllocatealldirentries(memstartdir);
				memstartdir=memAllocdir(NULL);
				disAllocatealldirentries(memfilestartdir);
				memfilestartdir=memAllocdir(NULL);

				deinit();
				init();
				txtSUM[0]=0;
				waitInit=TRUE;
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGTSKOPTN), NULL, (DLGPROC) DLGTSKOPTNFunc);



		}
		break;
	 //case WM_DESTROY :
     //FreeResource (hResource) ;
     //PostQuitMessage (0) ;
     //return 0 ;

	case WM_CLOSE:
		disAllocatealldirentries(memstartdir);
		//memstartdir=memAllocdir(NULL);
		disAllocatealldirentries(memfilestartdir);
		//memfilestartdir=memAllocdir(NULL);

		deinit();
		free(txtSUM);
		free(dialoginfo);
		EndDialog(hwndDlg,0);
		return TRUE;

	}
	//return DefWindowProc(hwndDlg,  msg,  wParam,  lParam);
	return FALSE;
}

static BOOL CALLBACK DLGTSKOPTNFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) {
	case WM_INITDIALOG:
		SendMessage(hwndDlg,WM_SETICON,TRUE,(LPARAM) (HICON)LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		//initWindow(hwndDlg);
		//InitializeApp(hwndDlg,wParam,lParam);
		initDLGTSKOPTN(hwndDlg);
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
			case ID_OKAY_BTN:
				getDLGTSKOPTN(hwndDlg);
				waitInit=TRUE;
				dialoginfo->DISPLAYLOG=TRUE;
				initWindow(mainDLG);
				EndDialog(hwndDlg,0);
				return TRUE;
			case ID_DB_SELECT:
				handelSaveFileTsk(hwndDlg);
				return TRUE;
			case ID_REP_SELECT:
				handelSaveFileRpt(hwndDlg);
				return TRUE;
			case ID_ED_SEARCHPTRN:
				if(HIWORD(wParam)==EN_CHANGE)
					{
						getDLGTSKOPTN(hwndDlg);
						return TRUE;
					}
				return FALSE;
			case 1010:
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGTSKOPTN), NULL, (DLGPROC) DialogFunc);
		}
		switch(HIWORD(wParam)) {
			case BN_CLICKED:
				getDLGTSKOPTN(hwndDlg);
				return TRUE;
			case EN_CHANGE:
				getDLGTSKOPTN(hwndDlg);
				return TRUE;

		}


		break;

	case WM_CLOSE:
		//free(dialoginfo);
		EndDialog(hwndDlg,0);
		return TRUE;

	}
	return FALSE;
}

		HDC            hdc ;
		PAINTSTRUCT    ps ;
		RECT           rect ;

static char  * pText ;
        static HGLOBAL hResource ;

unsigned char txttemp[]="Test";
unsigned char *txtCopyrightconv;


static LOGFONT logfont ;
static HFONT   hFont ;


void PopFontInitialize (HWND hwndEdit)
{
     GetObject (GetStockObject (SYSTEM_FONT), sizeof (LOGFONT),
                (PTSTR) &logfont) ;

     hFont = CreateFontIndirect (&logfont) ;
     SendMessage (hwndEdit, WM_SETFONT, (WPARAM) hFont, 0) ;
}




static BOOL CALLBACK DLGABOUTFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) {

	case WM_INITDIALOG:
		SendMessage(hwndDlg,WM_SETICON,TRUE,(LPARAM) (HICON)LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		//SendMessage(GetDlgItem(hwndDlg,ID_ICON),WM_SETICON,TRUE,(LPARAM) (HICON)LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		hdc=BeginPaint(hwndDlg,&ps);
		DrawIcon(hdc,5,5,LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		EndPaint(hwndDlg,&ps);
		//initWindow(hwndDlg);
		//InitializeApp(hwndDlg,wParam,lParam);
		//initDLGTSKOPTN(hwndDlg);

		//txtCopyrightconv=(unsigned char *)malloc(sizeof(unsigned char)*20000);
		//txtCopyright=(unsigned char *)malloc(sizeof(unsigned char)*20000);
		//LoadString(hinstGLB, LIC,&txtCopyright,sizeof(txtCopyright)*20000);
		//FILE *uipou;
		//uipou=fopen("h:\\project\\fi32\\license.txt","r");
		//fread(txtCopyright,sizeof(unsigned char),20000,uipou);
		int i=0;
		txtCopyright=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i+=sprintf(&txtCopyright[i],"Floke Integrity\n");
		i+=sprintf(&txtCopyright[i],"Copyright (C) 2000  Jon Wickmann\n");
		i+=sprintf(&txtCopyright[i],"\n");
		i+=sprintf(&txtCopyright[i],"This program is free software; you can redistribute it and/or modify\n");
		i+=sprintf(&txtCopyright[i],"it under the terms of the GNU General Public License as published by\n");
		i+=sprintf(&txtCopyright[i],"the Free Software Foundation; either version 2 of the License, or\n");
		i+=sprintf(&txtCopyright[i],"(at your option) any later version.\n");
		i+=sprintf(&txtCopyright[i],"\n");
		i+=sprintf(&txtCopyright[i],"This program is distributed in the hope that it will be useful,\n");
		i+=sprintf(&txtCopyright[i],"but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
		i+=sprintf(&txtCopyright[i],"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
		i+=sprintf(&txtCopyright[i],"GNU General Public License for more details.\n");
		i+=sprintf(&txtCopyright[i],"\n");
		i+=sprintf(&txtCopyright[i],"You should have received a copy of the GNU General Public License\n");
		i+=sprintf(&txtCopyright[i],"along with this program; if not, write to the Free Software\n");
		i+=sprintf(&txtCopyright[i],"Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n");
		SendDlgItemMessage(hwndDlg,ID_txtCOP,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txtCopyright);
		free(txtCopyright);
		//SetWindowText(GetDlgItem(hwndDlg,ID_COPYRIGHT),(LPCTSTR)txtCopyright);
		//SendDlgItemMessage(hDlg,ID_LINE2,WM_SETTEXT,0,(LPARAM)(LPCTSTR)dialoginfo->LINE2);
		//sprintf(txtCopyrightconv,"%s\n",txtCopyright);

		//SetWindowText(GetDlgItem(hwndDlg,ID_COPYRIGHT),(PTSTR)txtCopyrightconv);

		//hResource = LoadResource (hinstGLB,
        //              FindResource (hinstGLB, TEXT ("#1032"),
        //                                   TEXT("TEXT"))) ;

        //  pText = (char *) LockResource (hResource) ;

		  //unsigned int iNumLines = 0 ;

          /*while (*txtCopyright != '\\' && txtCopyright != '\0')
          {
               if (*txtCopyright == '\n')
                    iNumLines ++ ;
               pText = AnsiNext (pText) ;
          }
          *pText = '\0' ; */

		//txtCopyright=(unsigned char *) LockResource(LoadResource(hinstGLB, FindResource(hinstGLB,TEXT("LIC"),TEXT("TEXT"))));
		//if(pText==NULL)
		//	{
				//SendDlgItemMessage(hwndDlg,ID_COPYRIGHT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txtCopyright);
		//	}



		//hdc=BeginPaint(hwndDlg,&ps);
		//GetClientRect (hwnd, &rect) ;
		//rect.left += 90 ;
		//rect.top  += 90 ;
		//DrawTextA (hdc, txtCopyright, -1, &rect, DT_EXTERNALLEADING) ;
		//TextOut(hdc,5,5,txtCopyright,200);
		//EndPaint (hwndDlg, &ps) ;
		//PopFontInitialize(GetDlgItem(hwndDlg,ID_COPYRIGHT));
		//txtCopyrightconv[200]=0;
		//WideCharToMultiByte(CP_ACP, 0, (PWSTR) txtCopyright, -1, txtCopyrightconv,20000, NULL, NULL) ;
		//MultiByteToWideChar(CP_ACP, 0,  txtCopyright, -1, txtCopyrightconv,20000) ;
		//SetWindowText(GetDlgItem(hwndDlg,ID_COPYRIGHT),(PTSTR)txtCopyright);



		return TRUE;

	case WM_CREATE:
		//SendDlgItemMessage(hwndDlg,ID_COPYRIGHT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txtCopyright);
		return TRUE;

	case WM_PAINT:
		hdc=BeginPaint(hwndDlg,&ps);
		DrawIcon(hdc,38,21,LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		EndPaint(hwndDlg,&ps);
		return TRUE;
		/*
		hdc=BeginPaint(hwndDlg,&ps);
		GetClientRect (hwnd, &rect) ;
		//rect.left += cxChar ;
		//rect.top  += cyChar * (1 - iPosition) ;
		DrawTextA (hdc, txtCopyright, -1, &rect, DT_EXTERNALLEADING) ;
		EndPaint (hwndDlg, &ps) ;
		return 0; */
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
			case ID_ABOUTOKAY:
				EndDialog(hwndDlg,0);
				return TRUE;
			case ID_ACK:
				DialogBox(hinstGLB, MAKEINTRESOURCE(DLGACK), NULL, (DLGPROC) ACKFunc);
				return TRUE;
			case ID_VIEWLIC:

				i=GetModuleFileName(GetModuleHandle(fi32exe),fi32exepath,MAX_PATH);
				fi32exepath[(i-(strlen(fi32exe)))]=0;
				strcpy(&fi32exepath[(i-(strlen(fi32exe)))],licensefile);
				return display_file(exe_dspltxt,fi32exepath);
			case ID_OKAY_BTN:
				getDLGTSKOPTN(hwndDlg);
				waitInit=TRUE;
				EndDialog(hwndDlg,0);
				return TRUE;
			case ID_DB_SELECT:
				handelSaveFileTsk(hwndDlg);
				return TRUE;
			case ID_REP_SELECT:
				handelSaveFileRpt(hwndDlg);
				return TRUE;
			case ID_ED_SEARCHPTRN:
				if(HIWORD(wParam)==EN_CHANGE)
					{
						getDLGTSKOPTN(hwndDlg);
						return TRUE;
					}
				return FALSE;
			case 1010:
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGTSKOPTN), NULL, (DLGPROC) DialogFunc);
		}
		switch(HIWORD(wParam)) {
			case BN_CLICKED:
				getDLGTSKOPTN(hwndDlg);
				return TRUE;
			case EN_CHANGE:
				getDLGTSKOPTN(hwndDlg);
				return TRUE;

		}


		break;

	case WM_CLOSE:
		//free(dialoginfo);
		EndDialog(hwndDlg,0);
		return TRUE;

	}
	return FALSE;
}


unsigned char BoolToNumber(BOOL in)
{
	if(in==TRUE)
		{
			return 1;
		}
	if(in==FALSE)
		{
			return 0;
		}
}
BOOL initDLGTSKOPTN(HWND hDlg)
{
	SendDlgItemMessage(hDlg,ID_DB_FILE,WM_SETTEXT,0,(LPARAM)(LPCTSTR)databasefile);
	SendDlgItemMessage(hDlg,ID_REP_FILE,WM_SETTEXT,0,(LPARAM)(LPCTSTR)report->reportfile);
	SendDlgItemMessage(hDlg,ID_ED_SEARCHPTRN,WM_SETTEXT,0,(LPARAM)(LPCTSTR)searchpattern);
	CheckDlgButton(hDlg,ID_RPT_HEADER,BoolToNumber(report->makeheader));
	CheckDlgButton(hDlg,ID_RPT_TIMESTAMP,BoolToNumber(report->makeheader_time));
	CheckDlgButton(hDlg,ID_RPT_CLEARD,BoolToNumber(report->reportCleardFiles));
	CheckDlgButton(hDlg,ID_RPT_CLEARD_HASH,BoolToNumber(report->reportCleardFilesWithHashes));
	CheckDlgButton(hDlg,ID_RPT_DELETED,BoolToNumber(report->reportDeletedFiles));
	CheckDlgButton(hDlg,ID_RPT_CHANGED_HASH,BoolToNumber(report->reportChangedFilesWithHashes));
	CheckDlgButton(hDlg,ID_RPT_CHANGED,BoolToNumber(report->reportChangedFiles));
	CheckDlgButton(hDlg,ID_RPT_DELETED_HASH,BoolToNumber(report->reportDeletedFilesWithHashes));
	CheckDlgButton(hDlg,ID_RPT_NEW,BoolToNumber(report->reportNewFiles));
	CheckDlgButton(hDlg,ID_RPT_NEW_HASH,BoolToNumber(report->reportNewFilesWithHashes));
	CheckDlgButton(hDlg,ID_RPT_ACCESDENIED,BoolToNumber(report->reportAccesDeniedFiles));
	CheckDlgButton(hDlg,ID_RPT_SUMMARY,BoolToNumber(report->makesummary));

	if(hashinfo->md5_working==FALSE)
		{
				EnableWindow(GetDlgItem(hDlg,ID_HASH_MD5),FALSE);
		}
	if(hashinfo->sha1_working==FALSE)
		{
				EnableWindow(GetDlgItem(hDlg,ID_HASH_SHA1),FALSE);
		}
	if(hashinfo->rmd160_working==FALSE)
		{
				EnableWindow(GetDlgItem(hDlg,ID_HASH_RMD160),FALSE);
		}
	if(hashinfo->tiger_working==FALSE)
		{
				EnableWindow(GetDlgItem(hDlg,ID_HASH_TIGER),FALSE);
		}

	if(hash==SHA1)
		{
			CheckRadioButton(hDlg,ID_HASH_SHA1,ID_HASH_MD5,ID_HASH_SHA1);
		}

	if(hash==MD5)
		{
			CheckRadioButton(hDlg,ID_HASH_SHA1,ID_HASH_MD5,ID_HASH_MD5);
		}

	if(hash==RMD160)
		{
			CheckRadioButton(hDlg,ID_HASH_SHA1,ID_HASH_MD5,ID_HASH_RMD160);
		}
	if(hash==TIGER)
		{
			CheckRadioButton(hDlg,ID_HASH_SHA1,ID_HASH_MD5,ID_HASH_TIGER);
		}


	SendDlgItemMessage(hDlg,ID_ED_SEARCHPTRN, WM_SETTEXT,0,(LPARAM)(LPCTSTR)searchpattern);

	unsigned char availableDrives[MAX_PATH];
	unsigned char drvstring[4];
	unsigned int i=0;
	unsigned int j=0;
	//BOOL correctstrng=TRUE;

	SendDlgItemMessage(hDlg,IDD_PATH_ROLL, CB_RESETCONTENT,0,0);
	i=0;
	j=GetLogicalDriveStrings(MAX_PATH,availableDrives);
	drvstring[3]=0;
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), WM_SETREDRAW ,FALSE,0);
	while(i<j)
		{
			//correctstrng=TRUE;
			drvstring[0]=availableDrives[i];
			i++;
			drvstring[1]=availableDrives[i];
			i++;
			drvstring[2]=availableDrives[i];
			i++;
			i++;
			//drvstring[3]=availableDrives[i];

			//SendDlgItemMessage(hDlg,ID_PATH_ROLL, CB_ADDSTRING,0,(LPARAM)(LPCTSTR)drvstring);
			SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)drvstring);

		}


	//SendMessage(GetDlgItem(hDlg, ID_PATH_ROLL), CB_RESETCONTENT ,0,0);
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), WM_SETREDRAW ,TRUE,0);
	if(SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_FINDSTRINGEXACT , (WPARAM) -1 ,(LPARAM)(LPCSTR)startpath)==CB_ERR)
		{
			SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)startpath);
		}
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_SETCURSEL,(WPARAM)SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_FINDSTRINGEXACT , (WPARAM) -1,(LPARAM)(LPCSTR)startpath),0);

	waitInit=FALSE;
	/*
	unsigned char tmpuu[]="Jon\n";
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)&tmpuu);
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)&tmpuu);
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)tmpuu);
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)tmpuu);
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)tmpuu);
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)tmpuu);
	SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL), WM_SETREDRAW ,TRUE,0);
	*/
}

BOOL handelSaveFileTsk(HWND hDlg)
{
     BOOL tmpBOOL;
	 unsigned char pstrFileName[MAX_PATH];
	 unsigned char pstrTitleName[MAX_PATH];

	 pstrFileName[0]=0;
	 //databasefile[0]=0;
	 static TCHAR szFilter[] = TEXT ("Floke Files (*.FLO)\0*.FLO\0")  \
                               TEXT ("All Files (*.*)\0*.*\0\0") ;

     ofn.lStructSize       = sizeof (OPENFILENAME) ;
     ofn.hwndOwner         = hDlg ;
     ofn.hInstance         = NULL ;
     ofn.lpstrFilter       = szFilter ;
     ofn.lpstrCustomFilter = NULL ;
     ofn.nMaxCustFilter    = 0 ;
     ofn.nFilterIndex      = 0 ;
     ofn.lpstrFile         = NULL ;
     ofn.nMaxFile          = MAX_PATH ;
     ofn.lpstrFileTitle    = NULL ;
     ofn.nMaxFileTitle     = MAX_PATH ;
     ofn.lpstrInitialDir   = NULL ;
     ofn.lpstrTitle        = NULL ;
     ofn.Flags             = 0 ;
     ofn.nFileOffset       = 0 ;
     ofn.nFileExtension    = 0 ;
     ofn.lpstrDefExt       = TEXT ("txt") ;
     ofn.lCustData         = 0L ;
     ofn.lpfnHook          = NULL ;
     ofn.lpTemplateName    = NULL ;

	 ofn.lpstrFile         = databasefile;
     ofn.lpstrFileTitle    = pstrTitleName ;
     ofn.Flags             = OFN_HIDEREADONLY | OFN_CREATEPROMPT ;

     tmpBOOL=GetSaveFileName (&ofn);

	 if(tmpBOOL==FALSE)
		 {
			pstrFileName[0]=0;
	 		databasefile[0]=0;
			 return FALSE;
			}
	//readFromFileToMem(databasefile);
	//dialoginfo->DISPLAYLOG=TRUE; //Just to test

	dialoginfo->TASKOPTN=TRUE;
	sprintf(dialoginfo->LINE1,"Task File: %s\n",databasefile);
	//strcpy(dialoginfo->LINE1,"\n");
	//strcpy(dialoginfo->LINE2,"\n");
	//sprintf(dialoginfo->LINE2,"Report File: %s\n",report->reportfile);
	if(report->reportfile[0]!=0)
		{
			dialoginfo->Ready=TRUE;
		}
	initWindow(mainDLG);  //Where can I set this
	initDLGTSKOPTN(hDlg);

	return TRUE;
}

BOOL handelSaveFileRpt(HWND hDlg)
{
     BOOL tmpBOOL;
	 unsigned char pstrFileName[MAX_PATH];
	 unsigned char pstrTitleName[MAX_PATH];

	 pstrFileName[0]=0;
	 //databasefile[0]=0;
	 static TCHAR szFilter[] = TEXT ("Report Files (*.REP)\0*.REP\0")  \
                               TEXT ("All Files (*.*)\0*.*\0\0") ;

     ofn.lStructSize       = sizeof (OPENFILENAME) ;
     ofn.hwndOwner         = hDlg ;
     ofn.hInstance         = NULL ;
     ofn.lpstrFilter       = szFilter ;
     ofn.lpstrCustomFilter = NULL ;
     ofn.nMaxCustFilter    = 0 ;
     ofn.nFilterIndex      = 0 ;
     ofn.lpstrFile         = NULL ;
     ofn.nMaxFile          = MAX_PATH ;
     ofn.lpstrFileTitle    = NULL ;
     ofn.nMaxFileTitle     = MAX_PATH ;
     ofn.lpstrInitialDir   = NULL ;
     ofn.lpstrTitle        = NULL ;
     ofn.Flags             = 0 ;
     ofn.nFileOffset       = 0 ;
     ofn.nFileExtension    = 0 ;
     ofn.lpstrDefExt       = TEXT ("txt") ;
     ofn.lCustData         = 0L ;
     ofn.lpfnHook          = NULL ;
     ofn.lpTemplateName    = NULL ;

	 ofn.lpstrFile         = pstrFileName;
     ofn.lpstrFileTitle    = pstrTitleName ;
     ofn.Flags             = OFN_HIDEREADONLY | OFN_CREATEPROMPT ;



     tmpBOOL=GetSaveFileName (&ofn);
	 strcpy(report->reportfile,pstrFileName);
	 if(tmpBOOL==FALSE)
		 {
			pstrFileName[0]=0;
	 		report->reportfile[0]=0;
			 //strcpy(report->reportfile,"FALSE");
			 return FALSE;
			}
	//readFromFileToMem(databasefile);
	//dialoginfo->DISPLAYLOG=TRUE; //Just to test

	dialoginfo->TASKOPTN=TRUE;
	//sprintf(dialoginfo->LINE1,"Task File: %s\n",databasefile);
	//strcpy(dialoginfo->LINE1,"\n");
	//strcpy(dialoginfo->LINE2,"\n");
	sprintf(dialoginfo->LINE2,"Report File: %s\n",report->reportfile);
	if(databasefile[0]!=0)
		{
			dialoginfo->Ready=TRUE;
		}
	waitInit=TRUE;
	initWindow(mainDLG);  //Where can I set this
	initDLGTSKOPTN(hDlg);
	waitInit=FALSE;
	return TRUE;
}

BOOL numberToBOOL(unsigned char in)
{
	if(in==1)
		{
			return TRUE;
		}
	if(in==0)
		{
			return FALSE;
		}
	return FALSE; //If Greyed
}
BOOL getDLGTSKOPTN(HWND hDlg)
{
	if(waitInit!=TRUE)
		{
			SendDlgItemMessage(hDlg,ID_DB_FILE,WM_GETTEXT,(WPARAM)MAX_PATH,(LPARAM)(LPCTSTR)databasefile);
			SendDlgItemMessage(hDlg,ID_REP_FILE,WM_GETTEXT,(WPARAM)MAX_PATH,(LPARAM)(LPCTSTR)report->reportfile);
			SendDlgItemMessage(hDlg,ID_ED_SEARCHPTRN,WM_GETTEXT,(WPARAM)SEARCHPATTERNLENGHT,(LPARAM)(LPCTSTR)searchpattern);

			SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL),  CB_GETLBTEXT ,(WPARAM)SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL),  CB_GETCURSEL ,0,0),(LPARAM)(LPCTSTR)startpath);

			report->makeheader=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_HEADER),  BM_GETCHECK ,0,0));

			report->makeheader_time=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_HEADER),  BM_GETCHECK ,0,0));
			//report->reportScannedFile=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_HEADER),  BM_GETCHECK ,0,0));
			//report->reportScannedFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_HEADER),  BM_GETCHECK ,0,0));
			report->reportCleardFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_CLEARD),  BM_GETCHECK ,0,0));
			report->reportCleardFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_CLEARD_HASH),  BM_GETCHECK ,0,0));
			report->reportChangedFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_CHANGED),  BM_GETCHECK ,0,0));
			report->reportChangedFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_CHANGED_HASH),  BM_GETCHECK ,0,0));
			report->reportDeletedFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_DELETED),  BM_GETCHECK ,0,0));
			report->reportDeletedFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_DELETED_HASH),  BM_GETCHECK ,0,0));
			report->reportNewFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_NEW),  BM_GETCHECK ,0,0));
			report->reportNewFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_NEW_HASH),  BM_GETCHECK ,0,0));
			report->reportAccesDeniedFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_ACCESDENIED),  BM_GETCHECK ,0,0));
			report->makesummary=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_SUMMARY),  BM_GETCHECK ,0,0));

			if(numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_HASH_SHA1),  BM_GETCHECK ,0,0))==TRUE)
				{
					hashinfo->hashlenght=5;
					hash=SHA1;
				}

			if(numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_HASH_TIGER),  BM_GETCHECK ,0,0))==TRUE)
				{
					hashinfo->hashlenght=3;
					hash=TIGER;
				}
			if(numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_HASH_RMD160),  BM_GETCHECK ,0,0))==TRUE)
				{
					hashinfo->hashlenght=5;
					hash=RMD160;
				}
			if(numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_HASH_MD5),  BM_GETCHECK ,0,0))==TRUE)
				{
					hashinfo->hashlenght=4;
					hash=MD5;
				}
			if(databasefile[0]!=0)
				{
					if(report->reportfile[0]!=0)
						{
							dialoginfo->Ready=TRUE;
						}
				}

			initWindow(mainDLG);
		}

}
static BOOL CALLBACK ACKFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{

	switch (msg) {
	/*
	case WM_CREATE:
		return TRUE;*/

	case WM_INITDIALOG:
		SendMessage(hwndDlg,WM_SETICON,TRUE,(LPARAM) (HICON)LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		txtACK=(unsigned char *)malloc(sizeof(unsigned char)*1024);
		int i=0;
		i+=sprintf(&txtACK[i],"This program contains code from:\n");
		i+=sprintf(&txtACK[i],"\n");
		i+=sprintf(&txtACK[i],"AIDE - Advanced Intrusion Detection Environment\n");
		i+=sprintf(&txtACK[i],"Copyright (C) 1999,2000 Rami Lehti, Pablo Virolainen\n");
		i+=sprintf(&txtACK[i],"http://www.cs.tut.fi/~rammer/aide.html\n");
		i+=sprintf(&txtACK[i],"\n");
		i+=sprintf(&txtACK[i],"GnuPG\n");
		i+=sprintf(&txtACK[i],"Copyright (C) 2000 Free Software Foundation, Inc.\n");
		i+=sprintf(&txtACK[i],"http://www.gnupg.org/\n");
		i+=sprintf(&txtACK[i],"\n");
		i+=sprintf(&txtACK[i],"Both covered by the GNU General Public License. See documentation and source for more details.\n");
		i+=sprintf(&txtACK[i],"\n");
		i+=sprintf(&txtACK[i],"Code compiled and developed with lcc-win32 by Jacob Navia (derived from lcc by C. Fraser and D. Hanson)\n");
		i+=sprintf(&txtACK[i],"See http://www.cs.virginia.edu/~lcc-win32\n");
		i+=sprintf(&txtACK[i],"\n");
		i+=sprintf(&txtACK[i],"The setup procedure is scripted in 'Inno Setup' by Jordan Russell\n");
		i+=sprintf(&txtACK[i],"See http://www.jrsoftware.org/\n");
		i+=sprintf(&txtACK[i],"\n");
		i+=sprintf(&txtACK[i],"The help file is written in MS-DOS Editor and Helper by Kenneth Rochel de Camargo Jr.\n");
		i+=sprintf(&txtACK[i],"\n");
		i+=sprintf(&txtACK[i],"The manual was written in MS-DOS Editor to the specifications of HTML 4.0 Transitional as publicized by W3C.\n");


		SendDlgItemMessage(hwndDlg,ID_ACK_TEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txtACK);
		free(txtACK);

		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
			case ID_DISPLAY:
				InitializeApp(hwndDlg,wParam,lParam);
				return TRUE;
			case IDM_DISPLAYLOG:
				return display_file(exe_dspltxt,report->reportfile);
			case IDDISPLAYLOG:
				return display_file(exe_dspltxt,report->reportfile);
			case IDSTART:
				handelStart(hwndDlg);

				return TRUE;
			//case IDCANCEL:
			//	EndDialog(hwndDlg,0);
			//	return 1;
			case IDM_ABOUT:
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGABOUT), NULL, (DLGPROC) DLGABOUTFunc);
			case 1020:
				handelOpenFile(hwndDlg);
				return TRUE;
			case IDM_TASKOPTN:
				waitInit=TRUE;
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGTSKOPTN), NULL, (DLGPROC) DLGTSKOPTNFunc);
			case 1010:
				waitInit=TRUE;
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGTSKOPTN), NULL, (DLGPROC) DLGTSKOPTNFunc);
			case ID_ACK_OKAY:
				EndDialog(hwndDlg,0);
				return 1;


		}
		break;

	 //case WM_DESTROY :
     //FreeResource (hResource) ;
     //PostQuitMessage (0) ;
     //return 0 ;

	case WM_CLOSE:
		free(dialoginfo);
		EndDialog(hwndDlg,0);
		return TRUE;

	}
	//return DefWindowProc(hwndDlg,  msg,  wParam,  lParam);
	return FALSE;
}



void ui_summary(unsigned int files,unsigned int newfiles,unsigned int deletedfiles,unsigned int changedfiles,unsigned int cleardfiles,unsigned int accesdeniedfiles)
{


		int i=0;
		i+=sprintf(&txtSUM[i],"\n");
		i+=sprintf(&txtSUM[i],"Summary:\n");
		i+=sprintf(&txtSUM[i],"\n");
		i+=sprintf(&txtSUM[i],"Scanned files: %u\n",files);
		i+=sprintf(&txtSUM[i],"New files: %u\n",newfiles);
		i+=sprintf(&txtSUM[i],"Not checked files %u\n",accesdeniedfiles);
		i+=sprintf(&txtSUM[i],"Changed files: %u\n",changedfiles);
		i+=sprintf(&txtSUM[i],"Deleted files: %u\n",deletedfiles);
		i+=sprintf(&txtSUM[i],"Cleard files: %u\n",cleardfiles);
		initWindow(mainDLG);


}

void settextreader()
{
	unsigned char sub_key[]="\\Software\\JWi\\FI\\001\\textreader";
	PLONG size;

	if(RegQueryValue(HKEY_CURRENT_USER,sub_key,exe_dspltxt,size)!=ERROR_SUCCESS)
		{
			exe_dspltxt[0]=0;
			//Start Preference dialog
		}

}

void sethtmlreader()
{
	unsigned char sub_key[]="\\Software\\JWi\\FI\\001\\htmlreader";
	PLONG size;

	if(RegQueryValue(HKEY_CURRENT_USER,sub_key,exe_dsplhelp,size)!=ERROR_SUCCESS)
		{
			exe_dsplhelp[0]=0;
			//Start Preference dialog
		}

}

void loadpreferences()
{
	int i=0;
	i=GetModuleFileName(GetModuleHandle(fi32exe),fi32exepath,MAX_PATH);
	fi32exepath[(i-(strlen(fi32exe)))]=0;
	strcpy(&fi32exepath[(i-(strlen(fi32exe)))],inifile);
	FILE *iniF;
	unsigned char l=0;
	int j=0;
	int k=0;

	iniF=fopen(fi32exepath,"r");
	fread(&l,sizeof(unsigned char),1,iniF);
	while(l!=*"\n")
		{

			exe_dspltxt[j]=l;
			j++;
			fread(&l,sizeof(unsigned char),1,iniF);
		}
	exe_dspltxt[j]=0;
	j++;
	j=0;
	fread(&l,sizeof(unsigned char),1,iniF);
	while(l!=*"\n")
		{

			exe_dsplhelp[j]=l;
			j++;
			fread(&l,sizeof(unsigned char),1,iniF);
		}
	exe_dsplhelp[j]=0;
	fread(&l,sizeof(unsigned char),1,iniF);
	if(l==49) //49=="1"
		{
			isWelcome=TRUE;

		}
	if(l!=49) //49=="1"
		{
			isWelcome=FALSE;
			wiz_screen=0;
		}
	fclose(iniF);




	//fprintf(errverboseout,"%s\n",exe_dspltxt);
	//fprintf(errverboseout,"%s\n",exe_dsplhelp);
}
void savepreferences(HWND HwndDlg)
{
	int i=0;
	i=GetModuleFileName(GetModuleHandle(fi32exe),fi32exepath,MAX_PATH);
	fi32exepath[(i-(strlen(fi32exe)))]=0;
	strcpy(&fi32exepath[(i-(strlen(fi32exe)))],inifile);
	FILE *iniF;
	unsigned char l=0;
	int j=0;
	int k=0;

	iniF=fopen(fi32exepath,"w");
	fprintf(iniF,"%s\n",exe_dspltxt);
	fprintf(iniF,"%s\n",exe_dsplhelp);
	if(numberToBOOL(SendMessage(GetDlgItem(HwndDlg, ID_SHOW_WELCOME),  BM_GETCHECK ,0,0))==TRUE)
		{
			fprintf(iniF,"1");
		}
	if(numberToBOOL(SendMessage(GetDlgItem(HwndDlg, ID_SHOW_WELCOME),  BM_GETCHECK ,0,0))==FALSE)
		{
			fprintf(iniF,"0");
		}
	fclose(iniF);

	/*unsigned char sub_key1[]="\\Software\\JWi\\FI\\001\\textreader";
	unsigned char sub_key2[]="\\Software\\JWi\\FI\\001\\htmlreader";
	HKEY	*cur;
	DWORD size;

	size=strlen(exe_dspltxt);
	RegOpenKeyEx(HKEY_CURRENT_USER,sub_key1,0,KEY_ALL_ACCESS,cur);
	if(RegSetValue(cur,sub_key1,REG_SZ,exe_dspltxt,size)!=ERROR_SUCCESS)
		{
			MessageBox(mainDLG,"Error! Can't access registry","FI: Error!",MB_ICONSTOP);
		}
	RegCloseKey(cur);

	RegCreateKey(HKEY_CURRENT_USER,sub_key2,cur);
	size=strlen(exe_dsplhelp);
	if(RegSetValue(cur,sub_key2,REG_SZ,exe_dsplhelp,size)!=ERROR_SUCCESS)
		{
			MessageBox(mainDLG,"Error! Can't access registry","FI: Error!",MB_ICONSTOP);
		}
	RegCloseKey(cur);*/
}

static BOOL CALLBACK PREFFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{

	switch (msg) {
	/*
	case WM_CREATE:
		return TRUE;*/

	case WM_INITDIALOG:
		SendMessage(hwndDlg,WM_SETICON,TRUE,(LPARAM) (HICON)LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		loadpreferences();
		CheckDlgButton(hwndDlg,ID_SHOW_WELCOME,BoolToNumber(isWelcome));
		isWelcome=FALSE; //False since we're not at start up
		/*
		unsigned char sub_key1[]="\\Software\\JWi\\FI\\001\\htmlreader";
		unsigned char sub_key2[]="\\Software\\JWi\\FI\\001\\textreader";
		PLONG size;

		RegQueryValue(HKEY_CURRENT_USER,sub_key1,exe_dsplhelp,size);
		RegQueryValue(HKEY_CURRENT_USER,sub_key2,exe_dspltxt,size);
		*/
		SendDlgItemMessage(hwndDlg,ID_ED_RPT_READER,WM_SETTEXT,0,(LPARAM)(LPCTSTR)exe_dspltxt);
		SendDlgItemMessage(hwndDlg,ID_ED_HLP_READER,WM_SETTEXT,0,(LPARAM)(LPCTSTR)exe_dsplhelp);



		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
					case ID_PREF_OKAY:

						SendDlgItemMessage(hwndDlg,ID_ED_RPT_READER,WM_GETTEXT,(WPARAM)MAX_PATH,(LPARAM)(LPCTSTR)exe_dspltxt);
						SendDlgItemMessage(hwndDlg,ID_ED_HLP_READER,WM_GETTEXT,(WPARAM)MAX_PATH,(LPARAM)(LPCTSTR)exe_dsplhelp);
						savepreferences(hwndDlg);
						EndDialog(hwndDlg,0);
						return 1;
					case ID_PREF_BTN_RPT:
						GetExe(hwndDlg,exe_dspltxt);
						SendDlgItemMessage(hwndDlg,ID_ED_RPT_READER,WM_SETTEXT,0,(LPARAM)(LPCTSTR)exe_dspltxt);
						return TRUE;
					case ID_PREF_BTN_HLP:
						GetExe(hwndDlg,exe_dsplhelp);
						SendDlgItemMessage(hwndDlg,ID_ED_HLP_READER,WM_SETTEXT,0,(LPARAM)(LPCTSTR)exe_dsplhelp);
						return TRUE;


		}
		break;

	 //case WM_DESTROY :
     //FreeResource (hResource) ;
     //PostQuitMessage (0) ;
     //return 0 ;

	case WM_CLOSE:
		//free(dialoginfo);
		EndDialog(hwndDlg,0);
		return TRUE;

	}
	//return DefWindowProc(hwndDlg,  msg,  wParam,  lParam);
	return FALSE;
}

BOOL GetExe(HWND hDlg,unsigned char *OUTfile)
{
     BOOL tmpBOOL;
	 unsigned char pstrFileName[MAX_PATH];
	 unsigned char pstrTitleName[MAX_PATH];

	 pstrFileName[0]=0;
	 databasefile[0]=0;
	 static TCHAR szFilter[] = TEXT ("Executable Files (*.EXE)\0*.EXE\0")  \
                               TEXT ("All Files (*.*)\0*.*\0\0") ;

     ofn.lStructSize       = sizeof (OPENFILENAME) ;
     ofn.hwndOwner         = hDlg ;
     ofn.hInstance         = NULL ;
     ofn.lpstrFilter       = szFilter ;
     ofn.lpstrCustomFilter = NULL ;
     ofn.nMaxCustFilter    = 0 ;
     ofn.nFilterIndex      = 0 ;
     ofn.lpstrFile         = NULL ;
     ofn.nMaxFile          = MAX_PATH ;
     ofn.lpstrFileTitle    = NULL ;
     ofn.nMaxFileTitle     = MAX_PATH ;
     ofn.lpstrInitialDir   = NULL ;
     ofn.lpstrTitle        = NULL ;
     ofn.Flags             = 0 ;
     ofn.nFileOffset       = 0 ;
     ofn.nFileExtension    = 0 ;
     ofn.lpstrDefExt       = TEXT ("txt") ;
     ofn.lCustData         = 0L ;
     ofn.lpfnHook          = NULL ;
     ofn.lpTemplateName    = NULL ;

	 ofn.lpstrFile         = OUTfile;
     ofn.lpstrFileTitle    = pstrTitleName ;
     ofn.Flags             = OFN_HIDEREADONLY | OFN_CREATEPROMPT ;

     tmpBOOL=GetOpenFileName (&ofn);

	 if(tmpBOOL==FALSE)
		 {
			pstrFileName[0]=0;
	 		OUTfile[0]=0;
			 return FALSE;
			}
	//readFromFileToMem(databasefile);
	//dialoginfo->DISPLAYLOG=TRUE; //Just to test

	//dialoginfo->TASKOPTN=TRUE;
	//sprintf(dialoginfo->LINE1,"Task File: %s\n",databasefile);
	//strcpy(dialoginfo->LINE1,"\n");
	//strcpy(dialoginfo->LINE2,"\n");
	//sprintf(dialoginfo->LINE2,"Report File: %s\n",report->reportfile);
	//dialoginfo->Ready=TRUE;
	//initWindow(hDlg);
	//hasBeenRead=TRUE;
	//taskNeverRun=FALSE;
	//dialoginfo->DISPLAYLOG=TRUE;
	//txtSUM[0]=0;
	//initWindow(mainDLG);
	return TRUE;
}


static BOOL CALLBACK DLG_WIZARDFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) {

	case WM_INITDIALOG:
		//wiz_screen=20; // To test Welcome Screen
		SendMessage(hwndDlg,WM_SETICON,TRUE,(LPARAM) (HICON)LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		//SendMessage(GetDlgItem(hwndDlg,ID_ICON),WM_SETICON,TRUE,(LPARAM) (HICON)LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		hdc=BeginPaint(hwndDlg,&ps);
		DrawIcon(hdc,5,5,LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		EndPaint(hwndDlg,&ps);
		wizard_init(hwndDlg);


		return TRUE;

	case WM_CREATE:
		//SendDlgItemMessage(hwndDlg,ID_COPYRIGHT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txtCopyright);
		return TRUE;

	case WM_PAINT:
		if(isWelcome==TRUE)
			{
				hdc=BeginPaint(hwndDlg,&ps);
				DrawIcon(hdc,38,21,LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
				EndPaint(hwndDlg,&ps);
				return TRUE;
			}
		hdc=BeginPaint(hwndDlg,&ps);
		DrawIcon(hdc,38,21,LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		EndPaint(hwndDlg,&ps);
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
			case ID_WIZ_NEXT:
				if(isWelcome==TRUE)
					{
						isWelcome=FALSE;
						EndDialog(hwndDlg,0);
						return TRUE;

					}
				isWelcome=FALSE;
				wizard_next(hwndDlg);
				return TRUE;
			case ID_WIZ_PREV:
				if(isWelcome==TRUE)
					{
						//isWelcome=FALSE;// Not False, cause we will not kill the dialog
						i=GetModuleFileName(GetModuleHandle(fi32exe),fi32exepath,MAX_PATH);
						fi32exepath[(i-(strlen(fi32exe)))]=0;
						strcpy(&fi32exepath[(i-(strlen(fi32exe)))],htmlhlpfile);
						return display_file(exe_dsplhelp,fi32exepath);

					}
				wizard_prev(hwndDlg);
				return TRUE;
			case ID_DB_SELECT:

				handelSaveFileTsk(hwndDlg);
				return TRUE;
			case ID_REP_SELECT:
				handelSaveFileRpt(hwndDlg);
				return TRUE;
			case ID_WIZ_CANCEL:
				if(isWelcome==TRUE)
					{
						isWelcome=FALSE;
						wiz_screen=0;
						EndDialog(hwndDlg,0);
						handelOpenFile(hwndDlg);
						return TRUE;

					}


				EndDialog(hwndDlg,0);
				return TRUE;
			case ID_WIZ_HELP:
				if(isWelcome==TRUE)
					{
						EndDialog(hwndDlg,0);
						isWelcome=FALSE;
						wiz_screen=0;
						disAllocatealldirentries(memstartdir);
						memstartdir=memAllocdir(NULL);
						disAllocatealldirentries(memfilestartdir);
						memfilestartdir=memAllocdir(NULL);

						deinit();
						init();
						txtSUM[0]=0;
						waitInit=TRUE;
						return DialogBox(hinstGLB, MAKEINTRESOURCE(DLG_WIZARD), NULL, (DLGPROC) DLG_WIZARDFunc);


					}
				i=GetModuleFileName(GetModuleHandle(fi32exe),fi32exepath,MAX_PATH);
				fi32exepath[(i-(strlen(fi32exe)))]=0;
				strcpy(&fi32exepath[(i-(strlen(fi32exe)))],hlpfile);
				WinHelp(hwndDlg,fi32exepath,HELP_CONTEXT,helpcontext);
				return TRUE;



			/*case ID_ABOUTOKAY:
				EndDialog(hwndDlg,0);
				return TRUE;
			case ID_ACK:
				DialogBox(hinstGLB, MAKEINTRESOURCE(DLGACK), NULL, (DLGPROC) ACKFunc);
				return TRUE;
			case ID_VIEWLIC:

				i=GetModuleFileName(GetModuleHandle(fi32exe),fi32exepath,MAX_PATH);
				fi32exepath[(i-(strlen(fi32exe)))]=0;
				strcpy(&fi32exepath[(i-(strlen(fi32exe)))],licensefile);
				return display_file(exe_dspltxt,fi32exepath);
			case ID_OKAY_BTN:
				getDLGTSKOPTN(hwndDlg);
				waitInit=TRUE;
				EndDialog(hwndDlg,0);
				return TRUE;
			case ID_DB_SELECT:
				handelSaveFileTsk(hwndDlg);
				return TRUE;
			case ID_REP_SELECT:
				handelSaveFileRpt(hwndDlg);
				return TRUE;
			case ID_ED_SEARCHPTRN:
				if(HIWORD(wParam)==EN_CHANGE)
					{
						getDLGTSKOPTN(hwndDlg);
						return TRUE;
					}
				return FALSE;
			case 1010:
				return DialogBox(hinstGLB, MAKEINTRESOURCE(DLGTSKOPTN), NULL, (DLGPROC) DialogFunc);
				*/
		}
		switch(HIWORD(wParam)) {
			/*
			case BN_CLICKED:
				getDLGTSKOPTN(hwndDlg);
				return TRUE;
			case EN_CHANGE:
				getDLGTSKOPTN(hwndDlg);
				return TRUE;
				*/

		}


		break;

	case WM_CLOSE:
		//free(dialoginfo);
		isWelcome=FALSE;
		EndDialog(hwndDlg,0);
		return TRUE;

	}
	return FALSE;
}

void wizard_screen1(HWND hwndDlg) //Function to set up first Wizard screen
{
	unsigned char *txt;

	DialogBox(hinstGLB, MAKEINTRESOURCE(DLG_WIZARD), NULL, (DLGPROC) DLG_WIZARDFunc);
	//helpcontext=21;


}

//static BOOL CALLBACK DLG_WIZARDFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);



void wizard_init(HWND hwndDlg);

void wizard_init(HWND hwndDlg)
{

	HWND hDlg;
	int i=0;
	unsigned char *txt;

	hDlg=hwndDlg;




	if(wiz_screen==0){

		helpcontext=20;
		EnableWindow(GetDlgItem(hwndDlg,ID_WIZ_PREV),FALSE);

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_REP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_HEADER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_TIMESTAMP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_RPT_FILES));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_ACCESDENIED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_SUMMARY));


		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATTERN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_ED_SEARCHPTRN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATH));
		DestroyWindow(GetDlgItem(hwndDlg,IDD_PATH_ROLL));
		DestroyWindow(GetDlgItem(hwndDlg,ID_PATH_SELECT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_FILES_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_TXT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_SHA1));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_TIGER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_RMD160));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_MD5));



		helpcontext=20;
		//wiz_screen=0; //Set to start screen
		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
	    i+=sprintf(&txt[i],"This Wizard will guide you through the process of creating a task, and setting all necessary options. \n");
  		i+=sprintf(&txt[i]," \n");
  		i+=sprintf(&txt[i],"Basically you will be posted several questions, with an explanatory text accompanying. The Wizard may give additional help if you press the help button. \n");
  		i+=sprintf(&txt[i],"\n");
  		i+=sprintf(&txt[i],"The next button will bring you to a new question, and the previous button will bring you back to the previous question if you feel for changing it.\n");
  		i+=sprintf(&txt[i]," \n");
  		i+=sprintf(&txt[i],"When the Wizard has all the information it needs, the next button will change to a finish button and by pressing that button you start the task\n");
  		i+=sprintf(&txt[i]," \n");
  		i+=sprintf(&txt[i],"Whenever you want to run the same task again, you don't need to go through this process again, just open the task from the file menu, and hit start.\n");

		SendDlgItemMessage(hwndDlg,ID_WIZ_TEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);
	}
	if(wiz_screen==1){

		helpcontext=21;
		EnableWindow(GetDlgItem(hwndDlg,ID_WIZ_PREV),TRUE);
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_REP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_HEADER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_TIMESTAMP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_RPT_FILES));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_ACCESDENIED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_SUMMARY));


		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATTERN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_ED_SEARCHPTRN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATH));
		DestroyWindow(GetDlgItem(hwndDlg,IDD_PATH_ROLL));
		DestroyWindow(GetDlgItem(hwndDlg,ID_PATH_SELECT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_SHA1));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_TIGER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_RMD160));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_MD5));

		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
		i+=sprintf(&txt[i],"Files \n");
  		i+=sprintf(&txt[i]," \n");
  		i+=sprintf(&txt[i],"Here you will give the path and filename of the database and report files you would like to create. \n");
  		i+=sprintf(&txt[i]," \n");
  		i+=sprintf(&txt[i],"The database file is used to store the fingerprints of your files, while the report file is a file where Floke will store reports of changes etc.\n");
  		i+=sprintf(&txt[i]," \n");
  		i+=sprintf(&txt[i],"Either enter the name of the files onto their respective fields or press the dotted buttons to bring up a file dialog. \n");
		SendDlgItemMessage(hwndDlg,ID_WIZ_TEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);
		SendDlgItemMessage(hDlg,ID_DB_FILE,WM_SETTEXT,0,(LPARAM)(LPCTSTR)databasefile);
		SendDlgItemMessage(hDlg,ID_REP_FILE,WM_SETTEXT,0,(LPARAM)(LPCTSTR)report->reportfile);
	}
	if(wiz_screen==2){

		helpcontext=22;

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_REP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_HEADER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_TIMESTAMP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_RPT_FILES));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_ACCESDENIED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_SUMMARY));


		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATTERN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_ED_SEARCHPTRN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATH));
		DestroyWindow(GetDlgItem(hwndDlg,IDD_PATH_ROLL));
		DestroyWindow(GetDlgItem(hwndDlg,ID_PATH_SELECT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_FILES_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_TXT));

		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
		i+=sprintf(&txt[i],"Hash \n");
  		i+=sprintf(&txt[i],"\n");
  		i+=sprintf(&txt[i],"Here you will select the algorithm to use for the task.\n");
  		i+=sprintf(&txt[i],"It is generally believed that SHA-1 and RIPEMD-160 are secure, while MD5 has been proved to have collisions (i.e. same fingerprint for different data sets). Tiger is a newer algorithm (currently not implemented).\n");
  		i+=sprintf(&txt[i],"\n");
  		i+=sprintf(&txt[i],"For further information see help. \n");
		SendDlgItemMessage(hwndDlg,ID_WIZ_TEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);
		if(hashinfo->md5_working==FALSE)
			{
					EnableWindow(GetDlgItem(hwndDlg,ID_HASH_MD5),FALSE);
			}
		if(hashinfo->sha1_working==FALSE)
			{
					EnableWindow(GetDlgItem(hwndDlg,ID_HASH_SHA1),FALSE);
			}
		if(hashinfo->rmd160_working==FALSE)
			{
					EnableWindow(GetDlgItem(hwndDlg,ID_HASH_RMD160),FALSE);
			}
		if(hashinfo->tiger_working==FALSE)
			{
					EnableWindow(GetDlgItem(hwndDlg,ID_HASH_TIGER),FALSE);
			}

		if(hash==SHA1)
			{
				CheckRadioButton(hwndDlg,ID_HASH_SHA1,ID_HASH_MD5,ID_HASH_SHA1);
			}

		if(hash==MD5)
			{
				CheckRadioButton(hwndDlg,ID_HASH_SHA1,ID_HASH_MD5,ID_HASH_MD5);
			}

		if(hash==RMD160)
			{
				CheckRadioButton(hwndDlg,ID_HASH_SHA1,ID_HASH_MD5,ID_HASH_RMD160);
			}
		if(hash==TIGER)
			{
				CheckRadioButton(hwndDlg,ID_HASH_SHA1,ID_HASH_MD5,ID_HASH_TIGER);
			}




	}
	if(wiz_screen==3){

		helpcontext=23;
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_REP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_HEADER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_TIMESTAMP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_RPT_FILES));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_ACCESDENIED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_SUMMARY));


		DestroyWindow(GetDlgItem(hwndDlg,ID_FILES_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_TXT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_SHA1));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_TIGER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_RMD160));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_MD5));


		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
		i+=sprintf(&txt[i],"Search pattern and path\n");
  		i+=sprintf(&txt[i],"\n");
  		i+=sprintf(&txt[i],"Enter a wild character search pattern, where asterisk (*) means several none specified characters, and question mark (?) means one none specified character. You can have several search patterns, just remember to end them with a pipe (|). You may not use more than 40 characters for your complete search pattern. \n");
  		i+=sprintf(&txt[i],"\n");
  		i+=sprintf(&txt[i],"e.g. '*.exe|*.com|'   Finds every file ending on either exe or com.\n");
  		i+=sprintf(&txt[i],"\n");
  		i+=sprintf(&txt[i],"In the path box, you have to select which drive to perform the search on.");



		SendDlgItemMessage(hwndDlg,ID_WIZ_TEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);
		SendDlgItemMessage(hwndDlg,ID_ED_SEARCHPTRN, WM_SETTEXT,0,(LPARAM)(LPCTSTR)searchpattern);

		unsigned char availableDrives[MAX_PATH];
		unsigned char drvstring[4];
		unsigned int i=0;
		unsigned int j=0;
		//BOOL correctstrng=TRUE;

		SendDlgItemMessage(hwndDlg,IDD_PATH_ROLL, CB_RESETCONTENT,0,0);
		i=0;
		j=GetLogicalDriveStrings(MAX_PATH,availableDrives);
		drvstring[3]=0;
		SendMessage(GetDlgItem(hwndDlg, IDD_PATH_ROLL), WM_SETREDRAW ,FALSE,0);
		while(i<j)
			{
				//correctstrng=TRUE;
				drvstring[0]=availableDrives[i];
				i++;
				drvstring[1]=availableDrives[i];
				i++;
				drvstring[2]=availableDrives[i];
				i++;
				i++;
				//drvstring[3]=availableDrives[i];

				//SendDlgItemMessage(hDlg,ID_PATH_ROLL, CB_ADDSTRING,0,(LPARAM)(LPCTSTR)drvstring);
				SendMessage(GetDlgItem(hwndDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)drvstring);

			}


		//SendMessage(GetDlgItem(hDlg, ID_PATH_ROLL), CB_RESETCONTENT ,0,0);
		SendMessage(GetDlgItem(hwndDlg, IDD_PATH_ROLL), WM_SETREDRAW ,TRUE,0);
		if(SendMessage(GetDlgItem(hwndDlg, IDD_PATH_ROLL), CB_FINDSTRINGEXACT , (WPARAM) -1 ,(LPARAM)(LPCSTR)startpath)==CB_ERR)
			{
				SendMessage(GetDlgItem(hwndDlg, IDD_PATH_ROLL), CB_ADDSTRING ,0,(LPARAM)(LPCTSTR)startpath);
			}
		SendMessage(GetDlgItem(hwndDlg, IDD_PATH_ROLL), CB_SETCURSEL,(WPARAM)SendMessage(GetDlgItem(hwndDlg, IDD_PATH_ROLL), CB_FINDSTRINGEXACT , (WPARAM) -1,(LPARAM)(LPCSTR)startpath),0);
		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
		i+=sprintf(&txt[i],"&Next ->");
		SendDlgItemMessage(hwndDlg,ID_WIZ_NEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);

	}

	if(wiz_screen==4){


		helpcontext=24;

		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
		i+=sprintf(&txt[i],"Report\n");
		i+=sprintf(&txt[i],"Here you might cross the things you want in your report. In the files sub-group you can also specify if you want to have the hashes displayed. \n");



		SendDlgItemMessage(hwndDlg,ID_WIZ_TEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);


		DestroyWindow(GetDlgItem(hwndDlg,ID_FILES_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_TXT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATTERN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_ED_SEARCHPTRN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATH));
		DestroyWindow(GetDlgItem(hwndDlg,IDD_PATH_ROLL));
		DestroyWindow(GetDlgItem(hwndDlg,ID_PATH_SELECT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_SHA1));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_TIGER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_RMD160));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_MD5));

		CheckDlgButton(hDlg,ID_RPT_HEADER,BoolToNumber(report->makeheader));
		CheckDlgButton(hDlg,ID_RPT_TIMESTAMP,BoolToNumber(report->makeheader_time));
		CheckDlgButton(hDlg,ID_RPT_CLEARD,BoolToNumber(report->reportCleardFiles));
		CheckDlgButton(hDlg,ID_RPT_CLEARD_HASH,BoolToNumber(report->reportCleardFilesWithHashes));
		CheckDlgButton(hDlg,ID_RPT_DELETED,BoolToNumber(report->reportDeletedFiles));
		CheckDlgButton(hDlg,ID_RPT_CHANGED_HASH,BoolToNumber(report->reportChangedFilesWithHashes));
		CheckDlgButton(hDlg,ID_RPT_CHANGED,BoolToNumber(report->reportChangedFiles));
		CheckDlgButton(hDlg,ID_RPT_DELETED_HASH,BoolToNumber(report->reportDeletedFilesWithHashes));
		CheckDlgButton(hDlg,ID_RPT_NEW,BoolToNumber(report->reportNewFiles));
		CheckDlgButton(hDlg,ID_RPT_NEW_HASH,BoolToNumber(report->reportNewFilesWithHashes));
		CheckDlgButton(hDlg,ID_RPT_ACCESDENIED,BoolToNumber(report->reportAccesDeniedFiles));
		CheckDlgButton(hDlg,ID_RPT_SUMMARY,BoolToNumber(report->makesummary));
		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
		i+=sprintf(&txt[i],"Nex&t ->");
		SendDlgItemMessage(hwndDlg,ID_WIZ_NEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);


	}
	if(wiz_screen==5){

		helpcontext=25;

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_REP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_HEADER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_TIMESTAMP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_RPT_FILES));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_ACCESDENIED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_SUMMARY));


		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATTERN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_ED_SEARCHPTRN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATH));
		DestroyWindow(GetDlgItem(hwndDlg,IDD_PATH_ROLL));
		DestroyWindow(GetDlgItem(hwndDlg,ID_PATH_SELECT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_FILES_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_TXT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_SHA1));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_TIGER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_RMD160));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_MD5));




		//wiz_screen=0; //Set to start screen
		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
		i+=sprintf(&txt[i],"Finished \n");
		i+=sprintf(&txt[i]," \n");
		i+=sprintf(&txt[i],"You have now given Floke all the information it needs. You may go back and review the information given, or you may press the 'Finish' button to come back to the main screen. On the main screen you may change the options by selecting 'Task Options' from the 'Options' menu. To start and save the task press 'Start'.  \n");

		SendDlgItemMessage(hwndDlg,ID_WIZ_TEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);
		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
		i+=sprintf(&txt[i],"&Finish");
		SendDlgItemMessage(hwndDlg,ID_WIZ_NEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		free(txt);


	}
		if(wiz_screen==20){

		//helpcontext=20;
		EnableWindow(GetDlgItem(hwndDlg,ID_WIZ_PREV),TRUE);


		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_REP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_HEADER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_TIMESTAMP));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_RPT_FILES));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CLEARD_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_CHANGED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_DELETED_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_NEW_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_ACCESDENIED));
		DestroyWindow(GetDlgItem(hwndDlg,ID_RPT_SUMMARY));


		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATTERN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_ED_SEARCHPTRN));
		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_SEARCH_PATH));
		DestroyWindow(GetDlgItem(hwndDlg,IDD_PATH_ROLL));
		DestroyWindow(GetDlgItem(hwndDlg,ID_PATH_SELECT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_FILES_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_DB_TXT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_FILE));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_SELECT));
		DestroyWindow(GetDlgItem(hwndDlg,ID_REP_TXT));

		DestroyWindow(GetDlgItem(hwndDlg,ID_TXT_HASH));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_SHA1));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_TIGER));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_RMD160));
		DestroyWindow(GetDlgItem(hwndDlg,ID_HASH_MD5));

		hdc=BeginPaint(hwndDlg,&ps);
		DrawIcon(hdc,5,5,LoadIcon(hinstGLB, MAKEINTRESOURCE(ICON_APPWND)));
		EndPaint(hwndDlg,&ps);

		helpcontext=20;
		//wiz_screen=0; //Set to start screen
		txt=(unsigned char *)malloc(sizeof(unsigned char)*830);
		i=0;
	    i+=sprintf(&txt[i],"Welcome to Floke Integrity\n");
  		i+=sprintf(&txt[i]," \n");
  		i+=sprintf(&txt[i],"Floke Integrity is a security application that protects the integrity of your files. Integrity is often a neglected part of computer security. Floke will use mathematically strong message- digest/hash functions (SHA-1, RIPEMD-160 or MD5) to make 'fingerprints' of your files. These 'fingerprints' are stored and checked against, when you fear that your files have been subject to tampering or changes from hardware/software malfunction. \n");
		i+=sprintf(&txt[i]," \n");
		i+=sprintf(&txt[i],"From here you may select what you would like to do.\n");


		SendDlgItemMessage(hwndDlg,ID_WIZ_TEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		i=0;
		i+=sprintf(&txt[i],"&Open a task");
		SendDlgItemMessage(hwndDlg,ID_WIZ_CANCEL,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		i=0;
		i+=sprintf(&txt[i],"&New task");
		SendDlgItemMessage(hwndDlg,ID_WIZ_HELP,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		i=0;
		i+=sprintf(&txt[i],"&View manual");
		SendDlgItemMessage(hwndDlg,ID_WIZ_PREV,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		i=0;
		i+=sprintf(&txt[i],"Ok&ay");
		SendDlgItemMessage(hwndDlg,ID_WIZ_NEXT,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);
		i=0;
		i+=sprintf(&txt[i],"Welcome");
		SendMessage(hwndDlg,WM_SETTEXT,0,(LPARAM)(LPCTSTR)txt);

		wiz_screen=0;


		free(txt);
	}

}

void wizard_next(HWND hwndDlg) //Function to handel next button
{
	switch(wiz_screen){
		case 0:
			wizard_store(hwndDlg);
			wiz_screen++;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 1:
			wizard_store(hwndDlg);
			wiz_screen++;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 2:
			wizard_store(hwndDlg);
			wiz_screen++;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 3:
			wizard_store(hwndDlg);
			wiz_screen++;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 4:
			wizard_store(hwndDlg);
			wiz_screen++;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 5:

			sprintf(dialoginfo->LINE1,"Task File: %s\n",databasefile);
			//strcpy(dialoginfo->LINE1,"\n");
			//strcpy(dialoginfo->LINE2,"\n");
			sprintf(dialoginfo->LINE2,"Report File: %s\n",report->reportfile);
			SendDlgItemMessage(mainDLG,ID_LINE1,WM_SETTEXT,0,(LPARAM)(LPCTSTR)dialoginfo->LINE1);
			SendDlgItemMessage(mainDLG,ID_LINE2,WM_SETTEXT,0,(LPARAM)(LPCTSTR)dialoginfo->LINE2);
			waitInit=TRUE;
			dialoginfo->DISPLAYLOG=TRUE;
			dialoginfo->TASKOPTN=TRUE;
			initWindow(mainDLG);
			EndDialog(hwndDlg,0);
			wiz_screen=0;
			return;



	}
}

void wizard_prev(HWND hwndDlg) //Function to handel prev button
{
	switch(wiz_screen){
		case 0:

			return;
		case 1:
			wizard_store(hwndDlg);
			wiz_screen--;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 2:
			wizard_store(hwndDlg);
			wiz_screen--;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 3:
			wizard_store(hwndDlg);
			wiz_screen--;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 4:
			wizard_store(hwndDlg);
			wiz_screen--;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;
		case 5:
			wizard_store(hwndDlg);
			wiz_screen--;
			DestroyWindow(hwndDlg);
			wizard_screen1(hwndDlg);
			return;


	}
}


BOOL wizard_store(HWND hwndDlg) //Function to store data acquired
{
	HWND hDlg;

	hDlg=hwndDlg;

	switch(wiz_screen){
		case 0:
			return TRUE;
		case 1:
			SendDlgItemMessage(hwndDlg,ID_DB_FILE,WM_GETTEXT,(WPARAM)MAX_PATH,(LPARAM)(LPCTSTR)databasefile);
			SendDlgItemMessage(hwndDlg,ID_REP_FILE,WM_GETTEXT,(WPARAM)MAX_PATH,(LPARAM)(LPCTSTR)report->reportfile);
			return TRUE;
		case 2:
			if(numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_HASH_SHA1),  BM_GETCHECK ,0,0))==TRUE)
				{
					hashinfo->hashlenght=5;
					hash=SHA1;
				}

			if(numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_HASH_TIGER),  BM_GETCHECK ,0,0))==TRUE)
				{
					hashinfo->hashlenght=3;
					hash=TIGER;
				}
			if(numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_HASH_RMD160),  BM_GETCHECK ,0,0))==TRUE)
				{
					hashinfo->hashlenght=5;
					hash=RMD160;
				}
			if(numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_HASH_MD5),  BM_GETCHECK ,0,0))==TRUE)
				{
					hashinfo->hashlenght=4;
					hash=MD5;
				}
			return TRUE;
		case 3:
			SendDlgItemMessage(hDlg,ID_ED_SEARCHPTRN,WM_GETTEXT,(WPARAM)SEARCHPATTERNLENGHT,(LPARAM)(LPCTSTR)searchpattern);
			SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL),  CB_GETLBTEXT ,(WPARAM)SendMessage(GetDlgItem(hDlg, IDD_PATH_ROLL),  CB_GETCURSEL ,0,0),(LPARAM)(LPCTSTR)startpath);
			dialoginfo->Ready=FALSE;
			return TRUE;
		case 4:
			report->makeheader=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_HEADER),  BM_GETCHECK ,0,0));

			report->makeheader_time=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_HEADER),  BM_GETCHECK ,0,0));
			//report->reportScannedFile=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_HEADER),  BM_GETCHECK ,0,0));
			//report->reportScannedFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_HEADER),  BM_GETCHECK ,0,0));
			report->reportCleardFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_CLEARD),  BM_GETCHECK ,0,0));
			report->reportCleardFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_CLEARD_HASH),  BM_GETCHECK ,0,0));
			report->reportChangedFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_CHANGED),  BM_GETCHECK ,0,0));
			report->reportChangedFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_CHANGED_HASH),  BM_GETCHECK ,0,0));
			report->reportDeletedFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_DELETED),  BM_GETCHECK ,0,0));
			report->reportDeletedFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_DELETED_HASH),  BM_GETCHECK ,0,0));
			report->reportNewFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_NEW),  BM_GETCHECK ,0,0));
			report->reportNewFilesWithHashes=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_NEW_HASH),  BM_GETCHECK ,0,0));
			report->reportAccesDeniedFiles=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_ACCESDENIED),  BM_GETCHECK ,0,0));
			report->makesummary=numberToBOOL(SendMessage(GetDlgItem(hDlg, ID_RPT_SUMMARY),  BM_GETCHECK ,0,0));
			dialoginfo->Ready=TRUE;
			return TRUE;
		case 5:

			return TRUE;





	}
	return FALSE;
}


