#print -r Running $ENV >&2

# rhm additions 6/8/02
alias f:="cd f:" g:="cd g:" h:="cd h:" i:="cd i:" z:="cd z:"
alias desktop:="cd C:/WINDOWS/Desktop"
alias lf="ls -p"
alias rem="#"
# end rhm additions

# MKS Toolkit sample environ.ksh -- Modify to taste.

# The file named by environment variable ENV is executed at startup of
# the KornShell.  When the KornShell is started with the "-L" option,
# this file is executed after the profile.ksh files.
# This is the place to perform initialization internal to the KornShell.

# Aliases to mimic the standard command interpreters and access their
# built-in commands.
alias a:="cd a:" b:="cd b:" c:="cd c:" d:="cd d:" e:="cd e:"
alias md=mkdir rd=rmdir
export SWITCHAR=${SWITCHAR:=/}	# if not already defined
for arg in cls copy del dir erase move path ren type ver verify vol
do
	alias $arg="'${COMSPEC}' ${SWITCHAR}c $arg"
done

# Applicable only to DOS KornShells. Change console.
#if [ $(uname) = DOS ] ; then ctty() { exec > $1 2>&1 <&1; }; fi

# Applicable only to DOS KornShells.
# If you make a habit of stopping Vi, or otherwise using
# Terminate-And-Stay-Resident (TSR) programs that are not installed from
# $ROOTDIR/etc/inittab, then this ulimit command avoids memory conflict
# in sub-shells as well as the login shell.
# Uncomment to use; -d parameter can be adjusted downwards.
#if [ $(uname) = DOS ]; then ulimit -d 48; fi

if [ ! $SH_OPTION_SETTINGS_RESTORED ] ; then 
	# Create a new command history file for each KornShell.  This avoids
	# history file conflicts when two or more KornShells are open
	# simultaneously.  Highly recommended for DOS with Windows, OS/2,
	# Windows NT and Windows 95.
	if [ _$- != _${-%%*i*} ]; then . $ROOTDIR/etc/newhist.ksh; fi

	# Here is an assortment of command line prompts.  Choose one by
	# deleting or commenting-out all others.
	PS1='[$PWD] '
	#PS1="$ "			# a simple default prompt
	#PS1="!% "			# prompt with history number
	#typeset -u PS1='$PWD>'		# equivalent to command prompt $p$g
	#typeset -u PS1='${PWD%%:*}>'	# equivalent to command prompt $n$g
fi
