/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/

#ifndef BCC32
#define ULLONG_TYPE unsigned long long
#define LLONG_TYPE long long
#else
#define ULLONG_TYPE unsigned long 
#define LLONG_TYPE long
#endif
/*      expression tree descriptions    */

typedef struct {
   long double r ;
   long double i ;
} _COMPLEX_S ;

enum e_node {
        en_void, en_voidnz,       /* used for parameter lists */
   en_cb, en_cub, en_cw, en_cuw, en_cl, en_cul, en_cll, en_cull, 
   en_cf, en_cd, en_cp, en_cld, en_cfc, en_crc, en_clrc,
   en_cfi, en_cri, en_clri,
        en_icon, en_lcon,en_iucon, en_lucon, en_llcon, en_llucon, 
        en_rcon, en_fcon, en_lrcon, 
        en_rimaginarycon, en_fimaginarycon, en_lrimaginarycon,
        en_rcomplexcon, en_fcomplexcon, en_lrcomplexcon,
	en_ccon, en_labcon, en_nacon, en_autocon, en_absacon, en_nalabcon,
        en_napccon, en_b_ref, en_w_ref, en_l_ref, en_ub_ref, en_uw_ref,
        en_ll_ref, en_ull_ref, en_bool_ref, en_cbool,
        en_fimaginaryref, en_rimaginaryref, en_lrimaginaryref,
        en_fcomplexref, en_rcomplexref, en_lrcomplexref,
	en_floatref, en_doubleref, en_longdoubleref, en_autoreg, en_trapcall,
        en_ul_ref, en_cl_reg, en_fcall, en_fcallb, en_intcall, en_tempref, en_regref,
	en_pfcallb, en_pfcall, en_pcallblock, en_sfcallb, en_sfcall, en_scallblock,
	en_add, en_sub, en_mul, en_mod,
        en_div, en_lsh, en_rsh, en_cond, en_assign, en_lassign, 
        en_refassign, en_eq, en_ne,
        en_asadd, en_assub, en_asmul, en_asdiv, en_asmod, en_asrsh,
	en_asumul, en_asudiv, en_asumod, en_pmul,
        en_aslsh, en_asand, en_asor, en_asxor, en_uminus, en_asuminus, en_not, 
        en_compl, en_ascompl,
        en_lt, en_le, en_gt, en_ge, en_and, en_or, en_land, en_lor,
        en_xor, en_ainc, en_adec, en_umul, en_udiv, en_umod, en_ugt,
        en_uge, en_ule, en_ult, en_moveblock, en_stackblock, en_callblock,
	en_pdiv, en_alsh, en_arsh, en_asarsh,en_arshd, en_asarshd,
	en_asalsh, en_bits, en_addstruc,
	en_thiscall, en_imode, en_ptr_ref, en_repcons, en_placeholder };

/*      statement node descriptions     */

enum e_stmt {
        st_line, st_expr, st_while, st_for, st_do, st_if, st_switch,
        st_case, st_goto, st_break, st_continue, st_label, st_asm,
        st_return, st_block, st__genword, st_abs, st_passthrough };

struct enode {
        enum e_node	nodetype;
	char bits;
	char startbit;
   int cflags;
	long size; /* For block moves */
        union {
                LLONG_TYPE      i;
                double          f;
                _COMPLEX_S c ;
                struct sym      *sp;    /* sym will be defined later */
               char     *name;  /* name during base class processing */
                struct enode    *p[2];
                } v;
        };

struct snode {
        enum e_stmt     stype;
        struct snode    *next;          /* next statement */
        struct enode    *exp;           /* condition or expression */
        struct snode    *s1, *s2,*lst;       /* internal statements &lineno*/
	/* changed */
	struct snode          *label;         /* label number for goto */
        };

struct cse {
        struct cse      *next;
        struct enode    *exp;           /* optimizable expression */
        short           uses;           /* number of uses */
        short            duses;          /* number of dereferenced uses */
	char		size;		/* Size of the expresion */
        char             voidf;          /* cannot optimize flag */
        char             reg;            /* allocated register */
        };

#define ENODE struct enode
#define SNODE struct snode
#define CSE struct cse