/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <errno.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <stdio.h>
#include <libp.h>
#include <dpmi.h>
#include <llp.h>
#include <sys\stat.h>

extern int _uihandles[HANDLE_MAX] ;

void _ll_uioinit(void)
{
      DWORD mode ;
      _uihandles[0] = GetStdHandle(STD_INPUT_HANDLE);
      _uihandles[1] = GetStdHandle(STD_OUTPUT_HANDLE);
      _uihandles[2] = GetStdHandle(STD_ERROR_HANDLE);

      GetConsoleMode((HANDLE) _uihandles[0], &mode) ;
      SetConsoleMode((HANDLE) _uihandles[0], mode & ~ENABLE_LINE_INPUT) ;

}
int _ll_chmod(char *path, int amode)
{
   amode = amode & S_IWRITE ? FILE_ATTRIBUTE_NORMAL : FILE_ATTRIBUTE_READONLY ;
   if (SetFileAttributes(path,amode))
      return 0 ;
   errno = GetLastError() ;
   return -1 ;
}

int _ll_chsize(int handle, int size)
{
   DPMI_REGS regs ;
   int old = _ll_getpos(handle) ;
   char buf[256] ;
   int len ;
   int rv ;
   if (old == -1)
      return old ;
   len = _ll_seek(handle,0,SEEK_END) ;
   if (len == -1)
      return len ;
   len = _ll_getpos(handle) ;
   if (len == -1)
      return len ;
   if (len != size) {
      if (len < size) {
         memset(buf,0,256) ;
         len = size - len ;
         while (len >= 256) {
            rv = _ll_write(handle,buf,256) ;
            if (rv == -1 || rv != 256)
               return -1 ;
            len -= 256 ;
         }
         if (len) {
            rv = _ll_write(handle,buf,len) ;
            if (rv == -1 || rv != len)
               return -1 ;
         }
      } else {
         if (_ll_seek(handle,size,SEEK_SET) == -1)
            return -1 ;
         if (!SetEndOfFile((HANDLE)handle)) {
            errno = GetLastError() ;
            return -1 ;
         }
      }
   }
   return _ll_seek(handle,old,SEEK_SET) ;
}

int _ll_dup(int handle)
{
   HANDLE dup ;
   if (DuplicateHandle(GetCurrentProcess(),(HANDLE)handle,
                      GetCurrentProcess(),&dup,
            0,FALSE,DUPLICATE_SAME_ACCESS)) {
      return (int)dup ;
   } else {
      errno = GetLastError() ;
      return 0 ;
   }
}

int _ll_setftime(int handle,void *ftimep)
{
	FILETIME timex,timet ;
   DosDateTimeToFileTime(*(((short *)ftimep)+1),*(short *)ftimep,&timex) ;
	LocalFileTimeToFileTime(&timex,&timet);
   return SetFileTime((HANDLE)handle,0,0,&timet) ? 0 : -1 ;
}

int _ll_getftime(int handle,void *ftimep)
{
	BY_HANDLE_FILE_INFORMATION info ;
	FILETIME timex ;
   if (!GetFileInformationByHandle((HANDLE)handle,&info)) {
      errno = GetLastError() ;
      return -1 ;
   }
   FileTimeToLocalFileTime(&info.ftLastWriteTime,&timex);
   FileTimeToDosDateTime(&timex,((short *)ftimep)+1, ftimep) ;
	return 0;
}

int _ll_isatty(int handle)
{
   return GetFileType((HANDLE)handle) == FILE_TYPE_CHAR ;
}

int _ll_lock(int handle, int offset, int length)
{
   if (LockFile((HANDLE)handle,offset,0,length,0))
      return 0 ;
   errno = GetLastError() ;
   return -1 ;
}

int _ll_unlock(int handle, int offset, int length)
{
   if (UnlockFile((HANDLE)handle,offset,0,length,0))
      return 0 ;
   errno = GetLastError() ;
   return -1 ;
}
int _ll_uioflags(int flags)
{
   if (flags & O_RDONLY)
      return GENERIC_READ ;
   if (flags & O_WRONLY)
      return GENERIC_WRITE ;
   return GENERIC_READ | GENERIC_WRITE ;
}
int _ll_shflags(int flags)
{
   switch((flags>>4) & 7) {   
      case 0:
      case 4:
      default:
         return FILE_SHARE_READ | FILE_SHARE_WRITE ;
      case 1:
         return 0 ;
      case 2:
         return FILE_SHARE_READ ;
      case 3:
         return FILE_SHARE_WRITE ;
   }
}