/*  math.h

    Definitions for the math floating point package.

*/

#ifndef  __MATH_H
#define  __MATH_H

#ifndef __DEFS_H__
#include <defs.h>
#endif


struct complex      /* as used by "_cabs" function */
{
    double  x, y;
};

struct _complexl    /* as used by "_cabsl" function */
{
    long double  x, y;
};

#define cabs(z)     (hypot  ((z).x, (z).y))
#define cabsl(z)    (hypotl ((z).x, (z).y))

typedef enum
{
    DOMAIN = 1,    /* argument domain error -- log (-1)        */
    SING,          /* argument singularity  -- pow (0,-2))     */
    OVERFLOW,      /* overflow range error  -- exp (1000)      */
    UNDERFLOW,     /* underflow range error -- exp (-1000)     */
    TLOSS,         /* total loss of significance -- sin(10e70) */
    PLOSS,         /* partial loss of signif. -- not used      */
    STACKFAULT     /* floating point unit stack overflow       */
}   _mexcep;

/* Constants rounded for 21 decimals. */
#define M_E         2.71828182845904523536
#define M_LOG2E     1.44269504088896340736
#define M_LOG10E    0.434294481903251827651
#define M_LN2       0.693147180559945309417
#define M_LN10      2.30258509299404568402
#define M_PI        3.14159265358979323846
#define M_PI_2      1.57079632679489661923
#define M_PI_4      0.785398163397448309616
#define M_1_PI      0.318309886183790671538
#define M_2_PI      0.636619772367581343076
#define M_1_SQRTPI  0.564189583547756286948
#define M_2_SQRTPI  1.12837916709551257390
#define M_SQRT2     1.41421356237309504880
#define M_SQRT_2    0.707106781186547524401

#define EDOM    33      /* Math argument */
#define ERANGE  34      /* Result too large */

struct  exception
{
    int type;
    char *name;
    double  arg1, arg2, retval;
};

struct  _exceptionl
{
    int type;
    char *name;
    long double  arg1, arg2, retval;
};

#define HUGE_VAL    _huge_dble
extern double _huge_dble;
#define _LHUGE_VAL   _huge_ldble
extern long double _huge_ldble;

#ifdef __cplusplus
extern "C" {
#endif

double      RTL_NORM acos    (double __x);
double      RTL_NORM asin    (double __x);
double      RTL_NORM atan    (double __x);
double      RTL_NORM atan2   (double __y, double __x);
double      RTL_NORM ceil    (double __x);
double      RTL_NORM cos     (double __x);
double      RTL_NORM cosh    (double __x);
double      RTL_NORM exp     (double __x);
double      RTL_NORM fabs    (double __x);
double      RTL_NORM floor   (double __x);
double      RTL_NORM fmod    (double __x, double __y);
double      RTL_NORM frexp   (double __x, int *__exponent);
double      RTL_NORM ldexp   (double __x, int __exponent);
double      RTL_NORM log     (double __x);
double      RTL_NORM log10   (double __x);
double      RTL_NORM modf    (double __x, double *__ipart);
double      RTL_NORM pow     (double __x, double __y);
double      RTL_NORM sin     (double __x);
double      RTL_NORM sinh    (double __x);
double      RTL_NORM sqrt    (double __x);
double      RTL_NORM tan     (double __x);
double      RTL_NORM tanh    (double __x);

long double RTL_NORM acosl  (long double __x);
long double RTL_NORM asinl  (long double __x);
long double RTL_NORM atan2l (long double __x, long double __y);
long double RTL_NORM atanl  (long double __x);
long double RTL_NORM ceill  (long double __x);
long double RTL_NORM coshl  (long double __x);
long double RTL_NORM cosl   (long double __x);
long double RTL_NORM expl   (long double __x);
long double RTL_NORM  fabsl  (long double __x);
long double RTL_NORM floorl (long double __x);
long double RTL_NORM fmodl  (long double __x, long double __y);
long double RTL_NORM frexpl (long double __x, int *__exponent);
long double RTL_NORM ldexpl (long double __x, int __exponent);
long double RTL_NORM log10l (long double __x);
long double RTL_NORM logl   (long double __x);
long double RTL_NORM modfl  (long double __x, long double *__ipart);
long double RTL_NORM powl   (long double __x, long double __y);
long double RTL_NORM sinhl  (long double __x);
long double RTL_NORM sinl   (long double __x);
long double RTL_NORM sqrtl  (long double __x);
long double RTL_NORM tanhl  (long double __x);
long double RTL_NORM tanl   (long double __x);


double      RTL_NORM hypot (double __x, double __y);
int         RTL_NORM _matherr (struct exception *__e);
double      RTL_NORM poly  (double __x, int __degree, double *__coeffs);
double      RTL_NORM pow10 (int __p);
long double RTL_NORM hypotl (long double __x, long double __y);
long double RTL_NORM polyl  (long double __x, int __degree, long double *__coeffs);
long double RTL_NORM pow10l (int __p);

#if !defined(__ABS_DEFINED)
#define __ABS_DEFINED
int         RTL_INTRINS abs(int __x);

#endif /* __ABS_DEFINED */

double      RTL_NORM atof  (const char *__s);
int         _matherrl (struct _exceptionl *__e);

long labs(long __x);
#define labs(__x)  abs(__x)

long double  RTL_NORM _atold (const char *__s);

#ifdef __cplusplus
};
#endif

#endif  /* __MATH_H */