#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <errno.h>
#include <libp.h>

extern int maxfiles;
extern FILE *_pstreams[] ;

unsigned char inbuf[512];

FILE _istreams[3] = { 
   { 0, _F_READ | _F_LBUF | _F_TERM,0,0,512,inbuf,inbuf,0,FILTOK },
   { 0, _F_WRIT | _F_LBUF | _F_TERM,1,0,0,0,0,0,FILTOK },
   { 0, _F_WRIT | _F_LBUF | _F_TERM,1,0,0,0,0,0,FILTOK }
} ;

//#undef stdin
//#undef stdout
//#undef stderr

extern int maxfiles;

FILE *__getStream(int stream)
{
   return _pstreams[stream] ;
}

void _ll_init(void)
{
   static int done ;
   if (!done) {
      DWORD mode ;
      _pstreams[0] = &_istreams[0] ;
      _pstreams[1] = &_istreams[1] ;
      _pstreams[2] = &_istreams[2] ;
      maxfiles = 3;
      stdin->fd = GetStdHandle(STD_INPUT_HANDLE);
      stdout->fd = GetStdHandle(STD_OUTPUT_HANDLE);
      stderr->fd = GetStdHandle(STD_ERROR_HANDLE);

      GetConsoleMode((HANDLE) stdin->fd, &mode) ;
      SetConsoleMode((HANDLE) stdin->fd, mode & ~ENABLE_LINE_INPUT) ;
      done = 1 ;
   }
}
int _ll_open(char *name, int flags, int shflags)
{
   HANDLE handle = CreateFile(name,flags,shflags,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
   if (handle == INVALID_HANDLE_VALUE) {
      errno = GetLastError() ;
		return 0;
   }
	return handle ;
}
int _ll_creat(char *name, int flags, int shflags)
{
   HANDLE handle = CreateFile(name,flags,shflags,0,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
   if (handle == INVALID_HANDLE_VALUE) {
      errno = GetLastError() ;
		return 0;
   }
	return handle ;
}
int _ll_close(int fd)
{
   if (!CloseHandle((HANDLE)fd)) {
      errno = GetLastError() ;
   }
	return 1 ;
}
size_t _ll_getpos(int fd)
{
   int rv =SetFilePointer((HANDLE)fd,0,0,FILE_CURRENT) ;
   if (rv == -1)
      errno = GetLastError() ;
   return rv ;
}
int _ll_flags(int flags)
{
	if (flags & _F_WRIT)
		if (flags & _F_READ)
			return GENERIC_READ | GENERIC_WRITE;
		else
			return GENERIC_WRITE;
	else
		return GENERIC_READ;
} 

int _ll_seek(int fd, size_t pos, int origin)
{
	int type ;
	switch(origin) {
		case SEEK_SET:
			type = FILE_BEGIN ;
			break ;
		case SEEK_CUR:
			type = FILE_CURRENT ;
			break ;
		case SEEK_END:
			type = FILE_END;
			break ;
	}
	type = SetFilePointer((HANDLE)fd,pos,0,type);
   if (type == -1)
      errno = GetLastError() ;
   return type == -1 ? -1 : 0 ;
}
int _ll_rename(char *old , char *new)
{
   int rv = MoveFile(old,new);
   if (!rv)
      errno = GetLastError() ;
   return rv ;
}
int _ll_remove(char *name)
{
   int rv = DeleteFile(name) ;
   if (!rv)
      errno = GetLastError() ;
   return rv ;
}
int _ll_write(int fd, void *buf, size_t size)
{
	int written ;
	int rv = WriteFile((HANDLE)fd,buf,size,&written,0);
   if (!rv) {
      errno = GetLastError() ;
		return rv ;
   }
   if (written != size) {
      errno = GetLastError() ;
      return written;
   }
   return written ;
}
int _ll_read(int fd, void *buf, size_t size)
{
	int read ;
	int rv = ReadFile((HANDLE)fd,buf,size,&read,0) ;
   if (!rv)
      errno = GetLastError() ;
	return read ;
}