/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <io.h>
#include <dos.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <libp.h>

extern int _uiflags[HANDLE_MAX],_uimodes[HANDLE_MAX] ;

int write(int __handle, void *__buf, unsigned __len)
{
   char *pos=__buf ;
   char obuf[2048] ;
   int olen=0 ;
   int lenleft = __len,writelen, ohand = __handle ;
   int i ;
   int totalwritten = 0 ;
   __handle = _uiohandle(__handle) ;
   if (__handle == -1)
      return -1 ;
   if (_uimodes[ohand] & O_RDONLY) {
      errno = EACCES ;
      return -1 ;
   }
   if (__len == 0)
      return 0 ;
   if (_uiflags[ohand] & O_APPEND) {
      if (lseek(__handle,0,SEEK_END))
         return -1 ;
      _uiflags[ohand] |= UIF_EOF ;
   }
   if (_uimodes[ohand] & O_BINARY) {
      while (lenleft >= 2048) {
         for (i=0; i< 3; i++) {
            writelen = _ll_write(__handle,pos,2048) ;
            if (writelen) {
               if  (writelen != 2048)
                  return writelen + totalwritten ;
               else {
                  totalwritten += 2048 ;
                  lenleft -= 2048 ;
                  pos += 2048 ;
                  break ;
               }
            }
            sleep(1) ;
         }
         if (i >= 3)
            totalwritten ;
      }
      if (lenleft) {
         for (i=0; i< 3; i++) {
            writelen = _ll_write(__handle,pos,lenleft) ;
            if (writelen)
               return writelen + totalwritten ;
            sleep(1) ;
         }
      }
      return totalwritten ;
   }
   for (i= 0 ; i < __len; i++) {
      if (*pos == '\n') {
         obuf[olen++]= '\r' ;
         totalwritten-- ;
      }
      obuf[olen++]= *pos++ ;
      if (olen >= 2040) {
         int j ;
         for (j=0; j< 3; j++) {
            writelen = _ll_write(__handle,obuf,olen) ;
            if (writelen) {
               if (writelen != olen)
                  return totalwritten + writelen ;
               totalwritten += writelen ;
               break ;
            }
            sleep(1) ;
         }
         if (j >= 3)
            return totalwritten ;
         olen = 0 ;
      }
   }
   if (olen) {
         int j ;
         for (j=0; j< 3; j++) {
            writelen = _ll_write(__handle,obuf,olen) ;
            if (writelen) {
               return totalwritten + writelen ;
            }
            sleep(1) ;
         }
   }
   return totalwritten ;
}