// SerialRedirect.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "SerialRedirect.h"

#include "SerialPorts.h"
#include "NetworkPorts.h"
#include "PortServer.h"

#include "MainFrm.h"
#include "SerialRedirectDoc.h"
#include "Main.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/*
	CString		rkeysEnumKeyNames( DWORD kindex );

	void		rkeysSetInt( CString kname, int kval );
	int			rkeysGetInt( CString kname, int def );

	void		rkeysSetString( CString kname, CString kval );
	CString		rkeysGetString( CString kname, CString def );

	BOOL		rkeysOpen(void);
	void		rkeysClose(void);


	HKEY rkeyThisApp;
	HKEY rkeyCompany;
	HKEY rkeySoftware;



BOOL CSerialRedirectApp::rkeysOpen(void)
{
	BOOL		rval = FALSE;
	DWORD		dwDisposition;
	CString		csSoftware, csCompany, csThisApp;

	csSoftware.LoadString( IDS_KEY_SOFTWARE );
	csCompany.LoadString( IDS_KEY_COMPANY );
	csThisApp.LoadString( IDS_KEY_APP );

	rkeySoftware = 0;
	rkeyCompany = 0;
	rkeyThisApp = 0;

	if( RegCreateKeyEx( HKEY_LOCAL_MACHINE, (LPCTSTR)csSoftware, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &rkeySoftware, &dwDisposition) == ERROR_SUCCESS )
	{
		if( RegCreateKeyEx( rkeySoftware, (LPCTSTR)csCompany, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &rkeyCompany, &dwDisposition) == ERROR_SUCCESS )
		{
			if( RegCreateKeyEx( rkeyCompany, (LPCTSTR)csThisApp, 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &rkeyThisApp, &dwDisposition) == ERROR_SUCCESS )
			{

				rkeysSetString("Sample", "SETTINGS=9600,N,8,1 NETPORT=0x1234 CTSFLOW=on/off DSRFLOW=on/off DTR=on/off RTS=flow/on/off OPEN=connect/always");

				rval= TRUE;
			}
		}
	}

	return rval;
}







void CSerialRedirectApp::rkeysClose(void)
{
	if( rkeyThisApp )		RegCloseKey( rkeyThisApp ), rkeyThisApp= 0;

	if( rkeyCompany )		RegCloseKey( rkeyCompany ), rkeyCompany= 0;

	if( rkeySoftware )		RegCloseKey( rkeySoftware ), rkeySoftware= 0;
}









CString CSerialRedirectApp::rkeysGetString( CString kname, CString def )
{
	CString		kval = def;
	DWORD		ktype,dataLen;

	if( RegQueryValueEx( rkeyThisApp, (LPCTSTR)kname, NULL, &ktype, NULL, &dataLen ) == ERROR_SUCCESS )
	{
		kval = CString( (TCHAR)0, (int)dataLen );
		RegQueryValueEx( rkeyThisApp, (LPCTSTR)kname, NULL, &ktype, (LPBYTE)(LPCTSTR)kval, &dataLen );
	}
	
	return kval;
}



void CSerialRedirectApp::rkeysSetString(CString kname, CString kval)
{
	RegSetValueEx( rkeyThisApp, (LPCTSTR)kname, 0, REG_SZ, (LPBYTE)(LPCTSTR)kval, kval.GetLength() );
}






int CSerialRedirectApp::rkeysGetInt( CString kname, int def )
{
	DWORD		ktype,dataLen;
	DWORD		kval = (DWORD)def;

	RegQueryValueEx( rkeyThisApp, (LPCTSTR)kname, NULL, &ktype, (LPBYTE)(LPCTSTR)kval, &dataLen );

	return (int)kval;
}



void CSerialRedirectApp::rkeysSetInt(CString kname, int kval)
{
	DWORD	outval = (DWORD)kval;

	RegSetValueEx( rkeyThisApp, (LPCTSTR)kname, 0, REG_DWORD, (LPBYTE)&outval, sizeof(DWORD) );
}




CString CSerialRedirectApp::rkeysEnumKeyNames( DWORD kindex )
{
	CString		rval;
	CString		cname((TCHAR)0,100);
	DWORD		keylen = cname.GetLength();

	if( RegEnumValue( rkeyThisApp, kindex, (LPTSTR)(LPCTSTR)cname, &keylen, NULL, NULL, NULL, NULL ) == ERROR_SUCCESS )
	{
		rval = CString( (LPCTSTR)cname, keylen );
	}
	return rval;
}

*/







/////////////////////////////////////////////////////////////////////////////
// CSerialRedirectApp

BEGIN_MESSAGE_MAP(CSerialRedirectApp, CWinApp)
	//{{AFX_MSG_MAP(CSerialRedirectApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()





/////////////////////////////////////////////////////////////////////////////
// The one and only CSerialRedirectApp object

CSerialRedirectApp theApp;


DWORD	GetElapsedTicks( DWORD timeMark )
{
	DWORD	tm = GetTickCount();
	return (tm>timeMark)?(tm-timeMark):(timeMark-tm);
}




static int	GetKeyIndex( CString cstrKey, int curIndex, int offset )
{
	return ((curIndex+offset) % (int)cstrKey.GetLength());
}



void dataEncrypt( char *buff, int len, CString cstrKey, int & curIndex )
{
	if( cstrKey.IsEmpty() ) return;

	int	i;

	for(i= 0; i< len; i++) 
	{
		buff[i] ^= cstrKey[ curIndex ];
		buff[i] ^= cstrKey[ curIndex = GetKeyIndex( cstrKey, curIndex, 1) ];
	}
	return;
}


void dataDecrypt( char *buff, int len, CString cstrKey, int & curIndex )
{
	if( cstrKey.IsEmpty() ) return;

	int	i, newNdx;

	for(i= 0; i< len; i++)
	{
		buff[i] ^= cstrKey[ newNdx = GetKeyIndex( cstrKey, curIndex, 1) ];
		buff[i] ^= cstrKey[ curIndex ];

		curIndex = newNdx;
	}
	return;
}




/////////////////////////////////////////////////////////////////////////////
// CSerialRedirectApp construction

CSerialRedirectApp::CSerialRedirectApp()
{
	m_mainFrame = NULL;
	m_SuperThread = NULL;
	m_boolSuperThreadTerminate = m_boolSuperThreadExited = FALSE;
	m_boolSuperSocketReady = FALSE;

	nBytesRead	= nBytesWritten = 0;

}


/////////////////////////////////////////////////////////////////////////////
// CSerialRedirectApp initialization


static UINT startSuperThread( LPVOID pParam )
{
	CSerialRedirectApp *me = (CSerialRedirectApp *)pParam;
	me->entrySuperThread();
	return 0;
}







BOOL CSerialRedirectApp::InitInstance()
{
	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	if( !appInitialize() )
	{
		return FALSE;
	}


	m_wndClassInvisibleParent = AfxRegisterWndClass( CS_OWNDC );
	m_wndInvisibleParent.CreateEx(0,(LPCTSTR)m_wndClassInvisibleParent,"",WS_DLGFRAME,CRect(0,0,10,10),NULL,0,NULL);

	CreateTaskbarIcons();

	// Standard initialization

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	SetRegistryKey(IDS_KEY_COMPANY);

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register document templates

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CSerialRedirectDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CMain));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;


	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CEdit	m_editReadme;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};




CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}





BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CString		cstrTemp;
	HMODULE		hmodMe;
	HRSRC		resReadmeText;
	LPBYTE		mbufReadmeText, p1;
	int			nBytes;

	hmodMe = GetModuleHandle(NULL);

	resReadmeText = FindResource(hmodMe,MAKEINTRESOURCE(IDR_READMETEXT), RT_RCDATA);

#ifdef _DEBUG
	if( !resReadmeText )
	{
		DWORD ecode = GetLastError();
		CString	cstrGetError((TCHAR)0,256);
		FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM+20, NULL, ecode, 0, (char *)(LPCTSTR)cstrGetError, cstrGetError.GetLength(), NULL ); 

		cstrTemp.Format("Readme didn't load;   result: %i    txt: %s", ecode, (LPCTSTR)cstrGetError );

		m_editReadme.SetWindowText(cstrTemp);
	}
	else
	{
#endif

	mbufReadmeText = (LPBYTE)LoadResource( hmodMe, resReadmeText );

	ASSERT( mbufReadmeText );

	p1 = (LPBYTE)strstr( (const char *)mbufReadmeText,"**");

	ASSERT( p1 );

	nBytes = (p1-mbufReadmeText);

	cstrTemp = CString( (LPCTSTR)mbufReadmeText, nBytes );

	m_editReadme.SetWindowText(cstrTemp);

#ifdef _DEBUG
	}
#endif
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_BOILERPLATE, m_editReadme);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog

void CSerialRedirectApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CSerialRedirectApp commands



static char *	rtrim(char * buff)
{
	char *p1;

	while( strlen(buff) )
	{
		p1= &buff[ strlen(buff)-1 ];

		if( *p1 > 32 ) break;

		*p1= 0;
	}

	return buff;
}


static char *	ltrim(char * buff)
{
	if( strlen(buff) ) 
		while( (*buff && *buff <= 32) ) 
			memmove(buff,buff+1,strlen(buff)+1);

	return buff;
}


static char *	alltrim(char *	buff)
{
	return ltrim(rtrim(buff));
}




static void enumCommaDelimited( char **buf, char *itembuff )
{
	char *p1 = strchr( *buf, ',');

	if( !p1 )
	{
		strcpy( itembuff, *buf);
		alltrim(itembuff);
		*buf = &(*buf)[ strlen(*buf) ];
		return;
	}

	int nBytes = (p1 - *buf );

	itembuff[nBytes]= 0;
	memcpy( itembuff, *buf, nBytes );
	alltrim(itembuff);

	*buf = ++p1;
	return;
}



static BOOL	parse(char *tok, char *parm, char **rest )
{
	char	*cpstart, *cp;

	if( (cp= strchr(*rest,'='))!= NULL )
	{
		*cp=0;	cp++;

		strcpy(tok,*rest);

		if( *cp== 34 )
		{
			++cp;

			cpstart = cp;
			while( *cp && *cp != 34 ) ++cp;

			if( *cp== 34 ){ *cp= 0; ++cp; }

			strcpy(parm,cpstart);
		}
		else
		{
			cpstart = cp;
			
			if( (cp= strchr(cp,' ')) != NULL )
			{
				*cp= 0;
				cp++;
			}
			else cp = cpstart+strlen(cpstart);

			strcpy(parm,cpstart);
		}

		*rest= cp;

		while( (cp= strchr(parm,34))!= NULL ) *cp= 32;

		alltrim(parm);
		strupr(alltrim(tok));

		alltrim(*rest);
	}
	else return FALSE;

	return TRUE;
}









int CSerialRedirectApp::ExitInstance() 
{
	m_wndInvisibleParent.DestroyWindow();

	if( m_iconTaskbarIdle ) DestroyIcon( m_iconTaskbarIdle );
	if( m_iconTaskbarAct0 ) DestroyIcon( m_iconTaskbarAct0 );
	if( m_iconTaskbarAct1 ) DestroyIcon( m_iconTaskbarAct1 );
	if( m_iconTaskbarAct2 ) DestroyIcon( m_iconTaskbarAct2 );
	if( m_iconTaskbarAct3 ) DestroyIcon( m_iconTaskbarAct3 );

	ASSERT( !m_SuperThread );
	ASSERT( !m_boolSuperSocketReady );
	ASSERT( m_listPortServers.IsEmpty() );
	ASSERT( m_listFreeDataBlocks.IsEmpty() );

	return CWinApp::ExitInstance();
}





void CSerialRedirectApp::CreateTaskbarIcons()
{
	ICONINFO	ici;

	m_cstrTaskbarTip.LoadString( IDS_ICONTIP );
	m_curTaskbarIcon = -1;

	m_busyCounter	= 0;

	ici.fIcon = TRUE;
	ici.xHotspot = 0;
	ici.yHotspot = 0;
	
	m_bmpMask.LoadBitmap( IDB_TBMASKBITS );

	ici.hbmMask = (HBITMAP)m_bmpMask;
	m_bmpTaskbarIdle.LoadBitmap( IDB_TBCOLORBITS_0 );
	ici.hbmColor = (HBITMAP)m_bmpTaskbarIdle;
	m_iconTaskbarIdle = CreateIconIndirect( &ici );

	ici.hbmMask = (HBITMAP)m_bmpMask;
	m_bmpTaskbarAct0.LoadBitmap( IDB_TBCOLORBITS_1 );
	ici.hbmColor = (HBITMAP)m_bmpTaskbarAct0;
	m_iconTaskbarAct0 = CreateIconIndirect( &ici );

	ici.hbmMask = (HBITMAP)m_bmpMask;
	m_bmpTaskbarAct1.LoadBitmap( IDB_TBCOLORBITS_2 );
	ici.hbmColor = (HBITMAP)m_bmpTaskbarAct1;
	m_iconTaskbarAct1 = CreateIconIndirect( &ici );

	ici.hbmMask = (HBITMAP)m_bmpMask;
	m_bmpTaskbarAct2.LoadBitmap( IDB_TBCOLORBITS_3 );
	ici.hbmColor = (HBITMAP)m_bmpTaskbarAct2;
	m_iconTaskbarAct2 = CreateIconIndirect( &ici );

	ici.hbmMask = (HBITMAP)m_bmpMask;
	m_bmpTaskbarAct3.LoadBitmap( IDB_TBCOLORBITS_4 );
	ici.hbmColor = (HBITMAP)m_bmpTaskbarAct3;
	m_iconTaskbarAct3 = CreateIconIndirect( &ici );

	ASSERT( m_iconTaskbarIdle );
}






void CSerialRedirectApp::SetTaskbarIcon( int nIcon )
{
	NOTIFYICONDATA	tbIcon;

	switch(nIcon)
	{
	case 1:
		tbIcon.hIcon = theApp.m_iconTaskbarAct0;
		break;

	case 2:
		tbIcon.hIcon = theApp.m_iconTaskbarAct1;
		break;

	case 3:
		tbIcon.hIcon = theApp.m_iconTaskbarAct2;
		break;

	case 4:
		tbIcon.hIcon = theApp.m_iconTaskbarAct3;
		break;

	default:
		nIcon = 0;
		tbIcon.hIcon = theApp.m_iconTaskbarIdle;
		break;
	}
	if( m_curTaskbarIcon == nIcon ) return;

	ASSERT( m_mainFrame );

	tbIcon.cbSize	= sizeof(NOTIFYICONDATA);
	tbIcon.hWnd		= ((CWnd *)m_mainFrame)->m_hWnd;
	tbIcon.uID		= 0;
	tbIcon.uFlags	= NIF_ICON | NIF_MESSAGE | NIF_TIP;

	tbIcon.uCallbackMessage = WM_TASKBARACTION;

	strcpy( (char *)tbIcon.szTip , (LPCTSTR)m_cstrTaskbarTip );

	if( m_curTaskbarIcon==-1 )
		Shell_NotifyIcon(NIM_ADD, &tbIcon); 
	else
		Shell_NotifyIcon(NIM_MODIFY, &tbIcon); 

	m_curTaskbarIcon = nIcon;
}






void	CSerialRedirectApp::AnimateTaskbarIcon( BOOL isBusy )
{
	if( isBusy || m_busyCounter )
	{
		if( !isBusy ) 
		{
			if( m_busyCounter ) --m_busyCounter;
		}
		else
		{
			if( m_busyCounter < 10 ) ++m_busyCounter;
		}

		int	cti = m_curTaskbarIcon+1;

		if( cti > 4 ) cti= 1;

		SetTaskbarIcon( cti );
	}
	else SetTaskbarIcon(0); 

	return;
}








#define	MAX_SETUPFILE_LINELEN	256



BOOL CSerialRedirectApp::appInitialize()
{
	HINSTANCE	hInst = AfxGetInstanceHandle();
	CString		cstrPath,cstrNetAddr;
	
	char	chPathName[ _MAX_PATH ];
	char	chDrive[ _MAX_DRIVE ];
	char	chPath[ _MAX_PATH ];

	GetModuleFileName( hInst, (LPTSTR)chPathName, _MAX_PATH );

	_splitpath( chPathName, chDrive, chPath, NULL, NULL );

	cstrPath.Format("%s%s", chDrive, chPath );

	m_cstrUserFile.LoadString( IDS_FMT_USERFILE );
	m_cstrUserFile = cstrPath + m_cstrUserFile;
	m_cstrUserFile.MakeUpper();

	m_cstrCfgFile.LoadString( IDS_FMT_CFGFILE );
	m_cstrCfgFile = cstrPath + m_cstrCfgFile;
	m_cstrCfgFile.MakeUpper();



	CStringList	listUsers;

	if( !fileLoadUserFile( &listUsers ) )
	{
		AfxMessageBox( IDS_MSG_NOUSERFILE, MB_OK );
		return FALSE;
	}
	if( listUsers.GetCount() == 0 )
	{
		AfxMessageBox( IDS_MSG_NOUSERS, MB_OK );
		return FALSE;
	}





	FILE		*inf;
	int			netPort= -1;
	char		*p1,buff[ MAX_SETUPFILE_LINELEN ];

	if( !(inf = fopen((char *)(LPCTSTR)m_cstrCfgFile, "rt")) )
	{
		AfxMessageBox( IDS_MSG_NOCFGFILE, MB_OK );
		return FALSE;
	}
	while( !feof(inf) )
	{
		if( fgets( buff, MAX_SETUPFILE_LINELEN-1, inf) )
		{
			if( (p1= strchr(buff,';')) ) *p1= 0;
			alltrim(buff);

			if( strlen(buff) )
			{
				if( (p1 = strchr(buff,32)) )
				{
					*p1= 0;

					strupr(buff);
					alltrim(buff);

					char	*line = p1+1;

					alltrim(line);

					if( strcmp(buff,"NETPORT")==0 && netPort==-1 )
					{
						netPort = atoi( line );
					}
					else if( strcmp(buff,"NETADDR")==0 && cstrNetAddr.IsEmpty() )
					{
						cstrNetAddr = CString(line);
					}
					else if( strcmp(buff,"SERVICE")==0 )
						processPortDef(line);
				}
			}
		}
	}
	fclose(inf);

	if( netPort==-1 )
	{
		AfxMessageBox( IDS_MSG_NONETPORT, MB_OK );
		return FALSE;
	}

	if( m_listPortServers.GetCount() == 0 )
	{
		AfxMessageBox( IDS_MSG_NOSERVICES, MB_OK );
		return FALSE;
	}





	if( cstrNetAddr.CompareNoCase("INADDR_ANY")==0 ) 
		cstrNetAddr = CString();


	if( !cstrNetAddr.IsEmpty() )
	{
		struct hostent * nif = gethostbyname( (const char *)(LPCTSTR)cstrNetAddr );

		if( nif )
		{
			char	*txtaddr = inet_ntoa( *((struct in_addr *)nif->h_addr_list[0]) );

			cstrNetAddr = CString( txtaddr );
		}

		m_cstrNetAddrDesc.Format("host %s (%s)", nif->h_name, (LPCTSTR)cstrNetAddr );
	}

	if( cstrNetAddr.IsEmpty() )
		m_cstrNetAddrDesc = "INADDR_ANY";


	BOOL	rval = FALSE;
	SOCKET	ssock;
	
	if( (ssock = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP )) != INVALID_SOCKET )
	{
		if( m_SuperSocket.Attach( ssock, 0 ) )
		{
			if( cstrNetAddr.IsEmpty() )
				rval = m_SuperSocket.Bind( netPort, NULL );
			else
				rval = m_SuperSocket.Bind( netPort, (LPCTSTR)cstrNetAddr );
		}


		if( rval )
		{
			if( (rval = m_SuperSocket.Listen(5)) )
			{
				//DWORD	sockOpt = -1;
				//rval= m_SuperSocket.IOCtl( FIONBIO, &sockOpt );
			}
		}

		if( !rval )
		{
#ifdef _DEBUG
			CString	cstrGetError((TCHAR)0,256);
			FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM+20, NULL, m_SuperSocket.GetLastError(), 0, (char *)(LPCTSTR)cstrGetError, cstrGetError.GetLength(), NULL ); 
			_asm int 3;
#endif
			AfxMessageBox( IDS_MSG_NETPORTOPENFAILED, MB_OK | MB_ICONERROR );
			return FALSE;
		}
	}
#ifdef _DEBUG
	else
	{
		_asm int 3;
	}
#endif

	m_boolSuperSocketReady = TRUE;






	CString			cps1Name, cps2Name;
	CPortServer		*cps1, *cps2;
	POSITION		pos1,pos2;
	BOOL			isSorting;

	do
	{
		isSorting = FALSE;

		pos1 = m_listPortServers.GetHeadPosition();

		while(pos1)
		{
			pos2 = pos1;
			cps1 = (CPortServer *)m_listPortServers.GetNext(pos2);
			if( !pos2 ) break;
			cps2 = (CPortServer *)m_listPortServers.GetAt(pos2);

			cps1Name = cps1->svrGetServiceName();
			cps2Name = cps2->svrGetServiceName();

			if( cps1Name.CompareNoCase((LPCTSTR)cps2Name) > 0 )
			{
				m_listPortServers.SetAt(pos1, cps2);
				m_listPortServers.SetAt(pos2, cps1);
				isSorting = TRUE;
			}
			pos1 = pos2;
		}
	}
	while( isSorting );



	m_SuperThread = AfxBeginThread( (AFX_THREADPROC)startSuperThread, (LPVOID)this, 0, 0, 0, NULL );
	m_SuperThread->m_bAutoDelete = TRUE;

	return TRUE;
}










BOOL CSerialRedirectApp::fileLoadUserFile( CStringList *listUsers )
{
	CString		cstrUser;
	char		*cp,*p1,buff[ MAX_SETUPFILE_LINELEN ];
	char		*uname, *upass, *uservices;
	FILE		*inf;

	listUsers->RemoveAll();

	if( !(inf = fopen((char *)(LPCTSTR)m_cstrUserFile, "rt")) )
	{
		return FALSE;
	}
	while( !feof(inf) )
	{
		if( fgets( buff, MAX_SETUPFILE_LINELEN-1, inf) )
		{
			if( (p1= strchr(buff,';')) ) *p1= 0;
			alltrim(buff);

			if( strlen(buff) )
			{
				while( (cp= strchr( buff,9))!= NULL ) *cp= 32;

				uname = upass = uservices= NULL;

				p1 = buff;

				uname= p1;
				alltrim(p1);
				if( (p1 = strchr(buff,32)) )
				{
					*p1= 0;

					upass = ++p1;
					alltrim(p1);
					if( (p1 = strchr(p1,32)) )
					{
						*p1= 0;

						uservices= ++p1;
						alltrim(p1);
					}
				}

				if( uname && upass && uservices )
				{
					alltrim(uname);
					strupr(uname);

					alltrim(upass);
					strupr(upass);

					alltrim(uservices);
					strupr(uservices);

					cstrUser.Format("%s/%s\t%s", uname, upass, uservices );

					listUsers->AddTail( cstrUser );
				}
			}
		}
	}
	fclose(inf);
	return TRUE;
}












void CSerialRedirectApp::processPortDef( char *line )
{
	CString		cstrService,cstrPort,cstrPortDesc,cstrKey;
	POSITION	pos;
	CPortServer	*cps;
	BOOL		boolFormattingErrorOfDeath = FALSE;

	char	tok[MAX_SETUPFILE_LINELEN],parm[MAX_SETUPFILE_LINELEN];
	char	*p1,*cp, *rest;

	int		cbaud=0, cparity=0, cbits=0, cstops=0, coptions=0;

	alltrim(line);

	if( strlen(line) )
	{
		while( (cp= strchr( (rest = line),9))!= NULL ) *cp= 32;
		
		while( parse(tok,parm,&rest) )
		{
			if( strcmp(tok,"NAME")==0 )
			{
				cstrService = CString(parm);
				cstrService.TrimLeft();
				cstrService.TrimRight();
				cstrService.MakeUpper();
			}

			else if( strcmp(tok,"PORT")==0 )
			{
				if( (p1= strchr(parm,':')) ) *p1= 0;
				alltrim(parm);
				cstrPort = CString(parm);
				cstrPort.MakeUpper();
			}

			else if( strcmp(tok,"SETTINGS")==0 )
			{
				DCB		dcb;
				CString	ctmp;

				if( cstrService.GetLength()==0 || cstrPort.GetLength()==0 )
				{
					AfxMessageBox( IDS_MSG_PORTNOTSET, MB_OK | MB_ICONSTOP );
					return;
				}

				dcb.DCBlength = sizeof(DCB);

				ctmp.Format("%s: %s", (LPCTSTR)cstrPort, parm);

				cstrPortDesc = ctmp;
				cstrPortDesc.MakeUpper();

				if( BuildCommDCB( (LPCTSTR)ctmp, &dcb ) )
				{
					cbaud	= dcb.BaudRate;
					cparity = dcb.Parity;
					cbits	= dcb.ByteSize;
					cstops	= dcb.StopBits;
				}
				else
				{	
					boolFormattingErrorOfDeath = TRUE;
#ifdef _DEBUG
					DWORD ecode = GetLastError();
					CString	cstrGetError((TCHAR)0,256);
					FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM+20, NULL, ecode, 0, (char *)(LPCTSTR)cstrGetError, cstrGetError.GetLength(), NULL ); 
#endif
				}
			}
			else if( strcmp(tok,"CTSFLOW")==0 )
			{
				strupr(parm);
				if( strcmp(parm,"ON")==0 )
					coptions |= COPT_CTSFLOW;
			}
			else if( strcmp(tok,"DSRFLOW")==0 )
			{
				strupr(parm);
				if( strcmp(parm,"ON")==0 )
					coptions |= COPT_DSRFLOW;
			}
			else if( strcmp(tok,"DTR")==0 )
			{
				strupr(parm);
				if( strcmp(parm,"ON")==0 )
					coptions |= COPT_ASSERTDTR;
			}
			else if( strcmp(tok,"RTS")==0 )
			{
				strupr(parm);
				if( strcmp(parm,"FLOW")==0 )
					coptions |= COPT_RTSFLOW;

				else if( strcmp(parm,"ON")==0 )
					coptions |= COPT_RTSON;
			}
			else if( strcmp(tok,"OPEN")==0 )
			{
				strupr(parm);
				if( strcmp(parm,"CONNECT")==0 )
					coptions |= COPT_OPENONCONNECT;
			}
			else if( strcmp(tok,"KEY")==0 )
			{
				if( cstrKey.IsEmpty() && strlen(tok) )
				{
					cstrKey = CString(parm);

					if( !cstrKey.IsEmpty() && cstrKey.GetLength() < 8 )
					{
						AfxMessageBox( IDS_MSG_KEYLEN, MB_ICONSTOP );
						boolFormattingErrorOfDeath = TRUE;
					}
				}
			}
			else boolFormattingErrorOfDeath = TRUE;


			if( boolFormattingErrorOfDeath )
			{
				boolFormattingErrorOfDeath = FALSE;
				CString	cstrErr;
				cstrErr.Format(IDS_MSG_INVALIDOPT, tok );
				AfxMessageBox(cstrErr,MB_OK);
			}
		}
	}

	if( cstrService.GetLength()==0 || cstrPort.GetLength()==0 )
	{
		AfxMessageBox( IDS_MSG_PORTNOTSET, MB_OK | MB_ICONSTOP );
		return;
	}

	pos = m_listPortServers.GetHeadPosition();
	while(pos)
	{
		cps = (CPortServer *)m_listPortServers.GetNext(pos);

		if( cstrService.Compare( (LPCTSTR)cps->svrGetServiceName()) ==0 
			||
			cstrPort.Compare( (LPCTSTR)cps->svrCommGetPort()) ==0 )
		{
			CString	cstrErr;

			cstrErr.Format(IDS_MSG_SERVICEDEF, tok );
			AfxMessageBox(cstrErr,MB_OK);
			return;
		}
	}

	cps = new CPortServer( cstrService, cstrPortDesc, cstrPort, cbaud, cparity, cbits, cstops, coptions, cstrKey );

	m_listPortServers.AddTail( cps );
}
















BOOL CSerialRedirectApp::appShutdown()
{
	CPortServer	*cps;

	if( m_SuperThread )
	{
		m_boolSuperThreadTerminate = TRUE;
		while( !m_boolSuperThreadExited ) Sleep(10);
		m_SuperThread = NULL;
	}

	if( m_boolSuperSocketReady )
	{
		DWORD sockOpt = 0;
		m_SuperSocket.IOCtl( FIONBIO, &sockOpt );
		m_SuperSocket.Close();

		m_boolSuperSocketReady = FALSE;
	}


	while( !m_listPortServers.IsEmpty() )
	{
		cps = (CPortServer *)m_listPortServers.RemoveHead();
		cps->svrTerminate();
		cps->svrClosePorts();
		delete cps;
	}

	while( !m_listFreeDataBlocks.IsEmpty() ) delete m_listFreeDataBlocks.RemoveHead();

	return TRUE;
}





















CDataBlock *	CSerialRedirectApp::dblkAlloc(void)
{
	CSingleLock		dbLock( &m_criticalDataBlocks );

	dbLock.Lock();

	CDataBlock		*dblock;

	if( m_listFreeDataBlocks.IsEmpty() )
		dblock = new CDataBlock;
	else
		dblock = (CDataBlock *)m_listFreeDataBlocks.RemoveHead();

	dblock->blkSent = dblock->blkLen = 0;

	return dblock;
}




void	 CSerialRedirectApp::dblkRelease( CDataBlock *blk )
{
	CSingleLock		dbLock( &m_criticalDataBlocks );

	dbLock.Lock();

	if( m_listFreeDataBlocks.GetCount() > DATABLOCK_MAXUNUSED )
		delete blk;
	else
	{
		blk->timeMark = GetTickCount();
		m_listFreeDataBlocks.AddHead( blk );
	}
}



void	CSerialRedirectApp::dblkPruneOldBlocks(void)
{
	CSingleLock		dbLock( &m_criticalDataBlocks );

	dbLock.Lock();

	CDataBlock	*blk;

	while( m_listFreeDataBlocks.GetCount() > DATABLOCK_MINRESERVED )
	{
		blk = (CDataBlock *)m_listFreeDataBlocks.GetTail();

		if( blk->blkAge() > 1000*120 )
			delete m_listFreeDataBlocks.RemoveTail();
	}
	return;
}










#define		RCVBUFF_LEN		1000




void CSerialRedirectApp::entrySuperThread(void)
{
	char			rcvBuff[RCVBUFF_LEN];
	char			*p1;

	int				c,i,nByteIndex,iRetVal;
	int				nRcvDataStart, nRcvDataEnd;

	DWORD			sockOpt;

	struct fd_set	fdsListen;
	struct timeval	timSelect;

	LPPARMSTRUCT	pm = (LPPARMSTRUCT) new PARMSTRUCT;


	pm->newSocket = NULL;

	while( !m_boolSuperThreadTerminate )
	{

		FD_ZERO( &fdsListen );
		fdsListen.fd_count		= 1;
		fdsListen.fd_array[0]	= m_SuperSocket.m_hSocket;

		timSelect.tv_sec = 0;
		timSelect.tv_usec = 10000;

		if( select(0, &fdsListen, NULL, NULL, &timSelect ) == 1 )
		{
			pm->newSocket = new CAsyncSocket;

			if( m_SuperSocket.Accept( *pm->newSocket, NULL, NULL ) )
			{
				sockOpt = -1;
				(pm->newSocket)->IOCtl( FIONBIO, &sockOpt );		// make non-blocking

				nByteIndex	= 0;

				pm->boolUserAuthorized	= FALSE;

				pm->cstrUser	= CString();
				pm->cstrPass	= CString();
				pm->cstrService = CString();
				pm->cstrResp	= CString();
				pm->cstrKey		= CString();

				pm->nKeyIndexRcv = pm->nKeyIndexXmt = 0;

				pm->parseIndex	= rcvBuff;
				memset( rcvBuff,0,RCVBUFF_LEN );

				pm->tmark = GetTickCount();

				for(;;)
				{
					if( GetElapsedTicks(pm->tmark) > 10000 )
					{
						pm->cstrResp.LoadString( IDS_NETRESP_NOAUTH );
						break;
					}


					iRetVal = (pm->newSocket)->Receive( (LPVOID)&rcvBuff[nByteIndex], RCVBUFF_LEN - nByteIndex );

					if( iRetVal != SOCKET_ERROR && iRetVal>0 )
					{
						dataDecrypt( &rcvBuff[nByteIndex], iRetVal, pm->cstrKey, pm->nKeyIndexRcv );

						nRcvDataStart = nByteIndex;

						nByteIndex += iRetVal;

						nRcvDataEnd = nByteIndex;

						if( RCVBUFF_LEN-nByteIndex == 0 ) 
						{
							pm->cstrResp.LoadString( IDS_NETRESP_OVERFLOW );
							break;	// filled up input buffer
						}

						rcvBuff[nRcvDataEnd]= 0;		// make sure we're terminated

					}
					else if( iRetVal==0 )				// socket closed
					{
						pm->cstrResp = "";
						break;
					}

					else if( iRetVal == SOCKET_ERROR )	// check error code
					{
						int ecode = GetLastError();
						if( !(ecode==WSAEWOULDBLOCK || ecode==WSAEINPROGRESS) ) 
						{
							pm->cstrResp.LoadString( IDS_NETRESP_NOAUTH );
							break;						// some other error
						}
						continue;
					}



					//
					// check for garbage
					//
					if( (nRcvDataStart != nRcvDataEnd) )
					{
						for(i=nRcvDataStart; i< nRcvDataEnd; i++)
						{
							c= rcvBuff[i];
							if( !__iscsym(c) )
							{
								if( c != 9 && c!= 32 && c != 13 && c != 10 ) 
								{
									c= -1;
									break;
								}
							}
 						}
						if( c==-1 )
						{
							pm->cstrResp.LoadString( IDS_NETRESP_NOAUTH );
							break;
						}
					}


					while( (p1= strchr((const char *)pm->parseIndex,13)) )
					{
						//
						// process all cr delimited lines we just received
						//
						*p1 = 0;

						if( ProcessUserLoginLine( pm ) ) goto finishLogin;

						pm->parseIndex = p1+1;

						while( (c= *pm->parseIndex),(c==10 || c==13) ) pm->parseIndex++;
					}
				}

finishLogin:


				if( !pm->boolUserAuthorized )
				{
					sockOpt = 0;
					(pm->newSocket)->IOCtl( FIONBIO, &sockOpt );		// make blocking

					if( !pm->cstrResp.IsEmpty() )
					{
						struct linger ling;
						ling.l_onoff = 1;
						ling.l_linger = 5;

						(pm->newSocket)->SetSockOpt( SO_LINGER, &ling, sizeof(ling) );


						dataEncrypt( (char *)(LPCTSTR)pm->cstrResp, pm->cstrResp.GetLength(), pm->cstrKey, pm->nKeyIndexXmt );
						(pm->newSocket)->Send((LPCTSTR)pm->cstrResp, pm->cstrResp.GetLength() );
					}

					(pm->newSocket)->ShutDown(2);
					(pm->newSocket)->Close();
					delete pm->newSocket;
				}
				else
				{
					ASSERT( pm->portServer );

					sockOpt = -1;
					(pm->newSocket)->IOCtl( FIONBIO, &sockOpt );		// make non-blocking

					dataEncrypt( (char *)(LPCTSTR)pm->cstrResp, pm->cstrResp.GetLength(), pm->cstrKey, pm->nKeyIndexXmt );
					(pm->newSocket)->Send((LPCTSTR)pm->cstrResp, pm->cstrResp.GetLength() );

					(pm->portServer)->svrSetEffectiveKey( pm->cstrKey );
					(pm->portServer)->svrConnectIncomingNetPort(pm->cstrUser, pm->newSocket, pm->nKeyIndexRcv, pm->nKeyIndexXmt);
				}
			}
			else delete pm->newSocket;

			pm->newSocket = NULL;
		}
	}

	if( pm->newSocket )	delete pm->newSocket;

	delete pm;

	m_boolSuperThreadExited = TRUE;
	return;
}







BOOL	CSerialRedirectApp::ProcessUserLoginLine( LPPARMSTRUCT	pm )
{
	POSITION		pos;
	char			*p1,*tok,*parm;
	CString			cstrDeltaText, cstrNewKey;
	BOOL			boolExitVal = FALSE;


	alltrim( pm->parseIndex );

	if( strlen( pm->parseIndex ) )
	{
		while( (p1= strchr((const char *)pm->parseIndex, 9))!= NULL ) *p1= 32;
		
		while( (p1= strstr((const char *)pm->parseIndex,"  "))!= NULL ) memmove( p1, p1+1, strlen((const char *)p1)+1 );

		if( (p1= strchr((const char *)pm->parseIndex,32)) )
		{
			tok = pm->parseIndex;
			*p1 = 0;
			parm= p1+1;

			strupr( tok );
			alltrim( tok );
			alltrim( parm );

			if( strcmp(tok,"USER")==0 && pm->cstrUser.IsEmpty() && !pm->cstrService.IsEmpty() )
			{
				pm->cstrUser = CString(parm);
				pm->tmark = GetTickCount();
			}

			else if( strcmp(tok,"PASS")==0 && pm->cstrPass.IsEmpty() && !pm->cstrService.IsEmpty() )
			{
				pm->cstrPass = CString(parm);
				pm->tmark = GetTickCount();
			}

			else if( strcmp(tok,"SERVICE")==0 && pm->cstrService.IsEmpty() )
			{
				BOOL	serviceOK = FALSE;

				pm->cstrService= CString(parm);
				pm->cstrService.MakeUpper();

				pos = m_listPortServers.GetHeadPosition();
				while(pos)
				{
					pm->portServer = (CPortServer *)m_listPortServers.GetNext(pos);

					if( pm->cstrService.CompareNoCase( (pm->portServer)->svrGetServiceName() )==0 )
					{
						pm->cstrResp.LoadString(IDS_NETRESP_SERVICE);
						(pm->newSocket)->Send((LPCTSTR)pm->cstrResp, pm->cstrResp.GetLength() );

						pm->cstrKey = (pm->portServer)->svrGetMasterKey();

						if( !pm->cstrKey.IsEmpty() )
						{
							(pm->portServer)->svrSetEffectiveKey( pm->cstrKey );

							(pm->portServer)->svrCreateDeltaKey( &cstrDeltaText, &cstrNewKey );

							pm->cstrResp.Format("KeyDelta %s\r", (LPCTSTR)cstrDeltaText );
							dataEncrypt( (char  *)(LPCTSTR)pm->cstrResp, pm->cstrResp.GetLength(), pm->cstrKey, pm->nKeyIndexXmt );
							(pm->newSocket)->Send((LPCTSTR)pm->cstrResp, pm->cstrResp.GetLength() );

							pm->cstrKey = cstrNewKey;
						}

						serviceOK = TRUE;
						break;
					}
				}
				if( !serviceOK ) 
				{
					pm->cstrResp.LoadString( IDS_NETRESP_NOAUTH );
					boolExitVal = TRUE;
				}
				pm->tmark = GetTickCount();
			}

			else
			{
				pm->cstrResp.LoadString( IDS_NETRESP_CORRUPT );
				boolExitVal = TRUE;
			}
		}
		else 
		{
			pm->cstrResp.LoadString( IDS_NETRESP_CORRUPT );
			boolExitVal = TRUE;
		}
	}


	if( pm->cstrUser.GetLength() * pm->cstrPass.GetLength() * pm->cstrService.GetLength() )
	{
		boolExitVal = ProcessUserTestLogin( pm );
	}

	return boolExitVal;
}










BOOL	CSerialRedirectApp::ProcessUserTestLogin( LPPARMSTRUCT	pm )
{
	POSITION		pos;
	CString			cstrTest, cstrTestUser, cstrTestAuth, cstrAuth, cstrLoginUser;
	CStringList		listUsers;
	int				i;
	BOOL			boolExitVal = FALSE;



	pm->cstrResp = CString();

	pm->cstrUser.MakeUpper();
	pm->cstrPass.MakeUpper();
	pm->cstrService.MakeUpper();

	fileLoadUserFile( &listUsers );

	cstrLoginUser = pm->cstrUser + "/" + pm->cstrPass;
	
	pos = listUsers.GetHeadPosition();
	while(pos)
	{
		cstrAuth = listUsers.GetNext(pos);

		if( (i = cstrAuth.Find((TCHAR)'\t')) > -1 )
		{
			cstrTestUser = cstrAuth.Left(i);
			cstrTestAuth = cstrAuth.Mid(i+1);

			if( cstrTestUser.Compare( (LPCTSTR)cstrLoginUser )==0 )
			{
				char *buf = (char *)(LPCTSTR)cstrTestAuth;
				char itembuff[RCVBUFF_LEN];

				while( strlen(buf) )
				{
					enumCommaDelimited( &buf, itembuff );
					strupr( itembuff );
					cstrTest = CString( itembuff );

					if( cstrTest.Compare((LPCTSTR)pm->cstrService) == 0 )
					{
						if( (pm->portServer)->svrIsConnected() )
						{
							pm->cstrResp.LoadString( IDS_NETRESP_BUSY );
						}
						else
						{
							pm->cstrResp.LoadString( IDS_NETRESP_CONNECTED );
							pm->boolUserAuthorized = TRUE;
						}
						boolExitVal = TRUE;
						break;
					}
				}
			}
		}
	}

	return boolExitVal;
}

