
#include "stdafx.h"
#include "SerialRedirect.h"

#include "NetworkPorts.h"
#include "SerialPorts.h"
#include "PortServer.h"




CNetworkPort::CNetworkPort( class CPortServer *port )
{
	m_port = port;
	m_socket = NULL;
	m_IsConnected = FALSE;

	m_curRcvBlock = m_curXmitBlock = NULL;
}



CNetworkPort::~CNetworkPort()
{
	prtCloseNetPort();
}






BOOL	CNetworkPort::prtSetNetPort( CAsyncSocket *mySocket )
{
	m_socket = mySocket;
	m_IsConnected = TRUE;
	return TRUE;
}





void	CNetworkPort::prtCloseNetPort(void)
{
	if( m_socket )
	{
		/*
		if( m_IsConnected )
		{
			DWORD	sockopt = 0;					// set blocking mode
			m_socket->IOCtl( FIONBIO, &sockopt );
			m_socket->Close();
		}
		else 
		*/

		m_socket->m_hSocket = INVALID_SOCKET;

		delete m_socket;
		m_socket = NULL;
	}

	if( m_curRcvBlock ) theApp.dblkRelease( m_curRcvBlock );
	if( m_curXmitBlock ) theApp.dblkRelease( m_curXmitBlock );

	m_curRcvBlock = m_curXmitBlock = NULL;

	m_IsConnected = FALSE;
	return;
}









void	CNetworkPort::prtServiceNetPort()
{
	int			iRetval;

	if( !m_curRcvBlock ) m_curRcvBlock = theApp.dblkAlloc();

	iRetval = m_socket->Receive( (LPVOID)&m_curRcvBlock->blkData[ m_curRcvBlock->blkLen ], m_curRcvBlock->blkLeft(), 0 );

	if( iRetval != SOCKET_ERROR && iRetval > 0 )
	{
		// if <>0 and not a SOCKET_ERROR, process the received bytes
		//
		if( m_curRcvBlock->blkLen==0 ) m_curRcvBlock->blkStartTimer();

		m_port->isTranceiving = TRUE;
		m_curRcvBlock->blkLen += iRetval;
		m_port->nBytesRead += iRetval;
		theApp.nBytesRead += iRetval;

		if( m_curRcvBlock->blkLeft() < DATABLOCK_FILLTHRESHOLD )
		{
			// current block is filled, decrypt the data and commit it
			//
			dataDecrypt( ( char *)m_curRcvBlock->blkData, m_curRcvBlock->blkLen, m_port->m_CryptKeyEffective, m_port->m_nKeyIndexNetRead );
			m_port->m_listNetReceive.AddTail( m_curRcvBlock );
			m_curRcvBlock = NULL;
		}
	}
	else if( iRetval == 0 ) 
	{
		m_IsConnected = FALSE;
		return;
	}

	else if( iRetval == SOCKET_ERROR )
	{
		int ecode = m_socket->GetLastError();

		if( ecode == WSAEWOULDBLOCK )
		{
			// receive socket is empty
			//
			if( m_curRcvBlock->blkAge() > DATABLOCK_MAXAGE )
			{
				// current block is filled, decrypt the data and commit
				//
				dataDecrypt( ( char *)m_curRcvBlock->blkData, m_curRcvBlock->blkLen, m_port->m_CryptKeyEffective, m_port->m_nKeyIndexNetRead );
				m_port->m_listNetReceive.AddTail( m_curRcvBlock );
				m_curRcvBlock = NULL;
			}
		}
		else if( ecode != WSAEINPROGRESS) 
		{
			// anything other than a wouldblock or inprogress means something
			// failed and the connection is lost
			//
			m_IsConnected = FALSE;
			return;
		}
	}





	if( !m_curXmitBlock )
	{
		if( m_port->m_listNetTransmit.GetCount() )
		{
			m_curXmitBlock = (CDataBlock *)m_port->m_listNetTransmit.RemoveHead();

			ASSERT( m_curXmitBlock->blkLen != 0 && m_curXmitBlock->blkSent == 0 );

			dataEncrypt( (char *)m_curXmitBlock->blkData, m_curXmitBlock->blkLen, m_port->m_CryptKeyEffective, m_port->m_nKeyIndexNetWrite );
		}
	}
	if( m_curXmitBlock )
	{
		iRetval = m_socket->Send( (LPVOID)&m_curXmitBlock->blkData[ m_curXmitBlock->blkSent ], (m_curXmitBlock->blkLen - m_curXmitBlock->blkSent), 0 );

		if( iRetval && iRetval != SOCKET_ERROR )
		{
			// if <>0 and not a SOCKET_ERROR, record the transmitted data
			//
			m_port->isTranceiving = TRUE;
			m_curXmitBlock->blkSent += iRetval;
			m_port->nBytesWritten += iRetval;
			theApp.nBytesWritten += iRetval;

			if( m_curXmitBlock->blkSent == m_curXmitBlock->blkLen )
			{
				theApp.dblkRelease( m_curXmitBlock );
				m_curXmitBlock = NULL;
			}
		}
		else if( iRetval == SOCKET_ERROR )
		{
			int ecode = m_socket->GetLastError();

			if( !(ecode == WSAEWOULDBLOCK || ecode == WSAEINPROGRESS) )
			{
				// anything other than a wouldblock or inprogress means we
				// lost the connection.

				m_IsConnected = FALSE;

#ifdef _DEBUG
				CString	cstrGetError((TCHAR)0,256);
				FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM+20, NULL, ecode, 0, (char *)(LPCTSTR)cstrGetError, cstrGetError.GetLength(), NULL ); 
				_asm int 3;
#endif
				return;
			}
		}
	}

	return;
}




// eof
