Attribute VB_Name = "TCPIP"
Option Explicit

Dim sockError%, sockErrorDesc$
Dim tcpEncryptCounter%, tcpDecryptCounter%, tcpKey$


Sub tcpCloseSocket()
   If frmMain!sock.State <> sckClosed Then
      frmMain!sock.Close
      Do While frmMain!sock.State <> sckClosed: DoEvents: Loop
   End If
End Sub

Function tcpConnect%(ByVal tcpUserID$, ByVal tcpPassword$, ByVal tcpAddr$, ByVal tcpPort$, ByVal myKey$, ByVal desiredSvc$, ByVal doStatus%, etext$)
   Dim i%, dvar As Variant
   Dim j%, k%, complete1%, complete2%, effectiveKey$, deltaKey$, a$
   
   Call tcpCloseSocket
   
   tcpKey = myKey
   
   If Len(tcpAddr) * Len(tcpPort) = 0 Then etext = "No Valid TCP/IP Address": GoTo tcpfail
   If Len(tcpUserID) * Len(tcpPassword) = 0 Then etext = "Invalid UserID/Password combination.": GoTo tcpfail
      
   If doStatus Then Call statusAdd("Connecting to " + tcpAddr + ":" + tcpPort)
   
   frmMain!sock.RemoteHost = tcpAddr: frmMain!sock.RemotePort = tcpPort: frmMain!sock.LocalPort = 0
   sockError = False: frmMain!sock.Connect
   Do While frmMain!sock.State <> sckConnected
      If sockError Then frmMain!sock.Close: etext = sockErrorDesc: GoTo tcpfail
      DoEvents
   Loop
   
   tcpEncryptCounter = 0: tcpDecryptCounter = 0
   
   
   
   '
   ' First request a service
   '
   DoEvents: On Error Resume Next
   Call tcpSendData("service " + desiredSvc + Chr$(13))
   On Error GoTo 0
   
   dvar = "": a$ = "": i = 70
   Do While i > 0
      If frmMain!sock.State <> sckConnected Then frmMain!sock.Close: etext = "Host dropped the connection.": GoTo tcpfail
      
      If frmMain!sock.BytesReceived > 0 Then
         a$ = a$ + tcpGetData(): If InStr(a$, Chr$(13)) > 0 Then Exit Do
      End If
      Call waitEvents(100): i = i - 1
   Loop
   i = InStr(a$, Chr$(13)): If i = 0 Then frmMain!sock.Close: etext = "Login Timed Out.": GoTo tcpfail
   a$ = Left(a$, i - 1)
   If UCase(Left(a$, 4)) = "FAIL" Then frmMain!sock.Close: etext = a$: GoTo tcpfail
   If UCase(Left(a$, 7)) <> "SUCCESS" Then frmMain!sock.Close: etext = "Unexpected Response: " + a$: GoTo tcpfail
   
   If doStatus Then Call statusAdd(a$)
   
   
   '
   ' If we have a key, wait for the keydelta
   '
   If Len(tcpKey) > 0 Then
      dvar = "": a$ = "": i = 70
      Do While i > 0
         If frmMain!sock.State <> sckConnected Then frmMain!sock.Close: etext = "Timeout waiting for KeyDelta.": GoTo tcpfail
         
         If frmMain!sock.BytesReceived > 0 Then
            a$ = a$ + tcpDecrypt(tcpGetData()): If InStr(a$, Chr$(13)) > 0 Or tcpTestGarbage(a$) Then Exit Do
         End If
         Call waitEvents(100): i = i - 1
      Loop
      i = InStr(a$, Chr$(13)): If i > 0 Then a$ = Left(a$, i - 1)
      If UCase(Left(a$, 8)) <> "KEYDELTA" Then frmMain!sock.Close: etext = "Unexpected Response: " + a$: GoTo tcpfail
      '
      ' convert the hex bytes into a string
      '
      a$ = Trim(Mid(a$, 9)): deltaKey = Space(Len(a$) / 2)
      For i = 1 To Len(a$) Step 2
         Mid(deltaKey, ((i - 1) / 2) + 1, 1) = Chr$(Val("&h" + Mid(a$, i, 2)))
      Next
         
      'Dim tfh%
      'tfh = FreeFile: Open "c:\temp\vbdeltakey.txt" For Output As tfh
      'For i = 1 To Len(deltaKey)
      '   Print #tfh, padr(tstr(i), 3) + "   " + Right("00" + Hex(Asc(Mid(deltaKey, i, 1))), 2)
      'Next
      'Close tfh
     
      '
      ' and merge the delta string with the original
      '
      Dim nIteration%
      
      complete1 = False: complete2 = False
      effectiveKey = Space(2 * max(Len(deltaKey), Len(tcpKey)))
      nIteration = 0
      i = 1: j = 1: k = 0
      
      Do While (Not complete1) Or (Not complete2)
         k = k + 1
         If (nIteration And 1) = 0 Then
            Mid(effectiveKey, k, 1) = Mid(deltaKey$, i, 1)
            i = i + 1: If i > Len(deltaKey$) Then i = 1: complete1 = True
         Else
            Mid(effectiveKey, k, 1) = Mid(tcpKey$, j, 1)
            j = j + 1: If j > Len(tcpKey) Then j = 1: complete2 = True
         End If
         nIteration = nIteration + 1
      Loop
      
      'Dim tfh2%
      'tfh2 = FreeFile: Open "c:\temp\vboutkey.txt" For Output As tfh
      'Print #tfh2, "master: [" + tcpKey + "]"
      'For i = 1 To k
      '   Print #tfh2, padr(tstr(i), 3) + "   " + Right("00" + Hex(Asc(Mid(effectiveKey, i, 1))), 2)
      'Next
      'Close tfh2
      
      tcpKey = Left(effectiveKey, k)
      
      If doStatus Then Call statusAdd("Encryption is enabled.")
   End If
   
   
   '
   ' SerialRedirect accepted the service, we modified the key if necessary, now log in
   '
   DoEvents: On Error Resume Next
   Call tcpSendData(tcpEncrypt("user " + tcpUserID + Chr$(13) + "pass " + tcpPassword + Chr$(13)))
   On Error GoTo 0
   
   dvar = "": a$ = "": i = 70
   Do While i > 0
      If frmMain!sock.State <> sckConnected Then frmMain!sock.Close: etext = "Host dropped the connection.": GoTo tcpfail
      
      If frmMain!sock.BytesReceived > 0 Then
         a$ = a$ + tcpDecrypt(tcpGetData())
         If InStr(a$, Chr$(13)) > 0 Or tcpTestGarbage(a$) Then Exit Do
      End If
      Call waitEvents(100): i = i - 1
   Loop
   i = InStr(a$, Chr$(13)): If i = 0 Then frmMain!sock.Close: etext = "Login Timed Out.": GoTo tcpfail
   a$ = Left(a$, i - 1)
   If UCase(Left(a$, 4)) = "FAIL" Then frmMain!sock.Close: etext = a$: GoTo tcpfail
   If UCase(Left(a$, 7)) <> "SUCCESS" Then frmMain!sock.Close: etext = "Unexpected Response: " + a$: GoTo tcpfail
   
   If doStatus Then Call statusAdd(a$)
   
   etext = a$: tcpConnect = True
   Exit Function

tcpfail:
   If doStatus Then Call statusAdd(etext$)
   tcpConnect = False
End Function

Function tcpEncrypt$(ByVal txt$)

   If Len(tcpKey) = 0 Then tcpEncrypt = txt: Exit Function

   Dim out$, i%, c%, j%
   
   On Error GoTo 0
   
   For i = 1 To Len(txt)
      c = Asc(Mid(txt, i, 1))
      
      c = c Xor Asc(Mid(tcpKey, tcpEncryptCounter + 1, 1))
        
      tcpEncryptCounter = GetKeyIndex(tcpEncryptCounter, 1)
      
      c = c Xor Asc(Mid(tcpKey, tcpEncryptCounter + 1, 1))
        
      out = out + Chr$(c)
   Next
   
   tcpEncrypt = out
End Function

Function tcpDecrypt$(ByVal txt$)

   If Len(tcpKey) = 0 Then tcpDecrypt = txt: Exit Function

   On Error GoTo 0
   
   Dim out$, i%, c%, newIndex%
 
   For i = 1 To Len(txt)
      c = Asc(Mid(txt, i, 1))
      
      newIndex = GetKeyIndex(tcpDecryptCounter, 1)
      
      c = c Xor Asc(Mid(tcpKey, newIndex + 1, 1))
      c = c Xor Asc(Mid(tcpKey, tcpDecryptCounter + 1, 1))
      
      tcpDecryptCounter = newIndex
      out = out + Chr$(c)
   Next
   tcpDecrypt = out
End Function



Sub tcpError(ByVal ecode%, ByVal edesc$)
   sockError = ecode
   sockErrorDesc = edesc
End Sub


Private Function GetKeyIndex%(ByVal curIndex%, ByVal offset%)
   GetKeyIndex = (curIndex + offset) Mod Len(tcpKey)
End Function


Function tcpGetData$()
   Dim dvar As Variant
   
   dvar = ""
   
   On Error GoTo geterr
   frmMain!sock.GetData dvar, vbString
   
   tcpGetData = CStr(dvar)
   Exit Function
   
geterr:
   Resume Next
End Function

Sub tcpSendData(ByVal dat$)
   Dim dvar As Variant
   
   On Error GoTo senderr
   dvar = dat: frmMain!sock.SendData dvar
   Exit Sub
   
senderr:
   Resume Next
End Sub


Private Function tcpTestGarbage%(ByVal dat$)
   Dim i%, c$
   
   tcpTestGarbage = False
   
   For i = 1 To Len(dat)
      c = (Mid(dat, i, 1))
      If c$ >= "0" And c <= "9" Then
      ElseIf UCase(c$) >= "A" And UCase(c$) <= "Z" Then
      ElseIf InStr(c$, "-_" + Chr$(32) + Chr$(9)) > 0 Then
      Else
         tcpTestGarbage = True
         Exit For
      End If
   Next
   
End Function


