#include <string.h>

#include <windows.h>

#include "ansiterm.h"

#define BG_BLACK    (0)
#define BG_RED      (BACKGROUND_RED)
#define BG_GREEN    (BACKGROUND_GREEN)
#define BG_YELLOW   (BACKGROUND_GREEN|BACKGROUND_RED)
#define BG_BLUE     (BACKGROUND_BLUE)
#define BG_MAGNETA  (BACKGROUND_BLUE|BACKGROUND_RED)
#define BG_CYAN     (BACKGROUND_BLUE|BACKGROUND_GREEN)
#define BG_WHITE    (BACKGROUND_BLUE|BACKGROUND_GREEN|BACKGROUND_RED)
#define BG_DEFAULT  BG_BLACK
#define BG_INTENS   BACKGROUND_INTENSITY

#define FG_BLACK    (0)
#define FG_RED      (FOREGROUND_RED)
#define FG_GREEN    (FOREGROUND_GREEN)
#define FG_YELLOW   (FOREGROUND_GREEN|FOREGROUND_RED)
#define FG_BLUE     (FOREGROUND_BLUE)
#define FG_MAGNETA  (FOREGROUND_BLUE|FOREGROUND_RED)
#define FG_CYAN     (FOREGROUND_BLUE|FOREGROUND_GREEN)
#define FG_WHITE    (FOREGROUND_BLUE|FOREGROUND_GREEN|FOREGROUND_RED)
#define FG_DEFAULT  FG_WHITE
#define FG_INTENS   FOREGROUND_INTENSITY

static int AnsiBgColor[8] =
  {			// B G R
    BG_BLACK,		// 0 0 0
    BG_RED,		// 0 0 1
    BG_GREEN,		// 0 1 0
    BG_YELLOW,		// 0 1 1
    BG_BLUE,            // 1 0 0
    BG_MAGNETA,         // 1 0 1
    BG_CYAN,            // 1 1 0
    BG_WHITE            // 1 1 1
  };

static int AnsiFgColor[8] =
  {
    FG_BLACK,
    FG_RED,
    FG_GREEN,
    FG_YELLOW,
    FG_BLUE,
    FG_MAGNETA,
    FG_CYAN,
    FG_WHITE
  };

int atopen ( ANSITERM *pat )
  {
    pat->handle = GetStdHandle ( STD_OUTPUT_HANDLE );
    atinit ( pat );
    return 0;
  }

int atcreate ( ANSITERM *pat )
  {
    pat->handle = CreateConsoleScreenBuffer (
      GENERIC_READ | GENERIC_WRITE,		// access flag
      FILE_SHARE_READ | FILE_SHARE_WRITE,	// buffer share mode
      NULL,					// pointer to security attributes
      CONSOLE_TEXTMODE_BUFFER,			// type of buffer to create
      NULL					// reserved
      );
    if ( pat->handle == INVALID_HANDLE_VALUE )
      return -1;
    SetConsoleActiveScreenBuffer ( pat->handle );
    atinit ( pat );
    return 0;
  }

int atinit ( ANSITERM *pat )
  {
    CONSOLE_SCREEN_BUFFER_INFO csbi;
    GetConsoleScreenBufferInfo ( pat->handle, &csbi );
    pat->cmax.X = csbi.dwSize.X - 1;
    pat->cmax.Y = csbi.dwSize.Y - 1;
    pat->cursor.X = csbi.dwCursorPosition.X;
    pat->cursor.Y = csbi.dwCursorPosition.Y;
    pat->scrollrect.Left = 0;
    pat->scrollrect.Top = 0;
    pat->scrollrect.Right = pat->cmax.X;
    pat->scrollrect.Bottom = pat->cmax.Y;
    return 0;
  }

int atcolorset ( ANSITERM *pat, int color )
  {
    SetConsoleTextAttribute ( pat->handle, color );
    pat->color = color;
    return 0;
  }

int atcursorset ( ANSITERM *pat, int x, int y )
  {
    pat->cursor.X = x;
    pat->cursor.Y = y;
    SetConsoleCursorPosition ( pat->handle, pat->cursor );
    return 0;
  }

int atcursormove ( ANSITERM *pat, int x, int y )
  {
    pat->cursor.X += x;
    pat->cursor.Y += y;
    SetConsoleCursorPosition ( pat->handle, pat->cursor );
    return 0;
  }

int atcursorsave ( ANSITERM *pat )
  {
    pat->csave.X = pat->cursor.X;
    pat->csave.Y = pat->cursor.Y;
    return 0;
  }

int atcursorrestore ( ANSITERM *pat )
  {
    pat->cursor.X = pat->csave.X;
    pat->cursor.Y = pat->csave.Y;
    SetConsoleCursorPosition ( pat->handle, pat->cursor );
    return 0;
  }

int atscrollsetrect ( ANSITERM * pat, int left, int top, int right, int bottom )
  {
    pat->scrollrect.Left = left;
    pat->scrollrect.Top = top;
    pat->scrollrect.Right = right;
    pat->scrollrect.Bottom = bottom;
    return 0;
  }

int atscroll ( ANSITERM * pat, int sx, int sy )
  {
    COORD coord;
    CHAR_INFO chiFill;
    coord.X = pat->scrollrect.Left + sx;
    coord.Y = pat->scrollrect.Top + sy;
    chiFill.Attributes = BG_DEFAULT | FG_DEFAULT;
    chiFill.Char.AsciiChar = ' ';
    ScrollConsoleScreenBuffer(
      pat->handle,		// screen buffer handle
      &pat->scrollrect,		// scrolling rectangle
      &pat->scrollrect,		// clipping rectangle
      coord,			// top left destination cell
      &chiFill );		// fill character and color
    return 0;
  }

int atfill ( ANSITERM * pat, int x, int y, int num, int ch, int attr )
  {
    DWORD len;
    COORD coord;
    coord.X = x;
    coord.Y = y;
    FillConsoleOutputCharacter ( pat->handle, ch, num, coord, &len );
    FillConsoleOutputAttribute ( pat->handle, attr, num, coord, &len );
    return 0;
  }

int atputc ( ANSITERM *pat, int ch )
  {
    static char seq[8] = { 0, 0, 0, 0, 0, 0, 0, 0 };
    static char arg[4] = { 0, 0, 0, 0 };
    static int n = 0;
    static int nn = 0;
    DWORD len;
    switch ( n )
      {
	case 0:
	  if ( ch < ' ' )
	    {
	      switch ( ch )
		{
		  case 7:
		    WriteConsole ( pat->handle, &ch, 1, &len, NULL );
		    break;
		  case '\n':
		    if ( pat->cursor.Y == pat->scrollrect.Bottom )
		      {
			atscroll ( pat, 0, -1 );
			pat->cursor.X = pat->scrollrect.Left;
			SetConsoleCursorPosition ( pat->handle, pat->cursor );
		      }
		      else
			{
			  pat->cursor.X = pat->scrollrect.Left;
			  pat->cursor.Y++;
			  SetConsoleCursorPosition ( pat->handle, pat->cursor );
			}
		    break;
		  case 27:
		    seq[n++] = ch;	// save "esc"
		    break;
		}
	    }
	    else
	      {
		if ( pat->cursor.X == pat->scrollrect.Right )
		  {
		    if ( pat->cursor.Y == pat->scrollrect.Bottom )
		      {
			WriteConsole ( pat->handle, &ch, 1, &len, NULL );
			atscroll ( pat, 0, -1 );
			pat->cursor.X = pat->scrollrect.Left;
			SetConsoleCursorPosition ( pat->handle, pat->cursor );
		      }
		      else
			{
			  WriteConsole ( pat->handle, &ch, 1, &len, NULL );
			  pat->cursor.X = pat->scrollrect.Left;
			  pat->cursor.Y++;
			  SetConsoleCursorPosition ( pat->handle, pat->cursor );
			}
		  }
		  else
		    {
		      WriteConsole ( pat->handle, &ch, 1, &len, NULL );
		      pat->cursor.X++;
		      SetConsoleCursorPosition ( pat->handle, pat->cursor );
		    }
	      }
	  break;
	case 1:
	  if ( ch == '[' )
	    seq[n++] = ch;	// save "["
	  break;
	default:
	  seq[n++] = ch;
	  if ( ch >= '0' && ch <= '9' )
	    {
	      arg[nn] *= 10;		// * 10
	      arg[nn] += ch - '0';	// ascii to dec
	    }
	    else
	      if ( ch == ';' )
		nn++;			// next arg.
		else
		  {
		    switch ( ch )
		      {
			case '@':		// char insert		n/a
			  break;
			case 'A':		// cursor up
			  if ( arg[0] == 0 ) arg[0] = 1;
			  atcursormove ( pat, 0, -arg[0] );
			  break;
			case 'B':		// cursor down
			  if ( arg[0] == 0 ) arg[0] = 1;
			  atcursormove ( pat, 0, arg[0] );
			  break;
			case 'C':		// cursor right
			case 'a':		// cursor right
			  if ( arg[0] == 0 ) arg[0] = 1;
			  atcursormove ( pat, arg[0], 0 );
			  break;
			case 'D':		// cursor left
			  if ( arg[0] == 0 ) arg[0] = 1;
			  atcursormove ( pat, -arg[0], 0 );
			  break;
			case 'E':		// cursor down 0,y	n/a
			  break;
			case 'F':		// cursor up 0,y	n/a
			  break;
			case 'G':		// cursor to col	n/a
			case '`':		// cursor to col	n/a
			  break;
			case 'H':		// cursor to x,y
			case 'f':		// cursor to x,y
			  if ( arg[0] == 0 || arg[1] == 0 )
			    atcursorset ( pat, 0, 0 );	// go to home
			    else
			      atcursorset ( pat, arg[1]-1, arg[0]-1 );
			  break;
			case 'J':		// screen erase
			  switch ( arg[0] )
			    {
			      case 0:	// clear EOScreen
				atfill (
				  pat,
				  pat->cursor.X, pat->cursor.Y,
				  (pat->cmax.X+1)*(pat->cmax.Y-pat->cursor.Y)+80-pat->cursor.X,
				  ' ', pat->color );
				break;
			      case 1:	// clear BOScreen
				atfill (
				  pat,
				  0, 0,
				  (pat->cmax.X+1)*(pat->cursor.Y)+pat->cursor.X+1,
				  ' ', pat->color );
				break;
			      case 2:	// clear screen
				atfill (
				  pat,
				  0, 0,
				  (pat->cmax.X+1)*(pat->cmax.Y+1),
				  ' ', pat->color );
				break;
			    }
			  break;
			case 'K':		// line erase
			  switch ( arg[0] )
			    {
			      case 0:	// clear EOLine
				atfill (
				  pat,
				  pat->cursor.X, pat->cursor.Y,
				  pat->cmax.X-pat->cursor.X+1,
				  ' ', pat->color );
				break;
			      case 1:	// clear BOLine
				atfill (
				  pat,
				  0, pat->cursor.Y,
				  pat->cursor.X+1,
				  ' ', pat->color );
				break;
			      case 2:	// clear line
				atfill (
				  pat,
				  0, pat->cursor.Y,
				  pat->cmax.X+1,
				  ' ', pat->color );
				break;
			    }
			  break;
			case 'L':		// line insert (w/scroll) n/a
			  break;
			case 'M':		// line delete (w/scroll) n/a
			  break;
			case 'P':		// char delete ???	n/a
			  break;
			case 'S':		// scroll up (not impl.) n/a
			  break;
			case 'T':		// scroll up (not impl.) n/a
			  break;
			case 'X':		// char erase (to eol)	n/a
			  break;
			case 'Z':		// tab stops go back	n/a
			  break;
			case 'b':		// char repeat ???	n/a
			  break;
			case 'c':		// terminal type answer	n/a
			  break;
			case 'd':		// cursor to line	n/a
			  break;
			case 'e':		// cursor up/down ?!	n/a
			  break;
			case 'g':		// tab stop delete ???	n/a
			  break;
			case 'h':		// mode h (set extended mode) n/a
			  break;
			case 'i':		// mode i (print screen) n/a
			  break;
			case 'l':		// mode l (unset extended mode) n/a
			  break;
			case 'm':		// color set
			  {
			    int i;
			    int color = pat->color;
			    for ( i=0; i<=nn; i++ )
			      if ( arg[i] <=8 )
				switch ( arg[i] )
				  {
				    case 0:	// normal
				      color = BG_DEFAULT | FG_DEFAULT;
				      break;
				    case 1:	// hi video
				      color |= FG_INTENS;
				      break;
				    case 2:	// lo video
				      color &= ~FG_INTENS;
				      break;
				    case 4:	// underline on		???
				      break;
				    case 5:	// blank video		???
				      break;
				    case 7:	// reverse video
				      color =
					( pat->color & 0x088 )
					| ( ( pat->color & 0x070 ) >> 4 )
					| ( ( pat->color & 0x007 ) << 4 );
				      break;
				    case 8:	// hidden		???
				      break;
				  }
				else
				  if ( arg[i] >= 30 && arg[i] <= 37 )
				    {
				      color &= 0x0f8; // clear fg color
				      color |= AnsiFgColor[arg[i]-30];
				    }
				    else
				      if ( arg[i] >= 40 && arg[i] <= 47 )
					{
					  color &= 0x08f; // clear bg color
					  color |= AnsiBgColor[arg[i]-40];
					}
			    atcolorset ( pat, color );
			  }
			  break;
			case 'n':		// mode n (report cursor) n/a
			  break;
			case 'p':		// miscellaneous ???	n/a
			  break;
			case 'r':		// scroll set region
			  if ( arg[0] == 0 || arg[1] == 0 )
			    atscrollsetrect ( pat, 0, 0, pat->cmax.X, pat->cmax.Y );
			    else
			      atscrollsetrect ( pat, 0, arg[0]-1, pat->cmax.X, arg[1]-1 );
			    pat->cursor.X = pat->scrollrect.Left;
			    pat->cursor.Y = pat->scrollrect.Top;
			    SetConsoleCursorPosition ( pat->handle, pat->cursor );
			  break;
			case 's':		// cursor save
			  atcursorsave ( pat );
			  break;
			case 't':		// sun sequence ???	n/a
			  break;
			case 'u':		// cursor restore
			  atcursorrestore ( pat );
			  break;
			case 'x':		// DEC terminal report	n/a
			  break;
		      }
		    memset ( seq, 0, sizeof(seq) );	// clear sequence
		    memset ( arg, 0, sizeof(arg) );	// clear arguments
		    n = 0;				// clear seq counter
		    nn = 0;				// clear arg counter
		  }
	  break;
      };
    if ( n >= sizeof(seq) ) n--;	// bound check
    if ( nn >= sizeof(arg) ) nn--;	// bound check
    return 0;
  }

int atputs ( ANSITERM *pat, char *str )
  {
    while ( *str )
      atputc ( pat, *str++ );
    return 0;
  }
